/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.mixin.entity;

import com.mojang.serialization.Codec;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.nbt.INbtEntityInvoker;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements INbtEntityInvoker {
    @Shadow
    @Final
    private EntityType<?> type;
    @Shadow
    private int id;
    @Shadow
    @Final
    private static Codec<List<String>> TAG_LIST_CODEC;
    @Shadow
    @Nullable
    private Entity vehicle;
    @Shadow
    protected UUID uuid;
    @Shadow
    private Level level;
    @Shadow
    private Vec3 position;
    @Shadow
    private Vec3 deltaMovement;
    @Shadow
    private float yRot;
    @Shadow
    private float xRot;
    @Shadow
    private boolean onGround;
    @Shadow
    public double fallDistance;
    @Shadow
    private int remainingFireTicks;
    @Shadow
    @Final
    protected SynchedEntityData entityData;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> DATA_AIR_SUPPLY_ID;
    @Shadow
    @Final
    private static EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME;
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> DATA_CUSTOM_NAME_VISIBLE;
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> DATA_SILENT;
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> DATA_NO_GRAVITY;
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> DATA_TICKS_FROZEN;
    @Shadow
    private int portalCooldown;
    @Shadow
    private boolean invulnerable;
    @Shadow
    private boolean hasGlowingTag;
    @Shadow
    private boolean hasVisualFire;
    @Shadow
    @Final
    private Set<String> tags;
    @Shadow
    private CustomData customData;

    @Shadow
    protected abstract void addAdditionalSaveData(ValueOutput var1);

    @Unique
    private Optional<CompoundTag> malilib$gatherPassengerlessNbtInternal(int expectedId) {
        if (this.id != expectedId) {
            return Optional.empty();
        }
        try {
            int i;
            CompoundTag nbt = new CompoundTag();
            if (this.vehicle != null) {
                nbt.store("Pos", Vec3.CODEC, (Object)new Vec3(this.vehicle.getX(), this.position.y(), this.vehicle.getZ()));
            } else {
                nbt.store("Pos", Vec3.CODEC, (Object)this.position);
            }
            nbt.store("Motion", Vec3.CODEC, (Object)this.deltaMovement);
            nbt.store("Rotation", Vec2.CODEC, (Object)new Vec2(this.yRot, this.xRot));
            nbt.putDouble("fall_distance", this.fallDistance);
            nbt.putShort("Fire", (short)this.remainingFireTicks);
            nbt.putShort("Air", ((Integer)this.entityData.get(DATA_AIR_SUPPLY_ID)).shortValue());
            nbt.putBoolean("OnGround", this.onGround);
            nbt.putBoolean("Invulnerable", this.invulnerable);
            nbt.putInt("PortalCooldown", this.portalCooldown);
            nbt.store("UUID", UUIDUtil.CODEC, (Object)this.uuid);
            ((Optional)this.entityData.get(DATA_CUSTOM_NAME)).ifPresent(name -> nbt.store("CustomName", ComponentSerialization.CODEC, name));
            if (((Boolean)this.entityData.get(DATA_CUSTOM_NAME_VISIBLE)).booleanValue()) {
                nbt.putBoolean("CustomNameVisible", true);
            }
            if (((Boolean)this.entityData.get(DATA_SILENT)).booleanValue()) {
                nbt.putBoolean("Silent", true);
            }
            if (((Boolean)this.entityData.get(DATA_NO_GRAVITY)).booleanValue()) {
                nbt.putBoolean("NoGravity", true);
            }
            if (this.hasGlowingTag) {
                nbt.putBoolean("Glowing", true);
            }
            if ((i = ((Integer)this.entityData.get(DATA_TICKS_FROZEN)).intValue()) > 0) {
                nbt.putInt("TicksFrozen", i);
            }
            if (this.hasVisualFire) {
                nbt.putBoolean("HasVisualFire", true);
            }
            if (!this.tags.isEmpty()) {
                nbt.store("Tags", TAG_LIST_CODEC, List.copyOf(this.tags));
            }
            if (!this.customData.isEmpty()) {
                nbt.store("data", CustomData.CODEC, (Object)this.customData);
            }
            NbtView view = NbtView.getWriter(this.level.registryAccess());
            this.addAdditionalSaveData(view.getWriter());
            nbt.merge(Objects.requireNonNullElse(view.readNbt(), new CompoundTag()));
            nbt.putString("id", EntityType.getKey(this.type).toString());
            return Optional.of(nbt);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("malilib$getNbtDataWithId: Exception writing NBT tags for entityId [{}]; Exception: {}", (Object)expectedId, (Object)err.getLocalizedMessage());
            return Optional.empty();
        }
    }

    @Override
    public Optional<CompoundTag> malilib$getNbtDataWithId(int expectedId) {
        return this.malilib$gatherPassengerlessNbtInternal(expectedId);
    }

    @Override
    public Optional<CompoundData> malilib$getDataTagWithId(int expectedId) {
        return this.malilib$gatherPassengerlessNbtInternal(expectedId).map(DataConverterNbt::fromVanillaCompound);
    }
}

