/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class PacketSplitter {
    public static final int MAX_TOTAL_PER_PACKET_S2C = 0x100000;
    public static final int MAX_PAYLOAD_PER_PACKET_S2C = 1048571;
    public static final int MAX_TOTAL_PER_PACKET_C2S = Short.MAX_VALUE;
    public static final int MAX_PAYLOAD_PER_PACKET_C2S = 32762;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_C2S = 0x100000;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_S2C = 0x4000000;
    private static final Map<Long, ReadingSession> READING_SESSIONS = new HashMap<Long, ReadingSession>();

    public static <T extends CustomPacketPayload> boolean send(IPluginClientPlayHandler<T> handler, FriendlyByteBuf packet, ClientPacketListener networkHandler) {
        return PacketSplitter.send(handler, packet, 32762, networkHandler);
    }

    private static <T extends CustomPacketPayload> boolean send(IPluginClientPlayHandler<T> handler, FriendlyByteBuf packet, int payloadLimit, ClientPacketListener networkHandler) {
        int len = packet.writerIndex();
        packet.resetReaderIndex();
        for (int offset = 0; offset < len; offset += payloadLimit) {
            int thisLen = Math.min(len - offset, payloadLimit);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer((int)thisLen));
            buf.resetWriterIndex();
            if (offset == 0) {
                buf.writeVarInt(len);
            }
            buf.writeBytes((ByteBuf)packet, thisLen);
            handler.encodeWithSplitter(buf, networkHandler);
        }
        packet.release();
        return true;
    }

    public static <T extends CustomPacketPayload> FriendlyByteBuf receive(IPluginClientPlayHandler<T> handler, long key, FriendlyByteBuf buf) {
        return PacketSplitter.receive(handler.getPayloadChannel(), key, buf, 0x4000000);
    }

    @Nullable
    private static FriendlyByteBuf receive(ResourceLocation channel, long key, FriendlyByteBuf buf, int maxLength) {
        return READING_SESSIONS.computeIfAbsent(key, ReadingSession::new).receive(buf, maxLength);
    }

    private static class ReadingSession {
        private final long key;
        private int expectedSize = -1;
        private FriendlyByteBuf received;

        private ReadingSession(long key) {
            this.key = key;
        }

        @Nullable
        private FriendlyByteBuf receive(FriendlyByteBuf data, int maxLength) {
            data.readerIndex(0);
            if (this.expectedSize < 0) {
                this.expectedSize = data.readVarInt();
                if (this.expectedSize > maxLength) {
                    throw new IllegalArgumentException("Payload too large");
                }
                this.received = new FriendlyByteBuf(Unpooled.buffer((int)this.expectedSize));
            }
            if (this.received == null) {
                throw new RuntimeException("Receive Buffer is empty");
            }
            this.received.writeBytes(data.copy());
            if (this.received.writerIndex() >= this.expectedSize) {
                READING_SESSIONS.remove(this.key);
                return this.received;
            }
            return null;
        }
    }
}

