/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.vertex.BufferBuilder;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class TestUtils {
    protected static Pair<BlockPos, BlockPos> getSpawnChunkCorners(BlockPos worldSpawn, int chunkRange, Level world) {
        int cx = worldSpawn.getX() >> 4;
        int cz = worldSpawn.getZ() >> 4;
        int minY = TestUtils.getMinY(world);
        int maxY = world != null ? world.getMaxY() + 1 : 320;
        BlockPos pos1 = new BlockPos(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        BlockPos pos2 = new BlockPos((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    private static int getMinY(Level world) {
        Minecraft mc = Minecraft.getInstance();
        int minY = Minecraft.useShaderTransparency() && world != null && mc.player != null ? (mc.player.blockPosition().getY() >= world.getSeaLevel() ? world.getSeaLevel() - 2 : world.getMinY()) : (world != null ? world.getMinY() : -64);
        return minY;
    }

    public static List<AABB> calculateBoxes(BlockPos posStart, BlockPos posEnd) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        Entity entity = EntityUtils.getCameraEntity();
        int boxMinX = Math.min(posStart.getX(), posEnd.getX());
        int boxMinZ = Math.min(posStart.getZ(), posEnd.getZ());
        int boxMaxX = Math.max(posStart.getX(), posEnd.getX());
        int boxMaxZ = Math.max(posStart.getZ(), posEnd.getZ());
        int centerX = (int)Math.floor(entity.getX());
        int centerZ = (int)Math.floor(entity.getZ());
        int maxDist = (Integer)Minecraft.getInstance().options.renderDistance().get() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.getY(), posEnd.getY());
        double maxY = Math.max(posStart.getY(), posEnd.getY()) + 1;
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        return boxes;
    }

    public static void renderWallQuads(AABB box, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads) {
        double cx = cameraPos.x;
        double cy = cameraPos.y;
        double cz = cameraPos.z;
        bufferQuads.addVertex((float)(box.minX - cx), (float)(box.maxY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, color.a);
        bufferQuads.addVertex((float)(box.minX - cx), (float)(box.minY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, color.a);
        bufferQuads.addVertex((float)(box.maxX - cx), (float)(box.minY - cy), (float)(box.maxZ - cz)).setColor(color.r, color.g, color.b, color.a);
        bufferQuads.addVertex((float)(box.maxX - cx), (float)(box.maxY - cy), (float)(box.maxZ - cz)).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderWallOutlines(AABB box, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Vec3 cameraPos, Color4f color, BufferBuilder bufferLines) {
        block4: {
            double lineX;
            double cz;
            double cy;
            double cx;
            block5: {
                double lineZ;
                cx = cameraPos.x;
                cy = cameraPos.y;
                cz = cameraPos.z;
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? TestUtils.roundUp(box.minY, lineIntervalV) : box.minY;
                    while (lineY <= box.maxY) {
                        bufferLines.addVertex((float)(box.minX - cx), (float)(lineY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                        bufferLines.addVertex((float)(box.maxX - cx), (float)(lineY - cy), (float)(box.maxZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (box.minX != box.maxX) break block5;
                double d = lineZ = alignLinesToModulo ? TestUtils.roundUp(box.minZ, lineIntervalH) : box.minZ;
                while (lineZ <= box.maxZ) {
                    bufferLines.addVertex((float)(box.minX - cx), (float)(box.minY - cy), (float)(lineZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                    bufferLines.addVertex((float)(box.minX - cx), (float)(box.maxY - cy), (float)(lineZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (box.minZ != box.maxZ) break block4;
            double d = lineX = alignLinesToModulo ? TestUtils.roundUp(box.minX, lineIntervalH) : box.minX;
            while (lineX <= box.maxX) {
                bufferLines.addVertex((float)(lineX - cx), (float)(box.minY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                bufferLines.addVertex((float)(lineX - cx), (float)(box.maxY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                lineX += lineIntervalH;
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }
}

