/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.position.BlockRotation;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;

public enum BlockMirror implements IConfigOptionListEntry,
StringRepresentable
{
    NONE(0, "none", null, Mirror.NONE),
    X(1, "x", Direction.Axis.X, Mirror.FRONT_BACK),
    Y(2, "y", Direction.Axis.Y, Mirror.NONE),
    Z(3, "z", Direction.Axis.Z, Mirror.LEFT_RIGHT);

    public static final StringRepresentable.EnumCodec<BlockMirror> CODEC;
    public static final IntFunction<BlockMirror> INDEX_TO_VALUE;
    public static final StreamCodec<ByteBuf, BlockMirror> PACKET_CODEC;
    public static final BlockMirror[] VALUES;
    private final int index;
    private final String name;
    private final String translationKey;
    private final Mirror vanillaMirror;
    @Nullable
    private final Direction.Axis axis;

    private BlockMirror(@Nullable int index, String name, Direction.Axis axis, Mirror vanillaMirror) {
        this.index = index;
        this.name = name;
        this.vanillaMirror = vanillaMirror;
        this.translationKey = "malilib.label.block_mirror." + name;
        this.axis = axis;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getStringValue() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Nonnull
    public String getSerializedName() {
        return this.name;
    }

    public BlockRotation toRotation(Direction direction) {
        if (direction.getAxis() == this.axis) {
            return BlockRotation.CW_180;
        }
        return BlockRotation.NONE;
    }

    public Direction mirror(Direction direction) {
        if (direction.getAxis() == this.axis) {
            return direction.getOpposite();
        }
        return direction;
    }

    @Override
    public BlockMirror cycle(boolean reverse) {
        int index = this.index + (reverse ? -1 : 1) & 3;
        return VALUES[index];
    }

    @Override
    public IConfigOptionListEntry fromString(String value) {
        return BlockMirror.byName(value);
    }

    public Mirror getVanillaMirror() {
        return this.vanillaMirror;
    }

    public static BlockMirror byName(String name) {
        for (BlockMirror mirror : VALUES) {
            if (!mirror.name.equalsIgnoreCase(name)) continue;
            return mirror;
        }
        return NONE;
    }

    static {
        CODEC = StringRepresentable.fromEnum(BlockMirror::values);
        INDEX_TO_VALUE = ByIdMap.continuous(BlockMirror::getIndex, (Object[])BlockMirror.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        PACKET_CODEC = ByteBufCodecs.idMapper(INDEX_TO_VALUE, BlockMirror::getIndex);
        VALUES = BlockMirror.values();
    }
}

