/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.config.options.BooleanHotkeyGuiWrapper;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.test.ConfigTestEnum;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class MaLiLibConfigGui
extends GuiConfigsBase {
    private static ConfigGuiTab tab = ConfigGuiTab.GENERIC;
    public static ImmutableList<ConfigTestEnum> TEST_ENUM_LIST = ConfigTestEnum.VALUES;

    public MaLiLibConfigGui() {
        super(10, 50, "malilib", null, "malilib.gui.title.configs", String.format("%s", MaLiLibReference.MOD_VERSION));
    }

    @Override
    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            if (!MaLiLibReference.DEBUG_MODE && (tab == ConfigGuiTab.TEST || tab == ConfigGuiTab.TEST_ENUM) || tab == ConfigGuiTab.EXPERIMENTAL) continue;
            x += this.createButton(x, y, -1, tab) + 2;
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(MaLiLibConfigGui.tab != tab);
        this.addButton(button, new ButtonListener(tab, this));
        return button.getWidth();
    }

    @Override
    protected int getConfigWidth() {
        ConfigGuiTab tab = MaLiLibConfigGui.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return 200;
        }
        return super.getConfigWidth();
    }

    @Override
    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        Object configs;
        ConfigGuiTab tab = MaLiLibConfigGui.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = MaLiLibConfigs.Generic.OPTIONS;
        } else if (tab == ConfigGuiTab.DEBUG) {
            configs = MaLiLibConfigs.Debug.OPTIONS;
        } else if (tab == ConfigGuiTab.TEST && MaLiLibReference.DEBUG_MODE) {
            configs = MaLiLibConfigs.Test.OPTIONS;
        } else {
            if (tab == ConfigGuiTab.TEST_ENUM && MaLiLibReference.DEBUG_MODE) {
                return GuiConfigsBase.ConfigOptionWrapper.createFor(TEST_ENUM_LIST.stream().map(this::wrapConfig).toList());
            }
            if (tab == ConfigGuiTab.EXPERIMENTAL) {
                // empty if block
            }
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    protected BooleanHotkeyGuiWrapper wrapConfig(ConfigTestEnum config) {
        return new BooleanHotkeyGuiWrapper(config.getName(), config, config.getKeybind());
    }

    public static enum ConfigGuiTab {
        GENERIC("malilib.gui.title.generic"),
        DEBUG("malilib.gui.title.debug"),
        TEST("malilib.gui.title.test"),
        TEST_ENUM("malilib.gui.title.test_enum"),
        EXPERIMENTAL("malilib.gui.title.experimental");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.translationKey, new Object[0]);
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final MaLiLibConfigGui parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, MaLiLibConfigGui parent) {
            this.tab = tab;
            this.parent = parent;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

