/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.gui.interfaces.IFileBrowserIconProvider;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.FileNameUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;

public class WidgetDirectoryEntry
extends WidgetListEntryBase<WidgetFileBrowserBase.DirectoryEntry> {
    protected final IDirectoryNavigator navigator;
    protected final WidgetFileBrowserBase.DirectoryEntry entry;
    protected final IFileBrowserIconProvider iconProvider;
    protected final boolean isOdd;

    public WidgetDirectoryEntry(int x, int y, int width, int height, boolean isOdd, WidgetFileBrowserBase.DirectoryEntry entry, int listIndex, IDirectoryNavigator navigator, IFileBrowserIconProvider iconProvider) {
        super(x, y, width, height, entry, listIndex);
        this.isOdd = isOdd;
        this.entry = entry;
        this.navigator = navigator;
        this.iconProvider = iconProvider;
    }

    public WidgetFileBrowserBase.DirectoryEntry getDirectoryEntry() {
        return this.entry;
    }

    @Override
    protected boolean onMouseClickedImpl(MouseButtonEvent click, boolean doubleClick) {
        if (this.entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY) {
            return super.onMouseClickedImpl(click, doubleClick);
        }
        this.navigator.switchToDirectory(this.entry.getDirectory().resolve(this.entry.getName()));
        return true;
    }

    @Override
    public void render(GuiGraphics drawContext, int mouseX, int mouseY, boolean selected) {
        super.render(drawContext, mouseX, mouseY, selected);
        if (selected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect(drawContext, this.x, this.y, this.width, this.height, 0x70FFFFFF);
        } else if (this.isOdd) {
            RenderUtils.drawRect(drawContext, this.x, this.y, this.width, this.height, 0x20FFFFFF);
        } else {
            RenderUtils.drawRect(drawContext, this.x, this.y, this.width, this.height, 0x38FFFFFF);
        }
        IGuiIcon icon = null;
        switch (this.entry.getType()) {
            case DIRECTORY: {
                icon = this.iconProvider.getIconDirectory();
                break;
            }
            default: {
                icon = this.iconProvider.getIconForFile(this.entry.getFullPath());
            }
        }
        int iconWidth = icon != null ? icon.getWidth() : 0;
        int xOffset = iconWidth + 2;
        if (icon != null) {
            icon.renderAt(drawContext, this.x, this.y + (this.height - icon.getHeight()) / 2, this.zLevel + 10, false, false);
        }
        if (selected) {
            RenderUtils.drawOutline(drawContext, this.x, this.y, this.width, this.height, -286331154);
        }
        int yOffset = (this.height - this.fontHeight) / 2 + 1;
        this.drawString(drawContext, this.x + xOffset + 2, this.y + yOffset, -1, this.getDisplayName());
        super.render(drawContext, mouseX, mouseY, selected);
    }

    protected String getDisplayName() {
        if (this.entry.getType() == WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY) {
            return this.entry.getDisplayName();
        }
        return FileNameUtils.getFileNameWithoutExtension(this.entry.getDisplayName());
    }
}

