/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.entity.IMixinPlayerEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.ItemType;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.malilib.util.nbt.NbtInventory;
import fi.dy.masa.malilib.util.nbt.NbtView;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.math.Fraction;

public class InventoryUtils {
    private static final AnsiLogger LOGGER = new AnsiLogger(InventoryUtils.class);
    public static final Pattern PATTERN_ITEM_BASE = Pattern.compile("^(?<name>(?:[a-z0-9\\._-]+:)[a-z0-9\\._-]+)$");

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return InventoryUtils.areStacksAndNbtEqual(stack1, stack2);
    }

    public static boolean areStacksAndNbtEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areStacksEqualIgnoreNbt(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItem((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        ItemStack ref = stack1.copy();
        ItemStack check = stack2.copy();
        ref.setCount(1);
        check.setCount(1);
        if (ref.isDamageableItem() && ref.isDamaged()) {
            ref.setDamageValue(0);
        }
        if (check.isDamageableItem() && check.isDamaged()) {
            check.setDamageValue(0);
        }
        return ItemStack.isSameItemSameComponents((ItemStack)ref, (ItemStack)check);
    }

    public static <T> boolean areNbtEqualIgnoreKeys(@Nonnull DataComponentMap tag1, @Nonnull DataComponentMap tag2, @Nullable DataComponentType<T> type, @Nullable Set<DataComponentType<T>> ignoredKeys) {
        Set keys1 = tag1.keySet();
        Set keys2 = tag2.keySet();
        if (ignoredKeys != null) {
            keys1.removeAll(ignoredKeys);
            keys2.removeAll(ignoredKeys);
        }
        if (!Objects.equals(keys1, keys2)) {
            return false;
        }
        if (type == null) {
            for (DataComponentType key : keys1) {
                if (Objects.equals(tag1.get(key), tag2.get(key))) continue;
                return false;
            }
            return true;
        }
        return Objects.equals(tag1.get(type), tag2.get(type));
    }

    public static boolean areNbtEqualIgnoreKeys(@Nonnull CompoundTag tag1, @Nonnull CompoundTag tag2, @Nullable Set<String> ignoredKeys) {
        Set keys1 = tag1.keySet();
        Set keys2 = tag2.keySet();
        if (ignoredKeys != null) {
            keys1.removeAll(ignoredKeys);
            keys2.removeAll(ignoredKeys);
        }
        if (!Objects.equals(keys1, keys2)) {
            return false;
        }
        for (String key : keys1) {
            if (Objects.equals(tag1.get(key), tag2.get(key))) continue;
            return false;
        }
        return true;
    }

    public static void swapSlots(AbstractContainerMenu container, int slotNum, int hotbarSlot) {
        Minecraft mc = Minecraft.getInstance();
        mc.gameMode.handleInventoryMouseClick(container.containerId, slotNum, hotbarSlot, ClickType.SWAP, (Player)mc.player);
    }

    public static boolean isRegularInventorySlot(int slotNumber, boolean allowOffhand) {
        return slotNumber > 8 && (allowOffhand || slotNumber < 45);
    }

    public static int findEmptySlotInPlayerInventory(AbstractContainerMenu containerPlayer, boolean allowOffhand, boolean reverse) {
        int startSlot = reverse ? containerPlayer.slots.size() - 1 : 0;
        int endSlot = reverse ? -1 : containerPlayer.slots.size();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)containerPlayer.slots.get(slotNum);
            ItemStack stackSlot = slot.getItem();
            if (!stackSlot.isEmpty() || !InventoryUtils.isRegularInventorySlot(slot.index, allowOffhand)) continue;
            return slot.index;
        }
        return -1;
    }

    public static int findSlotWithItem(AbstractContainerMenu container, ItemStack stackReference, boolean reverse) {
        int startSlot = reverse ? container.slots.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.slots.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof InventoryMenu;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)container.slots.get(slotNum);
            if (isPlayerInv && !InventoryUtils.isRegularInventorySlot(slot.index, false) || !InventoryUtils.areStacksEqualIgnoreDurability(slot.getItem(), stackReference)) continue;
            return slot.index;
        }
        return -1;
    }

    public static boolean swapItemToMainHand(ItemStack stackReference, Minecraft mc) {
        LocalPlayer player = mc.player;
        boolean isCreative = player.hasInfiniteMaterials();
        if (InventoryUtils.areStacksEqualIgnoreNbt(stackReference, player.getMainHandItem())) {
            return false;
        }
        if (isCreative) {
            player.getInventory().addAndPickItem(stackReference);
            mc.gameMode.handleCreativeModeItemAdd(player.getMainHandItem(), 36 + player.getInventory().getSelectedSlot());
            return true;
        }
        int slot = InventoryUtils.findSlotWithItem((AbstractContainerMenu)player.inventoryMenu, stackReference, true);
        if (slot != -1) {
            int currentHotbarSlot = player.getInventory().getSelectedSlot();
            mc.gameMode.handleInventoryMouseClick(player.inventoryMenu.containerId, slot, currentHotbarSlot, ClickType.SWAP, (Player)mc.player);
            return true;
        }
        return false;
    }

    @Nullable
    public static Container getInventory(Level world, BlockPos pos) {
        boolean isLoaded = world.hasChunkAt(pos);
        if (!isLoaded) {
            return null;
        }
        BlockEntity te = world.getChunkAt(pos).getBlockEntity(pos);
        if (te instanceof Container) {
            BlockPos posAdj;
            boolean isLoadedAdj;
            ChestType type;
            Container inv = (Container)te;
            BlockState state = world.getBlockState(pos);
            if (state.getBlock() instanceof ChestBlock && te instanceof ChestBlockEntity && (type = (ChestType)state.getValue((Property)ChestBlock.TYPE)) != ChestType.SINGLE && (isLoadedAdj = world.hasChunkAt(posAdj = pos.relative(ChestBlock.getConnectedDirection((BlockState)state))))) {
                BlockState stateAdj = world.getBlockState(posAdj);
                BlockEntity te2 = world.getChunkAt(posAdj).getBlockEntity(posAdj);
                if (stateAdj.getBlock() == state.getBlock() && te2 instanceof ChestBlockEntity && stateAdj.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && stateAdj.getValue((Property)ChestBlock.FACING) == state.getValue((Property)ChestBlock.FACING)) {
                    Container invRight = type == ChestType.RIGHT ? inv : (Container)te2;
                    Container invLeft = type == ChestType.RIGHT ? (Container)te2 : inv;
                    inv = new CompoundContainer(invRight, invLeft);
                }
            }
            return inv;
        }
        return null;
    }

    public static boolean shulkerBoxHasItems(ItemStack stack) {
        ItemContainerContents container = (ItemContainerContents)stack.getComponents().get(DataComponents.CONTAINER);
        if (container != null) {
            return container.nonEmptyItems().iterator().hasNext();
        }
        return false;
    }

    @Nullable
    public static CompoundTag stackHasNbtItems(ItemStack stack, @Nonnull RegistryAccess registry) {
        CompoundTag nbt;
        if (!stack.isEmpty() && InventoryUtils.hasNbtItems(nbt = (CompoundTag)ItemStack.CODEC.encodeStart((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).getOrThrow())) {
            return nbt;
        }
        return null;
    }

    public static boolean hasNbtItems(CompoundTag nbt) {
        if (nbt.contains("Items")) {
            ListTag tagList = nbt.getListOrEmpty("Items");
            return !tagList.isEmpty();
        }
        if (nbt.contains("Inventory")) {
            ListTag tagList = nbt.getListOrEmpty("Inventory");
            return !tagList.isEmpty();
        }
        if (nbt.contains("EnderItems")) {
            ListTag tagList = nbt.getListOrEmpty("EnderItems");
            return !tagList.isEmpty();
        }
        if (nbt.contains("item")) {
            return true;
        }
        if (nbt.contains("Item")) {
            return true;
        }
        if (nbt.contains("Book")) {
            return true;
        }
        return nbt.contains("RecordItem");
    }

    public static NonNullList<ItemStack> getNbtItems(@Nonnull CompoundTag nbt) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return NonNullList.create();
        }
        return InventoryUtils.getNbtItems(nbt, -1, mc.level.registryAccess());
    }

    public static NonNullList<ItemStack> getNbtItems(@Nonnull CompoundTag nbt, int slotCount, @Nonnull RegistryAccess registry) {
        if (slotCount > 256) {
            slotCount = 256;
        }
        if (nbt.contains("Items")) {
            ListTag list = nbt.getListOrEmpty("Items");
            if (slotCount < 0) {
                slotCount = list.size();
            }
            slotCount = NbtInventory.getAdjustedSize(slotCount);
            NbtInventory nbtInv = NbtInventory.fromNbtList(list, false, registry);
            if (nbtInv == null || nbtInv.isEmpty()) {
                return NonNullList.create();
            }
            return nbtInv.toVanillaList(slotCount);
        }
        if (nbt.contains("Inventory")) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(nbt);
            boolean isPlayer = type == InventoryOverlay.InventoryRenderType.PLAYER;
            ListTag list = nbt.getListOrEmpty("Inventory");
            if (slotCount < 0) {
                slotCount = list.size();
            }
            slotCount = NbtInventory.getAdjustedSize(slotCount);
            NbtInventory nbtInv = NbtInventory.fromNbtList(list, !isPlayer, registry);
            if (nbtInv == null || nbtInv.isEmpty()) {
                return NonNullList.create();
            }
            return nbtInv.toVanillaList(slotCount);
        }
        if (nbt.contains("EnderItems")) {
            ListTag list = nbt.getListOrEmpty("EnderItems");
            if (slotCount < 0) {
                slotCount = Math.max(list.size(), 27);
            }
            slotCount = NbtInventory.getAdjustedSize(slotCount);
            NbtInventory nbtInv = NbtInventory.fromNbtList(list, false, registry);
            if (nbtInv == null || nbtInv.isEmpty()) {
                return NonNullList.create();
            }
            return nbtInv.toVanillaList(slotCount);
        }
        if (nbt.contains("item")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("item"));
            NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            items.addFirst((Object)entry);
            return items;
        }
        if (nbt.contains("Item")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("Item"));
            NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            items.addFirst((Object)entry);
            return items;
        }
        if (nbt.contains("Book")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("Book"));
            NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            items.addFirst((Object)entry);
            return items;
        }
        if (nbt.contains("RecordItem")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("RecordItem"));
            NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            items.addFirst((Object)entry);
            return items;
        }
        return NonNullList.create();
    }

    public static Container getNbtInventory(@Nonnull CompoundTag nbt) {
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        return InventoryUtils.getNbtInventory(nbt, -1, Minecraft.getInstance().level.registryAccess());
    }

    public static Container getNbtInventory(@Nonnull CompoundTag nbt, int slotCount, @Nonnull RegistryAccess registry) {
        if (slotCount > 256) {
            slotCount = 256;
        }
        if (nbt.contains("Items")) {
            if (slotCount < 0) {
                ListTag list = nbt.getListOrEmpty("Items");
                slotCount = list.size();
            }
            slotCount = NbtInventory.getAdjustedSize(slotCount);
            NbtInventory nbtInv = NbtInventory.fromNbt(nbt, "Items", false, registry);
            if (nbtInv == null || nbtInv.isEmpty()) {
                return null;
            }
            return nbtInv.toInventory(slotCount);
        }
        if (nbt.contains("Inventory")) {
            boolean isPlayer;
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(nbt);
            boolean bl = isPlayer = type == InventoryOverlay.InventoryRenderType.PLAYER;
            if (slotCount < 0) {
                ListTag list = nbt.getListOrEmpty("Inventory");
                slotCount = list.size();
            }
            slotCount = NbtInventory.getAdjustedSize(slotCount);
            NbtInventory nbtInv = NbtInventory.fromNbt(nbt, "Inventory", !isPlayer, registry);
            if (nbtInv == null || nbtInv.isEmpty()) {
                return null;
            }
            return nbtInv.toInventory(slotCount);
        }
        if (nbt.contains("EnderItems")) {
            ListTag list = nbt.getListOrEmpty("EnderItems");
            if (slotCount < 0) {
                slotCount = Math.max(list.size(), 27);
            }
            slotCount = NbtInventory.getAdjustedSize(slotCount);
            NbtInventory nbtInv = NbtInventory.fromNbtList(list, false, registry);
            if (nbtInv == null || nbtInv.isEmpty()) {
                return null;
            }
            return nbtInv.toInventory(Math.max(slotCount, 27));
        }
        if (nbt.contains("item")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("item"));
            SimpleContainer inv = new SimpleContainer(1);
            inv.setItem(0, entry.copy());
            return inv;
        }
        if (nbt.contains("Item")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("Item"));
            SimpleContainer inv = new SimpleContainer(1);
            inv.setItem(0, entry.copy());
            return inv;
        }
        if (nbt.contains("Book")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("Book"));
            SimpleContainer inv = new SimpleContainer(1);
            inv.setItem(0, entry.copy());
            return inv;
        }
        if (nbt.contains("RecordItem")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("RecordItem"));
            SimpleContainer inv = new SimpleContainer(1);
            inv.setItem(0, entry.copy());
            return inv;
        }
        return null;
    }

    public static Container getNbtInventoryHorseFix(@Nonnull CompoundTag nbt, int slotCount, @Nonnull RegistryAccess registry) {
        NonNullList<ItemStack> horseEquipment = NbtEntityUtils.getHorseEquipmentFromNbt(nbt, registry);
        if (slotCount > 256) {
            slotCount = 256;
        }
        if (nbt.contains("Items")) {
            if (slotCount < 0) {
                ListTag list = nbt.getListOrEmpty("Items");
                slotCount = list.size();
            }
            SimpleContainer inv = new SimpleContainer(slotCount + 1);
            inv.setItem(0, (ItemStack)horseEquipment.getLast());
            NbtInventory nbtInv = NbtInventory.fromNbt(nbt, "Items", false, registry);
            if (nbtInv != null && !nbtInv.isEmpty()) {
                NonNullList<ItemStack> items = nbtInv.toVanillaList(slotCount + 1);
                for (int i = 0; i < slotCount; ++i) {
                    inv.setItem(i + 1, (ItemStack)items.get(i));
                }
            }
            return inv;
        }
        if (!((ItemStack)horseEquipment.getLast()).isEmpty()) {
            SimpleContainer inv = new SimpleContainer(1);
            inv.setItem(0, ((ItemStack)horseEquipment.getLast()).copy());
            return inv;
        }
        if (nbt.contains("item")) {
            ItemStack entry = InventoryUtils.fromNbtOrEmpty(registry, nbt.get("item"));
            SimpleContainer inv = new SimpleContainer(1);
            inv.setItem(0, entry.copy());
            return inv;
        }
        return null;
    }

    @Nullable
    public static PlayerEnderChestContainer getPlayerEnderItems(Player player) {
        if (player != null) {
            return ((IMixinPlayerEntity)player).malilib_getEnderItems();
        }
        return null;
    }

    @Nullable
    public static PlayerEnderChestContainer getPlayerEnderItemsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("EnderItems")) {
            PlayerEnderChestContainer inv = new PlayerEnderChestContainer();
            NbtView view = NbtView.getReader(nbt, registry);
            inv.fromSlots(view.getReader().listOrEmpty("EnderItems", ItemStackWithSlot.CODEC));
            return inv;
        }
        return null;
    }

    public static NonNullList<ItemStack> getSellingItemsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        MerchantOffers offers = NbtEntityUtils.getTradeOffersFromNbt(nbt, registry);
        if (offers != null) {
            return InventoryUtils.getSellingItems(offers);
        }
        return NonNullList.create();
    }

    public static NonNullList<ItemStack> getSellingItems(@Nonnull MerchantOffers offers) {
        if (!offers.isEmpty()) {
            NonNullList result = NonNullList.create();
            for (MerchantOffer entry : offers) {
                if (entry == null) continue;
                ItemStack sellItem = entry.getResult();
                result.add((Object)sellItem.copy());
            }
            return result;
        }
        return NonNullList.create();
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn) {
        ItemContainerContents container = (ItemContainerContents)stackIn.getComponents().get(DataComponents.CONTAINER);
        if (container != null) {
            Iterator iter = container.nonEmptyStream().iterator();
            NonNullList items = NonNullList.createWithCapacity((int)((int)container.nonEmptyStream().count()));
            int i = 0;
            while (iter.hasNext()) {
                items.add((Object)((ItemStack)iter.next()).copy());
                ++i;
            }
            return items;
        }
        return NonNullList.create();
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn, int slotCount) {
        ItemContainerContents itemContainer = (ItemContainerContents)stackIn.getComponents().get(DataComponents.CONTAINER);
        if (itemContainer != null) {
            long defSlotCount = itemContainer.stream().count();
            slotCount = slotCount < 1 ? (defSlotCount < 256L ? (int)defSlotCount : 256) : Math.min(slotCount, 256);
            NonNullList items = NonNullList.createWithCapacity((int)slotCount);
            Iterator iter = itemContainer.stream().iterator();
            for (int i = 0; i < slotCount; ++i) {
                ItemStack entry = iter.hasNext() ? (ItemStack)iter.next() : ItemStack.EMPTY;
                items.add((Object)entry.copy());
            }
            return items;
        }
        return NonNullList.create();
    }

    public static boolean bundleHasItems(ItemStack stack) {
        BundleContents bundleContainer = (BundleContents)stack.getComponents().get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContainer != null) {
            return !bundleContainer.isEmpty();
        }
        return false;
    }

    public static Fraction bundleOccupancy(ItemStack stack) {
        BundleContents bundleContainer = (BundleContents)stack.getComponents().get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContainer != null) {
            return bundleContainer.weight();
        }
        return Fraction.ZERO;
    }

    public static int bundleCountItems(ItemStack stack) {
        BundleContents bundleContainer = (BundleContents)stack.getComponents().get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContainer != null) {
            return bundleContainer.size();
        }
        return -1;
    }

    public static NonNullList<ItemStack> getBundleItems(ItemStack stackIn) {
        BundleContents bundleContainer = (BundleContents)stackIn.getComponents().getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        if (bundleContainer != null && !bundleContainer.equals((Object)BundleContents.EMPTY)) {
            int maxSlots = bundleContainer.size();
            NonNullList items = NonNullList.createWithCapacity((int)maxSlots);
            Iterator iter = bundleContainer.itemCopyStream().iterator();
            while (iter.hasNext()) {
                ItemStack slot = (ItemStack)iter.next();
                if (slot.isEmpty()) continue;
                items.add((Object)slot.copy());
            }
            return items;
        }
        return NonNullList.create();
    }

    public static NonNullList<ItemStack> getBundleItems(ItemStack stackIn, int maxSlots) {
        BundleContents bundleContainer = (BundleContents)stackIn.getComponents().getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        if (bundleContainer != null && !bundleContainer.equals((Object)BundleContents.EMPTY)) {
            int defMaxSlots = bundleContainer.size();
            maxSlots = maxSlots < 1 ? defMaxSlots : (maxSlots < 64 ? maxSlots : defMaxSlots);
            NonNullList items = NonNullList.createWithCapacity((int)maxSlots);
            Iterator iter = bundleContainer.itemCopyStream().iterator();
            for (int limit = 0; iter.hasNext() && limit < maxSlots; ++limit) {
                items.add((Object)((ItemStack)iter.next()).copy());
            }
            return items;
        }
        return NonNullList.create();
    }

    public static Object2IntOpenHashMap<ItemType> getStoredItemCounts(ItemStack stackShulkerBox) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stackShulkerBox);
        for (ItemStack stack : items) {
            if (stack.isEmpty()) continue;
            map.addTo((Object)new ItemType(stack), stack.getCount());
        }
        return map;
    }

    public static Object2IntOpenHashMap<ItemType> getInventoryItemCounts(Container inv) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int slots = inv.getContainerSize();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.isEmpty()) continue;
            map.addTo((Object)new ItemType(stack, false, true), stack.getCount());
            if (!(stack.getItem() instanceof BlockItem) || !(((BlockItem)stack.getItem()).getBlock() instanceof ShulkerBoxBlock)) continue;
            Object2IntOpenHashMap<ItemType> boxCounts = InventoryUtils.getStoredItemCounts(stack);
            for (ItemType type : boxCounts.keySet()) {
                map.addTo((Object)type, boxCounts.getInt((Object)type));
            }
        }
        return map;
    }

    public static NonNullList<ItemStack> getAsItemList(Container inv) {
        if (inv == null || inv.isEmpty()) {
            return NonNullList.create();
        }
        int size = inv.getContainerSize();
        NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < size; ++i) {
            ItemStack entry = inv.getItem(i);
            if (entry.isEmpty()) continue;
            list.set(i, (Object)entry.copy());
        }
        return list;
    }

    @Nullable
    public static Container getAsInventory(NonNullList<ItemStack> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        SimpleContainer inv = new SimpleContainer(items.size());
        for (int slot = 0; slot < items.size(); ++slot) {
            inv.setItem(slot, ((ItemStack)items.get(slot)).copy());
        }
        return inv;
    }

    @Nullable
    public static ItemStack getItemStackFromString(String itemNameIn) {
        return InventoryUtils.getItemStackFromString(itemNameIn, -1, DataComponentMap.EMPTY);
    }

    @Nullable
    public static ItemStack getItemStackFromString(String itemNameIn, DataComponentMap data) {
        return InventoryUtils.getItemStackFromString(itemNameIn, -1, data);
    }

    @Nullable
    public static ItemStack getItemStackFromString(String itemNameIn, int count) {
        return InventoryUtils.getItemStackFromString(itemNameIn, count, DataComponentMap.EMPTY);
    }

    @Nullable
    public static ItemStack getItemStackFromString(String itemNameIn, int count, @Nonnull DataComponentMap data) {
        String itemName;
        if (itemNameIn.isEmpty() || itemNameIn.equals("empty") || itemNameIn.equals("minecraft:air") || itemNameIn.equals("air")) {
            return ItemStack.EMPTY;
        }
        Matcher matcherBase = PATTERN_ITEM_BASE.matcher(itemNameIn);
        if (matcherBase.matches() && (itemName = matcherBase.group("name")) != null) {
            ResourceLocation itemId = ResourceLocation.tryParse((String)itemName);
            Holder itemEntry = BuiltInRegistries.ITEM.get(itemId).orElse(null);
            if (itemEntry != null && itemEntry.isBound()) {
                ItemStack stackOut = count < 0 ? new ItemStack(itemEntry) : new ItemStack(itemEntry, count);
                if (!data.isEmpty() && !data.equals((Object)DataComponentMap.EMPTY)) {
                    stackOut.applyComponents(data);
                }
                return stackOut;
            }
            MaLiLib.LOGGER.warn(StringUtils.translate("malilib.error.invalid_item_stack_entry.string", itemName));
        }
        return null;
    }

    @Nullable
    public static ItemStack getItemStackFromString(String stringIn, @Nonnull RegistryAccess registry) {
        ItemParser.ItemResult results;
        ItemParser itemStringReader = new ItemParser((HolderLookup.Provider)registry);
        try {
            results = itemStringReader.parse(new StringReader(stringIn));
        }
        catch (CommandSyntaxException e) {
            MaLiLib.LOGGER.warn(StringUtils.translate("malilib.error.invalid_item_stack_entry.nbt_syntax", stringIn));
            return null;
        }
        ItemStack stackOut = new ItemStack(results.item());
        stackOut.applyComponentsAndValidate(results.components());
        return stackOut;
    }

    public static Holder<Item> getItemEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder)registry.lookupOrThrow(BuiltInRegistries.ITEM.key()).get(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasStoredBlockEntityData(ItemStack stack) {
        return stack.has(DataComponents.BLOCK_ENTITY_DATA);
    }

    public static CompoundTag getStoredBlockEntityNbt(ItemStack stack) {
        TypedEntityData component;
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && (component = (TypedEntityData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null) {
            return component.copyTagWithoutId();
        }
        return new CompoundTag();
    }

    public static ItemStack fromNbtOrEmpty(@Nullable Tag tag) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            return InventoryUtils.fromNbtOrEmpty(mc.level.registryAccess(), tag);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getStackCodec(@Nonnull CompoundTag nbt, String key) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            return InventoryUtils.getStackCodec(nbt, mc.level.registryAccess(), key);
        }
        return ItemStack.EMPTY;
    }

    public static CompoundTag putStackCodec(@Nonnull CompoundTag nbt, @Nonnull ItemStack stack, String key) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            return InventoryUtils.putStackCodec(nbt, mc.level.registryAccess(), stack, key);
        }
        return new CompoundTag();
    }

    public static ItemStack fromNbtOrEmpty(@Nonnull RegistryAccess registry, @Nullable Tag tag) {
        if (tag == null) {
            return ItemStack.EMPTY;
        }
        return ItemStack.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial().orElse(ItemStack.EMPTY);
    }

    public static ItemStack getStackCodec(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry, String key) {
        return nbt.read(key, ItemStack.CODEC, (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(ItemStack.EMPTY);
    }

    public static CompoundTag putStackCodec(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry, @Nonnull ItemStack stack, String key) {
        nbt.store(key, ItemStack.CODEC, (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack);
        return nbt;
    }
}

