/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.converter;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.ByteArrayData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntArrayData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.LongArrayData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.StringData;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class DataConverterNbt {
    @Nullable
    public static BaseData fromVanillaNbt(Tag vanillaTag) {
        switch (vanillaTag.getId()) {
            case 1: {
                return new ByteData(((ByteTag)vanillaTag).value());
            }
            case 2: {
                return new ShortData(((ShortTag)vanillaTag).value());
            }
            case 3: {
                return new IntData(((IntTag)vanillaTag).value());
            }
            case 4: {
                return new LongData(((LongTag)vanillaTag).value());
            }
            case 5: {
                return new FloatData(((FloatTag)vanillaTag).value());
            }
            case 6: {
                return new DoubleData(((DoubleTag)vanillaTag).value());
            }
            case 8: {
                return new StringData(((StringTag)vanillaTag).value());
            }
            case 7: {
                return new ByteArrayData(((ByteArrayTag)vanillaTag).getAsByteArray());
            }
            case 11: {
                return new IntArrayData(((IntArrayTag)vanillaTag).getAsIntArray());
            }
            case 12: {
                return new LongArrayData(((LongArrayTag)vanillaTag).getAsLongArray());
            }
            case 10: {
                return DataConverterNbt.fromVanillaCompound((CompoundTag)vanillaTag);
            }
            case 9: {
                return DataConverterNbt.fromVanillaList((ListTag)vanillaTag);
            }
        }
        MaLiLib.LOGGER.warn("DataConverterNbt.fromVanillaCompound: Unknown NBT tag id {}", (Object)vanillaTag.getId());
        return null;
    }

    @Nullable
    public static ListData fromVanillaList(ListTag vanillaList) {
        ListData list = new ListData(vanillaList.getId());
        for (int index = 0; index < vanillaList.size(); ++index) {
            Tag entry = (Tag)vanillaList.get(index);
            if (entry.getId() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.fromVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return null;
            }
            BaseData convertedTag = DataConverterNbt.fromVanillaNbt(entry);
            if (convertedTag == null) {
                return null;
            }
            list.add(convertedTag);
        }
        return list;
    }

    public static CompoundData fromVanillaCompound(CompoundTag vanillaCompound) {
        CompoundData data = new CompoundData();
        for (String key : vanillaCompound.keySet()) {
            BaseData convertedTag = DataConverterNbt.fromVanillaNbt(vanillaCompound.get(key));
            if (convertedTag == null) continue;
            data.put(key, convertedTag);
        }
        return data;
    }

    @Nullable
    public static Tag toVanillaNbt(BaseData data) {
        switch (data.getType()) {
            case 1: {
                return ByteTag.valueOf((byte)((ByteData)data).value);
            }
            case 2: {
                return ShortTag.valueOf((short)((ShortData)data).value);
            }
            case 3: {
                return IntTag.valueOf((int)((IntData)data).value);
            }
            case 4: {
                return LongTag.valueOf((long)((LongData)data).value);
            }
            case 5: {
                return FloatTag.valueOf((float)((FloatData)data).value);
            }
            case 6: {
                return DoubleTag.valueOf((double)((DoubleData)data).value);
            }
            case 8: {
                return StringTag.valueOf((String)((StringData)data).value);
            }
            case 7: {
                return new ByteArrayTag(((ByteArrayData)data).value);
            }
            case 11: {
                return new IntArrayTag(((IntArrayData)data).value);
            }
            case 12: {
                return new LongArrayTag(((LongArrayData)data).value);
            }
            case 10: {
                return DataConverterNbt.toVanillaCompound((CompoundData)data);
            }
            case 9: {
                return DataConverterNbt.toVanillaList((ListData)data);
            }
        }
        MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaNbt: Unknown NBT tag id {}", (Object)data.getType());
        return null;
    }

    @Nullable
    public static ListTag toVanillaList(ListData listData) {
        ListTag list = new ListTag();
        for (int index = 0; index < listData.size(); ++index) {
            BaseData entry = listData.get(index);
            if (entry.getType() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return null;
            }
            Tag convertedTag = DataConverterNbt.toVanillaNbt(entry);
            if (convertedTag == null) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaList: Got a null tag in a list at index {}", (Object)index);
                return null;
            }
            list.add((Object)convertedTag);
        }
        return list;
    }

    public static CompoundTag toVanillaCompound(CompoundData compoundData) {
        CompoundTag tag = new CompoundTag();
        for (String key : compoundData.getKeys()) {
            Tag convertedTag = DataConverterNbt.toVanillaNbt(compoundData.getData(key).orElse(null));
            if (convertedTag == null) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaCompound: Got a null tag in a compound with key {}", (Object)key);
                return null;
            }
            tag.put(key, convertedTag);
        }
        return tag;
    }
}

