/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game.wrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class RegistryUtils {
    public static Block getBlockByIdStr(String name) {
        try {
            return RegistryUtils.getBlockById(fi.dy.masa.malilib.util.data.ResourceLocation.of(name));
        }
        catch (Exception e) {
            return Blocks.AIR;
        }
    }

    public static Block getBlockById(fi.dy.masa.malilib.util.data.ResourceLocation id) {
        return (Block)BuiltInRegistries.BLOCK.getValue(id.getId());
    }

    public static Block getBlockById(ResourceLocation id) {
        return (Block)BuiltInRegistries.BLOCK.getValue(id);
    }

    @Nonnull
    public static fi.dy.masa.malilib.util.data.ResourceLocation getBlockId(Block block) {
        return fi.dy.masa.malilib.util.data.ResourceLocation.of(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    @Nonnull
    public static fi.dy.masa.malilib.util.data.ResourceLocation getBlockId(BlockState state) {
        return RegistryUtils.getBlockId(state.getBlock());
    }

    public static String getBlockIdStr(Block block) {
        fi.dy.masa.malilib.util.data.ResourceLocation id = RegistryUtils.getBlockId(block);
        return id.toString();
    }

    public static Holder<Block> getBlockEntry(fi.dy.masa.malilib.util.data.ResourceLocation id, @Nonnull RegistryAccess registry) {
        return RegistryUtils.getBlockEntry(id.getId(), registry);
    }

    public static Holder<Block> getBlockEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder)registry.lookupOrThrow(BuiltInRegistries.BLOCK.key()).get(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Holder<BlockEntityType<?>> getBlockEntityType(fi.dy.masa.malilib.util.data.ResourceLocation id, @Nonnull RegistryAccess registry) {
        return RegistryUtils.getBlockEntityType(id.getId(), registry);
    }

    @Nullable
    public static Holder<BlockEntityType<?>> getBlockEntityType(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return registry.lookupOrThrow(BuiltInRegistries.BLOCK_ENTITY_TYPE.key()).get(id).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Holder<EntityType<?>> getEntityType(fi.dy.masa.malilib.util.data.ResourceLocation id, @Nonnull RegistryAccess registry) {
        return RegistryUtils.getEntityType(id.getId(), registry);
    }

    @Nullable
    public static Holder<EntityType<?>> getEntityType(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return registry.lookupOrThrow(BuiltInRegistries.ENTITY_TYPE.key()).get(id).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBlockIdStr(BlockState state) {
        return RegistryUtils.getBlockIdStr(state.getBlock());
    }

    public static Collection<fi.dy.masa.malilib.util.data.ResourceLocation> getRegisteredBlockIds() {
        return fi.dy.masa.malilib.util.data.ResourceLocation.of(new ArrayList<ResourceLocation>(BuiltInRegistries.BLOCK.keySet()));
    }

    public static List<Block> getSortedBlockList() {
        ArrayList<Block> blocks = new ArrayList<Block>(BuiltInRegistries.BLOCK.stream().toList());
        blocks.sort(Comparator.comparing(RegistryUtils::getBlockIdStr));
        return blocks;
    }

    public static Item getItemByIdStr(String name) {
        try {
            return RegistryUtils.getItemById(fi.dy.masa.malilib.util.data.ResourceLocation.of(name));
        }
        catch (Exception e) {
            return Items.AIR;
        }
    }

    public static Item getItemById(fi.dy.masa.malilib.util.data.ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.getValue(id.getId());
    }

    public static fi.dy.masa.malilib.util.data.ResourceLocation getItemId(Item item) {
        return fi.dy.masa.malilib.util.data.ResourceLocation.of(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static String getItemIdStr(Item item) {
        fi.dy.masa.malilib.util.data.ResourceLocation id = RegistryUtils.getItemId(item);
        return id.toString();
    }

    public static Collection<fi.dy.masa.malilib.util.data.ResourceLocation> getRegisteredItemIds() {
        return fi.dy.masa.malilib.util.data.ResourceLocation.of(new ArrayList<ResourceLocation>(BuiltInRegistries.ITEM.keySet()));
    }

    public static List<Item> getSortedItemList() {
        ArrayList<Item> items = new ArrayList<Item>(BuiltInRegistries.ITEM.stream().toList());
        items.sort(Comparator.comparing(RegistryUtils::getItemIdStr));
        return items;
    }
}

