/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import fi.dy.masa.malilib.mixin.nbt.IMixinNbtReadView;
import fi.dy.masa.malilib.mixin.nbt.IMixinNbtWriteView;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueInputContextHelper;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbtView {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"malilib-NbtView");
    private static final ProblemReporter log = new ProblemReporter.ScopedCollector(LOGGER);
    private ValueInput reader;
    private ValueOutput writer;

    private NbtView() {
    }

    public static NbtView getReader(CompoundTag nbt, @Nonnull RegistryAccess registry) {
        NbtView wrapper = new NbtView();
        wrapper.reader = TagValueInput.create((ProblemReporter)log, (HolderLookup.Provider)registry, (CompoundTag)nbt);
        wrapper.writer = null;
        return wrapper;
    }

    public static NbtView getWriter(@Nonnull RegistryAccess registry) {
        NbtView wrapper = new NbtView();
        wrapper.reader = null;
        wrapper.writer = TagValueOutput.createWithContext((ProblemReporter)log, (HolderLookup.Provider)registry);
        return wrapper;
    }

    public ProblemReporter getErrorReporter() {
        return log;
    }

    public boolean isReader() {
        return this.reader != null;
    }

    public boolean isWriter() {
        return this.writer != null;
    }

    @Nullable
    public ValueInput getReader() {
        return this.reader;
    }

    @Nullable
    public ValueOutput getWriter() {
        return this.writer;
    }

    @Nullable
    public TagValueInput asNbtReader() {
        return (TagValueInput)this.reader;
    }

    @Nullable
    public TagValueOutput asNbtWriter() {
        return (TagValueOutput)this.writer;
    }

    @Nullable
    public ValueInputContextHelper getReaderContext() {
        if (this.isReader()) {
            return ((IMixinNbtReadView)this.reader).malilib_getContext();
        }
        LOGGER.error("getReaderContext(): Called from a Writer Context");
        return null;
    }

    @Nullable
    public DynamicOps<?> getWriterOps() {
        if (this.isWriter()) {
            return ((IMixinNbtWriteView)this.writer).malilib_getOps();
        }
        LOGGER.error("getWriterOps(): Called from a Reader Context");
        return null;
    }

    @Nullable
    public CompoundTag readNbt() {
        if (this.isReader()) {
            return ((IMixinNbtReadView)this.reader).malilib_getNbt();
        }
        if (this.isWriter()) {
            return ((IMixinNbtWriteView)this.writer).malilib_getNbt();
        }
        LOGGER.error("readNbt(): General failure");
        return null;
    }

    @Nullable
    public NbtView writeNbt(@Nonnull CompoundTag nbtIn) {
        if (this.isReader()) {
            LOGGER.error("writeNbt(): Called from a Reader Context");
            return null;
        }
        for (String key : nbtIn.keySet()) {
            Objects.requireNonNull(this.readNbt()).put(key, nbtIn.get(key));
        }
        return this;
    }

    public <T> Optional<T> readFlatMap(MapCodec<T> mapCodec) {
        if (this.isWriter()) {
            LOGGER.error("readFlatMap(): Called from a Writer Context");
            return Optional.empty();
        }
        return NbtUtils.readFlatMap(Objects.requireNonNullElse(this.readNbt(), new CompoundTag()), mapCodec);
    }

    public <T> Optional<T> readCodec(String key, Codec<T> codec) {
        if (this.isWriter()) {
            LOGGER.error("readCodec(): Called from a Writer Context");
            return Optional.empty();
        }
        try {
            return this.reader.read(key, codec);
        }
        catch (Exception err) {
            LOGGER.warn("readCodec(): Exception reading from key '{}'; {}", (Object)key, (Object)err.getLocalizedMessage());
            return Optional.empty();
        }
    }

    public <T> CompoundTag writeFlatMap(MapCodec<T> mapCodec, T value) {
        if (this.isReader()) {
            LOGGER.error("writeFlatMap(): Called from a Reader Context");
            return new CompoundTag();
        }
        this.writeNbt(NbtUtils.writeFlatMap(mapCodec, value));
        return this.readNbt();
    }

    public <T> CompoundTag writeCodec(String key, Codec<T> codec, T value) {
        if (this.isReader()) {
            LOGGER.error("writeCodec(): Called from a Reader Context");
            return new CompoundTag();
        }
        try {
            this.writer.store(key, codec, value);
            return this.readNbt();
        }
        catch (Exception err) {
            LOGGER.warn("writeCodec(): Exception writing to key '{}'; {}", (Object)key, (Object)err.getLocalizedMessage());
            return new CompoundTag();
        }
    }
}

