/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.util.position.BlockRotation;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public class PositionUtils {
    public static final Direction[] ALL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] VERTICAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP};
    public static final int SIZE_BITS_X = 26;
    public static final int SIZE_BITS_Z = 26;
    public static final int SIZE_BITS_Y = 12;
    public static final long BITMASK_X = 0x3FFFFFFL;
    public static final long BITMASK_Y = 4095L;
    public static final long BITMASK_Z = 0x3FFFFFFL;
    public static final int BIT_SHIFT_Z = 0;
    public static final int BIT_SHIFT_Y = 26;
    public static final int BIT_SHIFT_X = 38;

    public static long blockPosToLong(int x, int y, int z) {
        return ((long)x & 0x3FFFFFFL) << 38 | ((long)y & 0xFFFL) << 26 | ((long)z & 0x3FFFFFFL) << 0;
    }

    public static int unpackX(long packedPos) {
        return (int)(packedPos << 0 >> 38);
    }

    public static int unpackY(long packedPos) {
        return (int)(packedPos << 26 >> 52);
    }

    public static int unpackZ(long packedPos) {
        return (int)(packedPos << 38 >> 38);
    }

    public static int getPackedChunkRelativePosition(BlockPos pos) {
        return pos.getY() << 8 | (pos.getZ() & 0xF) << 4 | pos.getX() & 0xF;
    }

    public static long getPackedAbsolutePosition(long chunkPos, int chunkRelativeBlockPos) {
        int chunkX = (int)chunkPos;
        int chunkZ = (int)(chunkPos >> 32);
        int x = (chunkX << 4) + (chunkRelativeBlockPos & 0xF);
        int y = chunkRelativeBlockPos >> 8;
        int z = (chunkZ << 4) + (chunkRelativeBlockPos >> 4 & 0xF);
        return PositionUtils.blockPosToLong(x, y, z);
    }

    public static int getChunkPosX(long chunkPosLong) {
        return (int)chunkPosLong;
    }

    public static int getChunkPosZ(long chunkPosLong) {
        return (int)(chunkPosLong >> 32);
    }

    public static ChunkPos chunkPosFromLong(long chunkPosLong) {
        return new ChunkPos(PositionUtils.getChunkPosX(chunkPosLong), PositionUtils.getChunkPosZ(chunkPosLong));
    }

    public static BlockPos getMinCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()));
    }

    public static BlockPos getMinCorner(BlockPos pos1, BlockPos pos2, BlockPos pos3) {
        return new BlockPos(Math.min(pos1.getX(), Math.min(pos2.getX(), pos3.getX())), Math.min(pos1.getY(), Math.min(pos2.getY(), pos3.getY())), Math.min(pos1.getZ(), Math.min(pos2.getZ(), pos3.getZ())));
    }

    public static BlockPos getMaxCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()));
    }

    public static BlockPos getMaxCorner(BlockPos pos1, BlockPos pos2, BlockPos pos3) {
        return new BlockPos(Math.max(pos1.getX(), Math.max(pos2.getX(), pos3.getX())), Math.max(pos1.getY(), Math.max(pos2.getY(), pos3.getY())), Math.max(pos1.getZ(), Math.max(pos2.getZ(), pos3.getZ())));
    }

    public static boolean isPositionInsideArea(BlockPos pos, BlockPos posMin, BlockPos posMax) {
        return pos.getX() >= posMin.getX() && pos.getX() <= posMax.getX() && pos.getY() >= posMin.getY() && pos.getY() <= posMax.getY() && pos.getZ() >= posMin.getZ() && pos.getZ() <= posMax.getZ();
    }

    public static Direction getClosestSideDirection(Entity entity) {
        float forwardYaw;
        Direction forwardDirection = entity.getDirection();
        float entityYaw = (entity.getYRot() % 360.0f + 360.0f) % 360.0f;
        if (entityYaw < (forwardYaw = forwardDirection.toYRot()) || forwardYaw == 0.0f && entityYaw > 270.0f) {
            return forwardDirection.getCounterClockWise();
        }
        return forwardDirection.getClockWise();
    }

    public static BlockPos getPositionInFrontOfEntity(Entity entity) {
        return PositionUtils.getPositionInFrontOfEntity(entity, 60.0f);
    }

    public static BlockPos getPositionInFrontOfEntity(Entity entity, float verticalThreshold) {
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float pitch = entity.getXRot();
        if (pitch >= verticalThreshold) {
            return BlockPos.containing((double)x, (double)(y - 1.0), (double)z);
        }
        if (pitch <= -verticalThreshold) {
            return BlockPos.containing((double)x, (double)Math.ceil(entity.getBoundingBox().maxY), (double)z);
        }
        double width = entity.getBbWidth();
        y = Math.floor(y + (double)entity.getEyeHeight(Pose.STANDING));
        switch (entity.getDirection()) {
            case EAST: {
                return new BlockPos((int)Math.ceil(x + width / 2.0), (int)y, (int)Math.floor(z));
            }
            case WEST: {
                return new BlockPos((int)Math.floor(x - width / 2.0) - 1, (int)y, (int)Math.floor(z));
            }
            case SOUTH: {
                return new BlockPos((int)Math.floor(x), (int)y, (int)Math.ceil(z + width / 2.0));
            }
            case NORTH: {
                return new BlockPos((int)Math.floor(x), (int)y, (int)Math.floor(z - width / 2.0) - 1);
            }
        }
        return BlockPos.containing((double)x, (double)y, (double)z);
    }

    @Nullable
    public static BlockRotation getRotation(Direction directionFrom, Direction directionTo) {
        if (directionFrom == directionTo) {
            return BlockRotation.NONE;
        }
        if (directionFrom.getAxis() == Direction.Axis.Y || directionTo.getAxis() == Direction.Axis.Y) {
            return null;
        }
        if (directionTo == directionFrom.getOpposite()) {
            return BlockRotation.CW_180;
        }
        return directionTo == directionFrom.getClockWise() ? BlockRotation.CW_90 : BlockRotation.CCW_90;
    }

    public static Vec3 getHitVecCenter(BlockPos basePos, Direction facing) {
        int x = basePos.getX();
        int y = basePos.getY();
        int z = basePos.getZ();
        switch (facing) {
            case UP: {
                return new Vec3((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            case DOWN: {
                return new Vec3((double)x + 0.5, (double)y, (double)z + 0.5);
            }
            case NORTH: {
                return new Vec3((double)x + 0.5, (double)y + 0.5, (double)z);
            }
            case SOUTH: {
                return new Vec3((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            }
            case WEST: {
                return new Vec3((double)x, (double)y + 0.5, (double)z);
            }
            case EAST: {
                return new Vec3((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            }
        }
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static HitPart getHitPart(Direction originalSide, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        Vec3 positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.x;
        double posV = positions.y;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static Vec3 getHitPartPositions(Direction originalSide, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        double x = hitVec.x - (double)pos.getX();
        double y = hitVec.y - (double)pos.getY();
        double z = hitVec.z - (double)pos.getZ();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case UP: 
            case DOWN: {
                switch (playerFacingH) {
                    case NORTH: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case SOUTH: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case WEST: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case EAST: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != Direction.DOWN) break;
                posV = 1.0 - posV;
                break;
            }
            case SOUTH: 
            case NORTH: {
                posH = originalSide.getAxisDirection() == Direction.AxisDirection.POSITIVE ? x : 1.0 - x;
                posV = y;
                break;
            }
            case EAST: 
            case WEST: {
                posH = originalSide.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? z : 1.0 - z;
                posV = y;
            }
        }
        return new Vec3(posH, posV, 0.0);
    }

    public static Direction getTargetedDirection(Direction side, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        Vec3 positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.x;
        double posV = positions.y;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.getAxis() == Direction.Axis.Y) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.getCounterClockWise() : playerFacingH.getClockWise();
                }
                if (side == Direction.DOWN) {
                    return posV > 0.5 ? playerFacingH.getOpposite() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.getOpposite() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.getClockWise() : side.getCounterClockWise();
            }
            return posV < 0.5 ? Direction.DOWN : Direction.UP;
        }
        return side;
    }

    public static Vec3 adjustPositionToSideOfEntity(Vec3 pos, Entity entity, Direction side) {
        double x = pos.x;
        double y = pos.y;
        double z = pos.z;
        if (side == Direction.DOWN) {
            y -= (double)entity.getBbHeight();
        } else if (side.getAxis().isHorizontal()) {
            x += (double)side.getStepX() * ((double)(entity.getBbWidth() / 2.0f) + 1.0E-4);
            z += (double)side.getStepZ() * ((double)(entity.getBbWidth() / 2.0f) + 1.0E-4);
        }
        return new Vec3(x, y, z);
    }

    public static Vec3 modifyValue(CoordinateType type, Vec3 valueIn, double amount) {
        switch (type.ordinal()) {
            case 0: {
                return new Vec3(valueIn.x + amount, valueIn.y, valueIn.z);
            }
            case 1: {
                return new Vec3(valueIn.x, valueIn.y + amount, valueIn.z);
            }
            case 2: {
                return new Vec3(valueIn.x, valueIn.y, valueIn.z + amount);
            }
        }
        return valueIn;
    }

    public static BlockPos modifyValue(CoordinateType type, BlockPos valueIn, int amount) {
        switch (type.ordinal()) {
            case 0: {
                return BlockPos.containing((double)(valueIn.getX() + amount), (double)valueIn.getY(), (double)valueIn.getZ());
            }
            case 1: {
                return BlockPos.containing((double)valueIn.getX(), (double)(valueIn.getY() + amount), (double)valueIn.getZ());
            }
            case 2: {
                return BlockPos.containing((double)valueIn.getX(), (double)valueIn.getY(), (double)(valueIn.getZ() + amount));
            }
        }
        return valueIn;
    }

    public static Vec3 setValue(CoordinateType type, Vec3 valueIn, double newValue) {
        switch (type.ordinal()) {
            case 0: {
                return new Vec3(newValue, valueIn.y, valueIn.z);
            }
            case 1: {
                return new Vec3(valueIn.x, newValue, valueIn.z);
            }
            case 2: {
                return new Vec3(valueIn.x, valueIn.y, newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos setValue(CoordinateType type, BlockPos valueIn, int newValue) {
        switch (type.ordinal()) {
            case 0: {
                return BlockPos.containing((double)newValue, (double)valueIn.getY(), (double)valueIn.getZ());
            }
            case 1: {
                return BlockPos.containing((double)valueIn.getX(), (double)newValue, (double)valueIn.getZ());
            }
            case 2: {
                return BlockPos.containing((double)valueIn.getX(), (double)valueIn.getY(), (double)newValue);
            }
        }
        return valueIn;
    }

    @Deprecated
    public static Direction getClosestLookingDirection(Entity entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    @Deprecated
    public static Direction getClosestLookingDirection(Entity entity, float verticalThreshold) {
        if (entity.getXRot() >= verticalThreshold) {
            return Direction.DOWN;
        }
        if (entity.getYRot() <= -verticalThreshold) {
            return Direction.UP;
        }
        return entity.getDirection();
    }

    public static BlockPos getEntityBlockPos(Entity entity) {
        return BlockPos.containing((double)Math.floor(entity.getX()), (double)Math.floor(entity.getY()), (double)Math.floor(entity.getZ()));
    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }
}

