/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.event.RenderEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IGuiRendererInvoker;
import fi.dy.masa.malilib.mixin.render.IMixinAbstractTexture;
import fi.dy.masa.malilib.mixin.render.IMixinDrawContext;
import fi.dy.masa.malilib.mixin.render.IMixinGuiRenderer;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderContext;
import fi.dy.masa.malilib.render.element.MaLiLibBasicRectGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibGradientRectGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibLightTexturedGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibTexturedGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibTexturedRectGuiElement;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.GuiRenderer;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.gui.PictureInPictureRendererPool;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class RenderUtils {
    private static final AnsiLogger LOGGER = new AnsiLogger(RenderUtils.class);
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/map/map_background.png");
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND_CHECKERBOARD = ResourceLocation.withDefaultNamespace((String)"textures/map/map_background_checkerboard.png");
    private static final SingleThreadedRandomSource RAND = new SingleThreadedRandomSource(0L);

    @Deprecated
    public static void blend(boolean toggle) {
        if (toggle) {
            GlStateManager._enableBlend();
            GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        } else {
            GlStateManager._disableBlend();
        }
    }

    @Deprecated
    public static void depthTest(boolean toggle) {
        if (toggle) {
            GlStateManager._enableDepthTest();
        } else {
            GlStateManager._disableDepthTest();
        }
    }

    @Deprecated
    public static void depthFunc(int depth) {
        GlStateManager._depthFunc((int)depth);
    }

    @Deprecated
    public static void depthMask(boolean toggle) {
        GlStateManager._depthMask((boolean)toggle);
    }

    @Deprecated
    public static void culling(boolean toggle) {
        if (toggle) {
            GlStateManager._enableCull();
        } else {
            GlStateManager._disableCull();
        }
    }

    @Deprecated
    public static void polygonOffset(boolean toggle) {
        if (toggle) {
            GlStateManager._enablePolygonOffset();
        } else {
            GlStateManager._disablePolygonOffset();
        }
    }

    @Deprecated
    public static void polygonOffset(float factor, float units) {
        GlStateManager._polygonOffset((float)factor, (float)units);
    }

    @Deprecated
    public static void fbStartDrawing() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    public static SimpleTexture bindShaderTexture(ResourceLocation texture, int textureId) throws RuntimeException {
        if (textureId < 0 || textureId > 12) {
            throw new RuntimeException("Invalid textureId of: " + textureId + " for texture: " + texture.toString());
        }
        SimpleTexture tex = (SimpleTexture)RenderUtils.tex().getTexture(texture);
        tex.setFilter(false, false);
        RenderSystem.setShaderTexture((int)textureId, (GpuTextureView)tex.getTextureView());
        return tex;
    }

    @Nullable
    public static GpuTexture bindGpuTexture(ResourceLocation texture) {
        SimpleTexture tex = (SimpleTexture)RenderUtils.tex().getTexture(texture);
        if (tex != null && ((IMixinAbstractTexture)tex).malilib_getGlTexture() != null) {
            return tex.getTexture();
        }
        return null;
    }

    @Nullable
    public static GpuTextureView bindGpuTextureView(ResourceLocation texture) {
        SimpleTexture tex = (SimpleTexture)RenderUtils.tex().getTexture(texture);
        if (tex != null && ((IMixinAbstractTexture)tex).malilib_getGlTextureView() != null) {
            return tex.getTextureView();
        }
        MaLiLib.LOGGER.error("bindGpuTextureView: Result is null!");
        return null;
    }

    public static void addSimpleElement(GuiGraphics drawContext, GuiElementRenderState simpleElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().submitGuiElement(simpleElement);
    }

    public static void addSpecialElement(GuiGraphics drawContext, PictureInPictureRenderState specialElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().submitPicturesInPictureState(specialElement);
    }

    @ApiStatus.Internal
    public static void registerSpecialGuiRenderers(GuiRenderer guiRenderer, MultiBufferSource.BufferSource immediate, Minecraft mc) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.putAll(((IMixinGuiRenderer)guiRenderer).malilib_getSpecialGuiRenderers());
        ((RenderEventHandler)RenderEventHandler.getInstance()).onRegisterSpecialGuiRenderer(guiRenderer, immediate, mc, builder);
        ((IGuiRendererInvoker)guiRenderer).malilib$replaceSpecialGuiRenderers((Map<Class<? extends PictureInPictureRenderState>, PictureInPictureRendererPool<?>>)builder.buildOrThrow());
        if (MaLiLibReference.DEBUG_MODE) {
            RenderUtils.dumpBuilderMap(((IMixinGuiRenderer)guiRenderer).malilib_getSpecialGuiRenderers());
        }
    }

    public static void dumpBuilderMap(Map<Class<? extends PictureInPictureRenderState>, PictureInPictureRendererPool<?>> entries) {
        System.out.print("DUMP SpecialGuiRenderers()\n");
        if (entries == null || entries.size() == 0) {
            System.out.print("NULL OR EMPTY!\n");
            return;
        }
        int i = 0;
        for (Class<? extends PictureInPictureRenderState> entry : entries.keySet()) {
            System.out.printf("[%d] K (State): [%s], V (Renderer): [%s]\n", i, entry.getName(), entries.get(entry).getClass().getName());
            ++i;
        }
        System.out.print("DUMP END\n");
    }

    public static void addItemElement(GuiGraphics drawContext, GuiItemRenderState itemElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().submitItem(itemElement);
    }

    public static void addTextElement(GuiGraphics drawContext, GuiTextRenderState textElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().submitText(textElement);
    }

    public static void pushScissor(GuiGraphics drawContext, @Nonnull ScreenRectangle rect) {
        ((IMixinDrawContext)drawContext).malilib_getScissorStack().push(rect);
    }

    public static boolean containsScissor(GuiGraphics drawContext, int x, int y) {
        return ((IMixinDrawContext)drawContext).malilib_getScissorStack().containsPoint(x, y);
    }

    public static ScreenRectangle peekLastScissor(GuiGraphics drawContext) {
        return ((IMixinDrawContext)drawContext).malilib_getScissorStack().peek();
    }

    public static ScreenRectangle popScissor(GuiGraphics drawContext) {
        return ((IMixinDrawContext)drawContext).malilib_getScissorStack().pop();
    }

    public static void drawOutlinedBox(GuiGraphics drawContext, int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, width, height, colorBg);
        RenderUtils.drawOutline(drawContext, x - 1, y - 1, width + 2, height + 2, colorBorder);
    }

    public static void drawOutlinedBox(GuiGraphics drawContext, int x, int y, int width, int height, float scale, int colorBg, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, width, height, colorBg, scale);
        RenderUtils.drawOutline(drawContext, x - 1, y - 1, width + 2, height + 2, scale, colorBorder);
    }

    public static void drawOutline(GuiGraphics drawContext, int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(drawContext, x, y, width, height, 1, colorBorder);
    }

    public static void drawOutline(GuiGraphics drawContext, int x, int y, int width, int height, float scale, int colorBorder) {
        RenderUtils.drawOutline(drawContext, x, y, width, height, scale, 1, colorBorder);
    }

    public static void drawOutline(GuiGraphics drawContext, int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, borderWidth, height, colorBorder);
        RenderUtils.drawRect(drawContext, x + width - borderWidth, y, borderWidth, height, colorBorder);
        RenderUtils.drawRect(drawContext, x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder);
        RenderUtils.drawRect(drawContext, x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder);
    }

    public static void drawOutline(GuiGraphics drawContext, int x, int y, int width, int height, float scale, int borderWidth, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, borderWidth, height, colorBorder, scale);
        RenderUtils.drawRect(drawContext, x + width - borderWidth, y, borderWidth, height, colorBorder, scale);
        RenderUtils.drawRect(drawContext, x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, scale);
        RenderUtils.drawRect(drawContext, x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, scale);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, boolean depthMask) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f, 1.0f, depthMask);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, color, zLevel, 1.0f, false);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, float zLevel, boolean depthMask) {
        RenderUtils.drawRect(x, y, width, height, color, zLevel, 1.0f, depthMask);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, float zLevel, float scale, boolean depthMask) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderContext ctx = new RenderContext(() -> "malilib:drawRect", depthMask ? MaLiLibPipelines.POSITION_COLOR_MASA_DEPTH_MASK : MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        BufferBuilder buffer = ctx.getBuilder();
        buffer.addVertex((float)x * scale, (float)y * scale, zLevel).setColor(r, g, b, a);
        buffer.addVertex((float)x * scale, (float)(y + height) * scale, zLevel).setColor(r, g, b, a);
        buffer.addVertex((float)(x + width) * scale, (float)(y + height) * scale, zLevel).setColor(r, g, b, a);
        buffer.addVertex((float)(x + width) * scale, (float)y * scale, zLevel).setColor(r, g, b, a);
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawRect(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void drawRect(GuiGraphics drawContext, int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(drawContext, x, y, width, height, color, 1.0f);
    }

    public static void drawRect(GuiGraphics drawContext, int x, int y, int width, int height, int color, float scale) {
        RenderUtils.addSimpleElement(drawContext, new MaLiLibBasicRectGuiElement(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)drawContext.pose()), x, y, width, height, scale, color, RenderUtils.peekLastScissor(drawContext)));
    }

    public static void drawScreenBlur(Minecraft mc) {
        mc.gameRenderer.processBlurEffect();
    }

    @Deprecated
    public static void drawTexturedRect(Matrix4f posMatrix, int x, int y, int u, int v, int width, int height, VertexConsumer buffer) {
        RenderUtils.drawTexturedRect(posMatrix, x, y, u, v, width, height, 0.0f, -1, buffer);
    }

    @Deprecated
    public static void drawTexturedRect(Matrix4f posMatrix, int x, int y, int u, int v, int width, int height, int color, VertexConsumer buffer) {
        RenderUtils.drawTexturedRect(posMatrix, x, y, u, v, width, height, 0.0f, color, buffer);
    }

    @Deprecated
    public static void drawTexturedRect(Matrix4f posMatrix, int x, int y, int u, int v, int width, int height, float zLevel, int color, VertexConsumer buffer) {
        float pixelWidth = 0.00390625f;
        buffer.addVertex(posMatrix, (float)x, (float)(y + height), zLevel).setUv((float)u * pixelWidth, (float)(v + height) * pixelWidth).setColor(color);
        buffer.addVertex(posMatrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).setColor(color);
        buffer.addVertex(posMatrix, (float)(x + width), (float)y, zLevel).setUv((float)(u + width) * pixelWidth, (float)v * pixelWidth).setColor(color);
        buffer.addVertex(posMatrix, (float)x, (float)y, zLevel).setUv((float)u * pixelWidth, (float)v * pixelWidth).setColor(color);
    }

    public static void drawTexturedRect(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(drawContext, texture, x, y, u, v, width, height, 0.0f, -1);
    }

    public static void drawTexturedRect(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int u, int v, int width, int height, float zLevel) {
        RenderUtils.drawTexturedRect(drawContext, texture, x, y, u, v, width, height, zLevel, -1);
    }

    public static void drawTexturedRect(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int u, int v, int width, int height, float zLevel, int argb) {
        float pixelWidth = 0.00390625f;
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(texture);
        if (gpuTextureView == null) {
            MaLiLib.LOGGER.error("drawTexturedRect(): GpuTextureView for '{}' is null!", (Object)texture.toString());
            return;
        }
        RenderUtils.addSimpleElement(drawContext, new MaLiLibTexturedGuiElement(RenderPipelines.GUI_TEXTURED, TextureSetup.singleTexture((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)drawContext.pose()), x, y, x + width, y + height, (float)u * pixelWidth, (float)(u + width) * pixelWidth, (float)v * pixelWidth, (float)(v + height) * pixelWidth, argb, RenderUtils.peekLastScissor(drawContext)));
    }

    @Deprecated
    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, VertexConsumer buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, -1, buffer);
    }

    @Deprecated
    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, int argb, VertexConsumer buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, argb, buffer);
    }

    @Deprecated
    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, int argb, VertexConsumer buffer) {
        float pixelWidth = 0.00390625f;
        buffer.addVertex((float)x, (float)(y + height), zLevel).setUv((float)u * pixelWidth, (float)(v + height) * pixelWidth).setColor(argb);
        buffer.addVertex((float)(x + width), (float)(y + height), zLevel).setUv((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).setColor(argb);
        buffer.addVertex((float)(x + width), (float)y, zLevel).setUv((float)(u + width) * pixelWidth, (float)v * pixelWidth).setColor(argb);
        buffer.addVertex((float)x, (float)y, zLevel).setUv((float)u * pixelWidth, (float)v * pixelWidth).setColor(argb);
    }

    public static void drawTexturedRectBatched(GuiGraphics drawContext, @Nonnull GpuTextureView gpuTextureView, int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRectBatched(drawContext, gpuTextureView, x, y, u, v, width, height, 0.0f, -1);
    }

    public static void drawTexturedRectBatched(GuiGraphics drawContext, @Nonnull GpuTextureView gpuTextureView, int x, int y, int u, int v, int width, int height, int argb) {
        RenderUtils.drawTexturedRectBatched(drawContext, gpuTextureView, x, y, u, v, width, height, 0.0f, argb);
    }

    public static void drawTexturedRectBatched(GuiGraphics drawContext, @Nonnull GpuTextureView gpuTextureView, int x, int y, int u, int v, int width, int height, float zLevel, int argb) {
        RenderUtils.addSimpleElement(drawContext, new MaLiLibTexturedRectGuiElement(RenderPipelines.GUI_TEXTURED, TextureSetup.singleTexture((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)drawContext.pose()), x, y, u, v, width, height, argb, RenderUtils.peekLastScissor(drawContext)));
    }

    public static void drawHoverText(GuiGraphics drawContext, int x, int y, List<String> textLines) {
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            Font font = RenderUtils.mc().font;
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().width;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.width(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            drawContext.pose().pushMatrix();
            drawContext.pose().translate(0.0f, 0.0f);
            float zLevel = 300.0f;
            int borderColor = -267386864;
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, fillColor1, fillColor2);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, fillColor1, fillColor2);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, fillColor1, fillColor1);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                drawContext.drawString(font, str, textStartX, textStartY, -1, false);
                textStartY += lineHeight;
            }
            drawContext.pose().popMatrix();
        }
    }

    public static void drawGradientRectBatched(GuiGraphics drawContext, float left, float top, float right, float bottom, int startColor, int endColor) {
        RenderUtils.addSimpleElement(drawContext, new MaLiLibGradientRectGuiElement(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)drawContext.pose()), left, top, right, bottom, startColor, endColor, RenderUtils.peekLastScissor(drawContext)));
    }

    @Deprecated
    public static void drawGradientRect(float left, float top, float right, float bottom, float zLevel, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        RenderContext ctx = new RenderContext(() -> "malilib:drawGradientRect", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        BufferBuilder buffer = ctx.getBuilder();
        buffer.addVertex(right, top, zLevel).setColor(sr, sg, sb, sa);
        buffer.addVertex(left, top, zLevel).setColor(sr, sg, sb, sa);
        buffer.addVertex(left, bottom, zLevel).setColor(er, eg, eb, ea);
        buffer.addVertex(right, bottom, zLevel).setColor(er, eg, eb, ea);
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawGradientRect(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void drawCenteredString(GuiGraphics drawContext, int x, int y, int color, String text) {
        drawContext.drawCenteredString(RenderUtils.mc().font, text, x, y, color);
    }

    public static void drawHorizontalLine(GuiGraphics drawContext, int x, int y, int width, int color) {
        RenderUtils.drawRect(drawContext, x, y, width, 1, color);
    }

    public static void drawVerticalLine(GuiGraphics drawContext, int x, int y, int height, int color) {
        RenderUtils.drawRect(drawContext, x, y, 1, height, color);
    }

    public static void renderSprite(GuiGraphics drawContext, ResourceLocation atlas, ResourceLocation texture, int x, int y, int width, int height) {
        TextureAtlasSprite sprite;
        if (texture != null && (sprite = RenderUtils.mc().getAtlasManager().getAtlasOrThrow(atlas).getSprite(texture)) != null) {
            drawContext.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, x, y, width, height, -1);
        }
    }

    public static void renderText(GuiGraphics drawContext, int x, int y, int color, String text) {
        String[] parts = text.split("\\\\n");
        Font textRenderer = RenderUtils.mc().font;
        for (String line : parts) {
            drawContext.drawString(textRenderer, line, x, y, color, true);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
    }

    public static void renderText(GuiGraphics drawContext, int x, int y, int color, List<String> lines) {
        if (!lines.isEmpty()) {
            Font textRenderer = RenderUtils.mc().font;
            for (String line : lines) {
                drawContext.drawString(textRenderer, line, x, y, color, false);
                Objects.requireNonNull(textRenderer);
                y += 9 + 2;
            }
        }
    }

    public static int renderText(GuiGraphics drawContext, int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines) {
        return RenderUtils.renderText(drawContext, xOff, yOff, scale, textColor, bgColor, alignment, useBackground, useShadow, true, lines);
    }

    public static int renderText(GuiGraphics drawContext, int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, boolean useStatusShift, List<String> lines) {
        boolean scaled;
        Font fontRenderer = RenderUtils.mc().font;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale < 0.0125) {
            return 0;
        }
        boolean bl = scaled = scale != 1.0;
        if (scaled) {
            drawContext.pose().pushMatrix();
            drawContext.pose().scale((float)scale, (float)scale);
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        if (useStatusShift) {
            posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (Player)RenderUtils.mc().player);
        }
        for (String line : lines) {
            int width = fontRenderer.width(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)width / 2.0 - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                Objects.requireNonNull(fontRenderer);
                RenderUtils.drawRect(drawContext, x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            drawContext.drawString(fontRenderer, line, x, y, textColor, useShadow);
        }
        if (scaled) {
            drawContext.pose().popMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, Player player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.getActiveEffects();
            boolean hasTurtleHelmet = EntityUtils.hasTurtleHelmetEquipped(player);
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (MobEffectInstance effectInstance : effects) {
                    MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                    if (!effectInstance.isVisible() || !effectInstance.showIcon()) continue;
                    if (effect.isBeneficial()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                if (hasTurtleHelmet && y1 == 0) {
                    y1 = 26;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
            if (hasTurtleHelmet) {
                return (int)(26.0 / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - expand);
        float minY = (float)((double)pos.getY() - expand);
        float minZ = (float)((double)pos.getZ() - expand);
        float maxX = (float)((double)pos.getX() + expand + 1.0);
        float maxY = (float)((double)pos.getY() + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() + expand + 1.0);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(BlockPos pos, Vec3 cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - cameraPos.x - expand);
        float minY = (float)((double)pos.getY() - cameraPos.y - expand);
        float minZ = (float)((double)pos.getZ() - cameraPos.z - expand);
        float maxX = (float)((double)pos.getX() - cameraPos.x + expand + 1.0);
        float maxY = (float)((double)pos.getY() - cameraPos.y + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - cameraPos.z + expand + 1.0);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, Vec3.ZERO, color, expand, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Vec3 cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - expand - cameraPos.x);
        float minY = (float)((double)pos.getY() - expand - cameraPos.y);
        float minZ = (float)((double)pos.getZ() - expand - cameraPos.z);
        float maxX = (float)((double)pos.getX() + expand - cameraPos.x + 1.0);
        float maxY = (float)((double)pos.getY() + expand - cameraPos.y + 1.0);
        float maxZ = (float)((double)pos.getZ() + expand - cameraPos.z + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        RenderUtils.drawBoxWithEdgesBatched(posMin, posMax, Vec3.ZERO, colorLines, colorSides, bufferQuads, bufferLines);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Vec3 cameraPos, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        float x1 = (float)((double)posMin.getX() - cameraPos.x);
        float y1 = (float)((double)posMin.getY() - cameraPos.y);
        float z1 = (float)((double)posMin.getZ() - cameraPos.z);
        float x2 = (float)((double)(posMax.getX() + 1) - cameraPos.x);
        float y2 = (float)((double)(posMax.getY() + 1) - cameraPos.y);
        float z2 = (float)((double)(posMax.getZ() + 1) - cameraPos.z);
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxTopBatchedQuads(float minX, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxBottomBatchedQuads(float minX, float minY, float minZ, float maxX, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxAllEdgesBatchedLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBox(IntBoundingBox bb, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        float minX = (float)((double)bb.minX - cameraPos.x);
        float minY = (float)((double)bb.minY - cameraPos.y);
        float minZ = (float)((double)bb.minZ - cameraPos.z);
        float maxX = (float)((double)(bb.maxX + 1) - cameraPos.x);
        float maxY = (float)((double)(bb.maxY + 1) - cameraPos.y);
        float maxZ = (float)((double)(bb.maxZ + 1) - cameraPos.z);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawBoxNoOutlines(IntBoundingBox bb, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads) {
        float minX = (float)((double)bb.minX - cameraPos.x);
        float minY = (float)((double)bb.minY - cameraPos.y);
        float minZ = (float)((double)bb.minZ - cameraPos.z);
        float maxX = (float)((double)(bb.maxX + 1) - cameraPos.x);
        float maxY = (float)((double)(bb.maxY + 1) - cameraPos.y);
        float maxZ = (float)((double)(bb.maxZ + 1) - cameraPos.z);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        Entity entity = RenderUtils.mc().getCameraEntity();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.getYRot(), entity.getXRot(), scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        Vec3 cameraPos = RenderUtils.camPos();
        double cx = cameraPos.x;
        double cy = cameraPos.y;
        double cz = cameraPos.z;
        Font textRenderer = RenderUtils.mc().font;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        global4fStack.translate((float)(x - cx), (float)(y - cy), (float)(z - cz));
        global4fStack.rotateYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        global4fStack.scale(-scale, -scale, scale);
        RenderUtils.culling(false);
        RenderUtils.blend(true);
        RenderContext ctx = new RenderContext(() -> "malilib:drawTextPlate", MaLiLibPipelines.POSITION_COLOR_MASA);
        BufferBuilder buffer = ctx.getBuilder();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.width(line));
        }
        int strLenHalf = maxLineLen / 2;
        Objects.requireNonNull(textRenderer);
        int textHeight = 9 * text.size() - 1;
        int bga = bgColor >>> 24 & 0xFF;
        int bgr = bgColor >>> 16 & 0xFF;
        int bgg = bgColor >>> 8 & 0xFF;
        int bgb = bgColor & 0xFF;
        if (disableDepth) {
            RenderUtils.depthTest(false);
        }
        buffer.addVertex((float)(-strLenHalf - 1), -1.0f, 0.0f).setColor(bgr, bgg, bgb, bga);
        buffer.addVertex((float)(-strLenHalf - 1), (float)textHeight, 0.0f).setColor(bgr, bgg, bgb, bga);
        buffer.addVertex((float)strLenHalf, (float)textHeight, 0.0f).setColor(bgr, bgg, bgb, bga);
        buffer.addVertex((float)strLenHalf, -1.0f, 0.0f).setColor(bgr, bgg, bgb, bga);
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawTextPlate(): Draw Exception; {}", (Object)err.getMessage());
        }
        int textY = 0;
        if (!disableDepth) {
            RenderUtils.polygonOffset(true);
            RenderUtils.polygonOffset(-0.6f, -1.2f);
        }
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.identity();
        ByteBufferBuilder allocator = new ByteBufferBuilder(1536);
        for (String line : text) {
            MultiBufferSource.BufferSource immediate;
            if (disableDepth) {
                RenderUtils.depthTest(false);
                immediate = MultiBufferSource.immediate((ByteBufferBuilder)allocator);
                textRenderer.drawInBatch(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF, false, modelMatrix, (MultiBufferSource)immediate, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                immediate.endBatch();
                RenderUtils.depthTest(true);
            }
            immediate = MultiBufferSource.immediate((ByteBufferBuilder)allocator);
            textRenderer.drawInBatch(line, (float)(-strLenHalf), (float)textY, textColor, false, modelMatrix, (MultiBufferSource)immediate, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            immediate.endBatch();
            Objects.requireNonNull(textRenderer);
            textY += 9;
        }
        allocator.close();
        if (!disableDepth) {
            RenderUtils.polygonOffset(0.0f, 0.0f);
            RenderUtils.polygonOffset(false);
        }
        RenderUtils.culling(true);
        global4fStack.popMatrix();
    }

    public static void renderBlockTargetingOverlay(Entity entity, BlockPos pos, Direction side, Vec3 hitVec, Color4f color, Matrix4f posMatrix) {
        MeshData meshData;
        Direction playerFacing = entity.getDirection();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        Vec3 cameraPos = RenderUtils.camPos();
        double x = (double)pos.getX() + 0.5 - cameraPos.x;
        double y = (double)pos.getY() + 0.5 - cameraPos.y;
        double z = (double)pos.getZ() + 0.5 - cameraPos.z;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockTargetingOverlay Side", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        BufferBuilder buffer = ctx.getBuilder();
        int quadAlpha = 45;
        int hr = (int)(color.r * 255.0f);
        int hg = (int)(color.g * 255.0f);
        int hb = (int)(color.b * 255.0f);
        int ha = (int)(color.a * 255.0f);
        int c = 255;
        buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, quadAlpha);
        buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, quadAlpha);
        buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, quadAlpha);
        buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, quadAlpha);
        switch (part) {
            case CENTER: {
                buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case LEFT: {
                buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case RIGHT: {
                buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case TOP: {
                buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
            case BOTTOM: {
                buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(hr, hg, hb, ha);
                buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(hr, hg, hb, ha);
                break;
            }
        }
        try {
            MeshData meshData2 = buffer.build();
            if (meshData2 != null) {
                ctx.draw(meshData2, false);
                meshData2.close();
            }
            ctx.reset();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlay():1: Draw Exception; {}", (Object)err.getMessage());
        }
        int wireColor = -1;
        buffer = ctx.start(() -> "malilib:renderBlockTargetingOverlay/center", MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        try {
            meshData = buffer.build();
            if (meshData != null) {
                ctx.color(wireColor);
                ctx.lineWidth(1.6f);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.reset();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlay():2: Draw Exception; {}", (Object)err.getMessage());
        }
        buffer = ctx.start(() -> "malilib:renderBlockTargetingOverlay/edges", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y - 0.25), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.25), (float)(y + 0.25), (float)z).setColor(c, c, c, c);
        try {
            meshData = buffer.build();
            if (meshData != null) {
                ctx.color(wireColor);
                ctx.lineWidth(1.6f);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlay():3: Draw Exception; {}", (Object)err.getMessage());
        }
        global4fStack.popMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(Entity entity, BlockPos pos, Direction side, Color4f color, Matrix4f posMatrix) {
        MeshData meshData;
        Direction playerFacing = entity.getDirection();
        Vec3 cameraPos = RenderUtils.camPos();
        double x = (double)pos.getX() + 0.5 - cameraPos.x;
        double y = (double)pos.getY() + 0.5 - cameraPos.y;
        double z = (double)pos.getZ() + 0.5 - cameraPos.z;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockTargetingOverlaySimple/quads", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        BufferBuilder buffer = ctx.getBuilder();
        int a = (int)(color.a * 255.0f);
        int r = (int)(color.r * 255.0f);
        int g = (int)(color.g * 255.0f);
        int b = (int)(color.b * 255.0f);
        int c = 255;
        buffer.addVertex((float)(x - 0.5), (float)(y - 0.5), (float)z).setColor(r, g, b, a);
        buffer.addVertex((float)(x + 0.5), (float)(y - 0.5), (float)z).setColor(r, g, b, a);
        buffer.addVertex((float)(x + 0.5), (float)(y + 0.5), (float)z).setColor(r, g, b, a);
        buffer.addVertex((float)(x - 0.5), (float)(y + 0.5), (float)z).setColor(r, g, b, a);
        try {
            meshData = buffer.build();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.reset();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlaySimple():1: Draw Exception; {}", (Object)err.getMessage());
        }
        buffer = ctx.start(() -> "malilib:renderBlockTargetingOverlaySimple/lines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        buffer.addVertex((float)(x - 0.375), (float)(y - 0.375), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.375), (float)(y - 0.375), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x + 0.375), (float)(y + 0.375), (float)z).setColor(c, c, c, c);
        buffer.addVertex((float)(x - 0.375), (float)(y + 0.375), (float)z).setColor(c, c, c, c);
        try {
            meshData = buffer.build();
            if (meshData != null) {
                ctx.lineWidth(1.6f);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlaySimple():2: Draw Exception; {}", (Object)err.getMessage());
        }
        global4fStack.popMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, Direction side, Direction playerFacing, Matrix4fStack matrix4fStack) {
        matrix4fStack.translate((float)x, (float)y, (float)z);
        switch (side) {
            case DOWN: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.toYRot()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(90.0f));
                break;
            }
            case UP: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.toYRot()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case NORTH: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case EAST: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(90.0f));
            }
        }
        matrix4fStack.translate((float)(-x), (float)(-y), (float)(-z + 0.51));
    }

    public static void renderMapPreview(GuiGraphics drawContext, ItemStack stack, int x, int y, int dimensions) {
        RenderUtils.renderMapPreview(drawContext, stack, x, y, dimensions, true);
    }

    public static void renderMapPreview(GuiGraphics drawContext, ItemStack stack, int x, int y, int dimensions, boolean requireShift) {
        if (stack.getItem() instanceof MapItem && (!requireShift || GuiBase.isShiftDown())) {
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            int uv = 0xF000F0;
            MapItemSavedData mapState = MapItem.getSavedData((ItemStack)stack, (Level)RenderUtils.mc().level);
            DataComponentMap data = stack.getComponents();
            MapId mapId = (MapId)data.get(DataComponents.MAP_ID);
            ResourceLocation bgTexture = mapState == null ? TEXTURE_MAP_BACKGROUND : TEXTURE_MAP_BACKGROUND_CHECKERBOARD;
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(bgTexture);
            if (gpuTextureView == null) {
                MaLiLib.LOGGER.error("renderMapPreview(): Failed to bind GpuTexture!");
                return;
            }
            RenderUtils.addSimpleElement(drawContext, new MaLiLibLightTexturedGuiElement(RenderPipelines.GUI_TEXTURED, TextureSetup.singleTexture((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)drawContext.pose()), x1, y1, x2, y2, 0.0f, 1.0f, 0.0f, 1.0f, -1, uv, RenderUtils.peekLastScissor(drawContext)));
            if (mapId != null && mapState != null) {
                double scale = (double)(dimensions - 16) / 128.0;
                drawContext.pose().pushMatrix();
                drawContext.pose().translate((float)(x1 += 8), (float)(y1 += 8));
                drawContext.pose().scale((float)scale, (float)scale);
                MapRenderState mapRenderState = new MapRenderState();
                RenderUtils.mc().getMapRenderer().extractRenderState(mapId, mapState, mapRenderState);
                drawContext.submitMapRenderState(mapRenderState);
                drawContext.pose().popMatrix();
            }
        }
    }

    public static void renderShulkerBoxPreview(GuiGraphics drawContext, ItemStack stack, int baseX, int baseY, boolean useBgColors) {
        if (stack.getComponents().has(DataComponents.CONTAINER)) {
            NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.isEmpty()) {
                return;
            }
            CompoundTag nbt = InventoryUtils.getStoredBlockEntityNbt(stack);
            HashSet<Integer> lockedSlots = new HashSet();
            Container inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = Mth.clamp((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = Mth.clamp((int)(baseY - height), (int)0, (int)(screenHeight - height));
            int color = stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof ShulkerBoxBlock ? RenderUtils.setShulkerboxBackgroundTintColor((ShulkerBoxBlock)((BlockItem)stack.getItem()).getBlock(), useBgColors) : -1;
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(drawContext, type, x, y, props.slotsPerRow, props.totalSlots, color, RenderUtils.mc());
            color = -1;
            if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, x, y);
            }
            if (type == InventoryOverlay.InventoryRenderType.CRAFTER && !nbt.isEmpty()) {
                lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(nbt);
                InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, lockedSlots, RenderUtils.mc());
            } else {
                InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            }
            matrix4fStack.popMatrix();
        }
    }

    public static void renderBundlePreview(GuiGraphics drawContext, ItemStack stack, int baseX, int baseY, boolean useBgColors) {
        RenderUtils.renderBundlePreview(drawContext, stack, baseX, baseY, 9, useBgColors);
    }

    public static void renderBundlePreview(GuiGraphics drawContext, ItemStack stack, int baseX, int baseY, int slotsPerRow, boolean useBgColors) {
        if (stack.getComponents().has(DataComponents.BUNDLE_CONTENTS)) {
            int count = InventoryUtils.bundleCountItems(stack);
            NonNullList<ItemStack> items = InventoryUtils.getBundleItems(stack, count);
            int n = slotsPerRow = slotsPerRow != 9 ? MathUtils.clamp(slotsPerRow, 6, 9) : 9;
            if (items.isEmpty()) {
                return;
            }
            Container inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, count, slotsPerRow);
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = Mth.clamp((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = Mth.clamp((int)(baseY - height), (int)0, (int)(screenHeight - height));
            int color = RenderUtils.setBundleBackgroundTintColor(stack, useBgColors);
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(drawContext, type, x, y, props.slotsPerRow, props.totalSlots, color, RenderUtils.mc());
            InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, count, RenderUtils.mc());
            matrix4fStack.popMatrix();
        }
    }

    public static void renderNbtItemsPreview(GuiGraphics drawContext, ItemStack stackIn, @Nonnull CompoundTag itemsTag, int baseX, int baseY, boolean useBgColors) {
        if (InventoryUtils.hasNbtItems(itemsTag)) {
            if (RenderUtils.mc().level == null) {
                return;
            }
            NonNullList<ItemStack> items = InventoryUtils.getNbtItems(itemsTag, -1, RenderUtils.mc().level.registryAccess());
            if (items.size() == 0) {
                return;
            }
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stackIn);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = Mth.clamp((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = Mth.clamp((int)(baseY - height), (int)0, (int)(screenHeight - height));
            int color = -1;
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(drawContext, type, x, y, props.slotsPerRow, items.size(), color, RenderUtils.mc());
            Container inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            matrix4fStack.popMatrix();
        }
    }

    public static int setShulkerboxBackgroundTintColor(@Nullable ShulkerBoxBlock block, boolean useBgColors) {
        if (block != null && useBgColors) {
            float[] colors = RenderUtils.getColorComponents(block.getColor() != null ? block.getColor().getTextureDiffuseColor() : -7905401);
            return ARGB.colorFromFloat((float)1.0f, (float)colors[0], (float)colors[1], (float)colors[2]);
        }
        return -1;
    }

    public static float[] getColorComponents(int color) {
        int j = (color & 0xFF0000) >> 16;
        int k = (color & 0xFF00) >> 8;
        int l = (color & 0xFF) >> 0;
        return new float[]{(float)j / 255.0f, (float)k / 255.0f, (float)l / 255.0f};
    }

    public static int setBundleBackgroundTintColor(ItemStack bundle, boolean useBgColors) {
        if (bundle.is(ItemTags.BUNDLES) && useBgColors) {
            return RenderUtils.getBundleColor(bundle);
        }
        return -1;
    }

    public static int getBundleColor(ItemStack bundle) {
        Item item = bundle.getItem();
        if (item == null) {
            return -1;
        }
        if (item.equals(Items.WHITE_BUNDLE)) {
            return -1644826;
        }
        if (item.equals(Items.ORANGE_BUNDLE)) {
            return -290016;
        }
        if (item.equals(Items.MAGENTA_BUNDLE)) {
            return -3388999;
        }
        if (item.equals(Items.LIGHT_BLUE_BUNDLE)) {
            return -13586459;
        }
        if (item.equals(Items.YELLOW_BUNDLE)) {
            return -866555;
        }
        if (item.equals(Items.LIME_BUNDLE)) {
            return -6561991;
        }
        if (item.equals(Items.PINK_BUNDLE)) {
            return -481603;
        }
        if (item.equals(Items.GRAY_BUNDLE)) {
            return -9667709;
        }
        if (item.equals(Items.LIGHT_GRAY_BUNDLE)) {
            return -5133149;
        }
        if (item.equals(Items.CYAN_BUNDLE)) {
            return -15420236;
        }
        if (item.equals(Items.BLUE_BUNDLE)) {
            return -12225593;
        }
        if (item.equals(Items.BROWN_BUNDLE)) {
            return -3044775;
        }
        if (item.equals(Items.GREEN_BUNDLE)) {
            return -8937191;
        }
        if (item.equals(Items.RED_BUNDLE)) {
            return -3000274;
        }
        if (item.equals(Items.BLACK_BUNDLE)) {
            return -13093297;
        }
        if (item.equals(Items.PURPLE_BUNDLE)) {
            return -7066934;
        }
        return -5875924;
    }

    public static int setVillagerBackgroundTintColor(VillagerData data, boolean useBgColors) {
        if (useBgColors) {
            Holder profession = data != null ? data.profession() : null;
            return RenderUtils.setVillagerBackgroundTintColor((Holder<VillagerProfession>)profession, useBgColors);
        }
        return -1;
    }

    public static int setVillagerBackgroundTintColor(Holder<VillagerProfession> profession, boolean useBgColors) {
        DyeColor dye;
        if (useBgColors && (dye = RenderUtils.getVillagerColor(profession)) != null) {
            float[] colors = RenderUtils.getColorComponents(dye.getTextureDiffuseColor());
            return ARGB.colorFromFloat((float)1.0f, (float)colors[0], (float)colors[1], (float)colors[2]);
        }
        return -1;
    }

    public static DyeColor getVillagerColor(Holder<VillagerProfession> profession) {
        if (profession == null) {
            return null;
        }
        if (profession.equals((Object)VillagerProfession.NONE)) {
            return DyeColor.BLUE;
        }
        if (profession.is(VillagerProfession.ARMORER)) {
            return DyeColor.GRAY;
        }
        if (profession.is(VillagerProfession.BUTCHER)) {
            return DyeColor.PINK;
        }
        if (profession.is(VillagerProfession.CARTOGRAPHER)) {
            return DyeColor.LIGHT_BLUE;
        }
        if (profession.is(VillagerProfession.CLERIC)) {
            return DyeColor.PURPLE;
        }
        if (profession.is(VillagerProfession.FARMER)) {
            return DyeColor.YELLOW;
        }
        if (profession.is(VillagerProfession.FISHERMAN)) {
            return DyeColor.CYAN;
        }
        if (profession.is(VillagerProfession.FLETCHER)) {
            return DyeColor.ORANGE;
        }
        if (profession.is(VillagerProfession.LEATHERWORKER)) {
            return DyeColor.BROWN;
        }
        if (profession.is(VillagerProfession.LIBRARIAN)) {
            return DyeColor.RED;
        }
        if (profession.is(VillagerProfession.MASON)) {
            return DyeColor.MAGENTA;
        }
        if (profession.is(VillagerProfession.NITWIT)) {
            return DyeColor.GREEN;
        }
        if (profession.is(VillagerProfession.SHEPHERD)) {
            return DyeColor.WHITE;
        }
        if (profession.is(VillagerProfession.TOOLSMITH)) {
            return DyeColor.LIGHT_GRAY;
        }
        if (profession.is(VillagerProfession.WEAPONSMITH)) {
            return DyeColor.BLACK;
        }
        return DyeColor.LIME;
    }

    public static boolean stateModelHasQuads(BlockState state) {
        return RenderUtils.modelHasQuads(Objects.requireNonNull(Minecraft.getInstance().getBlockRenderer().getBlockModel(state)));
    }

    public static boolean modelHasQuads(@Nonnull BlockStateModel model) {
        return RenderUtils.hasQuads(model.collectParts((RandomSource)new SingleThreadedRandomSource(0L)));
    }

    public static boolean hasQuads(List<BlockModelPart> modelParts) {
        if (modelParts.isEmpty()) {
            return false;
        }
        int totalSize = 0;
        for (BlockModelPart part : modelParts) {
            for (Direction face : PositionUtils.ALL_DIRECTIONS) {
                totalSize += part.getQuads(face).size();
            }
            totalSize += part.getQuads(null).size();
        }
        return totalSize > 0;
    }

    public static void renderModelInGui(GuiGraphics drawContext, int x, int y, BlockState state) {
        RenderUtils.renderModelInGui(drawContext, x, y, 16, 0.0f, state, 0.625f);
    }

    public static void renderModelInGui(GuiGraphics drawContext, int x, int y, int size, float zLevel, BlockState state, float scale) {
        if (state.getBlock() == Blocks.AIR) {
            return;
        }
    }

    private static void renderModel(BlockStateModel model, BlockState state, PoseStack matrices, BufferBuilder builder) {
        SingleThreadedRandomSource random = new SingleThreadedRandomSource(0L);
        List parts = model.collectParts((RandomSource)random);
        PoseStack.Pose entry = matrices.last();
        int l = LightTexture.pack((int)15, (int)15);
        int[] light = new int[]{l, l, l, l};
        float[] brightness = new float[]{0.75f, 0.75f, 0.75f, 1.0f};
        for (BlockModelPart part : parts) {
            for (Direction face : PositionUtils.ALL_DIRECTIONS) {
                random.setSeed(0L);
                RenderUtils.renderQuads(part.getQuads(face), brightness, light, entry, builder);
            }
            random.setSeed(0L);
            RenderUtils.renderQuads(part.getQuads(null), brightness, light, entry, builder);
        }
    }

    private static void renderQuads(List<BakedQuad> quads, float[] brightness, int[] light, PoseStack.Pose matrixEntry, BufferBuilder builder) {
        for (BakedQuad quad : quads) {
            RenderUtils.renderQuad(quad, brightness, light, matrixEntry, builder);
        }
    }

    private static void renderQuad(BakedQuad quad, float[] brightness, int[] light, PoseStack.Pose matrixEntry, BufferBuilder builder) {
        builder.putBulkData(matrixEntry, quad, brightness, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY, true);
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, BakedQuad quad) {
        int[] vertexData = quad.vertices();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int vertexSize = vertexData.length / 4;
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
            buffer.addVertex(fx, fy, fz).setColor(color.r, color.g, color.b, color.a);
        }
    }

    public static Minecraft mc() {
        return Minecraft.getInstance();
    }

    public static RenderTarget fb() {
        return RenderUtils.mc().getMainRenderTarget();
    }

    public static Vec3 camPos() {
        return RenderUtils.mc().gameRenderer.getMainCamera().getPosition();
    }

    public static TextureManager tex() {
        return RenderUtils.mc().getTextureManager();
    }

    public static LightTexture lightmap() {
        return RenderUtils.mc().gameRenderer.lightTexture();
    }

    public static float matrix4fRotateFix(float ang) {
        return ang * ((float)Math.PI / 180);
    }

    public static void renderBlockOutline(BlockPos pos, float expand, float lineWidth, Color4f color) {
        RenderUtils.renderBlockOutline(pos, expand, lineWidth, color, false);
    }

    public static void renderBlockOutline(BlockPos pos, float expand, float lineWidth, Color4f color, boolean renderThrough) {
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockOutline", renderThrough ? MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL : MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        BufferBuilder buffer = ctx.getBuilder();
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLinesSimple(pos, color, expand, buffer);
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockOutline(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLinesSimple(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        Vec3 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float minX = (float)((double)pos.getX() - dx - expand);
        float minY = (float)((double)pos.getY() - dy - expand);
        float minZ = (float)((double)pos.getZ() - dz - expand);
        float maxX = (float)((double)pos.getX() - dx + expand + 1.0);
        float maxY = (float)((double)pos.getY() - dy + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - dz + expand + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawConnectingLineBatchedLines(BlockPos pos1, BlockPos pos2, boolean center, Color4f color, BufferBuilder buffer) {
        Vec3 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float x1 = (float)((double)pos1.getX() - dx);
        float y1 = (float)((double)pos1.getY() - dy);
        float z1 = (float)((double)pos1.getZ() - dz);
        float x2 = (float)((double)pos2.getX() - dx);
        float y2 = (float)((double)pos2.getY() - dy);
        float z2 = (float)((double)pos2.getZ() - dz);
        if (center) {
            x1 += 0.5f;
            y1 += 0.5f;
            z1 += 0.5f;
            x2 += 0.5f;
            y2 += 0.5f;
            z2 += 0.5f;
        }
        buffer.addVertex(x1, y1, z1).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x2, y2, z2).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderBlockOutlineOverlapping(BlockPos pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Matrix4f matrix4f) {
        RenderUtils.renderBlockOutlineOverlapping(pos, expand, lineWidth, color1, color2, color3, matrix4f, false);
    }

    public static void renderBlockOutlineOverlapping(BlockPos pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Matrix4f matrix4f, boolean renderThrough) {
        Vec3 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float minX = (float)((double)pos.getX() - dx - (double)expand);
        float minY = (float)((double)pos.getY() - dy - (double)expand);
        float minZ = (float)((double)pos.getZ() - dz - (double)expand);
        float maxX = (float)((double)pos.getX() - dx + (double)expand + 1.0);
        float maxY = (float)((double)pos.getY() - dy + (double)expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - dz + (double)expand + 1.0);
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockOutlineOverlapping", renderThrough ? MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL : MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        BufferBuilder buffer = ctx.getBuilder();
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockOutlineOverlapping(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void renderAreaOutline(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ) {
        Vec3 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        double minX = (double)Math.min(pos1.getX(), pos2.getX()) - dx;
        double minY = (double)Math.min(pos1.getY(), pos2.getY()) - dy;
        double minZ = (double)Math.min(pos1.getZ(), pos2.getZ()) - dz;
        double maxX = (double)Math.max(pos1.getX(), pos2.getX()) - dx + 1.0;
        double maxY = (double)Math.max(pos1.getY(), pos2.getY()) - dy + 1.0;
        double maxZ = (double)Math.max(pos1.getZ(), pos2.getZ()) - dz + 1.0;
        RenderUtils.drawBoundingBoxEdges((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, colorX, colorY, colorZ, lineWidth);
    }

    private static void drawBoundingBoxEdges(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f colorX, Color4f colorY, Color4f colorZ, float lineWidth) {
        RenderContext ctx = new RenderContext(() -> "malilib:drawBoundingBoxEdges", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        BufferBuilder buffer = ctx.getBuilder();
        RenderUtils.drawBoundingBoxLinesX(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawBoundingBoxEdges(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    private static void drawBoundingBoxLinesX(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesY(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesZ(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderAreaSides(BlockPos pos1, BlockPos pos2, Color4f color, Matrix4f matrix4f) {
        RenderUtils.renderAreaSides(pos1, pos2, color, matrix4f, false);
    }

    public static void renderAreaSides(BlockPos pos1, BlockPos pos2, Color4f color, Matrix4f matrix4f, boolean shouldResort) {
        RenderContext ctx = new RenderContext(() -> "malilib:renderAreaSides", MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH);
        BufferBuilder buffer = ctx.getBuilder();
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, buffer);
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                if (shouldResort) {
                    ctx.upload(meshData, true);
                    ctx.startResorting(meshData, ctx.createVertexSorter(RenderUtils.camPos()));
                } else {
                    ctx.upload(meshData, false);
                }
                meshData.close();
                ctx.drawPost();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderAreaSides(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void renderAreaSidesBatched(BlockPos pos1, BlockPos pos2, Color4f color, double expand, BufferBuilder buffer) {
        Vec3 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        double minX = (double)Math.min(pos1.getX(), pos2.getX()) - dx - expand;
        double minY = (double)Math.min(pos1.getY(), pos2.getY()) - dy - expand;
        double minZ = (double)Math.min(pos1.getZ(), pos2.getZ()) - dz - expand;
        double maxX = (double)(Math.max(pos1.getX(), pos2.getX()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.getY(), pos2.getY()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.getZ(), pos2.getZ()) + 1) - dz + expand;
        RenderUtils.drawBoxAllSidesBatchedQuads((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, color, buffer);
    }

    public static void renderAreaOutlineNoCorners(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ) {
        int end;
        int xMin = Math.min(pos1.getX(), pos2.getX());
        int yMin = Math.min(pos1.getY(), pos2.getY());
        int zMin = Math.min(pos1.getZ(), pos2.getZ());
        int xMax = Math.max(pos1.getX(), pos2.getX());
        int yMax = Math.max(pos1.getY(), pos2.getY());
        int zMax = Math.max(pos1.getZ(), pos2.getZ());
        double expand = 0.001;
        Vec3 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float dxMin = (float)(-dx - 0.001);
        float dyMin = (float)(-dy - 0.001);
        float dzMin = (float)(-dz - 0.001);
        float dxMax = (float)(-dx + 0.001);
        float dyMax = (float)(-dy + 0.001);
        float dzMax = (float)(-dz + 0.001);
        float minX = (float)xMin + dxMin;
        float minY = (float)yMin + dyMin;
        float minZ = (float)zMin + dzMin;
        float maxX = (float)xMax + dxMax;
        float maxY = (float)yMax + dyMax;
        float maxZ = (float)zMax + dzMax;
        RenderContext ctx = new RenderContext(() -> "malilib:renderAreaOutlineNoCorners", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        BufferBuilder buffer = ctx.getBuilder();
        int start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, minY, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, minY, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, maxY + 1.0f, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, maxY + 1.0f, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, minY, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, minY, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, maxY + 1.0f, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, maxY + 1.0f, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(minX, (float)start + dyMin, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(minX, (float)end + dyMax, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, (float)start + dyMin, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(maxX + 1.0f, (float)end + dyMax, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(minX, (float)start + dyMin, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(minX, (float)end + dyMax, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, (float)start + dyMin, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(maxX + 1.0f, (float)end + dyMax, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(minX, minY, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(minX, minY, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, minY, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(maxX + 1.0f, minY, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(minX, maxY + 1.0f, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(minX, maxY + 1.0f, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, maxY + 1.0f, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(maxX + 1.0f, maxY + 1.0f, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        try {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawAreaOutlineNoCorners(): Draw Exception; {}", (Object)err.getMessage());
        }
    }
}

