/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.TestUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@ApiStatus.Experimental
public class TestWalls
implements AutoCloseable {
    public static final TestWalls INSTANCE = new TestWalls();
    protected boolean renderThrough = false;
    protected boolean useCulling = false;
    protected float glLineWidth = 3.0f;
    private List<AABB> boxes;
    private BlockPos center = null;
    protected BlockPos lastUpdatePos = null;
    private Vec3 updateCameraPos = Vec3.ZERO;
    private boolean hasData = false;
    private final boolean shouldResort;
    private final boolean needsUpdate;
    private final int updateDistance = 48;

    public TestWalls() {
        this.shouldResort = false;
        this.needsUpdate = true;
        this.boxes = new ArrayList<AABB>();
    }

    public Vec3 getUpdatePosition() {
        return this.updateCameraPos;
    }

    public void setUpdatePosition(Vec3 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    public boolean needsUpdate(Entity cameraEntity, Minecraft mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.getX() - (double)this.lastUpdatePos.getX()) > (double)this.updateDistance || Math.abs(cameraEntity.getZ() - (double)this.lastUpdatePos.getZ()) > (double)this.updateDistance || Math.abs(cameraEntity.getY() - (double)this.lastUpdatePos.getY()) > (double)this.updateDistance;
    }

    public void update(Camera camera, Entity entity, Minecraft mc) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        int radius = MaLiLibConfigs.Test.TEST_CONFIG_INTEGER.getIntegerValue();
        Vec3 vec = camera.getPosition();
        BlockPos pos = entity.blockPosition();
        BlockPos testPos = pos.offset(2, 0, 2);
        Pair<BlockPos, BlockPos> corners = TestUtils.getSpawnChunkCorners(testPos, radius, (Level)mc.level);
        this.boxes = TestUtils.calculateBoxes((BlockPos)corners.getLeft(), (BlockPos)corners.getRight());
        if (!this.boxes.isEmpty()) {
            this.center = testPos;
            this.hasData = true;
        } else {
            this.center = null;
            this.hasData = false;
        }
        this.setUpdatePosition(vec);
    }

    public void render(Camera camera, Matrix4f matrix4f, Matrix4f projMatrix, Minecraft mc, ProfilerFiller profiler) {
        profiler.push("render_test_walls");
        if (this.hasData && !this.boxes.isEmpty() && this.center != null) {
            this.renderQuads(camera, mc, profiler);
            this.renderOutlines(camera, mc, profiler);
            this.boxes.clear();
            this.center = null;
            this.hasData = false;
        }
        profiler.pop();
    }

    private void renderQuads(Camera camera, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null || !this.hasData || this.boxes.isEmpty()) {
            return;
        }
        profiler.push("quads");
        Color4f quadsColor = MaLiLibConfigs.Test.TEST_CONFIG_COLOR.getColor();
        Vec3 cameraPos = camera.getPosition();
        RenderContext ctx = new RenderContext(() -> "malilib:TestWalls/quads", MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        BufferBuilder builder = ctx.getBuilder();
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        Vec3 updatePos = this.getUpdatePosition();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate((float)(updatePos.x - cameraPos.x), (float)(updatePos.y - cameraPos.y), (float)(updatePos.z - cameraPos.z));
        RenderUtils.drawBlockBoundingBoxSidesBatchedQuads(this.center, cameraPos, quadsColor, 0.001, builder);
        for (AABB entry : this.boxes) {
            TestUtils.renderWallQuads(entry, cameraPos, quadsColor, builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                if (this.shouldResort) {
                    ctx.upload(meshData, true);
                    ctx.startResorting(meshData, ctx.createVertexSorter(camera));
                } else {
                    ctx.upload(meshData, false);
                }
                ctx.drawPost();
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("TestWalls#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrix4fstack.popMatrix();
        profiler.pop();
    }

    private void renderOutlines(Camera camera, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("outlines");
        Color4f linesColor = Color4f.WHITE;
        Vec3 cameraPos = camera.getPosition();
        RenderContext ctx = new RenderContext(() -> "malilib:TestWalls/lines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        BufferBuilder builder = ctx.getBuilder();
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        Vec3 updatePos = this.getUpdatePosition();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate((float)(updatePos.x - cameraPos.x), (float)(updatePos.y - cameraPos.y), (float)(updatePos.z - cameraPos.z));
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(this.center, cameraPos, linesColor, 0.001, builder);
        for (AABB entry : this.boxes) {
            TestUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, linesColor, builder);
        }
        matrix4fstack.popMatrix();
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.lineWidth(this.glLineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("TestWalls#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    public void clear() {
        this.lastUpdatePos = BlockPos.ZERO;
        this.hasData = false;
        this.boxes.clear();
    }

    @Override
    public void close() {
        this.clear();
    }
}

