/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game.wrap;

import java.nio.file.Path;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class GameWrap {
    public static Minecraft getClient() {
        return Minecraft.getInstance();
    }

    @Nullable
    public static ClientLevel getClientWorld() {
        return GameWrap.getClient().level;
    }

    @Nullable
    public static ServerLevel getClientPlayersServerWorld() {
        Player player = GameWrap.getClientPlayer();
        MinecraftServer server = GameWrap.getIntegratedServer();
        return player != null && server != null ? server.getLevel(player.level().dimension()) : null;
    }

    @Nullable
    public static RegistryAccess getClientRegistryManager() {
        return GameWrap.getClientWorld() != null ? GameWrap.getClientWorld().registryAccess() : null;
    }

    @Nullable
    public static RegistryAccess getServerRegistryManager() {
        return GameWrap.getClientPlayersServerWorld() != null ? GameWrap.getClientPlayersServerWorld().registryAccess() : null;
    }

    @Nullable
    public static Player getClientPlayer() {
        return GameWrap.getClient().player;
    }

    @Nullable
    public static Inventory getPlayerInventory() {
        LocalPlayer player = GameWrap.getClient().player;
        return player != null ? player.getInventory() : null;
    }

    public static MultiPlayerGameMode getInteractionManager() {
        return GameWrap.getClient().gameMode;
    }

    public static void clickSlot(int syncId, int slotId, int mouseButton, ClickType clickType) {
        MultiPlayerGameMode controller = GameWrap.getInteractionManager();
        if (controller != null) {
            controller.handleInventoryMouseClick(syncId, slotId, mouseButton, clickType, GameWrap.getClientPlayer());
        }
    }

    public static double getPlayerReachDistance() {
        if (GameWrap.getClientPlayer() != null) {
            return GameWrap.getClientPlayer().blockInteractionRange();
        }
        return 4.5;
    }

    @Nullable
    public static MinecraftServer getIntegratedServer() {
        return GameWrap.getClient().getSingleplayerServer();
    }

    @Nullable
    public static ClientPacketListener getNetworkConnection() {
        return GameWrap.getClient().getConnection();
    }

    public static Options getOptions() {
        return GameWrap.getClient().options;
    }

    public static GameRules getGameRules() {
        if (GameWrap.getClient().hasSingleplayerServer()) {
            if (GameWrap.getClient().getSingleplayerServer() != null) {
                return GameWrap.getClient().getSingleplayerServer().getGameRules();
            }
        } else if (GameWrap.getClient().getConnection() != null) {
            return new GameRules(GameWrap.getClient().getConnection().enabledFeatures());
        }
        return new GameRules(FeatureFlagSet.of());
    }

    public static void printToChat(String msg) {
        if (GameWrap.getClient().level != null) {
            GameWrap.getClient().gui.getChat().addMessage(Component.nullToEmpty((String)msg));
        }
    }

    public static void showHotbarMessage(String msg) {
        if (GameWrap.getClient().level != null) {
            GameWrap.getClient().gui.setOverlayMessage(Component.nullToEmpty((String)msg), false);
        }
    }

    public static boolean sendChatMessage(String command) {
        Player player = GameWrap.getClientPlayer();
        if (player != null) {
            player.displayClientMessage(Component.nullToEmpty((String)command), false);
            return true;
        }
        return false;
    }

    public static boolean sendCommand(String command) {
        if (!((String)command).startsWith("/")) {
            command = "/" + (String)command;
        }
        return GameWrap.sendChatMessage((String)command);
    }

    @Nullable
    public static Entity getCameraEntity() {
        Minecraft mc = GameWrap.getClient();
        Entity entity = mc.getCameraEntity();
        return entity != null ? entity : mc.player;
    }

    public static String getPlayerName() {
        Player player = GameWrap.getClientPlayer();
        return player != null ? player.getName().tryCollapseToString() : "?";
    }

    public static HitResult getHitResult() {
        return GameWrap.getClient().hitResult;
    }

    public static long getCurrentWorldTick() {
        ClientLevel world = GameWrap.getClientWorld();
        return world != null ? world.getGameTime() : -1L;
    }

    public static boolean isCreativeMode() {
        Player player = GameWrap.getClientPlayer();
        return player != null && player.hasInfiniteMaterials();
    }

    public static int getRenderDistanceChunks() {
        return GameWrap.getOptions().getEffectiveRenderDistance();
    }

    public static int getVanillaOptionsScreenScale() {
        return (Integer)GameWrap.getOptions().guiScale().get();
    }

    public static boolean isSinglePlayer() {
        return GameWrap.getClient().isLocalServer();
    }

    public static boolean isUnicode() {
        return GameWrap.getClient().isEnforceUnicode();
    }

    public static boolean isHideGui() {
        return GameWrap.getOptions().hideGui;
    }

    public static void scheduleToClientThread(Runnable task) {
        Minecraft mc = GameWrap.getClient();
        if (mc.isSameThread()) {
            task.run();
        } else {
            mc.wrapRunnable(task);
        }
    }

    public static void profilerPush(String name) {
        Profiler.get().push(name);
    }

    public static void profilerPush(Supplier<String> nameSupplier) {
        Profiler.get().push(nameSupplier);
    }

    public static void profilerSwap(String name) {
        Profiler.get().popPush(name);
    }

    public static void profilerSwap(Supplier<String> nameSupplier) {
        Profiler.get().popPush(nameSupplier);
    }

    public static void profilerPop() {
        Profiler.get().pop();
    }

    public static void openFile(Path file) {
        Util.getPlatform().openPath(file);
    }

    @Nullable
    public static Path getCurrentSinglePlayerWorldDirectory() {
        MinecraftServer server;
        if (GameWrap.isSinglePlayer() && (server = GameWrap.getIntegratedServer()) != null) {
            return server.getWorldPath(LevelResource.ROOT);
        }
        return null;
    }
}

