/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.hikarii.customrecipes.bstats.bukkit.Metrics;
import org.hikarii.customrecipes.bstats.charts.SimplePie;
import org.hikarii.customrecipes.bstats.charts.SingleLineChart;
import org.hikarii.customrecipes.command.CustomRecipesCommand;
import org.hikarii.customrecipes.config.ConfigManager;
import org.hikarii.customrecipes.config.ConfigMigration;
import org.hikarii.customrecipes.config.DefaultRecipesManager;
import org.hikarii.customrecipes.config.RecipeStateTracker;
import org.hikarii.customrecipes.listener.RecipeAmountListener;
import org.hikarii.customrecipes.listener.RecipeCraftListener;
import org.hikarii.customrecipes.listener.RecipeDiscoverListener;
import org.hikarii.customrecipes.listener.RecipeHidingListener;
import org.hikarii.customrecipes.listener.RecipePreviewListener;
import org.hikarii.customrecipes.recipe.RecipeDataManager;
import org.hikarii.customrecipes.recipe.RecipeManager;
import org.hikarii.customrecipes.recipe.RecipeWorldManager;
import org.hikarii.customrecipes.recipe.vanilla.VanillaRecipeManager;
import org.hikarii.customrecipes.update.UpdateChecker;
import org.hikarii.customrecipes.update.UpdateNotifier;
import org.hikarii.customrecipes.update.UpdateSource;
import org.hikarii.customrecipes.util.MessageUtil;

public final class CustomRecipes
extends JavaPlugin {
    private static CustomRecipes instance;
    private ConfigManager configManager;
    private ConfigMigration configMigration;
    private RecipeManager recipeManager;
    private boolean debugMode = false;
    private boolean keepSpawnEggNames = false;
    private boolean useCraftedCustomNames = true;
    private UpdateChecker updateChecker;
    private RecipeDataManager recipeDataManager;
    private RecipeWorldManager recipeWorldManager;
    private VanillaRecipeManager vanillaRecipeManager;
    private RecipeStateTracker recipeStateTracker;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        MessageUtil.setPlugin(this);
        this.recipeManager = new RecipeManager(this);
        this.recipeDataManager = new RecipeDataManager(this);
        this.recipeWorldManager = new RecipeWorldManager(this);
        this.configManager = new ConfigManager(this);
        this.recipeStateTracker = new RecipeStateTracker(this);
        this.configMigration = new ConfigMigration(this);
        if (!this.configMigration.checkAndMigrate()) {
            this.getLogger().severe("Config migration failed! Some recipes may not work correctly.");
            this.getLogger().severe("Please check the console for errors and report them to the developer.");
        }
        DefaultRecipesManager defaultRecipes = new DefaultRecipesManager(this);
        defaultRecipes.initializeDefaultRecipes();
        this.vanillaRecipeManager = new VanillaRecipeManager(this);
        if (!this.loadConfiguration()) {
            this.getLogger().severe("Failed to load configuration! Plugin will be disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerCommands();
        this.registerListeners();
        this.getLogger().info("CustomRecipes has been enabled!");
        this.getLogger().info("Loaded " + this.recipeManager.getRecipeCount() + " custom recipes");
        this.initializeMetrics();
        this.initializeUpdateChecker();
    }

    public void onDisable() {
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAll();
        }
        if (this.updateChecker != null) {
            this.updateChecker.stopPeriodicCheck();
        }
        this.getLogger().info("CustomRecipes has been disabled!");
    }

    public boolean loadConfiguration() {
        try {
            this.reloadConfig();
            this.debugMode = this.getConfig().getBoolean("debug", false);
            this.useCraftedCustomNames = this.getConfig().getBoolean("use-crafted-custom-names", true);
            this.keepSpawnEggNames = this.getConfig().getBoolean("spawn-egg-keep-custom-name", false);
            this.configManager.loadRecipes();
            this.recipeStateTracker.syncEnabledRecipes();
            this.recipeManager.registerAllRecipes();
            if (this.recipeWorldManager != null) {
                this.recipeWorldManager.loadWorldRestrictions();
            }
            return true;
        }
        catch (Exception e) {
            this.getLogger().severe("Error loading configuration: " + e.getMessage());
            if (this.debugMode) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private void registerCommands() {
        CustomRecipesCommand commandExecutor = new CustomRecipesCommand(this);
        this.getCommand("customrecipes").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("customrecipes").setTabCompleter((TabCompleter)commandExecutor);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new RecipeDiscoverListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RecipeHidingListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RecipeAmountListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RecipeCraftListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RecipePreviewListener(this), (Plugin)this);
    }

    public static CustomRecipes getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public VanillaRecipeManager getVanillaRecipeManager() {
        return this.vanillaRecipeManager;
    }

    public RecipeStateTracker getRecipeStateTracker() {
        return this.recipeStateTracker;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isKeepSpawnEggNames() {
        return this.keepSpawnEggNames;
    }

    public boolean isUseCraftedCustomNames() {
        return this.useCraftedCustomNames;
    }

    public RecipeDataManager getRecipeDataManager() {
        return this.recipeDataManager;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        this.getConfig().set("debug", (Object)debugMode);
        this.saveConfig();
    }

    public void debug(String message) {
        if (this.debugMode) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    private void initializeMetrics() {
        int pluginId = 27998;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new SingleLineChart("total_recipes", () -> this.recipeManager.getRecipeCount()));
        metrics.addCustomChart(new SingleLineChart("enabled_recipes", () -> (int)this.recipeManager.getAllRecipes().stream().filter(recipe -> this.recipeManager.isRecipeEnabled(recipe.getKey())).count()));
        metrics.addCustomChart(new SimplePie("using_custom_names", () -> this.useCraftedCustomNames ? "Yes" : "No"));
        this.debug("bStats metrics initialized");
    }

    public RecipeWorldManager getRecipeWorldManager() {
        return this.recipeWorldManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    private void initializeUpdateChecker() {
        this.updateChecker = new UpdateChecker(this, UpdateSource.GITHUB, "130198", "hikarii-dev/Custom-Recipes");
        this.updateChecker.startPeriodicCheck();
        this.getServer().getPluginManager().registerEvents((Listener)new UpdateNotifier(this, this.updateChecker), (Plugin)this);
        this.debug("Update checker initialized with periodic checks");
    }
}

