/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.command.subcommands.GuiSubcommand;
import org.hikarii.customrecipes.command.subcommands.ListSubcommand;
import org.hikarii.customrecipes.command.subcommands.ReloadSubcommand;
import org.hikarii.customrecipes.util.MessageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRecipesCommand
implements CommandExecutor,
TabCompleter {
    private final CustomRecipes plugin;
    private final Map<String, SubCommand> subCommands;

    public CustomRecipesCommand(CustomRecipes plugin) {
        this.plugin = plugin;
        this.subCommands = new HashMap<String, SubCommand>();
        this.registerSubcommand(new ReloadSubcommand(plugin));
        this.registerSubcommand(new GuiSubcommand(plugin));
        this.registerSubcommand(new ListSubcommand(plugin));
    }

    private void registerSubcommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(), subCommand);
        for (String alias : subCommand.getAliases()) {
            this.subCommands.put(alias.toLowerCase(), subCommand);
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            if (!(sender.hasPermission("customrecipes.manage") || sender.hasPermission("customrecipes.reload") || sender.hasPermission("customrecipes.gui"))) {
                SubCommand listCommand = this.subCommands.get("list");
                if (listCommand != null && sender.hasPermission(listCommand.getPermission())) {
                    listCommand.execute(sender, new String[0]);
                    return true;
                }
                MessageUtil.sendError(sender, "You don't have permission to use this command.");
                return true;
            }
            this.showHelp(sender);
            return true;
        }
        String subCommandName = args[0].toLowerCase();
        if (subCommandName.equals("help")) {
            if (!(sender.hasPermission("customrecipes.manage") || sender.hasPermission("customrecipes.reload") || sender.hasPermission("customrecipes.gui"))) {
                MessageUtil.sendError(sender, "You don't have permission to use this command.");
                return true;
            }
            this.showHelp(sender);
            return true;
        }
        SubCommand subCommand = this.subCommands.get(subCommandName);
        if (subCommand != null) {
            if (!sender.hasPermission(subCommand.getPermission())) {
                MessageUtil.sendError(sender, "You don't have permission to use this command.");
                return true;
            }
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            subCommand.execute(sender, subArgs);
            return true;
        }
        MessageUtil.sendError(sender, "Unknown subcommand.");
        return true;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(MessageUtil.colorize("<gradient:#00D4FF:#7B2CBF>====== CustomRecipes Help ======</gradient>"));
        sender.sendMessage((Component)Component.empty());
        HashSet<SubCommand> uniqueCommands = new HashSet<SubCommand>(this.subCommands.values());
        for (SubCommand subCommand : uniqueCommands) {
            if (!sender.hasPermission(subCommand.getPermission())) continue;
            TextComponent commandComponent = Component.text((String)("  /" + subCommand.getUsage()), (TextColor)NamedTextColor.AQUA);
            TextComponent descComponent = Component.text((String)(" - " + subCommand.getDescription()), (TextColor)NamedTextColor.GRAY);
            sender.sendMessage(commandComponent.append((Component)descComponent));
        }
        sender.sendMessage((Component)Component.empty());
        sender.sendMessage(MessageUtil.colorize("<gray>Use <yellow>/cr<gray> as a shortcut"));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        SubCommand subCommand;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("customrecipes.manage") || sender.hasPermission("customrecipes.reload") || sender.hasPermission("customrecipes.gui")) {
                completions.add("help");
            }
            for (SubCommand subCommand2 : new HashSet<SubCommand>(this.subCommands.values())) {
                if (!sender.hasPermission(subCommand2.getPermission())) continue;
                completions.add(subCommand2.getName());
            }
            String input = args[0].toLowerCase();
            return completions.stream().filter(s -> s.toLowerCase().startsWith(input)).sorted().toList();
        }
        if (args.length > 1 && (subCommand = this.subCommands.get(args[0].toLowerCase())) != null && sender.hasPermission(subCommand.getPermission())) {
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            return subCommand.tabComplete(sender, subArgs);
        }
        return completions;
    }

    public static interface SubCommand {
        public String getName();

        public List<String> getAliases();

        public String getDescription();

        public String getUsage();

        public String getPermission();

        public void execute(CommandSender var1, String[] var2);

        public List<String> tabComplete(CommandSender var1, String[] var2);
    }
}

