/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.command.subcommands;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.command.CustomRecipesCommand;
import org.hikarii.customrecipes.util.MessageUtil;

public class ReloadSubcommand
implements CustomRecipesCommand.SubCommand {
    private final CustomRecipes plugin;

    public ReloadSubcommand(CustomRecipes plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public List<String> getAliases() {
        return List.of("rl", "refresh");
    }

    @Override
    public String getDescription() {
        return "Reload plugin configuration and recipes";
    }

    @Override
    public String getUsage() {
        return "customrecipes reload";
    }

    @Override
    public String getPermission() {
        return "customrecipes.reload";
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        MessageUtil.sendInfo(sender, "Reloading CustomRecipes configuration...");
        long startTime = System.currentTimeMillis();
        boolean success = this.plugin.loadConfiguration();
        long duration = System.currentTimeMillis() - startTime;
        if (success) {
            int recipeCount = this.plugin.getRecipeManager().getRecipeCount();
            MessageUtil.sendSuccess(sender, "Successfully reloaded! Loaded <white>" + recipeCount + "<green> recipes in <white>" + duration + "ms");
        } else {
            MessageUtil.sendError(sender, "Failed to reload configuration. Check console for errors.");
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

