/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.RecipeConfigLoader;
import org.hikarii.customrecipes.config.RecipeFileManager;
import org.hikarii.customrecipes.config.ValidationException;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeManager;

public class ConfigManager {
    private final CustomRecipes plugin;
    private final RecipeConfigLoader recipeLoader;
    private final RecipeFileManager recipeFileManager;

    public ConfigManager(CustomRecipes plugin) {
        this.plugin = plugin;
        this.recipeLoader = new RecipeConfigLoader(plugin);
        this.recipeFileManager = new RecipeFileManager(plugin);
    }

    public void loadRecipes() throws ValidationException {
        FileConfiguration config = this.plugin.getConfig();
        RecipeManager recipeManager = this.plugin.getRecipeManager();
        recipeManager.clearRecipes();
        List enabledRecipes = config.getStringList("enabled-recipes");
        if (enabledRecipes.isEmpty()) {
            this.plugin.getLogger().warning("No recipes are enabled in configuration");
            return;
        }
        HashSet<String> loadedKeys = new HashSet<String>();
        int successCount = 0;
        int failCount = 0;
        for (String key : enabledRecipes) {
            try {
                ConfigurationSection recipeSection;
                this.recipeLoader.validateKey(key);
                String keyLower = key.toLowerCase();
                if (loadedKeys.contains(keyLower)) {
                    this.plugin.getLogger().warning("Duplicate recipe key in enabled-recipes: " + key);
                    continue;
                }
                File recipeFile = new File(this.recipeFileManager.getRecipesFolder(), key + ".yml");
                if (recipeFile.exists()) {
                    YamlConfiguration fileConfig = YamlConfiguration.loadConfiguration((File)recipeFile);
                    recipeSection = fileConfig;
                    this.plugin.debug("Loading recipe '" + key + "' from file");
                } else {
                    recipeSection = config.getConfigurationSection(key);
                    if (recipeSection == null) {
                        throw new ValidationException("Recipe file not found and not in main config: " + key);
                    }
                    this.plugin.debug("Loading recipe '" + key + "' from main config (legacy)");
                }
                CustomRecipe recipe = this.recipeLoader.loadRecipe(key, recipeSection);
                recipeManager.addRecipe(recipe);
                loadedKeys.add(keyLower);
                ++successCount;
                this.plugin.debug("Loaded recipe: " + key);
            }
            catch (ValidationException e) {
                this.plugin.getLogger().severe("Failed to load recipe '" + key + "': " + e.getMessage());
                if (this.plugin.isDebugMode() && e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                ++failCount;
            }
        }
        this.plugin.getLogger().info("Loaded " + successCount + " recipes successfully" + (String)(failCount > 0 ? " (" + failCount + " failed)" : ""));
    }

    public boolean validateConfiguration() {
        try {
            FileConfiguration config = this.plugin.getConfig();
            if (!config.contains("enabled-recipes")) {
                this.plugin.getLogger().severe("Configuration is missing 'enabled-recipes' section");
                return false;
            }
            this.loadRecipes();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Configuration validation failed: " + e.getMessage());
            if (this.plugin.isDebugMode()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public void addEnabledRecipe(String recipeKey) {
        FileConfiguration config = this.plugin.getConfig();
        List enabled = config.getStringList("enabled-recipes");
        if (!enabled.contains(recipeKey)) {
            enabled.add(recipeKey);
            config.set("enabled-recipes", (Object)enabled);
            this.plugin.saveConfig();
            this.plugin.debug("Added '" + recipeKey + "' to enabled-recipes");
        }
    }

    public void removeEnabledRecipe(String recipeKey) {
        FileConfiguration config = this.plugin.getConfig();
        List enabled = config.getStringList("enabled-recipes");
        boolean removed = false;
        Iterator iterator = enabled.iterator();
        while (iterator.hasNext()) {
            String existing = (String)iterator.next();
            if (!existing.equalsIgnoreCase(recipeKey)) continue;
            iterator.remove();
            removed = true;
            this.plugin.debug("Removed '" + existing + "' from enabled-recipes (matched: " + recipeKey + ")");
        }
        if (removed) {
            config.set("enabled-recipes", (Object)enabled);
            this.plugin.saveConfig();
            this.plugin.debug("Removed '" + recipeKey + "' from enabled-recipes");
        }
    }

    public boolean isRecipeInEnabledList(String recipeKey) {
        FileConfiguration config = this.plugin.getConfig();
        List enabled = config.getStringList("enabled-recipes");
        return enabled.contains(recipeKey);
    }

    public RecipeFileManager getRecipeFileManager() {
        return this.recipeFileManager;
    }
}

