/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.ConfigRewriter;
import org.hikarii.customrecipes.config.DefaultRecipesManager;

public class ConfigMigration {
    private final CustomRecipes plugin;

    public ConfigMigration(CustomRecipes plugin) {
        this.plugin = plugin;
    }

    public boolean checkAndMigrate() {
        int configVersion = this.plugin.getConfig().getInt("config-version", 1);
        if (configVersion == 2) {
            this.plugin.debug("Config is up to date (v" + configVersion + ")");
            return true;
        }
        this.plugin.getLogger().info("Detected old config version (" + configVersion + "), migrating to v2...");
        try {
            Set<String> preservedDeletedRecipes = this.preserveDeletedRecipesInfo();
            this.createBackup();
            this.plugin.getLogger().info("Running universal migration from v" + configVersion + " to v2...");
            this.detectDeletedDefaultRecipes();
            this.plugin.getLogger().info("Rewriting config.yml with new template...");
            ConfigRewriter rewriter = new ConfigRewriter(this.plugin);
            if (rewriter.rewriteConfig()) {
                this.plugin.getLogger().info("\u2713 Config.yml rewritten successfully!");
            } else {
                this.plugin.getLogger().warning("Failed to rewrite config.yml, but migration continues");
            }
            this.restoreDeletedRecipesInfo(preservedDeletedRecipes);
            this.plugin.getConfig().set("config-version", (Object)2);
            this.plugin.saveConfig();
            this.plugin.getLogger().info("\u2713 Config migration completed successfully!");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to migrate config: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private Set<String> preserveDeletedRecipesInfo() {
        HashSet<String> deletedRecipes = new HashSet<String>();
        try {
            Set<String> existingDeleted = this.plugin.getRecipeStateTracker().getDeletedDefaultRecipes();
            deletedRecipes.addAll(existingDeleted);
            this.plugin.getLogger().info("Preserved " + deletedRecipes.size() + " deleted recipe(s) from previous state");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not preserve deleted recipes info: " + e.getMessage());
        }
        return deletedRecipes;
    }

    private void restoreDeletedRecipesInfo(Set<String> preservedDeletedRecipes) {
        if (preservedDeletedRecipes == null || preservedDeletedRecipes.isEmpty()) {
            return;
        }
        try {
            for (String recipeKey : preservedDeletedRecipes) {
                this.plugin.getRecipeStateTracker().markDefaultRecipeDeleted(recipeKey);
            }
            this.plugin.getLogger().info("Restored " + preservedDeletedRecipes.size() + " deleted recipe(s) to state tracker");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not restore deleted recipes info: " + e.getMessage());
        }
    }

    private void detectDeletedDefaultRecipes() {
        this.plugin.getLogger().info("Detecting deleted default recipes...");
        List<String> defaultRecipeKeys = DefaultRecipesManager.getDefaultRecipeKeys();
        List enabledRecipes = this.plugin.getConfig().getStringList("enabled-recipes");
        File recipesFolder = new File(this.plugin.getDataFolder(), "recipes");
        int deletedCount = 0;
        for (String defaultKey : defaultRecipeKeys) {
            File recipeFile = new File(recipesFolder, defaultKey + ".yml");
            if (recipeFile.exists() || enabledRecipes.contains(defaultKey)) continue;
            this.plugin.getRecipeStateTracker().markDefaultRecipeDeleted(defaultKey);
            this.plugin.getLogger().info("Marked as deleted: " + defaultKey);
            ++deletedCount;
        }
        if (deletedCount > 0) {
            this.plugin.getLogger().info("Found " + deletedCount + " deleted default recipes");
        } else {
            this.plugin.debug("No deleted default recipes found");
        }
    }

    private void createBackup() {
        try {
            File recipesFolder;
            File dataFolder = this.plugin.getDataFolder();
            File backupFolder = new File(dataFolder, "backups");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            String timestamp = String.valueOf(System.currentTimeMillis());
            File backupFile = new File(backupFolder, "config-backup-" + timestamp + ".yml");
            File mainConfig = new File(dataFolder, "config.yml");
            if (mainConfig.exists()) {
                Files.copy(mainConfig.toPath(), backupFile.toPath(), new CopyOption[0]);
                this.plugin.getLogger().info("Created config backup: " + backupFile.getName());
            }
            if ((recipesFolder = new File(dataFolder, "recipes")).exists()) {
                File recipesBackup = new File(backupFolder, "recipes-backup-" + timestamp);
                this.copyFolder(recipesFolder, recipesBackup);
                this.plugin.getLogger().info("Created recipes backup: " + recipesBackup.getName());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to create backup: " + e.getMessage());
        }
    }

    private void copyFolder(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            String[] files;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            if ((files = source.list()) != null) {
                for (String file : files) {
                    File srcFile = new File(source, file);
                    File destFile = new File(destination, file);
                    this.copyFolder(srcFile, destFile);
                }
            }
        } else {
            Files.copy(source.toPath(), destination.toPath(), new CopyOption[0]);
        }
    }
}

