/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.hikarii.customrecipes.CustomRecipes;

public class ConfigRewriter {
    private final CustomRecipes plugin;
    private final File configFile;
    private static final List<String> PRESERVED_KEYS = Arrays.asList("debug", "use-crafted-custom-names", "spawn-egg-keep-custom-name", "ignore-metadata", "world-restrictions", "recipe-world-settings", "enabled-recipes");

    public ConfigRewriter(CustomRecipes plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
    }

    public boolean rewriteConfig() {
        try {
            this.plugin.getLogger().info("Rewriting config.yml with preserved settings...");
            Map<String, Object> preservedValues = this.saveCurrentSettings();
            this.createBackup();
            if (this.configFile.exists()) {
                this.configFile.delete();
            }
            this.plugin.saveResource("config.yml", false);
            this.restoreSettings(preservedValues);
            this.plugin.getLogger().info("\u2713 Config rewritten successfully!");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to rewrite config: " + e.getMessage());
            if (this.plugin.isDebugMode()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private Map<String, Object> saveCurrentSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        FileConfiguration config = this.plugin.getConfig();
        for (String key : PRESERVED_KEYS) {
            if (!config.contains(key)) continue;
            Object value = config.get(key);
            settings.put(key, this.deepCopy(value));
            this.plugin.debug("Preserved setting: " + key + " = " + String.valueOf(value));
        }
        return settings;
    }

    private void restoreSettings(Map<String, Object> preservedValues) throws IOException {
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        for (Map.Entry<String, Object> entry : preservedValues.entrySet()) {
            config.set(entry.getKey(), entry.getValue());
            this.plugin.debug("Restored setting: " + entry.getKey());
        }
        this.plugin.saveConfig();
    }

    private Object deepCopy(Object value) {
        if (value instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)value;
            HashMap<String, Object> copy = new HashMap<String, Object>();
            for (String key : section.getKeys(false)) {
                copy.put(key, this.deepCopy(section.get(key)));
            }
            return copy;
        }
        if (value instanceof List) {
            return new ArrayList((List)value);
        }
        if (value instanceof Map) {
            return new HashMap((Map)value);
        }
        return value;
    }

    private void createBackup() {
        try {
            File backupFolder = new File(this.plugin.getDataFolder(), "backups");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            String timestamp = String.valueOf(System.currentTimeMillis());
            File backupFile = new File(backupFolder, "config-backup-" + timestamp + ".yml");
            if (this.configFile.exists()) {
                Files.copy(this.configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().info("Created config backup: " + backupFile.getName());
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to create config backup: " + e.getMessage());
        }
    }

    public boolean needsRewrite(int currentVersion, int targetVersion) {
        return currentVersion < targetVersion;
    }
}

