/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.RecipeStateTracker;

public class DefaultRecipesManager {
    private final CustomRecipes plugin;
    private final File recipesFolder;
    private static final List<String> DEFAULT_RECIPES = Arrays.asList("BeeSpawnEgg", "CowSpawnEgg", "CreeperSpawnEgg", "EndermanSpawnEgg", "SkeletonSpawnEgg", "ZombieSpawnEgg", "DiamondFromCoal", "EnderPearlStack", "GoldenAppleStack");

    public DefaultRecipesManager(CustomRecipes plugin) {
        this.plugin = plugin;
        this.recipesFolder = new File(plugin.getDataFolder(), "recipes");
    }

    public void initializeDefaultRecipes() {
        if (!this.recipesFolder.exists()) {
            this.recipesFolder.mkdirs();
        }
        RecipeStateTracker stateTracker = this.plugin.getRecipeStateTracker();
        List enabledRecipes = this.plugin.getConfig().getStringList("enabled-recipes");
        int added = 0;
        int skipped = 0;
        boolean configChanged = false;
        for (String recipeKey : DEFAULT_RECIPES) {
            File recipeFile = new File(this.recipesFolder, recipeKey + ".yml");
            if (stateTracker.wasDefaultRecipeDeleted(recipeKey)) {
                this.plugin.debug("Skipping deleted default recipe: " + recipeKey);
                ++skipped;
                if (!enabledRecipes.contains(recipeKey)) continue;
                enabledRecipes.remove(recipeKey);
                configChanged = true;
                this.plugin.debug("Removed deleted recipe from enabled-recipes: " + recipeKey);
                continue;
            }
            if (recipeFile.exists() || !this.copyDefaultRecipe(recipeKey)) continue;
            if (!enabledRecipes.contains(recipeKey)) {
                enabledRecipes.add(recipeKey);
                configChanged = true;
            }
            ++added;
            this.plugin.debug("Added default recipe: " + recipeKey);
        }
        if (configChanged) {
            this.plugin.getConfig().set("enabled-recipes", (Object)enabledRecipes);
            this.plugin.saveConfig();
            if (added > 0) {
                this.plugin.getLogger().info("Added " + added + " default recipes" + (String)(skipped > 0 ? " (" + skipped + " previously deleted)" : ""));
            }
        } else if (skipped > 0) {
            this.plugin.debug("Skipped " + skipped + " previously deleted default recipes");
        }
    }

    private boolean copyDefaultRecipe(String recipeKey) {
        try {
            String resourcePath = "default-recipes/" + recipeKey + ".yml";
            InputStream resource = this.plugin.getResource(resourcePath);
            if (resource == null) {
                this.plugin.getLogger().warning("Default recipe not found in jar: " + recipeKey);
                return false;
            }
            File targetFile = new File(this.recipesFolder, recipeKey + ".yml");
            Files.copy(resource, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            resource.close();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to copy default recipe " + recipeKey + ": " + e.getMessage());
            return false;
        }
    }

    public static List<String> getDefaultRecipeKeys() {
        return DEFAULT_RECIPES;
    }

    public static boolean isDefaultRecipe(String recipeKey) {
        for (String defaultRecipe : DEFAULT_RECIPES) {
            if (!defaultRecipe.equalsIgnoreCase(recipeKey)) continue;
            return true;
        }
        return false;
    }
}

