/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hikarii.customrecipes.CustomRecipes;

public class JsonRecipeFileManager {
    private final CustomRecipes plugin;
    private final File recipesFolder;
    private final Gson gson;

    public JsonRecipeFileManager(CustomRecipes plugin) {
        this.plugin = plugin;
        this.recipesFolder = new File(plugin.getDataFolder(), "recipes");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        if (!this.recipesFolder.exists()) {
            this.recipesFolder.mkdirs();
        }
    }

    public void saveRecipeJson(String recipeKey, Map<String, Object> recipeData) throws IOException {
        File jsonFile = new File(this.recipesFolder, recipeKey + ".json");
        try (FileWriter writer = new FileWriter(jsonFile);){
            this.gson.toJson(recipeData, (Appendable)writer);
        }
        this.plugin.debug("Saved recipe to JSON: " + jsonFile.getName());
    }

    public Map<String, Object> loadRecipeJson(String recipeKey) throws IOException {
        File jsonFile = new File(this.recipesFolder, recipeKey + ".json");
        if (!jsonFile.exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(jsonFile);){
            JsonObject json = JsonParser.parseReader(reader).getAsJsonObject();
            Map<String, Object> map = this.jsonToMap(json);
            return map;
        }
    }

    private Map<String, Object> jsonToMap(JsonObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        json.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonObject()) {
                map.put(key, this.jsonToMap(value.getAsJsonObject()));
            } else if (value.isJsonArray()) {
                map.put(key, this.gson.fromJson(value, List.class));
            } else if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    map.put(key, primitive.getAsNumber());
                } else if (primitive.isBoolean()) {
                    map.put(key, primitive.getAsBoolean());
                } else {
                    map.put(key, primitive.getAsString());
                }
            }
        });
        return map;
    }

    public boolean deleteRecipe(String recipeKey) {
        File jsonFile = new File(this.recipesFolder, recipeKey + ".json");
        if (jsonFile.exists()) {
            boolean deleted = jsonFile.delete();
            if (deleted) {
                this.plugin.debug("Deleted JSON file: " + jsonFile.getName());
            }
            return deleted;
        }
        return false;
    }

    public boolean jsonFileExists(String recipeKey) {
        return new File(this.recipesFolder, recipeKey + ".json").exists();
    }
}

