/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.ValidationException;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.ShapedRecipeData;
import org.hikarii.customrecipes.recipe.data.ShapelessRecipeData;
import org.hikarii.customrecipes.util.ItemStackSerializer;

public class RecipeConfigLoader {
    private final CustomRecipes plugin;

    public RecipeConfigLoader(CustomRecipes plugin) {
        this.plugin = plugin;
    }

    public CustomRecipe loadRecipe(String key, ConfigurationSection section) throws ValidationException {
        if (section == null) {
            throw new ValidationException("Recipe '" + key + "' has no configuration section");
        }
        try {
            ItemMeta meta;
            ItemStack resultItem;
            String name = section.getString("crafted-name");
            ArrayList<String> description = section.getStringList("crafted-description");
            if ((name == null || name.isEmpty()) && ((name = section.getString("crafted-name")) == null || name.isEmpty())) {
                name = section.getString("gui-name");
            }
            if ((description == null || description.isEmpty()) && ((description = section.getStringList("crafted-description")) == null || description.isEmpty())) {
                description = section.getStringList("gui-description");
            }
            String typeStr = section.getString("type", "SHAPED");
            RecipeType type = RecipeType.fromString(typeStr);
            if (section.contains("result-full")) {
                try {
                    resultObj = section.get("result-full");
                    resultMap = null;
                    if (resultObj instanceof Map) {
                        Map<String, Object> map;
                        resultMap = map = (Map<String, Object>)resultObj;
                    } else if (resultObj instanceof ConfigurationSection) {
                        ConfigurationSection resultSection = (ConfigurationSection)resultObj;
                        resultMap = this.configSectionToMap(resultSection);
                    }
                    if (resultMap == null) {
                        throw new ValidationException("Invalid result-full format");
                    }
                    resultItem = ItemStackSerializer.fromMap(resultMap);
                }
                catch (Exception e) {
                    throw new ValidationException("Failed to load result-full item: " + e.getMessage(), e);
                }
            } else if (section.contains("result")) {
                try {
                    resultObj = section.get("result");
                    resultMap = null;
                    if (resultObj instanceof Map) {
                        Map map = (Map)resultObj;
                        resultMap = map;
                    } else if (resultObj instanceof ConfigurationSection) {
                        ConfigurationSection resultSection = (ConfigurationSection)resultObj;
                        resultMap = this.configSectionToMap(resultSection);
                    }
                    if (resultMap == null) {
                        throw new ValidationException("Invalid result format - not a Map or ConfigurationSection");
                    }
                    resultItem = ItemStackSerializer.fromMap(resultMap);
                }
                catch (Exception e) {
                    throw new ValidationException("Failed to load result item: " + e.getMessage(), e);
                }
            } else {
                String materialStr = section.getString("material");
                if (materialStr == null || materialStr.isEmpty()) {
                    throw new ValidationException("Recipe '" + key + "' is missing 'material' field");
                }
                Material resultMaterial = Material.getMaterial((String)materialStr.toUpperCase());
                if (resultMaterial == null) {
                    throw new ValidationException("Recipe '" + key + "' has invalid material: " + materialStr);
                }
                int resultAmount = section.getInt("amount", 1);
                if (resultAmount < 1 || resultAmount > 64) {
                    throw new ValidationException("Recipe '" + key + "' amount must be between 1 and 64");
                }
                resultItem = new ItemStack(resultMaterial, resultAmount);
            }
            if ((name == null || name.isEmpty()) && resultItem != null && (meta = resultItem.getItemMeta()) != null && meta.hasDisplayName()) {
                name = PlainTextComponentSerializer.plainText().serialize(meta.displayName());
            }
            if ((description == null || description.isEmpty()) && resultItem != null && (meta = resultItem.getItemMeta()) != null && meta.hasLore() && meta.lore() != null) {
                description = new ArrayList<String>();
                for (Component line : meta.lore()) {
                    String loreText = PlainTextComponentSerializer.plainText().serialize(line);
                    if (loreText == null || loreText.isEmpty()) continue;
                    description.add(loreText);
                }
            }
            boolean hidden = section.getBoolean("hidden", false);
            ShapedRecipeData recipeData = null;
            ShapelessRecipeData shapelessData = null;
            if (type == RecipeType.SHAPED) {
                recipeData = this.loadShapedRecipeData(key, section);
            } else if (type == RecipeType.SHAPELESS) {
                shapelessData = this.loadShapelessRecipeData(key, section);
            } else {
                throw new ValidationException("Recipe type '" + String.valueOf((Object)type) + "' is not yet supported");
            }
            ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
            if (section.contains("potion-effects")) {
                List effectsList = section.getMapList("potion-effects");
                for (Map effectMap : effectsList) {
                    try {
                        String effectName = (String)effectMap.get("type");
                        int duration = effectMap.containsKey("duration") ? ((Number)effectMap.get("duration")).intValue() : 160;
                        int amplifier = effectMap.containsKey("amplifier") ? ((Number)effectMap.get("amplifier")).intValue() : 0;
                        PotionEffectType effectType = PotionEffectType.getByName((String)effectName);
                        if (effectType != null) {
                            potionEffects.add(new PotionEffect(effectType, duration, amplifier));
                            continue;
                        }
                        this.plugin.getLogger().warning("Unknown potion effect: " + effectName);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to parse potion effect: " + e.getMessage());
                    }
                }
            }
            return new CustomRecipe(key, name, description, type, recipeData, shapelessData, resultItem, hidden, potionEffects);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Error loading recipe '" + key + "': " + e.getMessage(), e);
        }
    }

    private ShapedRecipeData loadShapedRecipeData(String key, ConfigurationSection section) throws ValidationException {
        List recipePattern = section.getStringList("recipe");
        if (recipePattern.isEmpty() || recipePattern.size() > 3) {
            throw new ValidationException("Recipe '" + key + "' has invalid recipe data: Recipe must have 1-3 rows");
        }
        while (recipePattern.size() < 3) {
            recipePattern.add("AIR AIR AIR");
        }
        for (int i = 0; i < recipePattern.size(); ++i) {
            String row = (String)recipePattern.get(i);
            String[] items = row.split(" ");
            if (items.length >= 3) continue;
            StringBuilder paddedRow = new StringBuilder(row);
            for (int j = items.length; j < 3; ++j) {
                if (paddedRow.length() > 0) {
                    paddedRow.append(" ");
                }
                paddedRow.append("AIR");
            }
            recipePattern.set(i, paddedRow.toString());
        }
        ArrayList<Object> exactItems = null;
        if (section.contains("exact-ingredients")) {
            exactItemsList = section.getList("exact-ingredients");
            exactItems = new ArrayList<ItemStack>();
            for (Object obj : exactItemsList) {
                if (obj == null) {
                    exactItems.add(null);
                    continue;
                }
                if (obj instanceof String) {
                    String base64 = (String)obj;
                    try {
                        ItemStack item = ItemStackSerializer.fromBase64(base64);
                        exactItems.add(item);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to deserialize exact item from Base64: " + e.getMessage());
                        exactItems.add(null);
                    }
                    continue;
                }
                exactItems.add(null);
            }
        } else if (section.contains("exact-items")) {
            exactItemsList = section.getList("exact-items");
            exactItems = new ArrayList();
            for (Object obj : exactItemsList) {
                if (obj == null) {
                    exactItems.add(null);
                    continue;
                }
                if (obj instanceof Map) {
                    Map itemMap = (Map)obj;
                    try {
                        ItemStack item = ItemStackSerializer.fromMap(itemMap);
                        exactItems.add(item);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to deserialize exact item: " + e.getMessage());
                        exactItems.add(null);
                    }
                    continue;
                }
                exactItems.add(null);
            }
        }
        try {
            return ShapedRecipeData.fromConfigList(recipePattern, exactItems);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Recipe '" + key + "' has invalid recipe data: " + e.getMessage(), e);
        }
    }

    private ShapelessRecipeData loadShapelessRecipeData(String key, ConfigurationSection section) throws ValidationException {
        List ingredientList = section.getStringList("ingredients");
        if (ingredientList.isEmpty()) {
            throw new ValidationException("Recipe '" + key + "' has no ingredients");
        }
        return ShapelessRecipeData.fromConfigList(ingredientList);
    }

    private Map<String, Object> configSectionToMap(ConfigurationSection section) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : section.getKeys(false)) {
            Object value = section.get(key);
            if (value instanceof ConfigurationSection) {
                map.put(key, this.configSectionToMap((ConfigurationSection)value));
                continue;
            }
            if (value instanceof List) {
                map.put(key, value);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public void validateKey(String key) throws ValidationException {
        if (key == null || key.isEmpty()) {
            throw new ValidationException("Recipe key cannot be empty");
        }
        if (!key.matches("[a-zA-Z0-9_-]+")) {
            throw new ValidationException("Recipe key '" + key + "' contains invalid characters. Only letters, numbers, underscores, and hyphens are allowed.");
        }
    }
}

