/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.RecipeConfigLoader;
import org.hikarii.customrecipes.config.ValidationException;
import org.hikarii.customrecipes.recipe.CustomRecipe;

public class RecipeFileManager {
    private final CustomRecipes plugin;
    private final File recipesFolder;

    public RecipeFileManager(CustomRecipes plugin) {
        this.plugin = plugin;
        this.recipesFolder = new File(plugin.getDataFolder(), "recipes");
        if (!this.recipesFolder.exists()) {
            this.recipesFolder.mkdirs();
        }
    }

    public Map<String, CustomRecipe> loadAllRecipes() throws ValidationException {
        HashMap<String, CustomRecipe> recipes = new HashMap<String, CustomRecipe>();
        RecipeConfigLoader loader = new RecipeConfigLoader(this.plugin);
        File[] files = this.recipesFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            this.plugin.getLogger().info("No recipe files found in recipes folder");
            return recipes;
        }
        int successCount = 0;
        int failCount = 0;
        for (File file : files) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                String recipeKey = file.getName().replace(".yml", "");
                CustomRecipe recipe = loader.loadRecipe(recipeKey, (ConfigurationSection)config);
                recipes.put(recipeKey.toLowerCase(), recipe);
                ++successCount;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load recipe from " + file.getName() + ": " + e.getMessage());
                ++failCount;
                if (!this.plugin.isDebugMode()) continue;
                e.printStackTrace();
            }
        }
        this.plugin.getLogger().info("Loaded " + successCount + " recipes from files" + (String)(failCount > 0 ? " (" + failCount + " failed)" : ""));
        return recipes;
    }

    public void saveRecipe(String recipeKey, ConfigurationSection recipeData) throws IOException {
        File recipeFile = new File(this.recipesFolder, recipeKey + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        for (String key : recipeData.getKeys(false)) {
            config.set(key, recipeData.get(key));
        }
        config.save(recipeFile);
        this.plugin.debug("Saved recipe to file: " + recipeFile.getName());
    }

    public void saveRecipe(String recipeKey, Map<String, Object> data) throws IOException {
        File recipeFile = new File(this.recipesFolder, recipeKey + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            config.set(entry.getKey(), entry.getValue());
        }
        config.save(recipeFile);
        this.plugin.debug("Saved recipe to file: " + recipeFile.getName());
    }

    public boolean deleteRecipe(String recipeKey) {
        File recipeFile = new File(this.recipesFolder, recipeKey + ".yml");
        if (recipeFile.exists()) {
            return recipeFile.delete();
        }
        return false;
    }

    public boolean recipeFileExists(String recipeKey) {
        File recipeFile = new File(this.recipesFolder, recipeKey + ".yml");
        return recipeFile.exists();
    }

    public File getRecipesFolder() {
        return this.recipesFolder;
    }
}

