/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.DefaultRecipesManager;

public class RecipeStateTracker {
    private final CustomRecipes plugin;
    private final File stateFile;
    private YamlConfiguration stateConfig;
    private Set<String> deletedDefaultRecipes;
    private Set<String> disabledRecipes;
    private String lastVersion;

    public RecipeStateTracker(CustomRecipes plugin) {
        this.plugin = plugin;
        this.stateFile = new File(plugin.getDataFolder(), "recipe-state.yml");
        this.deletedDefaultRecipes = new HashSet<String>();
        this.disabledRecipes = new HashSet<String>();
        this.load();
    }

    private void load() {
        if (!this.stateFile.exists()) {
            this.createDefaultState();
            return;
        }
        try {
            this.stateConfig = YamlConfiguration.loadConfiguration((File)this.stateFile);
            List deleted = this.stateConfig.getStringList("deleted-default-recipes");
            this.deletedDefaultRecipes.addAll(deleted);
            List disabled = this.stateConfig.getStringList("disabled-recipes");
            this.disabledRecipes.addAll(disabled);
            this.lastVersion = this.stateConfig.getString("last-version", "1.1.2");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load recipe state: " + e.getMessage());
            e.printStackTrace();
            this.createDefaultState();
        }
    }

    private void createDefaultState() {
        this.stateConfig = new YamlConfiguration();
        this.stateConfig.set("version", (Object)1);
        this.stateConfig.set("last-version", (Object)this.plugin.getDescription().getVersion());
        this.stateConfig.set("deleted-default-recipes", new ArrayList());
        this.stateConfig.set("disabled-recipes", new ArrayList());
        this.stateConfig.set("migration-notes", Arrays.asList("This file tracks which recipes have been deleted or disabled", "Do not edit manually unless you know what you're doing"));
        this.save();
    }

    public void save() {
        try {
            this.stateConfig.set("deleted-default-recipes", new ArrayList<String>(this.deletedDefaultRecipes));
            this.stateConfig.set("disabled-recipes", new ArrayList<String>(this.disabledRecipes));
            this.stateConfig.set("last-version", (Object)this.plugin.getDescription().getVersion());
            this.stateConfig.set("last-updated", (Object)System.currentTimeMillis());
            this.stateConfig.save(this.stateFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save recipe state: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void markDefaultRecipeDeleted(String recipeKey) {
        String correctCaseName = recipeKey;
        for (String defaultRecipe : DefaultRecipesManager.getDefaultRecipeKeys()) {
            if (!defaultRecipe.equalsIgnoreCase(recipeKey)) continue;
            correctCaseName = defaultRecipe;
            break;
        }
        this.deletedDefaultRecipes.add(correctCaseName);
        this.save();
    }

    public boolean wasDefaultRecipeDeleted(String recipeKey) {
        for (String deletedRecipe : this.deletedDefaultRecipes) {
            if (!deletedRecipe.equalsIgnoreCase(recipeKey)) continue;
            return true;
        }
        return false;
    }

    public void markRecipeDisabled(String recipeKey) {
        String normalizedKey = recipeKey.toLowerCase();
        this.disabledRecipes.add(normalizedKey);
        this.save();
    }

    public void markRecipeEnabled(String recipeKey) {
        this.disabledRecipes.removeIf(disabled -> disabled.equalsIgnoreCase(recipeKey));
        this.save();
    }

    public boolean isRecipeDisabled(String recipeKey) {
        for (String disabledRecipe : this.disabledRecipes) {
            if (!disabledRecipe.equalsIgnoreCase(recipeKey)) continue;
            return true;
        }
        return false;
    }

    public void unmarkDefaultRecipeDeleted(String recipeKey) {
        this.deletedDefaultRecipes.remove(recipeKey);
        this.save();
        this.plugin.debug("Unmarked default recipe as deleted: " + recipeKey);
    }

    public Set<String> getDeletedDefaultRecipes() {
        return new HashSet<String>(this.deletedDefaultRecipes);
    }

    public Set<String> getDisabledRecipes() {
        return new HashSet<String>(this.disabledRecipes);
    }

    public String getLastVersion() {
        return this.lastVersion;
    }

    public boolean isFreshInstall() {
        return !this.stateFile.exists() && this.deletedDefaultRecipes.isEmpty();
    }

    public void syncEnabledRecipes() {
        List enabledRecipes = this.plugin.getConfig().getStringList("enabled-recipes");
        LinkedHashSet<String> syncedRecipes = new LinkedHashSet<String>();
        File recipesFolder = this.plugin.getConfigManager().getRecipeFileManager().getRecipesFolder();
        Map<String, String> existingRecipeFiles = this.getExistingRecipeFiles(recipesFolder);
        int removed = 0;
        int kept = 0;
        for (String recipeKey : new ArrayList(enabledRecipes)) {
            String actualFileName = existingRecipeFiles.get(recipeKey.toLowerCase());
            if (actualFileName != null) {
                if (!this.wasDefaultRecipeDeleted(recipeKey)) {
                    syncedRecipes.add(actualFileName);
                    ++kept;
                    continue;
                }
                this.plugin.debug("Removing deleted recipe from enabled-recipes: " + recipeKey);
                ++removed;
                continue;
            }
            this.plugin.debug("Removing non-existent recipe from enabled-recipes: " + recipeKey);
            ++removed;
        }
        if (removed > 0 || syncedRecipes.size() != enabledRecipes.size()) {
            this.plugin.getConfig().set("enabled-recipes", new ArrayList(syncedRecipes));
            this.plugin.saveConfig();
            this.plugin.getLogger().info("Synchronized enabled-recipes: " + kept + " kept" + (String)(removed > 0 ? ", " + removed + " removed" : ""));
        } else {
            this.plugin.debug("enabled-recipes already synchronized");
        }
    }

    private Map<String, String> getExistingRecipeFiles(File recipesFolder) {
        HashMap<String, String> files = new HashMap<String, String>();
        if (!recipesFolder.exists()) {
            return files;
        }
        File[] recipeFiles = recipesFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (recipeFiles != null) {
            for (File file : recipeFiles) {
                String fileName = file.getName().replace(".yml", "");
                files.put(fileName.toLowerCase(), fileName);
            }
        }
        return files;
    }

    public boolean needsMigration() {
        String currentVersion = this.plugin.getDescription().getVersion();
        return !currentVersion.equals(this.lastVersion);
    }

    public void cleanup() {
        HashSet<String> defaultRecipeKeys = new HashSet<String>(DefaultRecipesManager.getDefaultRecipeKeys());
        this.deletedDefaultRecipes.removeIf(key -> !defaultRecipeKeys.contains(key));
        this.plugin.debug("Cleaned up recipe state");
        this.save();
    }
}

