/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.ItemEditorGUI;
import org.hikarii.customrecipes.util.MessageUtil;

public class EnchantmentSelectorGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;
    private final ItemStack targetItem;
    private final Map<Enchantment, Integer> selectedEnchantments;
    private final Consumer<Map<Enchantment, Integer>> onComplete;
    private final Consumer<Boolean> onHideToggle;
    private final Consumer<Void> onReturn;
    private boolean showAllEnchantments = false;
    private boolean hideEnchantments = false;
    private int page = 0;
    private static final int ENCHANTS_PER_PAGE = 45;

    public EnchantmentSelectorGUI(CustomRecipes plugin, Player player, ItemStack targetItem, Map<Enchantment, Integer> currentEnchantments, boolean hideEnchants, Consumer<Void> onReturn) {
        this.plugin = plugin;
        this.player = player;
        this.targetItem = targetItem;
        this.selectedEnchantments = new HashMap<Enchantment, Integer>(currentEnchantments);
        this.hideEnchantments = hideEnchants;
        this.onReturn = onReturn;
        this.onComplete = null;
        this.onHideToggle = null;
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createMenuTitle("Select Enchantments", NamedTextColor.LIGHT_PURPLE));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addEnchantmentBooks();
        this.addNavigationButtons();
        this.addFilterButton();
        this.addHideEnchantsButton();
        this.addBackButton();
    }

    private void fillBorders() {
        ItemStack borderPane = new ItemStack(Material.PURPLE_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 45; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
    }

    private List<Enchantment> getAvailableEnchantments() {
        if (this.showAllEnchantments) {
            return Arrays.stream(Enchantment.values()).sorted(Comparator.comparing(e -> e.getKey().getKey())).collect(Collectors.toList());
        }
        return Arrays.stream(Enchantment.values()).filter(e -> e.canEnchantItem(this.targetItem)).sorted(Comparator.comparing(e -> e.getKey().getKey())).collect(Collectors.toList());
    }

    private void addEnchantmentBooks() {
        List<Enchantment> enchantments = this.getAvailableEnchantments();
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, enchantments.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Enchantment enchantment = enchantments.get(i);
            ItemStack book = this.createEnchantmentBook(enchantment);
            this.inventory.setItem(i - startIndex, book);
        }
    }

    private ItemStack createEnchantmentBook(Enchantment enchantment) {
        int currentLevel = this.selectedEnchantments.getOrDefault(enchantment, 0);
        Material bookType = currentLevel > 0 ? Material.KNOWLEDGE_BOOK : Material.BOOK;
        ItemStack book = new ItemStack(bookType);
        ItemMeta meta = book.getItemMeta();
        String enchantName = this.formatEnchantmentName(enchantment.getKey().getKey());
        NamedTextColor nameColor = currentLevel > 0 ? NamedTextColor.AQUA : NamedTextColor.GRAY;
        meta.displayName(((TextComponent)Component.text((String)enchantName, (TextColor)nameColor).decoration(TextDecoration.BOLD, currentLevel > 0)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Max Level: " + enchantment.getMaxLevel()), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)("Current: Level " + currentLevel), (TextColor)(currentLevel > 0 ? NamedTextColor.GREEN : NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        String description = this.getEnchantmentDescription(enchantment);
        if (description != null) {
            lore.add(Component.text((String)description, (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
        }
        if (!enchantment.canEnchantItem(this.targetItem)) {
            lore.add(Component.text((String)"\u26a0 Not compatible with item", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
        }
        lore.add(Component.text((String)"\u00bb Left Click: +1 Level", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, true));
        lore.add(Component.text((String)"\u00bb Right Click: -1 Level", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
        lore.add(Component.text((String)"\u00bb Shift Click: Set Max/Reset", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        book.setItemMeta(meta);
        return book;
    }

    private String formatEnchantmentName(String key) {
        String[] parts = key.split("_");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            result.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }

    private String getEnchantmentDescription(Enchantment enchantment) {
        return switch (enchantment.getKey().getKey()) {
            case "protection" -> "Reduces damage from all sources";
            case "fire_protection" -> "Reduces fire damage";
            case "feather_falling" -> "Reduces fall damage";
            case "blast_protection" -> "Reduces explosion damage";
            case "projectile_protection" -> "Reduces projectile damage";
            case "respiration" -> "Extends underwater breathing";
            case "aqua_affinity" -> "Faster mining underwater";
            case "thorns" -> "Damages attackers";
            case "depth_strider" -> "Faster underwater movement";
            case "frost_walker" -> "Freezes water beneath you";
            case "soul_speed" -> "Faster on soul blocks";
            case "swift_sneak" -> "Faster sneaking";
            case "sharpness" -> "Increases melee damage";
            case "smite" -> "Increases damage to undead";
            case "bane_of_arthropods" -> "Increases damage to arthropods";
            case "knockback" -> "Increases knockback";
            case "fire_aspect" -> "Sets target on fire";
            case "looting" -> "Increases mob loot";
            case "sweeping_edge" -> "Increases sweep attack damage";
            case "efficiency" -> "Faster mining";
            case "silk_touch" -> "Mines blocks intact";
            case "unbreaking" -> "Increases durability";
            case "fortune" -> "Increases block drops";
            case "power" -> "Increases arrow damage";
            case "punch" -> "Increases arrow knockback";
            case "flame" -> "Arrows set target on fire";
            case "infinity" -> "Infinite arrows (needs 1)";
            case "luck_of_the_sea" -> "Increases fishing luck";
            case "lure" -> "Faster fishing";
            case "loyalty" -> "Trident returns";
            case "impaling" -> "Increases trident damage";
            case "riptide" -> "Trident launches player";
            case "channeling" -> "Summons lightning";
            case "multishot" -> "Shoots 3 arrows";
            case "quick_charge" -> "Faster crossbow reload";
            case "piercing" -> "Arrows pierce entities";
            case "mending" -> "Repairs with XP";
            case "vanishing_curse" -> "Item vanishes on death";
            case "binding_curse" -> "Cannot remove armor";
            case "density" -> "Increases mace damage based on fall distance";
            case "breach" -> "Reduces enemy armor effectiveness";
            case "wind_burst" -> "Launches entities with wind burst";
            default -> null;
        };
    }

    private void addNavigationButtons() {
        List<Enchantment> enchantments = this.getAvailableEnchantments();
        int maxPages = (int)Math.ceil((double)enchantments.size() / 45.0);
        if (maxPages > 1) {
            ItemStack prevButton = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevButton.getItemMeta();
            prevMeta.displayName(Component.text((String)"\u25c0 Previous Page", (TextColor)(this.page > 0 ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false));
            prevMeta.lore(List.of((TextComponent)Component.text((String)("Page " + (this.page + 1) + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
            prevButton.setItemMeta(prevMeta);
            this.inventory.setItem(48, prevButton);
            ItemStack nextButton = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextButton.getItemMeta();
            nextMeta.displayName(Component.text((String)"Next Page \u25b6", (TextColor)(this.page < maxPages - 1 ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false));
            nextMeta.lore(List.of((TextComponent)Component.text((String)("Page " + (this.page + 1) + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
            nextButton.setItemMeta(nextMeta);
            this.inventory.setItem(50, nextButton);
        }
    }

    private void addFilterButton() {
        ItemStack button = new ItemStack(this.showAllEnchantments ? Material.ENDER_EYE : Material.ENDER_PEARL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)(this.showAllEnchantments ? "All Enchantments" : "Compatible Only"), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (this.showAllEnchantments) {
            lore.add(Component.text((String)"Showing all enchantments", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"including incompatible ones", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        } else {
            lore.add(Component.text((String)"Showing only enchantments", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"compatible with this item", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(45, button);
    }

    private void addHideEnchantsButton() {
        ItemStack button = new ItemStack(this.hideEnchantments ? Material.ENDER_EYE : Material.ENDER_PEARL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Enchantment Visibility", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Status: " + (this.hideEnchantments ? "Hidden" : "Visible")), (TextColor)(this.hideEnchantments ? NamedTextColor.RED : NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"When hidden, enchantments", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"won't show on the item", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(46, button);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"\u00ab Back to Item Editor", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Save and return", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        back.setItemMeta(meta);
        this.inventory.setItem(53, back);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        List<Enchantment> enchantments;
        int enchantIndex;
        Player clicker;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player) || !(clicker = (Player)humanEntity).equals((Object)this.player)) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        if (slot == 45) {
            this.showAllEnchantments = !this.showAllEnchantments;
            this.page = 0;
            this.updateInventory();
            return;
        }
        if (slot == 46) {
            this.hideEnchantments = !this.hideEnchantments;
            this.updateInventory();
            return;
        }
        if (slot == 48) {
            if (this.page > 0) {
                --this.page;
                this.updateInventory();
            }
            return;
        }
        if (slot == 50) {
            List<Enchantment> enchantments2 = this.getAvailableEnchantments();
            int maxPages = (int)Math.ceil((double)enchantments2.size() / 45.0);
            if (this.page < maxPages - 1) {
                ++this.page;
                this.updateInventory();
            }
            return;
        }
        if (slot == 53) {
            ItemEditorGUI editor = ItemEditorGUI.getLastEditor(this.player.getUniqueId());
            if (editor != null) {
                editor.customEnchantments.clear();
                editor.customEnchantments.putAll(this.selectedEnchantments);
                editor.hideEnchantments = this.hideEnchantments;
                editor.forceUpdatePreview();
            }
            this.player.closeInventory();
            if (this.onReturn != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.onReturn.accept(null));
            }
            return;
        }
        if (slot < 45 && (enchantIndex = this.page * 45 + slot) < (enchantments = this.getAvailableEnchantments()).size()) {
            Enchantment enchantment = enchantments.get(enchantIndex);
            int currentLevel = this.selectedEnchantments.getOrDefault(enchantment, 0);
            int maxLevel = enchantment.getMaxLevel();
            if (clickType.isShiftClick()) {
                if (currentLevel > 0) {
                    this.selectedEnchantments.remove(enchantment);
                } else {
                    this.selectedEnchantments.put(enchantment, maxLevel);
                }
            } else if (clickType.isLeftClick()) {
                if (currentLevel < maxLevel) {
                    this.selectedEnchantments.put(enchantment, currentLevel + 1);
                }
            } else if (clickType.isRightClick() && currentLevel > 0) {
                if (currentLevel == 1) {
                    this.selectedEnchantments.remove(enchantment);
                } else {
                    this.selectedEnchantments.put(enchantment, currentLevel - 1);
                }
            }
            this.updateInventory();
        }
    }

    public Map<Enchantment, Integer> getSelectedEnchantments() {
        return new HashMap<Enchantment, Integer>(this.selectedEnchantments);
    }

    public boolean isHideEnchantments() {
        return this.hideEnchantments;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

