/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.EnchantmentSelectorGUI;
import org.hikarii.customrecipes.util.MessageUtil;

public class ItemEditorGUI
implements Listener {
    private static final Map<UUID, ItemEditorGUI> waitingForInput = new HashMap<UUID, ItemEditorGUI>();
    private static final Map<UUID, ItemEditorGUI> lastEditors = new HashMap<UUID, ItemEditorGUI>();
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;
    private final ItemStack item;
    private final Consumer<ItemStack> onComplete;
    private String customName;
    private List<String> customLore;
    private Integer customModelData;
    private Map<String, String> customNBT;
    public Map<Enchantment, Integer> customEnchantments;
    private EditMode currentMode = EditMode.NONE;
    private String tempNBTKey;
    public boolean hideEnchantments = false;

    public static ItemEditorGUI getLastEditor(UUID playerUuid) {
        return lastEditors.get(playerUuid);
    }

    public ItemEditorGUI(CustomRecipes plugin, Player player, ItemStack item, Consumer<ItemStack> onComplete) {
        this.plugin = plugin;
        lastEditors.put(player.getUniqueId(), this);
        this.player = player;
        this.item = item.clone();
        this.onComplete = onComplete;
        this.customName = null;
        this.customLore = new ArrayList<String>();
        this.customModelData = null;
        this.customNBT = new HashMap<String, String>();
        this.customEnchantments = new HashMap<Enchantment, Integer>();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (meta.hasDisplayName()) {
                this.customName = PlainTextComponentSerializer.plainText().serialize(meta.displayName());
            }
            if (meta.hasLore() && meta.lore() != null) {
                for (Component line : meta.lore()) {
                    String loreText = PlainTextComponentSerializer.plainText().serialize(line);
                    this.customLore.add(loreText);
                }
            }
            if (meta.hasCustomModelData()) {
                this.customModelData = meta.getCustomModelData();
            }
            if (meta.hasEnchants()) {
                this.customEnchantments.putAll(meta.getEnchants());
            }
            if (meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                this.hideEnchantments = true;
            }
            PersistentDataContainer container = meta.getPersistentDataContainer();
            for (NamespacedKey key : container.getKeys()) {
                String value;
                if (!key.getNamespace().equals(plugin.getName().toLowerCase()) || (value = (String)container.get(key, PersistentDataType.STRING)) == null) continue;
                this.customNBT.put(key.getKey(), value);
            }
        }
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createMenuTitle("Advanced Item Editor", NamedTextColor.DARK_GREEN));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addPreviewItem();
        this.addNameButton();
        this.addLoreButton();
        this.addCustomModelDataButton();
        this.addNBTButton();
        this.addEnchantmentButton();
        this.addClearButton();
        this.addSaveButton();
        this.addCancelButton();
    }

    private void fillBorders() {
        ItemStack borderPane = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
    }

    private void addPreviewItem() {
        ItemStack preview = this.item.clone();
        ItemMeta meta = preview.getItemMeta();
        if (meta != null) {
            if (this.customName != null && !this.customName.isEmpty()) {
                meta.displayName(MessageUtil.colorize(this.customName).decoration(TextDecoration.ITALIC, false));
            }
            if (!this.customLore.isEmpty()) {
                List<Component> loreComponents = this.customLore.stream().map(line -> MessageUtil.colorize(line).decoration(TextDecoration.ITALIC, false)).toList();
                meta.lore((List)loreComponents);
            }
            if (this.customModelData != null) {
                meta.setCustomModelData(this.customModelData);
            }
            for (Map.Entry entry : this.customEnchantments.entrySet()) {
                meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            if (this.hideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (!this.customNBT.isEmpty()) {
                PersistentDataContainer container = meta.getPersistentDataContainer();
                for (Map.Entry<String, String> entry : this.customNBT.entrySet()) {
                    NamespacedKey key = new NamespacedKey((Plugin)this.plugin, entry.getKey());
                    container.set(key, PersistentDataType.STRING, (Object)entry.getValue());
                }
            }
            preview.setItemMeta(meta);
        }
        this.inventory.setItem(22, preview);
    }

    private void addNameButton() {
        ItemStack button = new ItemStack(Material.NAME_TAG);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Edit Name", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (this.customName != null && !this.customName.isEmpty()) {
            lore.add(Component.text((String)"Current:", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(MessageUtil.colorize(this.customName).decoration(TextDecoration.ITALIC, false));
        } else {
            lore.add(Component.text((String)"No name set", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to edit", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(11, button);
    }

    private void addLoreButton() {
        ItemStack button = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Edit Description", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (!this.customLore.isEmpty()) {
            lore.add(Component.text((String)("Current lines: " + this.customLore.size()), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            for (int i = 0; i < Math.min(3, this.customLore.size()); ++i) {
                lore.add(MessageUtil.colorize(this.customLore.get(i)).decoration(TextDecoration.ITALIC, false));
            }
            if (this.customLore.size() > 3) {
                lore.add(Component.text((String)("... and " + (this.customLore.size() - 3) + " more"), (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
            }
        } else {
            lore.add(Component.text((String)"No description set", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Left Click to add line", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        lore.add(Component.text((String)"\u00bb Right Click to clear & restart", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(20, button);
    }

    private void addCustomModelDataButton() {
        ItemStack button = new ItemStack(Material.PAINTING);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Custom Model Data", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (this.customModelData != null) {
            lore.add(((TextComponent)Component.text((String)"Current: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((int)this.customModelData, (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        } else {
            lore.add(Component.text((String)"No custom model data", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"Used for texture packs", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to set", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(15, button);
    }

    private void addNBTButton() {
        ItemStack button = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"NBT Data", (TextColor)NamedTextColor.DARK_AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (!this.customNBT.isEmpty()) {
            lore.add(Component.text((String)("Current NBT tags: " + this.customNBT.size()), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            int shown = 0;
            for (Map.Entry<String, String> entry : this.customNBT.entrySet()) {
                if (shown++ >= 3) {
                    lore.add(Component.text((String)("... and " + (this.customNBT.size() - 3) + " more"), (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
                    break;
                }
                lore.add(Component.text((String)(entry.getKey() + ": " + entry.getValue()), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
            }
        } else {
            lore.add(Component.text((String)"No NBT data set", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to add NBT", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(24, button);
    }

    private void addEnchantmentButton() {
        ItemStack button = new ItemStack(Material.ENCHANTING_TABLE);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Enchantments", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (!this.customEnchantments.isEmpty()) {
            lore.add(Component.text((String)("Current enchantments: " + this.customEnchantments.size()), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            int shown = 0;
            for (Map.Entry<Enchantment, Integer> entry : this.customEnchantments.entrySet()) {
                if (shown++ >= 3) {
                    lore.add(Component.text((String)("  ... and " + (this.customEnchantments.size() - 3) + " more"), (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
                    break;
                }
                String enchName = entry.getKey().getKey().getKey();
                lore.add(Component.text((String)("  \u2022 " + enchName + " " + String.valueOf(entry.getValue())), (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.ITALIC, false));
            }
        } else {
            lore.add(Component.text((String)"No enchantments", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to open selector", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(29, button);
    }

    private void addClearButton() {
        ItemStack button = new ItemStack(Material.BARRIER);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(Component.text((String)"Clear All", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Clear all customization", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to clear", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(53, button);
    }

    private void addSaveButton() {
        ItemStack button = new ItemStack(Material.LIME_WOOL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Save & Return", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Apply changes and", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"return to creator", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to save", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(48, button);
    }

    private void addCancelButton() {
        ItemStack button = new ItemStack(Material.RED_WOOL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Cancel", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Discard changes", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to cancel", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(50, button);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 11) {
            this.currentMode = EditMode.NAME;
            waitingForInput.put(this.player.getUniqueId(), this);
            this.player.closeInventory();
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type the item name in chat (supports MiniMessage colors)");
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type <red>cancel</red> to cancel");
            return;
        }
        if (slot == 20) {
            if (event.getClick().isRightClick()) {
                this.customLore.clear();
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Cleared crafted description");
                this.updateInventory();
                return;
            }
            this.currentMode = EditMode.LORE;
            waitingForInput.put(this.player.getUniqueId(), this);
            this.player.closeInventory();
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type a description line in chat (supports MiniMessage colors)");
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type <red>done</red> when finished, or <red>cancel</red> to cancel");
            return;
        }
        if (slot == 15) {
            this.currentMode = EditMode.CUSTOM_MODEL_DATA;
            waitingForInput.put(this.player.getUniqueId(), this);
            this.player.closeInventory();
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type the custom model data number in chat");
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type <red>cancel</red> to cancel or <red>clear</red> to remove");
            return;
        }
        if (slot == 24) {
            this.currentMode = EditMode.NBT_KEY;
            waitingForInput.put(this.player.getUniqueId(), this);
            this.player.closeInventory();
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type the NBT tag key in chat");
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type <red>cancel</red> to cancel");
            return;
        }
        if (slot == 29) {
            this.player.closeInventory();
            String savedName = this.customName;
            ArrayList<String> savedLore = new ArrayList<String>(this.customLore);
            Integer savedModelData = this.customModelData;
            HashMap<String, String> savedNBT = new HashMap<String, String>(this.customNBT);
            HashMap<Enchantment, Integer> savedEnchants = new HashMap<Enchantment, Integer>(this.customEnchantments);
            boolean savedHide = this.hideEnchantments;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> new EnchantmentSelectorGUI(this.plugin, this.player, this.item, savedEnchants, savedHide, v -> {
                ItemEditorGUI editor = ItemEditorGUI.getLastEditor(this.player.getUniqueId());
                ItemEditorGUI newEditor = new ItemEditorGUI(this.plugin, this.player, this.item, this.onComplete);
                newEditor.customName = savedName;
                newEditor.customLore = savedLore;
                newEditor.customModelData = savedModelData;
                newEditor.customNBT = savedNBT;
                if (editor != null) {
                    newEditor.customEnchantments.clear();
                    newEditor.customEnchantments.putAll(editor.customEnchantments);
                    newEditor.hideEnchantments = editor.hideEnchantments;
                }
                newEditor.updateInventory();
                newEditor.open();
            }).open());
            return;
        }
        if (slot == 53) {
            this.customName = null;
            this.customLore.clear();
            this.customModelData = null;
            this.customNBT.clear();
            this.customEnchantments.clear();
            ItemMeta meta = this.item.getItemMeta();
            if (meta != null) {
                meta.displayName(null);
                meta.lore(null);
                meta.setCustomModelData(null);
                for (Enchantment ench : meta.getEnchants().keySet()) {
                    meta.removeEnchant(ench);
                }
                PersistentDataContainer container = meta.getPersistentDataContainer();
                for (NamespacedKey key : new HashSet(container.getKeys())) {
                    if (!key.getNamespace().equals(this.plugin.getName().toLowerCase())) continue;
                    container.remove(key);
                }
                this.item.setItemMeta(meta);
            }
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Cleared all customization");
            this.updateInventory();
            return;
        }
        if (slot == 48) {
            this.applyToItem();
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Saved item customization");
            this.player.closeInventory();
            if (this.onComplete != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.onComplete.accept(this.getEditedItem()));
            }
            return;
        }
        if (slot == 50) {
            this.player.closeInventory();
            if (this.onComplete != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.onComplete.accept(null));
            }
            return;
        }
    }

    private void applyToItem() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (this.customName != null && !this.customName.isEmpty()) {
                meta.displayName(MessageUtil.colorize(this.customName).decoration(TextDecoration.ITALIC, false));
            }
            if (!this.customLore.isEmpty()) {
                List<Component> loreComponents = this.customLore.stream().map(line -> MessageUtil.colorize(line).decoration(TextDecoration.ITALIC, false)).toList();
                meta.lore((List)loreComponents);
            }
            if (this.customModelData != null) {
                meta.setCustomModelData(this.customModelData);
            }
            for (Map.Entry entry : this.customEnchantments.entrySet()) {
                meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            if (this.hideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (!this.customNBT.isEmpty()) {
                PersistentDataContainer container = meta.getPersistentDataContainer();
                for (Map.Entry<String, String> entry : this.customNBT.entrySet()) {
                    NamespacedKey key = new NamespacedKey((Plugin)this.plugin, entry.getKey());
                    container.set(key, PersistentDataType.STRING, (Object)entry.getValue());
                }
            }
            this.item.setItemMeta(meta);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player chatPlayer = event.getPlayer();
        ItemEditorGUI editor = waitingForInput.get(chatPlayer.getUniqueId());
        if (editor == null || !chatPlayer.equals((Object)this.player)) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            waitingForInput.remove(chatPlayer.getUniqueId());
            this.currentMode = EditMode.NONE;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                MessageUtil.sendAdminWarning((CommandSender)chatPlayer, "Cancelled");
                editor.open();
            });
            return;
        }
        switch (this.currentMode.ordinal()) {
            case 1: {
                editor.customName = message;
                waitingForInput.remove(chatPlayer.getUniqueId());
                this.currentMode = EditMode.NONE;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    MessageUtil.sendAdminSuccess((CommandSender)chatPlayer, "Set item name");
                    editor.updateInventory();
                    editor.open();
                });
                break;
            }
            case 2: {
                if (message.equalsIgnoreCase("done")) {
                    waitingForInput.remove(chatPlayer.getUniqueId());
                    this.currentMode = EditMode.NONE;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        MessageUtil.sendAdminSuccess((CommandSender)chatPlayer, "Finished editing description");
                        editor.updateInventory();
                        editor.open();
                    });
                    break;
                }
                editor.customLore.add(message);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    MessageUtil.sendAdminSuccess((CommandSender)chatPlayer, "Added description line");
                    MessageUtil.sendAdminInfo((CommandSender)chatPlayer, "Type another line, or type <gold>done</gold> to finish");
                });
                break;
            }
            case 3: {
                if (message.equalsIgnoreCase("clear")) {
                    editor.customModelData = null;
                    waitingForInput.remove(chatPlayer.getUniqueId());
                    this.currentMode = EditMode.NONE;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        MessageUtil.sendAdminSuccess((CommandSender)chatPlayer, "Cleared custom model data");
                        editor.updateInventory();
                        editor.open();
                    });
                    break;
                }
                try {
                    int modelData = Integer.parseInt(message);
                    editor.customModelData = modelData;
                    waitingForInput.remove(chatPlayer.getUniqueId());
                    this.currentMode = EditMode.NONE;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        MessageUtil.sendAdminSuccess((CommandSender)chatPlayer, "Set custom model data to " + modelData);
                        editor.updateInventory();
                        editor.open();
                    });
                }
                catch (NumberFormatException e) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> MessageUtil.sendError((CommandSender)chatPlayer, "Invalid number! Please enter a valid integer."));
                }
                break;
            }
            case 4: {
                editor.tempNBTKey = message;
                this.currentMode = EditMode.NBT_VALUE;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> MessageUtil.sendAdminInfo((CommandSender)chatPlayer, "Now type the value for NBT tag '" + message + "'"));
                break;
            }
            case 5: {
                editor.customNBT.put(editor.tempNBTKey, message);
                waitingForInput.remove(chatPlayer.getUniqueId());
                this.currentMode = EditMode.NONE;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    MessageUtil.sendAdminSuccess((CommandSender)chatPlayer, "Added NBT: " + editor.tempNBTKey + " = " + message);
                    editor.updateInventory();
                    editor.open();
                });
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player) && !waitingForInput.containsKey(this.player.getUniqueId())) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
            AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
        }
    }

    public String getCustomName() {
        return this.customName;
    }

    public List<String> getCustomLore() {
        return this.customLore;
    }

    public Integer getCustomModelData() {
        return this.customModelData;
    }

    public Map<String, String> getCustomNBT() {
        return this.customNBT;
    }

    public ItemStack getEditedItem() {
        return this.item.clone();
    }

    public void forceUpdatePreview() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            for (Enchantment enchantment : new HashSet(meta.getEnchants().keySet())) {
                meta.removeEnchant(enchantment);
            }
            for (Map.Entry entry : this.customEnchantments.entrySet()) {
                meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            if (this.hideEnchantments) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            this.item.setItemMeta(meta);
        }
        this.updateInventory();
    }

    private static enum EditMode {
        NONE,
        NAME,
        LORE,
        CUSTOM_MODEL_DATA,
        NBT_KEY,
        NBT_VALUE;

    }
}

