/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.RecipeViewerGUI;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.util.MessageUtil;

public class PlayerRecipeListGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;
    private List<CustomRecipe> recipes;
    private int page = 0;
    private static final int RECIPES_PER_PAGE = 45;
    private RecipeFilter currentFilter = RecipeFilter.ALL;

    public PlayerRecipeListGUI(CustomRecipes plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.recipes = this.getFilteredRecipes();
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createGradientMenuTitle("Custom Recipes"));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private List<CustomRecipe> getFilteredRecipes() {
        List<CustomRecipe> allRecipes = new ArrayList<CustomRecipe>(this.plugin.getRecipeManager().getAllRecipes());
        allRecipes = allRecipes.stream().filter(recipe -> this.plugin.getRecipeManager().isRecipeEnabled(recipe.getKey())).collect(Collectors.toList());
        if (this.currentFilter == RecipeFilter.ALL) {
            return allRecipes;
        }
        return allRecipes.stream().filter(recipe -> recipe.getType() == RecipeType.SHAPED || recipe.getType() == RecipeType.SHAPELESS).collect(Collectors.toList());
    }

    private void cycleFilter() {
        this.currentFilter = this.currentFilter.next();
        this.recipes = this.getFilteredRecipes();
        this.page = 0;
        this.updateInventory();
    }

    private void updateInventory() {
        this.inventory.clear();
        if (this.recipes.isEmpty()) {
            ItemStack noRecipes = new ItemStack(Material.BARRIER);
            ItemMeta meta = noRecipes.getItemMeta();
            meta.displayName(Component.text((String)"No Custom Recipes Available", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
            meta.lore(List.of((TextComponent)Component.text((String)"Check back later!", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
            noRecipes.setItemMeta(meta);
            this.inventory.setItem(22, noRecipes);
            this.addNavigationButtons();
            return;
        }
        ItemStack emptySlot = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta emptyMeta = emptySlot.getItemMeta();
        emptyMeta.displayName((Component)Component.empty());
        emptySlot.setItemMeta(emptyMeta);
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, emptySlot);
        }
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, this.recipes.size());
        int slot = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            CustomRecipe recipe = this.recipes.get(i);
            ItemStack item = this.createRecipeItem(recipe);
            this.inventory.setItem(slot++, item);
        }
        this.addNavigationButtons();
        this.addInfoItem();
    }

    private ItemStack createRecipeItem(CustomRecipe recipe) {
        ItemStack item = new ItemStack(recipe.getResultMaterial());
        ItemMeta meta = item.getItemMeta();
        Component displayName = recipe.getName() != null && !recipe.getName().isEmpty() ? MessageUtil.colorize(recipe.getName()).decoration(TextDecoration.BOLD, true).decoration(TextDecoration.ITALIC, false) : ((TextComponent)Component.text((String)MessageUtil.formatMaterialName(recipe.getResultMaterial().name()), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false);
        meta.displayName(displayName);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"\ud83d\udc41 ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)"Click to view recipe", (TextColor)NamedTextColor.GRAY))).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void addNavigationButtons() {
        int maxPages = (int)Math.ceil((double)this.recipes.size() / 45.0);
        ItemStack prevButton = new ItemStack(Material.ARROW);
        ItemMeta prevMeta = prevButton.getItemMeta();
        if (this.page > 0) {
            prevMeta.displayName(Component.text((String)"\u25c0 Previous Page", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            prevMeta.lore(List.of((TextComponent)Component.text((String)("Page " + this.page + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            prevMeta.displayName(Component.text((String)"\u25c0 Previous Page", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
            prevMeta.lore(List.of((TextComponent)Component.text((String)"Already on first page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        prevButton.setItemMeta(prevMeta);
        this.inventory.setItem(48, prevButton);
        ItemStack nextButton = new ItemStack(Material.ARROW);
        ItemMeta nextMeta = nextButton.getItemMeta();
        if (this.page < maxPages - 1) {
            nextMeta.displayName(Component.text((String)"Next Page \u25b6", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            nextMeta.lore(List.of((TextComponent)Component.text((String)("Page " + (this.page + 2) + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            nextMeta.displayName(Component.text((String)"Next Page \u25b6", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
            nextMeta.lore(List.of((TextComponent)Component.text((String)"Already on last page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        nextButton.setItemMeta(nextMeta);
        this.inventory.setItem(50, nextButton);
        ItemStack filterButton = new ItemStack(this.currentFilter.getIcon());
        ItemMeta filterMeta = filterButton.getItemMeta();
        filterMeta.displayName(((TextComponent)Component.text((String)("Filter: " + this.currentFilter.getDisplayName()), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> filterLore = new ArrayList<Object>();
        filterLore.add(Component.empty());
        filterLore.add(Component.text((String)"Click to change filter", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        filterLore.add(Component.empty());
        for (RecipeFilter filter : RecipeFilter.values()) {
            NamedTextColor color = filter == this.currentFilter ? NamedTextColor.GREEN : NamedTextColor.YELLOW;
            filterLore.add(Component.text((String)("  \u2022 " + filter.getDisplayName()), (TextColor)color).decoration(TextDecoration.ITALIC, false));
        }
        filterMeta.lore(filterLore);
        filterButton.setItemMeta(filterMeta);
        this.inventory.setItem(49, filterButton);
    }

    private void addInfoItem() {
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(Component.text((String)"Recipe Information", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> infoLore = new ArrayList<Object>();
        infoLore.add(Component.empty());
        int totalRecipes = this.plugin.getRecipeManager().getAllRecipes().stream().filter(recipe -> this.plugin.getRecipeManager().isRecipeEnabled(recipe.getKey())).collect(Collectors.toList()).size();
        int filteredRecipes = this.recipes.size();
        if (this.currentFilter == RecipeFilter.ALL) {
            infoLore.add(Component.text((String)("Total Recipes: " + totalRecipes), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        } else {
            infoLore.add(Component.text((String)("Showing: " + filteredRecipes + "/" + totalRecipes), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            infoLore.add(Component.text((String)("Filter: " + this.currentFilter.getDisplayName()), (TextColor)this.currentFilter.getColor()).decoration(TextDecoration.ITALIC, false));
        }
        infoLore.add(Component.empty());
        infoLore.add(Component.text((String)"Click recipe to view details", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        meta.lore(infoLore);
        info.setItemMeta(meta);
        this.inventory.setItem(53, info);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int recipeIndex;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 48 && this.page > 0) {
            --this.page;
            this.updateInventory();
            return;
        }
        int maxPages = (int)Math.ceil((double)this.recipes.size() / 45.0);
        if (slot == 50 && this.page < maxPages - 1) {
            ++this.page;
            this.updateInventory();
            return;
        }
        if (slot == 49) {
            this.cycleFilter();
            return;
        }
        if (slot < 45 && (recipeIndex = this.page * 45 + slot) < this.recipes.size()) {
            CustomRecipe recipe = this.recipes.get(recipeIndex);
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
            new RecipeViewerGUI(this.plugin, this.player, recipe, this).open();
        }
    }

    public void reopen() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.player.openInventory(this.inventory);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }

    public static enum RecipeFilter {
        ALL("All Stations", Material.CHEST, NamedTextColor.WHITE),
        CRAFTING_TABLE("Crafting Table", Material.CRAFTING_TABLE, NamedTextColor.GREEN);

        private final String displayName;
        private final Material icon;
        private final NamedTextColor color;

        private RecipeFilter(String displayName, Material icon, NamedTextColor color) {
            this.displayName = displayName;
            this.icon = icon;
            this.color = color;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Material getIcon() {
            return this.icon;
        }

        public NamedTextColor getColor() {
            return this.color;
        }

        public RecipeFilter next() {
            RecipeFilter[] values = RecipeFilter.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

