/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.JsonRecipeFileManager;
import org.hikarii.customrecipes.gui.ItemEditorGUI;
import org.hikarii.customrecipes.gui.RecipeEditorGUI;
import org.hikarii.customrecipes.gui.StationSelectorGUI;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.ShapedRecipeData;
import org.hikarii.customrecipes.recipe.data.ShapelessRecipeData;
import org.hikarii.customrecipes.util.ItemStackSerializer;
import org.hikarii.customrecipes.util.MessageUtil;

public class RecipeCreatorGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;
    private RecipeType currentType = RecipeType.SHAPED;
    private ItemStack[] savedGrid = new ItemStack[9];
    private ItemStack[] gridItems = new ItemStack[9];
    private ItemEditorGUI currentEditor = null;
    private ItemStack resultItem = null;
    private static final int[] GRID_SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    private static final int RESULT_SLOT = 25;
    private static final int TYPE_TOGGLE = 45;
    private static final int CREATE_BUTTON = 48;
    private static final int CANCEL_BUTTON = 50;
    private static final int EDIT_RESULT_BUTTON = 53;

    public RecipeCreatorGUI(CustomRecipes plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createGradientMenuTitle("Create Custom Recipe"));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addGridItems();
        this.addEqualsSign();
        this.addTypeToggleButton();
        this.addCreateButton();
        this.addCancelButton();
        this.addEditResultButton();
        this.updateResultDisplay();
    }

    private void updateResultDisplay() {
        if (this.resultItem != null && this.resultItem.getType() != Material.AIR) {
            ItemStack display = this.resultItem.clone();
            ItemMeta meta = display.getItemMeta();
            if (meta != null) {
                ArrayList originalLore = this.resultItem.hasItemMeta() && this.resultItem.getItemMeta().hasLore() && this.resultItem.getItemMeta().lore() != null ? new ArrayList(this.resultItem.getItemMeta().lore()) : new ArrayList();
                ArrayList<Object> displayLore = new ArrayList<Object>(originalLore);
                displayLore.add(Component.empty());
                displayLore.add(Component.text((String)("Amount: " + display.getAmount()), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
                displayLore.add(Component.empty());
                displayLore.add(Component.text((String)"\u00bb Left Click to add", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, true));
                displayLore.add(Component.text((String)"\u00bb Right Click to remove", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
                meta.lore(displayLore);
                display.setItemMeta(meta);
            }
            this.inventory.setItem(25, display);
        } else {
            this.inventory.setItem(25, null);
        }
    }

    private void addGridItems() {
        for (int i = 0; i < 9; ++i) {
            if (this.gridItems[i] == null || this.gridItems[i].getType() == Material.AIR) continue;
            ItemStack display = this.gridItems[i].clone();
            ItemMeta meta = display.getItemMeta();
            if (meta != null) {
                Damageable damageable;
                ArrayList<Object> lore = meta.hasLore() && meta.lore() != null ? new ArrayList<Object>(meta.lore()) : new ArrayList<Object>();
                lore.add(Component.empty());
                lore.add(Component.text((String)("Amount: " + display.getAmount()), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
                if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
                    short maxDurability = display.getType().getMaxDurability();
                    int currentDurability = maxDurability - damageable.getDamage();
                    lore.add(Component.text((String)("Durability: " + currentDurability + "/" + maxDurability), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
                }
                lore.add(Component.empty());
                lore.add(Component.text((String)"\u00bb Left Click to add", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, true));
                lore.add(Component.text((String)"\u00bb Right Click to remove", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
                meta.lore(lore);
                display.setItemMeta(meta);
            }
            this.inventory.setItem(GRID_SLOTS[i], display);
        }
    }

    private void handleCreateRecipe() {
        block18: {
            boolean hasIngredient = false;
            for (int i = 0; i < 9; ++i) {
                if (this.gridItems[i] == null || this.gridItems[i].getType() == Material.AIR) continue;
                hasIngredient = true;
                break;
            }
            if (!hasIngredient) {
                MessageUtil.sendError((CommandSender)this.player, "Please place at least one ingredient in the grid!");
                return;
            }
            if (this.resultItem == null || this.resultItem.getType() == Material.AIR) {
                MessageUtil.sendError((CommandSender)this.player, "Please place a result item!");
                return;
            }
            ItemStack result = this.resultItem.clone();
            String recipeKey = this.generateRecipeKey(result.getType());
            try {
                ShapedRecipeData recipeData = null;
                ShapelessRecipeData shapelessData = null;
                if (this.currentType == RecipeType.SHAPED) {
                    ArrayList<ItemStack> exactItems = new ArrayList<ItemStack>();
                    ArrayList<String> patternList = new ArrayList<String>();
                    for (int row = 0; row < 3; ++row) {
                        StringBuilder rowBuilder = new StringBuilder();
                        for (int col = 0; col < 3; ++col) {
                            int index = row * 3 + col;
                            ItemStack item = this.gridItems[index];
                            if (item == null || item.getType() == Material.AIR) {
                                rowBuilder.append("AIR ");
                                exactItems.add(null);
                                continue;
                            }
                            rowBuilder.append(item.getType().name());
                            if (item.getAmount() > 1) {
                                rowBuilder.append(":").append(item.getAmount());
                            }
                            rowBuilder.append(" ");
                            boolean shouldSaveExact = false;
                            if (item.hasItemMeta()) {
                                Damageable damageable;
                                EnchantmentStorageMeta bookMeta;
                                ItemMeta meta = item.getItemMeta();
                                if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta && (bookMeta = (EnchantmentStorageMeta)meta).hasStoredEnchants()) {
                                    shouldSaveExact = true;
                                    this.plugin.getLogger().info("DEBUG handleCreateRecipe[" + index + "]: ENCHANTED_BOOK with StoredEnchants: " + String.valueOf(bookMeta.getStoredEnchants()));
                                }
                                if (meta.hasEnchants()) {
                                    shouldSaveExact = true;
                                }
                                if (!meta.getPersistentDataContainer().getKeys().isEmpty()) {
                                    shouldSaveExact = true;
                                }
                                if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage() && damageable.getDamage() > 0) {
                                    shouldSaveExact = true;
                                }
                            }
                            if (shouldSaveExact) {
                                exactItems.add(item.clone());
                                this.plugin.getLogger().info("DEBUG handleCreateRecipe[" + index + "]: Saving exactItem: " + String.valueOf(item.getType()));
                                continue;
                            }
                            exactItems.add(null);
                        }
                        patternList.add(rowBuilder.toString().trim());
                    }
                    recipeData = ShapedRecipeData.fromConfigList(patternList, exactItems);
                } else {
                    shapelessData = ShapelessRecipeData.fromGridItems(this.gridItems);
                }
                CustomRecipe newRecipe = new CustomRecipe(recipeKey, null, new ArrayList<String>(), this.currentType, recipeData, shapelessData, result.clone(), false, new ArrayList<PotionEffect>());
                this.saveRecipeToConfig(recipeKey, recipeData, shapelessData, result);
                List enabledRecipes = this.plugin.getConfig().getStringList("enabled-recipes");
                if (!enabledRecipes.contains(recipeKey)) {
                    enabledRecipes.add(recipeKey);
                    this.plugin.getConfig().set("enabled-recipes", (Object)enabledRecipes);
                    this.plugin.saveConfig();
                    this.plugin.reloadConfig();
                }
                this.plugin.getRecipeManager().registerSingleRecipe(newRecipe);
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Created recipe: <white>" + recipeKey);
                this.player.closeInventory();
                new RecipeEditorGUI(this.plugin, this.player, newRecipe).open();
            }
            catch (Exception e) {
                MessageUtil.sendError((CommandSender)this.player, "Failed to create recipe: " + e.getMessage());
                this.plugin.getLogger().warning("Recipe creation failed: " + e.getMessage());
                if (!this.plugin.isDebugMode()) break block18;
                e.printStackTrace();
            }
        }
    }

    private void saveRecipeToConfig(String recipeKey, ShapedRecipeData shapedData, ShapelessRecipeData shapelessData, ItemStack result) {
        try {
            ItemMeta resultMeta;
            HashMap<String, Object> recipeData = new HashMap<String, Object>();
            if (this.currentType == RecipeType.SHAPELESS) {
                recipeData.put("type", this.currentType.name());
            }
            if (this.currentType == RecipeType.SHAPED) {
                ArrayList<String> patternList = new ArrayList<String>();
                for (int row = 0; row < 3; ++row) {
                    StringBuilder rowBuilder = new StringBuilder();
                    for (int col = 0; col < 3; ++col) {
                        int index = row * 3 + col;
                        ItemStack item = this.gridItems[index];
                        if (item == null || item.getType() == Material.AIR) {
                            rowBuilder.append("AIR ");
                            continue;
                        }
                        rowBuilder.append(item.getType().name());
                        if (item.getAmount() > 1) {
                            rowBuilder.append(":").append(item.getAmount());
                        }
                        rowBuilder.append(" ");
                    }
                    patternList.add(rowBuilder.toString().trim());
                }
                recipeData.put("recipe", patternList);
                ArrayList<ItemStack> exactItemsToSave = new ArrayList<ItemStack>();
                boolean hasExactItems = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack item = this.gridItems[i];
                    boolean shouldSaveExact = false;
                    if (item != null && item.hasItemMeta()) {
                        EnchantmentStorageMeta bookMeta;
                        Damageable damageable;
                        ItemMeta meta = item.getItemMeta();
                        if (meta.hasEnchants()) {
                            shouldSaveExact = true;
                        }
                        if (!meta.getPersistentDataContainer().getKeys().isEmpty()) {
                            shouldSaveExact = true;
                        }
                        if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage() && damageable.getDamage() > 0) {
                            shouldSaveExact = true;
                        }
                        if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta && (bookMeta = (EnchantmentStorageMeta)meta).hasStoredEnchants()) {
                            shouldSaveExact = true;
                        }
                    }
                    if (shouldSaveExact) {
                        exactItemsToSave.add(item.clone());
                        hasExactItems = true;
                        continue;
                    }
                    exactItemsToSave.add(null);
                }
                if (hasExactItems) {
                    ArrayList<String> serializedItems = new ArrayList<String>();
                    for (ItemStack exactItem : exactItemsToSave) {
                        if (exactItem != null) {
                            serializedItems.add(ItemStackSerializer.toBase64(exactItem));
                            continue;
                        }
                        serializedItems.add(null);
                    }
                    recipeData.put("exact-ingredients", serializedItems);
                }
            } else {
                recipeData.put("ingredients", shapelessData.toConfigList());
            }
            Map<String, Object> resultData = ItemStackSerializer.toMap(result);
            recipeData.put("result", resultData);
            recipeData.put("material", result.getType().name());
            recipeData.put("amount", result.getAmount());
            if (result.hasItemMeta() && ((resultMeta = result.getItemMeta()).hasDisplayName() || resultMeta.hasLore() || resultMeta.hasEnchants() || !resultMeta.getPersistentDataContainer().getKeys().isEmpty())) {
                recipeData.put("result-full", ItemStackSerializer.toMap(result));
            }
            recipeData.put("hidden", false);
            ItemMeta meta = result.getItemMeta();
            if (meta != null) {
                String name;
                if (meta.hasDisplayName() && (name = PlainTextComponentSerializer.plainText().serialize(meta.displayName())) != null && !name.isEmpty()) {
                    recipeData.put("name", name);
                }
                if (meta.hasLore() && meta.lore() != null) {
                    ArrayList<String> loreStrings = new ArrayList<String>();
                    for (Component line : meta.lore()) {
                        String loreText = PlainTextComponentSerializer.plainText().serialize(line);
                        if (loreText == null || loreText.isEmpty()) continue;
                        loreStrings.add(loreText);
                    }
                    if (!loreStrings.isEmpty()) {
                        recipeData.put("description", loreStrings);
                    }
                }
            }
            this.plugin.getConfigManager().getRecipeFileManager().saveRecipe(recipeKey, recipeData);
            JsonRecipeFileManager jsonManager = new JsonRecipeFileManager(this.plugin);
            jsonManager.saveRecipeJson(recipeKey, recipeData);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save recipe: " + e.getMessage());
            MessageUtil.sendError((CommandSender)this.player, "Failed to save recipe file!");
        }
    }

    private void fillBorders() {
        ItemStack borderPane = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
        for (int slot : GRID_SLOTS) {
            this.inventory.setItem(slot, null);
        }
        this.inventory.setItem(25, null);
    }

    private void addEqualsSign() {
        ItemStack equals = new ItemStack(Material.ORANGE_STAINED_GLASS_PANE);
        ItemMeta meta = equals.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"=", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Place ingredients in the", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"3x3 grid on the left", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"Place result item", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"on the right \u2192", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        equals.setItemMeta(meta);
        this.inventory.setItem(23, equals);
    }

    private void addTypeToggleButton() {
        boolean isShaped = this.currentType == RecipeType.SHAPED;
        ItemStack toggle = new ItemStack(isShaped ? Material.CRAFTING_TABLE : Material.CHEST);
        ItemMeta meta = toggle.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)(isShaped ? "Shaped Recipe" : "Shapeless Recipe"), (TextColor)(isShaped ? NamedTextColor.AQUA : NamedTextColor.LIGHT_PURPLE)).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (isShaped) {
            lore.add(Component.text((String)"Position matters!", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"Items must be placed", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"in exact positions.", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        } else {
            lore.add(Component.text((String)"Position doesn't matter!", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"Items can be placed", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"in any order.", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        toggle.setItemMeta(meta);
        this.inventory.setItem(45, toggle);
    }

    private void addCreateButton() {
        ItemStack create = new ItemStack(Material.LIME_WOOL);
        ItemMeta meta = create.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Create Recipe", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Click to create this", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"custom recipe!", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"\u00bb Left Click", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true)));
        create.setItemMeta(meta);
        this.inventory.setItem(48, create);
    }

    private void addCancelButton() {
        ItemStack cancel = new ItemStack(Material.RED_WOOL);
        ItemMeta meta = cancel.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Cancel", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Return to main menu", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"\u00bb Click to cancel", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true)));
        cancel.setItemMeta(meta);
        this.inventory.setItem(50, cancel);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player dragPlayer;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        Object object = event.getWhoClicked();
        if (!(object instanceof Player) || !(dragPlayer = (Player)object).equals((Object)this.player)) {
            return;
        }
        object = event.getRawSlots().iterator();
        while (object.hasNext()) {
            int slot = (Integer)object.next();
            if (slot >= this.inventory.getSize()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        boolean isGridSlot = false;
        int gridIndex = -1;
        for (int i = 0; i < GRID_SLOTS.length; ++i) {
            if (slot != GRID_SLOTS[i]) continue;
            isGridSlot = true;
            gridIndex = i;
            break;
        }
        if (isGridSlot) {
            ItemStack existing;
            if (event.getClickedInventory() != this.inventory) {
                return;
            }
            event.setCancelled(true);
            if (clickType.isLeftClick()) {
                ItemStack cursor = event.getCursor();
                if (cursor != null && cursor.getType() != Material.AIR) {
                    ItemStack existing2 = this.gridItems[gridIndex];
                    int maxStack = cursor.getType().getMaxStackSize();
                    if (existing2 == null || existing2.getType() == Material.AIR) {
                        this.gridItems[gridIndex] = cursor.clone();
                        this.gridItems[gridIndex].setAmount(1);
                    } else if (existing2.getType() == cursor.getType()) {
                        existing2.setAmount(Math.min(existing2.getAmount() + 1, maxStack));
                    } else {
                        this.gridItems[gridIndex] = cursor.clone();
                        this.gridItems[gridIndex].setAmount(1);
                    }
                } else {
                    ItemStack existing3 = this.gridItems[gridIndex];
                    if (existing3 != null && existing3.getType() != Material.AIR) {
                        int maxStack = existing3.getType().getMaxStackSize();
                        existing3.setAmount(Math.min(existing3.getAmount() + 1, maxStack));
                    }
                }
                this.updateInventory();
            } else if (clickType.isRightClick() && (existing = this.gridItems[gridIndex]) != null && existing.getType() != Material.AIR) {
                if (existing.getAmount() > 1) {
                    existing.setAmount(existing.getAmount() - 1);
                } else {
                    this.gridItems[gridIndex] = null;
                }
                this.updateInventory();
            }
            return;
        }
        if (slot == 25) {
            if (event.getClickedInventory() != this.inventory) {
                return;
            }
            event.setCancelled(true);
            if (clickType.isLeftClick()) {
                ItemStack cursor = event.getCursor();
                if (cursor != null && cursor.getType() != Material.AIR) {
                    if (this.resultItem == null || this.resultItem.getType() == Material.AIR) {
                        this.resultItem = cursor.clone();
                        this.resultItem.setAmount(1);
                    } else if (this.resultItem.isSimilar(cursor)) {
                        int newAmount = Math.min(this.resultItem.getAmount() + 1, cursor.getType().getMaxStackSize());
                        this.resultItem.setAmount(newAmount);
                    } else {
                        this.resultItem = cursor.clone();
                        this.resultItem.setAmount(1);
                    }
                } else if (this.resultItem != null && this.resultItem.getType() != Material.AIR) {
                    int newAmount = Math.min(this.resultItem.getAmount() + 1, this.resultItem.getType().getMaxStackSize());
                    this.resultItem.setAmount(newAmount);
                }
            } else if (clickType.isRightClick() && this.resultItem != null && this.resultItem.getType() != Material.AIR) {
                if (this.resultItem.getAmount() > 1) {
                    this.resultItem.setAmount(this.resultItem.getAmount() - 1);
                } else {
                    this.resultItem = null;
                }
            }
            this.updateResultDisplay();
            return;
        }
        if (event.getClickedInventory() != this.inventory) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (slot == 45) {
            this.currentType = this.currentType == RecipeType.SHAPED ? RecipeType.SHAPELESS : RecipeType.SHAPED;
            this.updateInventory();
            return;
        }
        if (slot == 48) {
            this.handleCreateRecipe();
            return;
        }
        if (slot == 50) {
            new StationSelectorGUI(this.plugin, this.player).open();
            return;
        }
        if (slot == 53) {
            if (this.resultItem == null || this.resultItem.getType() == Material.AIR) {
                MessageUtil.sendError((CommandSender)this.player, "Please place a result item first!");
                return;
            }
            ItemStack[] tempSavedGrid = new ItemStack[9];
            for (int i = 0; i < 9; ++i) {
                tempSavedGrid[i] = this.gridItems[i] != null ? this.gridItems[i].clone() : null;
            }
            RecipeType tempSavedType = this.currentType;
            ItemStack tempResult = this.resultItem.clone();
            this.currentEditor = new ItemEditorGUI(this.plugin, this.player, tempResult, editedItem -> {
                RecipeCreatorGUI newGUI = new RecipeCreatorGUI(this.plugin, this.player);
                newGUI.currentType = tempSavedType;
                for (int i = 0; i < 9; ++i) {
                    newGUI.gridItems[i] = tempSavedGrid[i] != null ? tempSavedGrid[i].clone() : null;
                }
                newGUI.resultItem = editedItem != null ? editedItem.clone() : tempResult.clone();
                newGUI.updateInventory();
                newGUI.open();
            });
            this.currentEditor.open();
            return;
        }
    }

    private void addEditResultButton() {
        ItemStack button = new ItemStack(Material.ANVIL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Edit Result Item", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Customize the result", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"item's name and lore", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to edit", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(53, button);
    }

    private String generateRecipeKey(Material material) {
        String baseName = this.formatMaterialName(material.name());
        Object key = baseName;
        int counter = 1;
        while (this.plugin.getRecipeManager().getRecipe((String)key) != null) {
            key = baseName + counter;
            ++counter;
        }
        return key;
    }

    private String formatMaterialName(String materialName) {
        String[] parts = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            result.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return result.toString();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

