/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.ItemEditorGUI;
import org.hikarii.customrecipes.gui.RecipeListGUI;
import org.hikarii.customrecipes.gui.WorldSettingsGUI;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.RecipeIngredient;
import org.hikarii.customrecipes.util.ItemStackSerializer;
import org.hikarii.customrecipes.util.MessageUtil;

public class RecipeEditorGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final CustomRecipe recipe;
    private final Inventory inventory;
    private boolean deleteConfirmation = false;
    private static final int EDIT_RECIPE_BUTTON = 46;
    private static final int EDIT_RESULT_SLOT = 25;
    private static final int GIVE_ITEM_BUTTON = 52;
    private boolean editMode = false;
    private ItemStack[] editGridItems = new ItemStack[9];
    private ItemStack editResultItem = null;
    private static final int[] GRID_SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};

    public RecipeEditorGUI(CustomRecipes plugin, Player player, CustomRecipe recipe) {
        this.plugin = plugin;
        this.player = player;
        this.recipe = recipe;
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createGradientMenuTitle("Recipe Editor"));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        if (this.editMode) {
            this.addEditableGrid();
            this.addEqualsSign();
            this.addEditableResultItem();
            this.addSaveEditButton();
            this.addCancelEditButton();
        } else {
            this.addCraftingGrid();
            this.addEqualsSign();
            this.addResultItem();
            this.addInfoBook();
            this.addHiddenToggleButton();
            this.addToggleButton();
            this.addWorldSettingsButton();
            this.addEditRecipeButton();
            this.addEditItemButton();
            this.addDeleteButton();
            this.addBackButton();
            this.addGiveItemButton();
        }
    }

    private void addEditableResultItem() {
        if (this.editResultItem != null && this.editResultItem.getType() != Material.AIR) {
            ItemStack display = this.editResultItem.clone();
            ItemMeta meta = display.getItemMeta();
            if (meta != null) {
                ArrayList<Object> lore = meta.hasLore() && meta.lore() != null ? new ArrayList<Object>(meta.lore()) : new ArrayList<Object>();
                lore.add(Component.empty());
                lore.add(Component.text((String)("Amount: " + display.getAmount()), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
                lore.add(Component.empty());
                lore.add(Component.text((String)"\u00bb Left Click to add", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, true));
                lore.add(Component.text((String)"\u00bb Right Click to remove", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
                meta.lore(lore);
                display.setItemMeta(meta);
            }
            this.inventory.setItem(25, display);
        } else {
            this.inventory.setItem(25, null);
        }
    }

    private void addEditableGrid() {
        for (int i = 0; i < 9; ++i) {
            if (this.editGridItems[i] != null && this.editGridItems[i].getType() != Material.AIR) {
                ItemStack display = this.editGridItems[i].clone();
                ItemMeta meta = display.getItemMeta();
                if (meta != null) {
                    Damageable damageable;
                    ArrayList originalLore = meta.hasLore() && meta.lore() != null ? new ArrayList(meta.lore()) : new ArrayList();
                    ArrayList<Object> displayLore = new ArrayList<Object>(originalLore);
                    displayLore.add(Component.empty());
                    displayLore.add(Component.text((String)("Amount: " + display.getAmount()), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
                    if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
                        short maxDurability = display.getType().getMaxDurability();
                        int currentDurability = maxDurability - damageable.getDamage();
                        displayLore.add(Component.text((String)("Durability: " + currentDurability + "/" + maxDurability), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
                    }
                    displayLore.add(Component.empty());
                    displayLore.add(Component.text((String)"\u00bb Left Click to add", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, true));
                    displayLore.add(Component.text((String)"\u00bb Right Click to remove", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
                    meta.lore(displayLore);
                    display.setItemMeta(meta);
                }
                this.inventory.setItem(GRID_SLOTS[i], display);
                continue;
            }
            this.inventory.setItem(GRID_SLOTS[i], null);
        }
    }

    private void addEditRecipeButton() {
        ItemStack button = new ItemStack(Material.CRAFTING_TABLE);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Edit Recipe Pattern", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Modify the crafting", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"pattern of this recipe", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to edit", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(46, button);
    }

    private void addSaveEditButton() {
        ItemStack button = new ItemStack(Material.LIME_WOOL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Save Recipe Changes", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Apply changes to recipe", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to save", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(45, button);
    }

    private void addCancelEditButton() {
        ItemStack button = new ItemStack(Material.RED_WOOL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Cancel Editing", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Discard changes", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to cancel", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(46, button);
    }

    private void initializeEditGrid() {
        block3: {
            block4: {
                Arrays.fill(this.editGridItems, null);
                this.editResultItem = this.recipe.getResultItem().clone();
                if (this.recipe.getType() != RecipeType.SHAPED) break block4;
                List<RecipeIngredient> ingredients = this.recipe.getRecipeData().ingredients();
                for (int i = 0; i < Math.min(ingredients.size(), 9); ++i) {
                    RecipeIngredient ingredient = ingredients.get(i);
                    if (ingredient.material() == Material.AIR) continue;
                    this.editGridItems[i] = ingredient.hasExactItem() ? ingredient.getExactItem().clone() : new ItemStack(ingredient.material(), ingredient.amount());
                }
                break block3;
            }
            if (this.recipe.getType() != RecipeType.SHAPELESS) break block3;
            Map<Material, Integer> ingredients = this.recipe.getShapelessData().ingredients();
            int index = 0;
            for (Map.Entry<Material, Integer> entry : ingredients.entrySet()) {
                if (index < 9) {
                    this.editGridItems[index++] = new ItemStack(entry.getKey(), entry.getValue().intValue());
                    continue;
                }
                break;
            }
        }
    }

    private void saveEditedRecipe() {
        block22: {
            if (this.editResultItem == null || this.editResultItem.getType() == Material.AIR) {
                MessageUtil.sendError((CommandSender)this.player, "Cannot save recipe without a result item!");
                return;
            }
            try {
                ItemMeta resultMeta;
                HashMap<String, Object> recipeData = new HashMap<String, Object>();
                recipeData.put("name", this.recipe.getName());
                recipeData.put("description", this.recipe.getDescription());
                recipeData.put("type", this.recipe.getType().name());
                recipeData.put("hidden", this.recipe.isHidden());
                if (this.recipe.getType() == RecipeType.SHAPED) {
                    ArrayList<String> pattern = new ArrayList<String>();
                    ArrayList<ItemStack> exactItems = new ArrayList<ItemStack>();
                    for (int row = 0; row < 3; ++row) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int col = 0; col < 3; ++col) {
                            int index = row * 3 + col;
                            ItemStack item = this.editGridItems[index];
                            if (item == null || item.getType() == Material.AIR) {
                                stringBuilder.append("AIR ");
                                exactItems.add(null);
                                continue;
                            }
                            stringBuilder.append(item.getType().name());
                            if (item.getAmount() > 1) {
                                stringBuilder.append(":").append(item.getAmount());
                            }
                            stringBuilder.append(" ");
                            boolean shouldSaveExact = false;
                            if (item.hasItemMeta()) {
                                Damageable damageable;
                                EnchantmentStorageMeta bookMeta;
                                ItemMeta meta = item.getItemMeta();
                                if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta && (bookMeta = (EnchantmentStorageMeta)meta).hasStoredEnchants()) {
                                    shouldSaveExact = true;
                                }
                                if (meta.hasEnchants()) {
                                    shouldSaveExact = true;
                                }
                                if (!meta.getPersistentDataContainer().getKeys().isEmpty()) {
                                    shouldSaveExact = true;
                                }
                                if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage() && damageable.getDamage() > 0) {
                                    shouldSaveExact = true;
                                }
                            }
                            if (shouldSaveExact) {
                                exactItems.add(item.clone());
                                continue;
                            }
                            exactItems.add(null);
                        }
                        pattern.add(stringBuilder.toString().trim());
                    }
                    recipeData.put("recipe", pattern);
                    ArrayList<String> exactItemsData = new ArrayList<String>();
                    for (ItemStack exactItem : exactItems) {
                        if (exactItem != null) {
                            exactItemsData.add(ItemStackSerializer.toBase64(exactItem));
                            continue;
                        }
                        exactItemsData.add(null);
                    }
                    if (exactItemsData.stream().anyMatch(Objects::nonNull)) {
                        recipeData.put("exact-ingredients", exactItemsData);
                    }
                } else {
                    ArrayList<CallSite> ingredients = new ArrayList<CallSite>();
                    HashMap<Material, Integer> counts = new HashMap<Material, Integer>();
                    for (ItemStack item : this.editGridItems) {
                        if (item == null || item.getType() == Material.AIR) continue;
                        counts.merge(item.getType(), item.getAmount(), Integer::sum);
                    }
                    for (Map.Entry entry : counts.entrySet()) {
                        ingredients.add((CallSite)((Object)(((Material)entry.getKey()).name() + ":" + String.valueOf(entry.getValue()))));
                    }
                    recipeData.put("ingredients", ingredients);
                }
                Map<String, Object> resultData = ItemStackSerializer.toMap(this.editResultItem);
                recipeData.put("result", resultData);
                recipeData.put("material", this.editResultItem.getType().name());
                recipeData.put("amount", this.editResultItem.getAmount());
                if (this.editResultItem.hasItemMeta() && ((resultMeta = this.editResultItem.getItemMeta()).hasDisplayName() || resultMeta.hasLore() || resultMeta.hasEnchants() || !resultMeta.getPersistentDataContainer().getKeys().isEmpty())) {
                    recipeData.put("result-full", ItemStackSerializer.toMap(this.editResultItem));
                }
                this.plugin.getConfigManager().getRecipeFileManager().saveRecipe(this.recipe.getKey(), recipeData);
                this.plugin.loadConfiguration();
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Recipe pattern updated successfully!");
                this.editMode = false;
                this.editResultItem = null;
                CustomRecipe updatedRecipe = this.plugin.getRecipeManager().getRecipe(this.recipe.getKey());
                if (updatedRecipe != null) {
                    new RecipeEditorGUI(this.plugin, this.player, updatedRecipe).open();
                }
            }
            catch (Exception e) {
                MessageUtil.sendError((CommandSender)this.player, "Failed to save recipe: " + e.getMessage());
                this.plugin.getLogger().severe("Failed to save edited recipe: " + e.getMessage());
                if (!this.plugin.isDebugMode()) break block22;
                e.printStackTrace();
            }
        }
    }

    private void fillBorders() {
        int[] gridSlots;
        ItemStack borderPane = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
        for (int slot : gridSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30}) {
            this.inventory.setItem(slot, null);
        }
        this.inventory.setItem(25, null);
    }

    private void addEqualsSign() {
        ItemStack equals = new ItemStack(Material.ORANGE_STAINED_GLASS_PANE);
        ItemMeta meta = equals.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"=", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Place ingredients in the", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"3x3 grid on the left", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"Place result item", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"on the right \u2192", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        equals.setItemMeta(meta);
        this.inventory.setItem(23, equals);
    }

    private void addCraftingGrid() {
        if (this.recipe.getType() == RecipeType.SHAPED) {
            this.addShapedCraftingGrid();
        } else if (this.recipe.getType() == RecipeType.SHAPELESS) {
            this.addShapelessCraftingGrid();
        }
    }

    private void addShapedCraftingGrid() {
        List<RecipeIngredient> ingredients = this.recipe.getRecipeData().ingredients();
        int[] gridSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
        for (int i = 0; i < ingredients.size() && i < gridSlots.length; ++i) {
            Damageable damageable;
            RecipeIngredient ingredient = ingredients.get(i);
            if (ingredient.material() == Material.AIR) continue;
            ItemStack item = ingredient.hasExactItem() ? ingredient.getExactItem().clone() : new ItemStack(ingredient.material(), ingredient.amount());
            ItemMeta meta = item.getItemMeta();
            if (meta != null && meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
                short maxDurability = item.getType().getMaxDurability();
                int currentDurability = maxDurability - damageable.getDamage();
                ArrayList<Object> lore = meta.hasLore() && meta.lore() != null ? new ArrayList<Object>(meta.lore()) : new ArrayList<Object>();
                lore.add(Component.empty());
                lore.add(Component.text((String)("Durability: " + currentDurability + "/" + maxDurability), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
                meta.lore(lore);
                item.setItemMeta(meta);
            }
            this.inventory.setItem(gridSlots[i], item);
        }
    }

    private void addShapelessCraftingGrid() {
        Map<Material, Integer> ingredients = this.recipe.getShapelessData().ingredients();
        int[] gridSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
        int slotIndex = 0;
        for (Map.Entry<Material, Integer> entry : ingredients.entrySet()) {
            Material mat = entry.getKey();
            int count = entry.getValue();
            for (int i = 0; i < count && slotIndex < gridSlots.length; ++slotIndex, ++i) {
                ItemStack item = new ItemStack(mat);
                ItemMeta meta = item.getItemMeta();
                meta.displayName(Component.text((String)MessageUtil.formatMaterialName(mat.name()), (TextColor)NamedTextColor.WHITE).decoration(TextDecoration.ITALIC, false));
                ArrayList<Component> lore = new ArrayList<Component>();
                lore.add(Component.text((String)"Shapeless ingredient", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
                lore.add(Component.text((String)"Position doesn't matter", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
                meta.lore(lore);
                item.setItemMeta(meta);
                this.inventory.setItem(gridSlots[slotIndex], item);
            }
        }
    }

    private void addResultItem() {
        ItemStack result = this.recipe.getResultItem().clone();
        this.inventory.setItem(25, result);
    }

    private void addInfoBook() {
        List<String> disabledWorlds;
        Object container;
        ItemMeta resultMeta;
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(Component.text((String)"Recipe Information", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Key: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)this.recipe.getKey(), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)"Type: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)this.recipe.getType().toString(), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)"Result: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)MessageUtil.formatMaterialName(this.recipe.getResultMaterial().name()), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)"Amount: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(this.recipe.getResultAmount() + "x"), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        if (this.recipe.getName() != null && !this.recipe.getName().isEmpty()) {
            lore.add(Component.text((String)"Name:", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            lore.add(MessageUtil.colorize("  " + this.recipe.getName()).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
        }
        if (this.recipe.getDescription() != null && !this.recipe.getDescription().isEmpty()) {
            lore.add(Component.text((String)"Description:", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
            for (String line : this.recipe.getDescription()) {
                lore.add(MessageUtil.colorize("  " + line).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.empty());
        }
        if ((resultMeta = this.recipe.getResultItem().getItemMeta()) != null && resultMeta.hasCustomModelData()) {
            lore.add(((TextComponent)Component.text((String)"Custom Model Data: ", (TextColor)NamedTextColor.LIGHT_PURPLE).append((Component)Component.text((int)resultMeta.getCustomModelData(), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
        }
        if (resultMeta != null && !(container = resultMeta.getPersistentDataContainer()).getKeys().isEmpty()) {
            lore.add(Component.text((String)"NBT Data:", (TextColor)NamedTextColor.DARK_AQUA).decoration(TextDecoration.ITALIC, false));
            for (NamespacedKey key : container.getKeys()) {
                if (!key.getNamespace().equals(this.plugin.getName().toLowerCase())) continue;
                String value = (String)container.get(key, PersistentDataType.STRING);
                lore.add(Component.text((String)("  \u2022 " + key.getKey() + ": " + value), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.empty());
        }
        if (resultMeta != null && resultMeta.hasEnchants()) {
            lore.add(Component.text((String)"Enchantments:", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.ITALIC, false));
            for (Map.Entry entry : resultMeta.getEnchants().entrySet()) {
                String enchName = ((Enchantment)entry.getKey()).getKey().getKey();
                lore.add(Component.text((String)("  \u2022 " + enchName + " " + String.valueOf(entry.getValue())), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.empty());
        }
        if (!(disabledWorlds = this.plugin.getRecipeWorldManager().getDisabledWorlds(this.recipe.getKey())).isEmpty()) {
            lore.add(Component.text((String)"World Restrictions:", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
            for (String world : disabledWorlds) {
                lore.add(Component.text((String)("  \u2022 " + world), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(lore);
        info.setItemMeta(meta);
        this.inventory.setItem(44, info);
    }

    private void addToggleButton() {
        boolean enabled = this.plugin.getRecipeManager().isRecipeEnabled(this.recipe.getKey());
        Material material = enabled ? Material.LIME_DYE : Material.GRAY_DYE;
        ItemStack toggleButton = new ItemStack(material);
        ItemMeta meta = toggleButton.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)(enabled ? "Enabled" : "Disabled"), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(enabled ? "Active" : "Inactive"), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)(enabled ? "Players can use this recipe" : "Recipe is disabled"), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)("\u00bb Click to " + (enabled ? "disable" : "enable")), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        toggleButton.setItemMeta(meta);
        this.inventory.setItem(48, toggleButton);
    }

    private void addWorldSettingsButton() {
        ItemStack button = new ItemStack(Material.FILLED_MAP);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"World Settings", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        List<String> disabledWorlds = this.plugin.getRecipeWorldManager().getDisabledWorlds(this.recipe.getKey());
        if (disabledWorlds.isEmpty()) {
            lore.add(Component.text((String)"Enabled in all worlds", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false));
        } else {
            lore.add(Component.text((String)"Disabled in:", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
            for (String world : disabledWorlds) {
                lore.add(Component.text((String)("  \u2022 " + world), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            }
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"Configure which worlds", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"this recipe works in", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to configure", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(49, button);
    }

    private void addEditItemButton() {
        ItemStack button = new ItemStack(Material.ANVIL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Edit Result Item", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Customize the result", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"item's properties:", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"\u2022 Name & Lore", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"\u2022 Custom Model Data", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"\u2022 NBT Tags", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"\u2022 Enchantments", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to edit", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(47, button);
    }

    private void addDeleteButton() {
        ItemStack deleteButton;
        if (this.deleteConfirmation) {
            deleteButton = new ItemStack(Material.LIME_WOOL);
            ItemMeta meta = deleteButton.getItemMeta();
            meta.displayName(((TextComponent)Component.text((String)"Confirm Deletion", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(Component.empty());
            lore.add(((TextComponent)Component.text((String)"\u26a0 ARE YOU SURE? \u26a0", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
            lore.add(Component.text((String)"This will permanently delete:", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"\u2022 Recipe from memory", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"\u2022 Recipe files (.yml, .json)", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"\u2022 All recipe data", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
            lore.add(((TextComponent)Component.text((String)"\u00bb Click again to DELETE", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, true));
            lore.add(Component.text((String)"\u00bb Click elsewhere to cancel", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
            meta.lore(lore);
            deleteButton.setItemMeta(meta);
        } else {
            deleteButton = new ItemStack(Material.BARRIER);
            ItemMeta meta = deleteButton.getItemMeta();
            meta.displayName(((TextComponent)Component.text((String)"Delete Recipe", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(Component.empty());
            lore.add(((TextComponent)Component.text((String)"\u26a0 Warning!", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"This will permanently delete", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)"this recipe and its files.", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
            lore.add(Component.text((String)"\u00bb Click to confirm", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
            meta.lore(lore);
            deleteButton.setItemMeta(meta);
        }
        this.inventory.setItem(50, deleteButton);
    }

    private void addHiddenToggleButton() {
        boolean hidden = this.recipe.isHidden();
        Material material = hidden ? Material.ENDER_EYE : Material.ENDER_PEARL;
        ItemStack button = new ItemStack(material);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)(hidden ? "Hidden Recipe" : "Visible Recipe"), (TextColor)(hidden ? NamedTextColor.DARK_PURPLE : NamedTextColor.AQUA)).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(hidden ? "Hidden" : "Visible"), (TextColor)(hidden ? NamedTextColor.DARK_PURPLE : NamedTextColor.GREEN)))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"If hidden, players must craft", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"this recipe once to unlock it.", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(45, button);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(Component.text((String)"\u00ab Back to Main Menu", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        back.setItemMeta(meta);
        this.inventory.setItem(53, back);
    }

    private void addGiveItemButton() {
        ItemStack button = new ItemStack(Material.CHEST);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Get Result Item", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Receive this recipe's", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"result item with all", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"configured properties", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to receive", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(52, button);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player dragPlayer;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        Object object = event.getWhoClicked();
        if (!(object instanceof Player) || !(dragPlayer = (Player)object).equals((Object)this.player)) {
            return;
        }
        object = event.getRawSlots().iterator();
        while (object.hasNext()) {
            int rawSlot = (Integer)object.next();
            if (rawSlot >= this.inventory.getSize()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        if (this.editMode) {
            if (slot == 25) {
                if (event.getClickedInventory() != this.inventory) {
                    return;
                }
                event.setCancelled(true);
                if (clickType.isLeftClick()) {
                    ItemStack cursor = event.getCursor();
                    if (cursor != null && cursor.getType() != Material.AIR) {
                        if (this.editResultItem == null || this.editResultItem.getType() == Material.AIR) {
                            this.editResultItem = cursor.clone();
                            this.editResultItem.setAmount(1);
                        } else if (this.editResultItem.getType() == cursor.getType()) {
                            int newAmount = Math.min(this.editResultItem.getAmount() + 1, cursor.getType().getMaxStackSize());
                            this.editResultItem.setAmount(newAmount);
                        } else {
                            this.editResultItem = cursor.clone();
                            this.editResultItem.setAmount(1);
                        }
                    } else if (this.editResultItem != null && this.editResultItem.getType() != Material.AIR) {
                        int newAmount = Math.min(this.editResultItem.getAmount() + 1, this.editResultItem.getType().getMaxStackSize());
                        this.editResultItem.setAmount(newAmount);
                    }
                    this.updateInventory();
                } else if (clickType.isRightClick() && this.editResultItem != null && this.editResultItem.getType() != Material.AIR) {
                    if (this.editResultItem.getAmount() > 1) {
                        this.editResultItem.setAmount(this.editResultItem.getAmount() - 1);
                    } else {
                        this.editResultItem = null;
                    }
                    this.updateInventory();
                }
                return;
            }
            boolean isGridSlot = false;
            int gridIndex = -1;
            for (int i = 0; i < GRID_SLOTS.length; ++i) {
                if (slot != GRID_SLOTS[i]) continue;
                isGridSlot = true;
                gridIndex = i;
                break;
            }
            if (isGridSlot) {
                ItemStack existing;
                if (event.getClickedInventory() != this.inventory) {
                    return;
                }
                event.setCancelled(true);
                if (clickType.isLeftClick()) {
                    ItemStack cursor = event.getCursor();
                    if (cursor != null && cursor.getType() != Material.AIR) {
                        ItemStack existing2 = this.editGridItems[gridIndex];
                        int maxStack = cursor.getType().getMaxStackSize();
                        if (existing2 == null || existing2.getType() == Material.AIR) {
                            this.editGridItems[gridIndex] = cursor.clone();
                            this.editGridItems[gridIndex].setAmount(1);
                        } else if (existing2.isSimilar(cursor)) {
                            existing2.setAmount(Math.min(existing2.getAmount() + 1, maxStack));
                        } else {
                            this.editGridItems[gridIndex] = cursor.clone();
                            this.editGridItems[gridIndex].setAmount(1);
                        }
                    } else {
                        ItemStack existing3 = this.editGridItems[gridIndex];
                        if (existing3 != null && existing3.getType() != Material.AIR) {
                            int maxStack = existing3.getType().getMaxStackSize();
                            existing3.setAmount(Math.min(existing3.getAmount() + 1, maxStack));
                        }
                    }
                    this.updateInventory();
                } else if (clickType.isRightClick() && (existing = this.editGridItems[gridIndex]) != null && existing.getType() != Material.AIR) {
                    if (existing.getAmount() > 1) {
                        existing.setAmount(existing.getAmount() - 1);
                    } else {
                        this.editGridItems[gridIndex] = null;
                    }
                    this.updateInventory();
                }
                return;
            }
            if (event.getClickedInventory() == this.inventory) {
                event.setCancelled(true);
                if (slot == 45) {
                    this.saveEditedRecipe();
                    return;
                }
                if (slot == 46) {
                    this.editMode = false;
                    this.editResultItem = null;
                    Arrays.fill(this.editGridItems, null);
                    this.updateInventory();
                    return;
                }
            }
            return;
        }
        if (event.getClickedInventory() == this.inventory) {
            event.setCancelled(true);
        }
        if (event.getClickedInventory() != this.inventory) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (slot != 50 && this.deleteConfirmation) {
            this.deleteConfirmation = false;
            this.updateInventory();
        }
        if (!this.player.hasPermission("customrecipes.manage")) {
            MessageUtil.sendError((CommandSender)this.player, "You don't have permission to manage recipes.");
            return;
        }
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (slot == 46) {
            this.editMode = true;
            this.initializeEditGrid();
            this.updateInventory();
            return;
        }
        if (slot == 48) {
            boolean currentlyEnabled = this.plugin.getRecipeManager().isRecipeEnabled(this.recipe.getKey());
            if (currentlyEnabled) {
                this.plugin.getRecipeManager().disableRecipe(this.recipe.getKey());
                this.plugin.getRecipeStateTracker().markRecipeDisabled(this.recipe.getKey());
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Disabled recipe: <white>" + this.recipe.getKey());
            } else {
                this.plugin.getRecipeManager().enableRecipe(this.recipe.getKey());
                this.plugin.getRecipeStateTracker().markRecipeEnabled(this.recipe.getKey());
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Enabled recipe: <white>" + this.recipe.getKey());
            }
            this.updateInventory();
            return;
        }
        if (slot == 49) {
            new WorldSettingsGUI(this.plugin, this.player, this.recipe).open();
            return;
        }
        if (slot == 47) {
            ItemStack resultItem = this.recipe.getResultItem();
            new ItemEditorGUI(this.plugin, this.player, resultItem, editedItem -> {
                CustomRecipe updatedRecipe;
                if (editedItem != null) {
                    ItemEditorGUI editor = ItemEditorGUI.getLastEditor(this.player.getUniqueId());
                    String newName = editor != null ? editor.getCustomName() : null;
                    List<String> newDesc = editor != null ? editor.getCustomLore() : null;
                    this.plugin.getRecipeManager().updateRecipeResult(this.recipe.getKey(), (ItemStack)editedItem, newName, newDesc);
                    MessageUtil.sendAdminSuccess((CommandSender)this.player, "Updated result item for recipe: " + this.recipe.getKey());
                }
                if ((updatedRecipe = this.plugin.getRecipeManager().getRecipe(this.recipe.getKey())) != null) {
                    new RecipeEditorGUI(this.plugin, this.player, updatedRecipe).open();
                }
            }).open();
            return;
        }
        if (slot == 50) {
            if (!this.deleteConfirmation) {
                this.deleteConfirmation = true;
                this.updateInventory();
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Click again to confirm deletion!");
                return;
            }
            String recipeKey = this.recipe.getKey();
            if (this.plugin.getRecipeManager().deleteRecipePermanently(recipeKey)) {
                this.plugin.getConfigManager().removeEnabledRecipe(recipeKey);
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Permanently deleted recipe: <white>" + recipeKey);
                this.player.closeInventory();
                new RecipeListGUI(this.plugin, this.player).open();
            } else {
                MessageUtil.sendError((CommandSender)this.player, "Failed to delete recipe.");
                this.deleteConfirmation = false;
                this.updateInventory();
            }
            return;
        }
        if (slot == 45) {
            boolean newValue = !this.recipe.isHidden();
            String recipeKey = this.recipe.getKey();
            try {
                File recipeFile = new File(this.plugin.getConfigManager().getRecipeFileManager().getRecipesFolder(), recipeKey + ".yml");
                if (recipeFile.exists()) {
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipeFile);
                    config.set("hidden", (Object)newValue);
                    config.save(recipeFile);
                    this.plugin.getRecipeManager().unregisterAll();
                    this.plugin.getConfigManager().loadRecipes();
                    this.plugin.getRecipeManager().registerAllRecipes();
                    MessageUtil.sendAdminSuccess((CommandSender)this.player, "Recipe is now " + (newValue ? "<dark_purple>hidden" : "<aqua>visible"));
                    CustomRecipe updatedRecipe = this.plugin.getRecipeManager().getRecipe(recipeKey);
                    if (updatedRecipe != null) {
                        new RecipeEditorGUI(this.plugin, this.player, updatedRecipe).open();
                    } else {
                        new RecipeListGUI(this.plugin, this.player).open();
                    }
                } else {
                    MessageUtil.sendError((CommandSender)this.player, "Recipe file not found.");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to toggle hidden state: " + e.getMessage());
                MessageUtil.sendError((CommandSender)this.player, "Failed to update recipe.");
            }
            return;
        }
        if (slot == 53) {
            new RecipeListGUI(this.plugin, this.player).open();
            return;
        }
        if (slot == 52) {
            ItemStack resultItem = this.recipe.getResultItem().clone();
            if (this.player.getInventory().firstEmpty() != -1) {
                this.player.getInventory().addItem(new ItemStack[]{resultItem});
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Received result item: " + this.recipe.getKey());
                try {
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.0f);
                }
                catch (Exception exception) {}
            } else {
                MessageUtil.sendError((CommandSender)this.player, "Your inventory is full!");
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

