/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.ItemEditorGUI;
import org.hikarii.customrecipes.gui.RecipeEditorGUI;
import org.hikarii.customrecipes.gui.SettingsGUI;
import org.hikarii.customrecipes.gui.StationSelectorGUI;
import org.hikarii.customrecipes.gui.VanillaRecipesGUI;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.util.MessageUtil;

public class RecipeListGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;
    private List<CustomRecipe> recipes;
    private int page = 0;
    private static final int RECIPES_PER_PAGE = 45;
    private RecipeFilter currentFilter = RecipeFilter.ALL;

    public RecipeListGUI(CustomRecipes plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.recipes = this.getFilteredRecipes();
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createGradientMenuTitle("Custom Recipes Menu"));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private List<CustomRecipe> getFilteredRecipes() {
        ArrayList<CustomRecipe> allRecipes = new ArrayList<CustomRecipe>(this.plugin.getRecipeManager().getAllRecipes());
        if (this.currentFilter == RecipeFilter.ALL) {
            return allRecipes;
        }
        return allRecipes.stream().filter(recipe -> {
            switch (this.currentFilter.ordinal()) {
                case 1: {
                    return recipe.getType() == RecipeType.SHAPED || recipe.getType() == RecipeType.SHAPELESS;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    private void cycleFilter() {
        this.currentFilter = this.currentFilter.next();
        this.recipes = this.getFilteredRecipes();
        this.page = 0;
        this.updateInventory();
    }

    private void updateInventory() {
        this.inventory.clear();
        if (this.recipes.isEmpty()) {
            ItemStack noRecipes = new ItemStack(Material.BARRIER);
            ItemMeta meta = noRecipes.getItemMeta();
            meta.displayName(Component.text((String)"Coming soon", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
            meta.lore(List.of((TextComponent)Component.text((String)"Please wait a few days", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"while I update the plugin", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
            noRecipes.setItemMeta(meta);
            this.inventory.setItem(22, noRecipes);
            this.addNavigationButtons();
            return;
        }
        ItemStack emptySlot = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta emptyMeta = emptySlot.getItemMeta();
        emptyMeta.displayName((Component)Component.empty());
        emptySlot.setItemMeta(emptyMeta);
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, emptySlot);
        }
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, this.recipes.size());
        int slot = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            CustomRecipe recipe = this.recipes.get(i);
            ItemStack item = this.createRecipeItem(recipe);
            this.inventory.setItem(slot++, item);
        }
        this.addNavigationButtons();
        this.addInfoItem();
    }

    private ItemStack createRecipeItem(CustomRecipe recipe) {
        ItemStack item = new ItemStack(recipe.getResultMaterial());
        ItemMeta meta = item.getItemMeta();
        boolean enabled = this.plugin.getRecipeManager().isRecipeEnabled(recipe.getKey());
        Component displayName = recipe.getName() != null && !recipe.getName().isEmpty() ? MessageUtil.colorize(recipe.getName()).decoration(TextDecoration.BOLD, true).decoration(TextDecoration.ITALIC, false) : ((TextComponent)Component.text((String)MessageUtil.formatMaterialName(recipe.getResultMaterial().name()), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false);
        meta.displayName(displayName);
        ArrayList<Object> lore = new ArrayList<Object>();
        if (recipe.getDescription() != null && !recipe.getDescription().isEmpty()) {
            for (String line : recipe.getDescription()) {
                lore.add(MessageUtil.colorize(line).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.empty());
        }
        Component statusLine = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)(enabled ? "\u2713 " : "\u2717 "), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)).decoration(TextDecoration.BOLD, true)).append(Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.BOLD, false))).append(Component.text((String)(enabled ? "Enabled" : "Disabled"), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)).decoration(TextDecoration.BOLD, false))).decoration(TextDecoration.ITALIC, false);
        lore.add(statusLine);
        lore.add(((TextComponent)Component.text((String)"Type: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)recipe.getType().toString(), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        ItemMeta resultMeta = recipe.getResultItem().getItemMeta();
        if (resultMeta != null) {
            PersistentDataContainer container;
            boolean hasSpecialProps = false;
            if (resultMeta.hasCustomModelData()) {
                if (!hasSpecialProps) {
                    lore.add(Component.empty());
                    hasSpecialProps = true;
                }
                lore.add(((TextComponent)Component.text((String)"Custom Model Data: ", (TextColor)NamedTextColor.LIGHT_PURPLE).append((Component)Component.text((int)resultMeta.getCustomModelData(), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
            }
            if (resultMeta.hasEnchants()) {
                if (!hasSpecialProps) {
                    lore.add(Component.empty());
                    hasSpecialProps = true;
                }
                lore.add(((TextComponent)Component.text((String)"Enchantments: ", (TextColor)NamedTextColor.LIGHT_PURPLE).append((Component)Component.text((String)(resultMeta.getEnchants().size() + "x"), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
                int shown = 0;
                for (Map.Entry entry : resultMeta.getEnchants().entrySet()) {
                    if (shown++ >= 2) break;
                    String enchName = ((Enchantment)entry.getKey()).getKey().getKey();
                    lore.add(Component.text((String)("  \u2022 " + enchName + " " + String.valueOf(entry.getValue())), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
                }
                if (resultMeta.getEnchants().size() > 2) {
                    lore.add(Component.text((String)("  ... and " + (resultMeta.getEnchants().size() - 2) + " more"), (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
                }
            }
            if (!(container = resultMeta.getPersistentDataContainer()).isEmpty()) {
                if (!hasSpecialProps) {
                    lore.add(Component.empty());
                }
                lore.add(((TextComponent)Component.text((String)"NBT Data: ", (TextColor)NamedTextColor.DARK_AQUA).append((Component)Component.text((String)(container.getKeys().size() + " tags"), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
                int shown = 0;
                for (NamespacedKey key : container.getKeys()) {
                    if (shown++ >= 2) break;
                    if (!key.getNamespace().equals(this.plugin.getName().toLowerCase())) continue;
                    String value = (String)container.get(key, PersistentDataType.STRING);
                    lore.add(Component.text((String)("  \u2022 " + key.getKey() + ": " + value), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
                }
                if (container.getKeys().size() > 2) {
                    lore.add(Component.text((String)("  ... and " + (container.getKeys().size() - 2) + " more"), (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
                }
            }
        }
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"\u2699 ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Left-click to manage", (TextColor)NamedTextColor.GRAY))).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)"\u270e ", (TextColor)NamedTextColor.LIGHT_PURPLE).append((Component)Component.text((String)"Right-click to edit item", (TextColor)NamedTextColor.GRAY))).decoration(TextDecoration.ITALIC, false));
        List<String> disabledWorlds = this.plugin.getRecipeWorldManager().getDisabledWorlds(recipe.getKey());
        if (!disabledWorlds.isEmpty()) {
            lore.add(Component.empty());
            lore.add(Component.text((String)"\u26a0 World Restrictions:", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.text((String)("Disabled in: " + String.join((CharSequence)", ", disabledWorlds)), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        }
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void addNavigationButtons() {
        int maxPages = (int)Math.ceil((double)this.recipes.size() / 45.0);
        ItemStack prevButton = new ItemStack(Material.ARROW);
        ItemMeta prevMeta = prevButton.getItemMeta();
        if (this.page > 0) {
            prevMeta.displayName(Component.text((String)"\u25c0 Previous Page", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            prevMeta.lore(List.of((TextComponent)Component.text((String)("Page " + this.page + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            prevMeta.displayName(Component.text((String)"\u25c0 Previous Page", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
            prevMeta.lore(List.of((TextComponent)Component.text((String)"Already on first page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        prevButton.setItemMeta(prevMeta);
        this.inventory.setItem(48, prevButton);
        ItemStack nextButton = new ItemStack(Material.ARROW);
        ItemMeta nextMeta = nextButton.getItemMeta();
        if (this.page < maxPages - 1) {
            nextMeta.displayName(Component.text((String)"Next Page \u25b6", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            nextMeta.lore(List.of((TextComponent)Component.text((String)("Page " + (this.page + 2) + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            nextMeta.displayName(Component.text((String)"Next Page \u25b6", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
            nextMeta.lore(List.of((TextComponent)Component.text((String)"Already on last page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        nextButton.setItemMeta(nextMeta);
        this.inventory.setItem(50, nextButton);
        ItemStack createButton = new ItemStack(Material.CRAFTING_TABLE);
        ItemMeta createMeta = createButton.getItemMeta();
        createMeta.displayName(Component.text((String)"Create New Recipe", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false));
        createMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"\u00bb Click to create recipe", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true)));
        createButton.setItemMeta(createMeta);
        this.inventory.setItem(45, createButton);
        ItemStack vanillaButton = new ItemStack(Material.CRAFTING_TABLE);
        ItemMeta vanillaMeta = vanillaButton.getItemMeta();
        vanillaMeta.displayName(Component.text((String)"Vanilla Recipes", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.ITALIC, false));
        vanillaMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"\u00bb Click to browse", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true)));
        vanillaButton.setItemMeta(vanillaMeta);
        this.inventory.setItem(52, vanillaButton);
        ItemStack filterButton = new ItemStack(this.currentFilter.getIcon());
        ItemMeta filterMeta = filterButton.getItemMeta();
        filterMeta.displayName(((TextComponent)Component.text((String)("Station: " + this.currentFilter.getDisplayName()), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> filterLore = new ArrayList<Object>();
        filterLore.add(Component.empty());
        filterLore.add(Component.text((String)"Click to change station", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        filterLore.add(Component.empty());
        for (RecipeFilter filter : RecipeFilter.values()) {
            NamedTextColor color = filter == this.currentFilter ? NamedTextColor.GREEN : NamedTextColor.YELLOW;
            filterLore.add(Component.text((String)("  \u2022 " + filter.getDisplayName()), (TextColor)color).decoration(TextDecoration.ITALIC, false));
        }
        filterMeta.lore(filterLore);
        filterButton.setItemMeta(filterMeta);
        this.inventory.setItem(47, filterButton);
        ItemStack settingsButton = new ItemStack(Material.COMPARATOR);
        ItemMeta settingsMeta = settingsButton.getItemMeta();
        settingsMeta.displayName(Component.text((String)"Settings", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        settingsMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"\u00bb Click to open settings", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true)));
        settingsButton.setItemMeta(settingsMeta);
        this.inventory.setItem(53, settingsButton);
    }

    private void addInfoItem() {
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(Component.text((String)"Recipe Information", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> infoLore = new ArrayList<Object>();
        infoLore.add(Component.empty());
        int totalRecipes = this.plugin.getRecipeManager().getAllRecipes().size();
        int filteredRecipes = this.recipes.size();
        if (this.currentFilter == RecipeFilter.ALL) {
            infoLore.add(Component.text((String)("Total Recipes: " + totalRecipes), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        } else {
            infoLore.add(Component.text((String)("Showing: " + filteredRecipes + "/" + totalRecipes), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            infoLore.add(Component.text((String)("Station: " + this.currentFilter.getDisplayName()), (TextColor)this.currentFilter.getColor()).decoration(TextDecoration.ITALIC, false));
        }
        infoLore.add(Component.empty());
        infoLore.add(Component.text((String)"Left Click recipe to manage", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        infoLore.add(Component.text((String)"Right Click recipe to edit item", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        meta.lore(infoLore);
        info.setItemMeta(meta);
        this.inventory.setItem(49, info);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int recipeIndex;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        if (slot == 48 && this.page > 0) {
            --this.page;
            this.updateInventory();
            return;
        }
        int maxPages = (int)Math.ceil((double)this.recipes.size() / 45.0);
        if (slot == 50 && this.page < maxPages - 1) {
            ++this.page;
            this.updateInventory();
            return;
        }
        if (slot == 45) {
            if (!this.player.hasPermission("customrecipes.manage")) {
                MessageUtil.sendError((CommandSender)this.player, "You don't have permission to create recipes.");
                return;
            }
            new StationSelectorGUI(this.plugin, this.player).open();
            return;
        }
        if (slot == 47) {
            this.cycleFilter();
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Station filter: <white>" + this.currentFilter.getDisplayName());
            return;
        }
        if (slot == 52) {
            new VanillaRecipesGUI(this.plugin, this.player).open();
            return;
        }
        if (slot == 53) {
            new SettingsGUI(this.plugin, this.player).open();
            return;
        }
        if (slot < 45 && (recipeIndex = this.page * 45 + slot) < this.recipes.size()) {
            CustomRecipe recipe = this.recipes.get(recipeIndex);
            if (clickType == ClickType.RIGHT) {
                if (!this.player.hasPermission("customrecipes.manage")) {
                    MessageUtil.sendError((CommandSender)this.player, "You don't have permission to edit recipes.");
                    return;
                }
                ItemStack resultItem = recipe.getResultItem();
                new ItemEditorGUI(this.plugin, this.player, resultItem, editedItem -> {
                    if (editedItem != null) {
                        ItemEditorGUI editor = ItemEditorGUI.getLastEditor(this.player.getUniqueId());
                        String newName = editor != null ? editor.getCustomName() : null;
                        List<String> newDesc = editor != null ? editor.getCustomLore() : null;
                        this.plugin.getRecipeManager().updateRecipeResult(recipe.getKey(), (ItemStack)editedItem, newName, newDesc);
                        MessageUtil.sendAdminSuccess((CommandSender)this.player, "Updated result item for recipe: " + recipe.getKey());
                    }
                    new RecipeListGUI(this.plugin, this.player).open();
                }).open();
            } else {
                new RecipeEditorGUI(this.plugin, this.player, recipe).open();
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }

    public static enum RecipeFilter {
        ALL("All Stations", Material.CHEST, NamedTextColor.WHITE),
        CRAFTING_TABLE("Crafting Table", Material.CRAFTING_TABLE, NamedTextColor.GREEN),
        FURNACE("Furnace", Material.FURNACE, NamedTextColor.GOLD),
        BLAST_FURNACE("Blast Furnace", Material.BLAST_FURNACE, NamedTextColor.DARK_RED),
        SMOKER("Smoker", Material.SMOKER, NamedTextColor.GRAY),
        ANVIL("Anvil", Material.ANVIL, NamedTextColor.DARK_GRAY),
        SMITHING_TABLE("Smithing Table", Material.SMITHING_TABLE, NamedTextColor.BLUE),
        BREWING_STAND("Brewing Stand", Material.BREWING_STAND, NamedTextColor.LIGHT_PURPLE),
        STONECUTTER("Stonecutter", Material.STONECUTTER, NamedTextColor.GRAY);

        private final String displayName;
        private final Material icon;
        private final NamedTextColor color;

        private RecipeFilter(String displayName, Material icon, NamedTextColor color) {
            this.displayName = displayName;
            this.icon = icon;
            this.color = color;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Material getIcon() {
            return this.icon;
        }

        public NamedTextColor getColor() {
            return this.color;
        }

        public RecipeFilter next() {
            RecipeFilter[] values = RecipeFilter.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

