/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.PlayerRecipeListGUI;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.RecipeIngredient;
import org.hikarii.customrecipes.util.MessageUtil;

public class RecipeViewerGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final CustomRecipe recipe;
    private final PlayerRecipeListGUI parentGUI;
    private final Inventory inventory;
    private static final int RESULT_SLOT = 25;
    private static final int[] GRID_SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    private static final int BACK_BUTTON_SLOT = 53;
    private static final int INFO_SLOT = 44;

    public RecipeViewerGUI(CustomRecipes plugin, Player player, CustomRecipe recipe, PlayerRecipeListGUI parentGUI) {
        this.plugin = plugin;
        this.player = player;
        this.recipe = recipe;
        this.parentGUI = parentGUI;
        String recipeName = recipe.getName() != null && !recipe.getName().isEmpty() ? recipe.getName() : MessageUtil.formatMaterialName(recipe.getResultMaterial().name());
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createGradientMenuTitle("Recipe: " + recipeName));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addCraftingGrid();
        this.addEqualsSign();
        this.addResultItem();
        this.addInfoBook();
        this.addBackButton();
    }

    private void fillBorders() {
        ItemStack borderPane = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
        for (int slot : GRID_SLOTS) {
            this.inventory.setItem(slot, null);
        }
        this.inventory.setItem(25, null);
    }

    private void addCraftingGrid() {
        if (this.recipe.getType() == RecipeType.SHAPED || this.recipe.getType() == RecipeType.SHAPELESS) {
            List<RecipeIngredient> ingredients = this.recipe.getRecipeData().ingredients();
            for (int i = 0; i < Math.min(GRID_SLOTS.length, ingredients.size()); ++i) {
                RecipeIngredient ingredient = ingredients.get(i);
                if (ingredient.material() == Material.AIR) continue;
                ItemStack displayItem = ingredient.hasExactItem() ? ingredient.getExactItem().clone() : new ItemStack(ingredient.material(), ingredient.amount());
                ItemMeta meta = displayItem.getItemMeta();
                if (meta != null) {
                    ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.lore()) : new ArrayList();
                    lore.add(Component.empty());
                    lore.add(Component.text((String)("Amount: " + ingredient.amount()), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
                    if (ingredient.hasExactItem()) {
                        lore.add(Component.text((String)"\u26a0 Exact item required", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
                    }
                    meta.lore(lore);
                    displayItem.setItemMeta(meta);
                }
                this.inventory.setItem(GRID_SLOTS[i], displayItem);
            }
        }
    }

    private void addEqualsSign() {
        ItemStack equals = new ItemStack(Material.ORANGE_STAINED_GLASS_PANE);
        ItemMeta meta = equals.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"=", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        equals.setItemMeta(meta);
        this.inventory.setItem(23, equals);
    }

    private void addResultItem() {
        ItemStack resultDisplay = this.recipe.getResultItem().clone();
        ItemMeta resultMeta = resultDisplay.getItemMeta();
        if (resultMeta != null) {
            ArrayList<Object> lore = resultMeta.hasLore() ? new ArrayList<Object>(resultMeta.lore()) : new ArrayList();
            lore.add(Component.empty());
            lore.add(((TextComponent)Component.text((String)"\u2714 Recipe Result", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
            resultMeta.lore(lore);
            resultDisplay.setItemMeta(resultMeta);
        }
        this.inventory.setItem(25, resultDisplay);
    }

    private void addInfoBook() {
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(Component.text((String)"Recipe Information", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (this.recipe.getName() != null && !this.recipe.getName().isEmpty()) {
            lore.add(((TextComponent)Component.text((String)"Name: ", (TextColor)NamedTextColor.GRAY).append(MessageUtil.colorize(this.recipe.getName()))).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(((TextComponent)Component.text((String)"Type: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)this.recipe.getType().toString(), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        if (this.recipe.getDescription() != null && !this.recipe.getDescription().isEmpty()) {
            lore.add(Component.empty());
            lore.add(Component.text((String)"Description:", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            for (String line : this.recipe.getDescription()) {
                lore.add(Component.text((String)("  " + line), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(lore);
        info.setItemMeta(meta);
        this.inventory.setItem(44, info);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(Component.text((String)"\u00ab Back to Recipe List", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        back.setItemMeta(meta);
        this.inventory.setItem(53, back);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 53) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
            this.parentGUI.reopen();
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

