/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.RecipeListGUI;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.util.MessageUtil;

public class SettingsGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;

    public SettingsGUI(CustomRecipes plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createGradientMenuTitle("Settings"));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addSpawnEggNameSetting();
        this.addCraftedNamesSetting();
        this.addIgnoreDataSetting();
        this.addAdminNotificationsSetting();
        this.addDisableAllCustomButton();
        this.addDisableAllVanillaButton();
        this.addWorldRestrictionSetting();
        this.addWorldSettingsButtons();
        this.addEnableAllCustomButton();
        this.addEnableAllVanillaButton();
        this.addBackButton();
    }

    private void fillBorders() {
        ItemStack borderPane = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
    }

    private void addSpawnEggNameSetting() {
        boolean enabled = this.plugin.isKeepSpawnEggNames();
        Material material = enabled ? Material.LIME_DYE : Material.GRAY_DYE;
        String status = enabled ? "Enabled" : "Disabled";
        NamedTextColor color = enabled ? NamedTextColor.GREEN : NamedTextColor.RED;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Spawn Egg Custom Names", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)status, (TextColor)color))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"If enabled, mobs spawned from", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"custom spawn eggs will keep", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"the custom name.", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        this.inventory.setItem(10, item);
    }

    private void addCraftedNamesSetting() {
        boolean enabled = this.plugin.isUseCraftedCustomNames();
        Material material = enabled ? Material.LIME_DYE : Material.GRAY_DYE;
        String status = enabled ? "Enabled" : "Disabled";
        NamedTextColor color = enabled ? NamedTextColor.GREEN : NamedTextColor.RED;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Crafted Item Custom Names", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)status, (TextColor)color))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"If enabled, crafted items will", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"have custom names and lore", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"from the recipe config.", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        this.inventory.setItem(12, item);
    }

    private void addIgnoreDataSetting() {
        boolean enabled = this.plugin.getConfig().getBoolean("ignore-metadata", false);
        Material material = enabled ? Material.LIME_DYE : Material.GRAY_DYE;
        String status = enabled ? "Enabled" : "Disabled";
        NamedTextColor color = enabled ? NamedTextColor.GREEN : NamedTextColor.RED;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Ignore Metadata", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)status, (TextColor)color))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"If enabled, recipe ingredients", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"will ignore NBT/metadata", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"(e.g., damaged items work)", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        this.inventory.setItem(14, item);
    }

    private void addAdminNotificationsSetting() {
        boolean enabled = this.plugin.getConfig().getBoolean("admin-notifications", true);
        Material material = enabled ? Material.LIME_DYE : Material.GRAY_DYE;
        String status = enabled ? "Enabled" : "Disabled";
        NamedTextColor color = enabled ? NamedTextColor.GREEN : NamedTextColor.RED;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Admin Notifications", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)status, (TextColor)color))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"If enabled, shows chat", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"notifications when you", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"perform admin actions", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        this.inventory.setItem(16, item);
    }

    private void addWorldRestrictionSetting() {
        boolean enabled = this.plugin.getRecipeWorldManager().isGlobalWorldRestrictionEnabled();
        List<String> disabledWorlds = this.plugin.getRecipeWorldManager().getGlobalDisabledWorlds();
        boolean hasRestrictions = !disabledWorlds.isEmpty();
        Material material = hasRestrictions ? Material.LIME_DYE : Material.GRAY_DYE;
        String status = hasRestrictions ? "Enabled" : "Disabled";
        NamedTextColor color = hasRestrictions ? NamedTextColor.GREEN : NamedTextColor.RED;
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"World Restrictions", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)status, (TextColor)color))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"If enabled, recipes can be", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"restricted per world", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        if (hasRestrictions) {
            lore.add(Component.empty());
            lore.add(Component.text((String)"Globally disabled in:", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
            for (String world : disabledWorlds) {
                lore.add(Component.text((String)("  \u2022 " + world), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
            }
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        this.inventory.setItem(28, item);
    }

    private void addWorldSettingsButtons() {
        this.addWorldButton(37, World.Environment.NORMAL, "Overworld", Material.GRASS_BLOCK);
        this.addWorldButton(38, World.Environment.NETHER, "Nether", Material.NETHERRACK);
        this.addWorldButton(39, World.Environment.THE_END, "The End", Material.END_STONE);
    }

    private void addWorldButton(int slot, World.Environment environment, String displayName, Material icon) {
        ItemStack item = new ItemStack(icon);
        ItemMeta meta = item.getItemMeta();
        List<String> globallyDisabled = this.plugin.getRecipeWorldManager().getGlobalDisabledWorlds();
        boolean isDisabled = false;
        ArrayList<String> worldsOfType = new ArrayList<String>();
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != environment) continue;
            worldsOfType.add(world.getName());
            if (!globallyDisabled.contains(world.getName())) continue;
            isDisabled = true;
        }
        NamedTextColor titleColor = isDisabled ? NamedTextColor.RED : NamedTextColor.GREEN;
        meta.displayName(((TextComponent)Component.text((String)(displayName + " Settings"), (TextColor)titleColor).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(isDisabled ? "Recipes Disabled" : "Recipes Enabled"), (TextColor)(isDisabled ? NamedTextColor.RED : NamedTextColor.GREEN)))).decoration(TextDecoration.ITALIC, false));
        if (!worldsOfType.isEmpty()) {
            lore.add(Component.empty());
            lore.add(Component.text((String)"Worlds:", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            for (String worldName : worldsOfType) {
                boolean worldDisabled = globallyDisabled.contains(worldName);
                lore.add(Component.text((String)("  \u2022 " + worldName), (TextColor)(worldDisabled ? NamedTextColor.RED : NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
            }
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        lore.add(Component.text((String)("\u00bb Affects all " + displayName.toLowerCase() + " worlds"), (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        this.inventory.setItem(slot, item);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(Component.text((String)"\u00ab Back to Main Menu", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        back.setItemMeta(meta);
        this.inventory.setItem(53, back);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 53) {
            new RecipeListGUI(this.plugin, this.player).open();
            return;
        }
        if (!this.player.hasPermission("customrecipes.manage")) {
            MessageUtil.sendError((CommandSender)this.player, "You don't have permission to change settings.");
            return;
        }
        if (slot == 10) {
            boolean newValue = !this.plugin.isKeepSpawnEggNames();
            this.plugin.getConfig().set("spawn-egg-keep-custom-name", (Object)newValue);
            this.plugin.saveConfig();
            this.plugin.loadConfiguration();
            MessageUtil.sendAdminSuccess((CommandSender)this.player, (newValue ? "Enabled" : "Disabled") + " spawn egg custom names");
            this.updateInventory();
            return;
        }
        if (slot == 12) {
            boolean newValue = !this.plugin.isUseCraftedCustomNames();
            this.plugin.getConfig().set("use-crafted-custom-names", (Object)newValue);
            this.plugin.saveConfig();
            this.plugin.loadConfiguration();
            MessageUtil.sendAdminSuccess((CommandSender)this.player, (newValue ? "Enabled" : "Disabled") + " crafted item custom names");
            this.updateInventory();
            return;
        }
        if (slot == 14) {
            boolean newValue = !this.plugin.getConfig().getBoolean("ignore-metadata", false);
            this.plugin.getConfig().set("ignore-metadata", (Object)newValue);
            this.plugin.saveConfig();
            MessageUtil.sendAdminSuccess((CommandSender)this.player, (newValue ? "Enabled" : "Disabled") + " ignore metadata");
            this.updateInventory();
            return;
        }
        if (slot == 16) {
            boolean newValue = !this.plugin.getConfig().getBoolean("admin-notifications", true);
            this.plugin.getConfig().set("admin-notifications", (Object)newValue);
            this.plugin.saveConfig();
            MessageUtil.sendAdminSuccess((CommandSender)this.player, (newValue ? "Enabled" : "Disabled") + " admin notifications");
            this.updateInventory();
            return;
        }
        if (slot == 41) {
            for (CustomRecipe recipe : this.plugin.getRecipeManager().getAllRecipes()) {
                if (!this.plugin.getRecipeManager().isRecipeEnabled(recipe.getKey())) continue;
                this.plugin.getRecipeManager().disableRecipe(recipe.getKey());
                this.plugin.getConfigManager().removeEnabledRecipe(recipe.getKey());
            }
            MessageUtil.sendAdminWarning((CommandSender)this.player, "Disabled all custom recipes");
            this.updateInventory();
            return;
        }
        if (slot == 32) {
            for (CustomRecipe recipe : this.plugin.getRecipeManager().getAllRecipes()) {
                String key = recipe.getKey();
                if (this.plugin.getRecipeManager().isRecipeEnabled(key)) continue;
                this.plugin.getRecipeManager().registerSingleRecipe(recipe);
                this.plugin.getConfigManager().addEnabledRecipe(key);
            }
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Enabled all custom recipes");
            this.updateInventory();
            return;
        }
        if (slot == 34) {
            int enabled = 0;
            for (String recipeKey : this.plugin.getVanillaRecipeManager().getAllVanillaRecipes().keySet()) {
                if (!this.plugin.getVanillaRecipeManager().isRecipeDisabled(recipeKey)) continue;
                this.plugin.getVanillaRecipeManager().toggleRecipe(recipeKey);
                ++enabled;
            }
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Enabled all " + enabled + " vanilla recipes");
            this.updateInventory();
            return;
        }
        if (slot == 43) {
            int disabled = 0;
            for (String recipeKey : this.plugin.getVanillaRecipeManager().getAllVanillaRecipes().keySet()) {
                if (this.plugin.getVanillaRecipeManager().isRecipeDisabled(recipeKey)) continue;
                this.plugin.getVanillaRecipeManager().toggleRecipe(recipeKey);
                ++disabled;
            }
            MessageUtil.sendAdminWarning((CommandSender)this.player, "Disabled all " + disabled + " vanilla recipes");
            this.updateInventory();
            return;
        }
        if (slot == 28) {
            boolean newValue = !this.plugin.getRecipeWorldManager().isGlobalWorldRestrictionEnabled();
            List<String> currentDisabled = this.plugin.getRecipeWorldManager().getGlobalDisabledWorlds();
            this.plugin.getRecipeWorldManager().setGlobalWorldRestrictions(newValue, currentDisabled);
            MessageUtil.sendAdminSuccess((CommandSender)this.player, (newValue ? "Enabled" : "Disabled") + " world restrictions");
            this.updateInventory();
            return;
        }
        if (slot == 37 || slot == 38 || slot == 39) {
            World.Environment env;
            switch (slot) {
                case 37: {
                    World.Environment environment = World.Environment.NORMAL;
                    break;
                }
                case 38: {
                    World.Environment environment = World.Environment.NETHER;
                    break;
                }
                case 39: {
                    World.Environment environment = World.Environment.THE_END;
                    break;
                }
                default: {
                    World.Environment environment = env = null;
                }
            }
            if (env != null) {
                this.toggleWorldEnvironment(env);
            }
            return;
        }
    }

    private void toggleWorldEnvironment(World.Environment environment) {
        ArrayList<String> globallyDisabled = new ArrayList<String>(this.plugin.getRecipeWorldManager().getGlobalDisabledWorlds());
        ArrayList<String> worldsOfType = new ArrayList<String>();
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != environment) continue;
            worldsOfType.add(world.getName());
        }
        if (worldsOfType.isEmpty()) {
            MessageUtil.sendAdminWarning((CommandSender)this.player, "No worlds of this type found!");
            return;
        }
        boolean anyDisabled = worldsOfType.stream().anyMatch(globallyDisabled::contains);
        if (anyDisabled) {
            globallyDisabled.removeAll(worldsOfType);
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Enabled recipes in all " + environment.name().toLowerCase().replace("_", " ") + " worlds");
        } else {
            globallyDisabled.addAll(worldsOfType);
            MessageUtil.sendAdminWarning((CommandSender)this.player, "Disabled recipes in all " + environment.name().toLowerCase().replace("_", " ") + " worlds");
        }
        this.plugin.getRecipeWorldManager().setGlobalWorldRestrictions(true, globallyDisabled);
        this.updateInventory();
    }

    private void addDisableAllCustomButton() {
        int totalCount;
        int disabledCount = (int)this.plugin.getRecipeManager().getAllRecipes().stream().filter(recipe -> !this.plugin.getRecipeManager().isRecipeEnabled(recipe.getKey())).count();
        boolean allDisabled = disabledCount == (totalCount = this.plugin.getRecipeManager().getRecipeCount()) && totalCount > 0;
        ItemStack button = new ItemStack(allDisabled ? Material.RED_DYE : Material.BARRIER);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Disable All Custom Recipes", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Total Recipes: " + totalCount), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)("Currently Disabled: " + disabledCount), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Disable all custom recipes", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"from working on the server", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to disable all", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(41, button);
    }

    private void addEnableAllCustomButton() {
        int enabledCount = (int)this.plugin.getRecipeManager().getAllRecipes().stream().filter(recipe -> this.plugin.getRecipeManager().isRecipeEnabled(recipe.getKey())).count();
        int totalCount = this.plugin.getRecipeManager().getRecipeCount();
        ItemStack button = new ItemStack(Material.LIME_DYE);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Enable All Custom Recipes", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Total Recipes: " + totalCount), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)("Currently Enabled: " + enabledCount), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Enable all custom recipes", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"on the server", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to enable all", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(32, button);
    }

    private void addEnableAllVanillaButton() {
        int totalVanilla = this.plugin.getVanillaRecipeManager().getAllVanillaRecipes().size();
        int disabledVanilla = (int)this.plugin.getVanillaRecipeManager().getAllVanillaRecipes().keySet().stream().filter(key -> this.plugin.getVanillaRecipeManager().isRecipeDisabled((String)key)).count();
        int enabledVanilla = totalVanilla - disabledVanilla;
        ItemStack button = new ItemStack(Material.LIME_DYE);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Enable All Vanilla Recipes", (TextColor)NamedTextColor.DARK_GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Total Recipes: " + totalVanilla), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)("Currently Enabled: " + enabledVanilla), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Enable all vanilla recipes", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"on the crafting table", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to enable all", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(34, button);
    }

    private void addDisableAllVanillaButton() {
        int totalVanilla = this.plugin.getVanillaRecipeManager().getAllVanillaRecipes().size();
        int disabledVanilla = (int)this.plugin.getVanillaRecipeManager().getAllVanillaRecipes().keySet().stream().filter(key -> this.plugin.getVanillaRecipeManager().isRecipeDisabled((String)key)).count();
        boolean allDisabled = disabledVanilla == totalVanilla && totalVanilla > 0;
        ItemStack button = new ItemStack(allDisabled ? Material.RED_DYE : Material.BARRIER);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Disable All Vanilla Recipes", (TextColor)NamedTextColor.DARK_RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Total Recipes: " + totalVanilla), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)("Currently Disabled: " + disabledVanilla), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Disable all vanilla recipes", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"from the crafting table", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u26a0 Warning: This affects", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"all 801 vanilla recipes!", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to disable all", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(43, button);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

