/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.RecipeCreatorGUI;
import org.hikarii.customrecipes.gui.RecipeListGUI;
import org.hikarii.customrecipes.util.MessageUtil;

public class StationSelectorGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;

    public StationSelectorGUI(CustomRecipes plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createGradientMenuTitle("Select Crafting Station"));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addStationButtons();
        this.addInfoItem();
        this.addBackButton();
    }

    private void fillBorders() {
        ItemStack borderPane = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
    }

    private void addStationButtons() {
        int[] slots = new int[]{10, 12, 14, 16, 19, 21, 23, 25, 28};
        RecipeStation[] stations = RecipeStation.values();
        for (int i = 0; i < Math.min(stations.length, slots.length); ++i) {
            RecipeStation station = stations[i];
            ItemStack button = this.createStationButton(station);
            this.inventory.setItem(slots[i], button);
        }
    }

    private ItemStack createStationButton(RecipeStation station) {
        ItemStack item = new ItemStack(station.getIcon());
        ItemMeta meta = item.getItemMeta();
        NamedTextColor nameColor = station.isEnabled() ? NamedTextColor.AQUA : NamedTextColor.DARK_GRAY;
        meta.displayName(((TextComponent)Component.text((String)station.getDisplayName(), (TextColor)nameColor).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)station.getDescription(), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Grid Size: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(station.getGridSize() + " slot" + (station.getGridSize() > 1 ? "s" : "")), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        if (station.isEnabled()) {
            lore.add(((TextComponent)((TextComponent)Component.text((String)"\u2713 ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)"Available", (TextColor)NamedTextColor.GREEN))).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
            lore.add(Component.text((String)"\u00bb Click to create recipe", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        } else {
            lore.add(((TextComponent)((TextComponent)Component.text((String)"\u2717 ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)station.getStatusMessage(), (TextColor)NamedTextColor.RED))).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        }
        meta.lore(lore);
        if (station.isEnabled()) {
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private void addInfoItem() {
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Crafting Stations", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Select a crafting station", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"to create a custom recipe", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        int enabledCount = 0;
        int totalCount = RecipeStation.values().length;
        for (RecipeStation station : RecipeStation.values()) {
            if (!station.isEnabled()) continue;
            ++enabledCount;
        }
        lore.add(((TextComponent)Component.text((String)"Available: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(enabledCount + "/" + totalCount), (TextColor)NamedTextColor.GREEN))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"More stations coming soon!", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        info.setItemMeta(meta);
        this.inventory.setItem(49, info);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(Component.text((String)"\u00ab Back to Recipe List", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Return to main menu", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        back.setItemMeta(meta);
        this.inventory.setItem(53, back);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player clicker;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player) || !(clicker = (Player)humanEntity).equals((Object)this.player)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (!this.player.hasPermission("customrecipes.manage")) {
            MessageUtil.sendError((CommandSender)this.player, "You don't have permission to create recipes.");
            return;
        }
        if (slot == 53) {
            new RecipeListGUI(this.plugin, this.player).open();
            return;
        }
        int[] stationSlots = new int[]{10, 12, 14, 16, 19, 21, 23, 25, 28};
        for (int i = 0; i < stationSlots.length; ++i) {
            if (slot != stationSlots[i] || i >= RecipeStation.values().length) continue;
            RecipeStation station = RecipeStation.values()[i];
            this.handleStationClick(station);
            return;
        }
    }

    private void handleStationClick(RecipeStation station) {
        if (!station.isEnabled()) {
            MessageUtil.sendAdminWarning((CommandSender)this.player, station.getDisplayName() + " is not yet available!");
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
            return;
        }
        switch (station.ordinal()) {
            case 0: {
                new RecipeCreatorGUI(this.plugin, this.player).open();
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Opening Crafting Table recipe creator...");
                break;
            }
            case 1: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Furnace recipes are coming soon!");
                break;
            }
            case 2: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Blast Furnace recipes are coming soon!");
                break;
            }
            case 3: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Smoker recipes are coming soon!");
                break;
            }
            case 4: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Stonecutter recipes are coming soon!");
                break;
            }
            case 5: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Brewing Stand recipes are coming soon!");
                break;
            }
            case 6: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Smithing Table recipes are coming soon!");
                break;
            }
            case 7: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Anvil recipes are coming soon!");
                break;
            }
            case 8: {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Loom recipes are coming soon!");
                break;
            }
            default: {
                MessageUtil.sendError((CommandSender)this.player, "Unknown station type!");
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }

    public static enum RecipeStation {
        CRAFTING_TABLE("Crafting Table", Material.CRAFTING_TABLE, true, 9, "Create shaped or shapeless recipes", "Standard 3x3 crafting grid"),
        FURNACE("Furnace", Material.FURNACE, false, 2, "Smelt items with fuel", "Coming soon!"),
        BLAST_FURNACE("Blast Furnace", Material.BLAST_FURNACE, false, 2, "Faster ore smelting", "Coming soon!"),
        SMOKER("Smoker", Material.SMOKER, false, 2, "Faster food cooking", "Coming soon!"),
        STONECUTTER("Stonecutter", Material.STONECUTTER, false, 1, "Cut stone blocks", "Coming soon!"),
        BREWING_STAND("Brewing Stand", Material.BREWING_STAND, false, 4, "Brew potions", "Coming soon!"),
        SMITHING_TABLE("Smithing Table", Material.SMITHING_TABLE, false, 3, "Upgrade equipment", "Coming soon!"),
        ANVIL("Anvil", Material.ANVIL, false, 2, "Combine and rename items", "Coming soon!"),
        LOOM("Loom", Material.LOOM, false, 3, "Create banners", "Coming soon!");

        private final String displayName;
        private final Material icon;
        private final boolean enabled;
        private final int gridSize;
        private final String description;
        private final String statusMessage;

        private RecipeStation(String displayName, Material icon, boolean enabled, int gridSize, String description, String statusMessage) {
            this.displayName = displayName;
            this.icon = icon;
            this.enabled = enabled;
            this.gridSize = gridSize;
            this.description = description;
            this.statusMessage = statusMessage;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Material getIcon() {
            return this.icon;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getGridSize() {
            return this.gridSize;
        }

        public String getDescription() {
            return this.description;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }
    }
}

