/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.VanillaRecipeSearchResultsGUI;
import org.hikarii.customrecipes.gui.VanillaRecipesGUI;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.vanilla.IngredientChoice;
import org.hikarii.customrecipes.recipe.vanilla.VanillaRecipeInfo;
import org.hikarii.customrecipes.recipe.vanilla.VanillaRecipeManager;
import org.hikarii.customrecipes.util.MessageUtil;

public class VanillaRecipeEditorGUI
implements Listener {
    private static final Map<UUID, VanillaRecipeEditorGUI> waitingForSearch = new HashMap<UUID, VanillaRecipeEditorGUI>();
    private static final int[] GRID_SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    private static final int RESULT_SLOT = 25;
    private static final int INGREDIENT_CYCLE_BUTTON = 52;
    private int currentVariantIndex = 0;
    private int maxVariants = 1;
    private long lastVariantSwitch = 0L;
    private static final long SWITCH_COOLDOWN = 200L;
    private final CustomRecipes plugin;
    private final Player player;
    private final VanillaRecipeInfo originalRecipe;
    private final VanillaRecipesGUI parentGUI;
    private final Inventory inventory;
    private final ItemStack[] gridItems = new ItemStack[9];
    private RecipeType currentType;

    public VanillaRecipeEditorGUI(CustomRecipes plugin, Player player, VanillaRecipeInfo recipe, VanillaRecipesGUI parentGUI) {
        this.plugin = plugin;
        this.player = player;
        this.originalRecipe = recipe;
        this.parentGUI = parentGUI;
        this.currentType = recipe.getType();
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createMenuTitle("Edit: " + recipe.getDisplayName(), NamedTextColor.DARK_AQUA));
        String recipeKey = recipe.getKey().replace("minecraft:", "");
        this.maxVariants = plugin.getVanillaRecipeManager().getMaxVariantsForRecipe(recipeKey);
        VanillaRecipeManager.VanillaRecipeState state = plugin.getVanillaRecipeManager().getRecipeState(recipeKey);
        if (state != null) {
            this.currentVariantIndex = state.getCurrentVariantIndex();
            this.loadVariantPattern(this.currentVariantIndex);
        } else {
            this.currentVariantIndex = 0;
            this.loadOriginalPattern();
        }
        plugin.getVanillaRecipeManager().setCurrentVariant(recipeKey, this.currentVariantIndex);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    private void loadOriginalPattern() {
        List<String> pattern = this.originalRecipe.getPattern();
        for (int i = 0; i < Math.min(pattern.size(), 3); ++i) {
            String[] row = pattern.get(i).split(" ");
            for (int j = 0; j < Math.min(row.length, 3); ++j) {
                Material material;
                String materialName = row[j];
                if (materialName.equals("AIR") || materialName.isEmpty() || (material = Material.getMaterial((String)materialName)) == null) continue;
                this.gridItems[i * 3 + j] = new ItemStack(material);
            }
        }
    }

    private void loadChangedPattern(List<String> pattern) {
        for (int i = 0; i < Math.min(pattern.size(), 3); ++i) {
            String[] row = pattern.get(i).split(" ");
            for (int j = 0; j < Math.min(row.length, 3); ++j) {
                Material material;
                String materialName = row[j];
                if (materialName.equals("AIR") || materialName.isEmpty() || (material = Material.getMaterial((String)materialName)) == null) continue;
                this.gridItems[i * 3 + j] = new ItemStack(material);
            }
        }
    }

    private void loadVariantPattern(int variantIndex) {
        Arrays.fill(this.gridItems, null);
        String recipeKey = this.originalRecipe.getKey().replace("minecraft:", "");
        VanillaRecipeManager.VanillaRecipeState state = this.plugin.getVanillaRecipeManager().getRecipeState(recipeKey);
        if (state != null && state.getPatternForVariant(variantIndex) != null) {
            List<String> pattern = state.getPatternForVariant(variantIndex);
            this.currentType = state.getTypeForVariant(variantIndex);
            for (int i = 0; i < Math.min(pattern.size(), 3); ++i) {
                String[] row = pattern.get(i).split(" ");
                for (int j = 0; j < Math.min(row.length, 3); ++j) {
                    String materialName = row[j];
                    if (!materialName.equals("AIR") && !materialName.isEmpty()) {
                        Material material = Material.getMaterial((String)materialName);
                        if (material != null) {
                            this.gridItems[i * 3 + j] = new ItemStack(material);
                            continue;
                        }
                        this.gridItems[i * 3 + j] = null;
                        continue;
                    }
                    this.gridItems[i * 3 + j] = null;
                }
            }
        } else {
            this.loadOriginalPattern();
        }
    }

    private void loadPatternToGrid(List<String> pattern) {
        for (int i = 0; i < Math.min(pattern.size(), 3); ++i) {
            String[] row = pattern.get(i).split(" ");
            for (int j = 0; j < Math.min(row.length, 3); ++j) {
                String materialName = row[j];
                if (!materialName.equals("AIR") && !materialName.isEmpty()) {
                    Material material = Material.getMaterial((String)materialName);
                    if (material == null) continue;
                    this.gridItems[i * 3 + j] = new ItemStack(material);
                    continue;
                }
                this.gridItems[i * 3 + j] = null;
            }
        }
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addGridItems();
        this.addResultItem();
        this.addEqualsSign();
        this.addTypeToggle();
        this.addButtons();
    }

    private void fillBorders() {
        ItemStack borderPane = new ItemStack(Material.CYAN_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, borderPane);
        }
        for (int slot : GRID_SLOTS) {
            this.inventory.setItem(slot, null);
        }
        this.inventory.setItem(25, null);
    }

    private void addGridItems() {
        for (int i = 0; i < 9; ++i) {
            if (this.gridItems[i] == null) continue;
            ItemStack display = this.gridItems[i].clone();
            ItemMeta meta = display.getItemMeta();
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(Component.empty());
            lore.add(Component.text((String)"Click to remove", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
            meta.lore(lore);
            display.setItemMeta(meta);
            this.inventory.setItem(GRID_SLOTS[i], display);
        }
    }

    private void addResultItem() {
        ItemStack result = this.originalRecipe.hasVariantResults() ? this.originalRecipe.getResultForVariant(this.currentVariantIndex) : new ItemStack(this.originalRecipe.getResultMaterial(), this.originalRecipe.getResultAmount());
        ItemMeta meta = result.getItemMeta();
        if (meta != null) {
            ArrayList<Object> lore = meta.hasLore() && meta.lore() != null ? new ArrayList<Object>(meta.lore()) : new ArrayList<Object>();
            lore.add(Component.empty());
            lore.add(Component.text((String)"\u00bb Left Click to add +1", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, true));
            lore.add(Component.text((String)"\u00bb Right Click to remove -1", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, true));
            meta.lore(lore);
            result.setItemMeta(meta);
        }
        this.inventory.setItem(25, result);
    }

    private void addEqualsSign() {
        ItemStack equals = new ItemStack(Material.ORANGE_STAINED_GLASS_PANE);
        ItemMeta meta = equals.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"=", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Place ingredients in the", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"3x3 grid on the left", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"Place result item", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"on the right \u2192", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        equals.setItemMeta(meta);
        this.inventory.setItem(23, equals);
    }

    private void addTypeToggle() {
        boolean isShaped = this.currentType == RecipeType.SHAPED;
        ItemStack toggle = new ItemStack(isShaped ? Material.CRAFTING_TABLE : Material.CHEST);
        ItemMeta meta = toggle.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)(isShaped ? "Shaped Recipe" : "Shapeless Recipe"), (TextColor)(isShaped ? NamedTextColor.AQUA : NamedTextColor.LIGHT_PURPLE)).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        if (isShaped) {
            lore.add(Component.text((String)"Position matters!", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        } else {
            lore.add(Component.text((String)"Position doesn't matter!", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        toggle.setItemMeta(meta);
        this.inventory.setItem(45, toggle);
    }

    private void addButtons() {
        if (this.maxVariants > 1) {
            this.addVariantSwitcher();
        }
        ItemStack save = new ItemStack(Material.LIME_WOOL);
        ItemMeta saveMeta = save.getItemMeta();
        saveMeta.displayName(((TextComponent)Component.text((String)"Save", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        saveMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Save changes and stay", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        save.setItemMeta(saveMeta);
        this.inventory.setItem(48, save);
        ItemStack close = new ItemStack(Material.RED_WOOL);
        ItemMeta closeMeta = close.getItemMeta();
        closeMeta.displayName(((TextComponent)Component.text((String)"Close", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        closeMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Return to recipe list", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        close.setItemMeta(closeMeta);
        this.inventory.setItem(50, close);
        ItemStack search = new ItemStack(Material.COMPASS);
        ItemMeta searchMeta = search.getItemMeta();
        searchMeta.displayName(((TextComponent)Component.text((String)"New Search", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        searchMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Search for another recipe", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        search.setItemMeta(searchMeta);
        this.inventory.setItem(51, search);
        ItemStack reset = new ItemStack(Material.BARRIER);
        ItemMeta resetMeta = reset.getItemMeta();
        resetMeta.displayName(((TextComponent)Component.text((String)"Reset", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        resetMeta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Restore original recipe", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"\u26a0 This cannot be undone", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false)));
        reset.setItemMeta(resetMeta);
        this.inventory.setItem(53, reset);
    }

    private void addVariantSwitcher() {
        String variantName = this.getVariantName(this.currentVariantIndex);
        ItemStack switcher = new ItemStack(Material.ARROW);
        ItemMeta meta = switcher.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Ingredient Variant", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Current: ", (TextColor)NamedTextColor.GRAY).append(Component.text((String)variantName, (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Available variants:", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        for (int i = 0; i < this.maxVariants; ++i) {
            String name = this.getVariantName(i);
            boolean isCurrent = i == this.currentVariantIndex;
            lore.add(((TextComponent)Component.text((String)(isCurrent ? "\u27a4 " : "  "), (TextColor)(isCurrent ? NamedTextColor.GREEN : NamedTextColor.GRAY)).append((Component)Component.text((String)name, (TextColor)(isCurrent ? NamedTextColor.GREEN : NamedTextColor.GRAY)))).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(Component.text((String)"Each variant has its", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"own recipe pattern", (TextColor)NamedTextColor.DARK_GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to switch variant", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        switcher.setItemMeta(meta);
        this.inventory.setItem(8, switcher);
    }

    private String getVariantName(int index) {
        IngredientChoice firstChoice = null;
        for (List<IngredientChoice> row : this.originalRecipe.getIngredientGrid()) {
            for (IngredientChoice choice : row) {
                if (!choice.hasMultipleOptions()) continue;
                firstChoice = choice;
                break;
            }
            if (firstChoice == null) continue;
            break;
        }
        if (firstChoice != null && index < firstChoice.getOptions().size()) {
            Material mat = firstChoice.getOptions().get(index);
            return MessageUtil.formatMaterialName(mat.name());
        }
        return "Variant " + (index + 1);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player dragPlayer;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        Object object = event.getWhoClicked();
        if (!(object instanceof Player) || !(dragPlayer = (Player)object).equals((Object)this.player)) {
            return;
        }
        object = event.getRawSlots().iterator();
        while (object.hasNext()) {
            int slot = (Integer)object.next();
            if (slot >= this.inventory.getSize()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player clicker;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player) || !(clicker = (Player)humanEntity).equals((Object)this.player)) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        if (slot == 8 && this.maxVariants > 1) {
            event.setCancelled(true);
            long now = System.currentTimeMillis();
            if (now - this.lastVariantSwitch < 200L) {
                return;
            }
            this.lastVariantSwitch = now;
            this.saveCurrentVariant();
            this.currentVariantIndex = (this.currentVariantIndex + 1) % this.maxVariants;
            String recipeKey = this.originalRecipe.getKey().replace("minecraft:", "");
            this.plugin.getVanillaRecipeManager().setCurrentVariant(recipeKey, this.currentVariantIndex);
            this.loadVariantPattern(this.currentVariantIndex);
            this.updateInventoryFast();
            return;
        }
        if (slot < 0 || slot >= 54) {
            return;
        }
        if (event.getClickedInventory() != this.inventory) {
            return;
        }
        if (slot == 25) {
            event.setCancelled(true);
            ItemStack result = this.inventory.getItem(25);
            if (clickType.isLeftClick()) {
                if (result != null && result.getType() != Material.AIR) {
                    int newAmount = Math.min(result.getAmount() + 1, result.getType().getMaxStackSize());
                    result.setAmount(newAmount);
                    this.inventory.setItem(25, result);
                }
            } else if (clickType.isRightClick() && result != null && result.getType() != Material.AIR && result.getAmount() > 1) {
                result.setAmount(result.getAmount() - 1);
                this.inventory.setItem(25, result);
            }
            return;
        }
        for (int i = 0; i < GRID_SLOTS.length; ++i) {
            if (slot != GRID_SLOTS[i]) continue;
            event.setCancelled(true);
            if (clickType.isLeftClick() && this.gridItems[i] != null) {
                this.gridItems[i] = null;
                this.updateInventory();
            } else if (event.getCursor() != null && event.getCursor().getType() != Material.AIR) {
                this.gridItems[i] = new ItemStack(event.getCursor().getType(), 1);
                this.updateInventory();
            }
            return;
        }
        event.setCancelled(true);
        if (slot == 45) {
            this.currentType = this.currentType == RecipeType.SHAPED ? RecipeType.SHAPELESS : RecipeType.SHAPED;
            this.updateInventory();
            return;
        }
        if (slot == 48) {
            this.saveRecipe();
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Saved recipe changes!");
            return;
        }
        if (slot == 50) {
            VanillaRecipesGUI gui = new VanillaRecipesGUI(this.plugin, this.player, this.parentGUI.getCurrentCategory(), this.parentGUI.getCurrentStation());
            gui.open();
            return;
        }
        if (slot == 51) {
            waitingForSearch.put(this.player.getUniqueId(), this);
            this.player.closeInventory();
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type the recipe name to search");
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type <red>cancel</red> to cancel");
            return;
        }
        if (slot == 53) {
            String recipeKey = this.originalRecipe.getKey().replace("minecraft:", "");
            this.plugin.getVanillaRecipeManager().resetRecipe(recipeKey);
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Reset recipe to original!");
            this.loadOriginalPattern();
            this.currentType = this.originalRecipe.getType();
            this.updateInventory();
            return;
        }
    }

    private void saveRecipe() {
        this.saveCurrentVariant();
        ItemStack resultItem = this.inventory.getItem(25);
        if (resultItem != null && resultItem.getAmount() != this.originalRecipe.getResultAmount()) {
            String recipeKey = this.originalRecipe.getKey().replace("minecraft:", "");
            VanillaRecipeManager.VanillaRecipeState state = this.plugin.getVanillaRecipeManager().getRecipeState(recipeKey);
            if (state != null) {
                state.setResultAmount(resultItem.getAmount());
            }
        }
        MessageUtil.sendAdminSuccess((CommandSender)this.player, "Saved variant: " + this.getVariantName(this.currentVariantIndex));
    }

    private void saveCurrentVariant() {
        ArrayList<String> pattern = new ArrayList<String>();
        for (int row = 0; row < 3; ++row) {
            StringBuilder rowPattern = new StringBuilder();
            for (int col = 0; col < 3; ++col) {
                ItemStack item = this.gridItems[row * 3 + col];
                if (item == null) {
                    rowPattern.append("AIR ");
                    continue;
                }
                rowPattern.append(item.getType().name()).append(" ");
            }
            pattern.add(rowPattern.toString().trim());
        }
        String recipeKey = this.originalRecipe.getKey().replace("minecraft:", "");
        this.plugin.getVanillaRecipeManager().updateRecipeVariant(recipeKey, this.currentVariantIndex, pattern, this.currentType);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player chatPlayer = event.getPlayer();
        VanillaRecipeEditorGUI editor = waitingForSearch.get(chatPlayer.getUniqueId());
        if (editor == null || !chatPlayer.equals((Object)this.player)) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            waitingForSearch.remove(chatPlayer.getUniqueId());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                MessageUtil.sendAdminWarning((CommandSender)chatPlayer, "Search cancelled");
                editor.open();
            });
            return;
        }
        List<VanillaRecipeInfo> results = this.plugin.getVanillaRecipeManager().searchRecipes(message);
        waitingForSearch.remove(chatPlayer.getUniqueId());
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (results.isEmpty()) {
                MessageUtil.sendError((CommandSender)chatPlayer, "No recipes found matching: " + message);
                editor.open();
            } else {
                new VanillaRecipeSearchResultsGUI(this.plugin, chatPlayer, results, message, this.parentGUI).open();
            }
        });
    }

    private void updateInventoryFast() {
        for (int slot : GRID_SLOTS) {
            this.inventory.setItem(slot, null);
        }
        if (this.maxVariants > 1) {
            this.addVariantSwitcher();
        }
        this.addResultItem();
        this.addGridItems();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player) && !waitingForSearch.containsKey(this.player.getUniqueId())) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
            AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

