/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.VanillaRecipeEditorGUI;
import org.hikarii.customrecipes.gui.VanillaRecipesGUI;
import org.hikarii.customrecipes.recipe.vanilla.VanillaRecipeInfo;
import org.hikarii.customrecipes.util.MessageUtil;

public class VanillaRecipeSearchResultsGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;
    private final List<VanillaRecipeInfo> results;
    private final String query;
    private final VanillaRecipesGUI parentGUI;
    private int page = 0;
    private static final int RESULTS_PER_PAGE = 45;

    public VanillaRecipeSearchResultsGUI(CustomRecipes plugin, Player player, List<VanillaRecipeInfo> results, String query, VanillaRecipesGUI parentGUI) {
        this.plugin = plugin;
        this.player = player;
        this.results = results;
        this.query = query;
        this.parentGUI = parentGUI;
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createMenuTitle("Search Results: " + query, NamedTextColor.LIGHT_PURPLE));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        ItemStack emptySlot = new ItemStack(Material.PURPLE_STAINED_GLASS_PANE);
        ItemMeta emptyMeta = emptySlot.getItemMeta();
        emptyMeta.displayName((Component)Component.empty());
        emptySlot.setItemMeta(emptyMeta);
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, emptySlot);
        }
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, this.results.size());
        for (int i = startIndex; i < endIndex; ++i) {
            VanillaRecipeInfo recipe = this.results.get(i);
            ItemStack item = this.createResultItem(recipe);
            this.inventory.setItem(i - startIndex, item);
        }
        this.addNavigationButtons();
        this.addInfoItem();
        this.addBackButton();
    }

    private ItemStack createResultItem(VanillaRecipeInfo recipe) {
        ItemStack item = new ItemStack(recipe.getResultMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)recipe.getDisplayName(), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Amount: " + recipe.getResultAmount() + "x"), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)("Category: " + recipe.getCategory().getDisplayName()), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Left Click to edit", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        String recipeKey = recipe.getKey().replace("minecraft:", "");
        boolean disabled = this.plugin.getVanillaRecipeManager().isRecipeDisabled(recipeKey);
        lore.add(Component.text((String)("\u00bb Right Click to " + (disabled ? "enable" : "disable")), (TextColor)(disabled ? NamedTextColor.GREEN : NamedTextColor.RED)).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void addNavigationButtons() {
        int maxPages = (int)Math.ceil((double)this.results.size() / 45.0);
        ItemStack prevButton = new ItemStack(Material.ARROW);
        ItemMeta prevMeta = prevButton.getItemMeta();
        prevMeta.displayName(Component.text((String)"\u25c0 Previous Page", (TextColor)(this.page > 0 ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false));
        if (this.page > 0) {
            prevMeta.lore(List.of((TextComponent)Component.text((String)("Page " + this.page + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            prevMeta.lore(List.of((TextComponent)Component.text((String)"Already on first page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        prevButton.setItemMeta(prevMeta);
        this.inventory.setItem(48, prevButton);
        ItemStack nextButton = new ItemStack(Material.ARROW);
        ItemMeta nextMeta = nextButton.getItemMeta();
        nextMeta.displayName(Component.text((String)"Next Page \u25b6", (TextColor)(this.page < maxPages - 1 ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false));
        if (this.page < maxPages - 1) {
            nextMeta.lore(List.of((TextComponent)Component.text((String)("Page " + (this.page + 2) + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            nextMeta.lore(List.of((TextComponent)Component.text((String)"Already on last page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        nextButton.setItemMeta(nextMeta);
        this.inventory.setItem(50, nextButton);
    }

    private void addInfoItem() {
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(Component.text((String)"Search Results", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        int maxPages = (int)Math.ceil((double)this.results.size() / 45.0);
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)("Query: " + this.query), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("Found: " + this.results.size() + " recipes"), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)("Page: " + (this.page + 1) + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        info.setItemMeta(meta);
        this.inventory.setItem(49, info);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(Component.text((String)"\u00ab Back", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        back.setItemMeta(meta);
        this.inventory.setItem(53, back);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int recipeIndex;
        Player clicker;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player) || !(clicker = (Player)humanEntity).equals((Object)this.player)) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        if (slot == 48 && this.page > 0) {
            --this.page;
            this.updateInventory();
            return;
        }
        int maxPages = (int)Math.ceil((double)this.results.size() / 45.0);
        if (slot == 50 && this.page < maxPages - 1) {
            ++this.page;
            this.updateInventory();
            return;
        }
        if (slot == 53) {
            new VanillaRecipesGUI(this.plugin, this.player).open();
            return;
        }
        if (slot < 45 && (recipeIndex = this.page * 45 + slot) < this.results.size()) {
            VanillaRecipeInfo recipe = this.results.get(recipeIndex);
            String recipeKey = recipe.getKey().replace("minecraft:", "");
            if (clickType.isRightClick()) {
                this.plugin.getVanillaRecipeManager().toggleRecipe(recipeKey);
                boolean nowDisabled = this.plugin.getVanillaRecipeManager().isRecipeDisabled(recipeKey);
                MessageUtil.send((CommandSender)this.player, (nowDisabled ? "Disabled" : "Enabled") + " vanilla recipe: " + recipe.getDisplayName(), (TextColor)(nowDisabled ? NamedTextColor.RED : NamedTextColor.GREEN));
                this.updateInventory();
            } else {
                new VanillaRecipeEditorGUI(this.plugin, this.player, recipe, this.parentGUI).open();
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

