/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.RecipeListGUI;
import org.hikarii.customrecipes.gui.VanillaRecipeEditorGUI;
import org.hikarii.customrecipes.gui.VanillaRecipeSearchResultsGUI;
import org.hikarii.customrecipes.recipe.vanilla.VanillaRecipeInfo;
import org.hikarii.customrecipes.util.MessageUtil;

public class VanillaRecipesGUI
implements Listener {
    private static final Map<UUID, VanillaRecipesGUI> waitingForSearch = new HashMap<UUID, VanillaRecipesGUI>();
    private final CustomRecipes plugin;
    private final Player player;
    private final Inventory inventory;
    private int page = 0;
    private static final int RECIPES_PER_PAGE = 45;
    private VanillaRecipeInfo.RecipeCategory currentCategory = null;
    private VanillaRecipeInfo.RecipeStation currentStation = VanillaRecipeInfo.RecipeStation.CRAFTING_TABLE;
    private List<VanillaRecipeInfo> displayedRecipes;
    private static final Map<UUID, VanillaRecipeInfo.RecipeCategory> savedCategories = new HashMap<UUID, VanillaRecipeInfo.RecipeCategory>();
    private static final Map<UUID, VanillaRecipeInfo.RecipeStation> savedStations = new HashMap<UUID, VanillaRecipeInfo.RecipeStation>();

    public VanillaRecipesGUI(CustomRecipes plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        VanillaRecipeInfo.RecipeCategory savedCat = savedCategories.get(player.getUniqueId());
        VanillaRecipeInfo.RecipeStation savedStat = savedStations.get(player.getUniqueId());
        if (savedCat != null) {
            this.currentCategory = savedCat;
        }
        if (savedStat != null) {
            this.currentStation = savedStat;
        }
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createMenuTitle("Vanilla Recipes", NamedTextColor.DARK_GREEN));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateDisplayedRecipes();
        this.updateInventory();
    }

    public VanillaRecipesGUI(CustomRecipes plugin, Player player, VanillaRecipeInfo.RecipeCategory category, VanillaRecipeInfo.RecipeStation station) {
        this.plugin = plugin;
        this.player = player;
        this.currentCategory = category;
        this.currentStation = station;
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createMenuTitle("Vanilla Recipes", NamedTextColor.DARK_GREEN));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateDisplayedRecipes();
        this.updateInventory();
    }

    public void open() {
        savedCategories.put(this.player.getUniqueId(), this.currentCategory);
        savedStations.put(this.player.getUniqueId(), this.currentStation);
        this.player.openInventory(this.inventory);
    }

    private void updateDisplayedRecipes() {
        List<VanillaRecipeInfo> allRecipes = new ArrayList<VanillaRecipeInfo>(this.plugin.getVanillaRecipeManager().getAllVanillaRecipes().values());
        if (this.currentStation != null) {
            allRecipes = allRecipes.stream().filter(r -> r.getStation() == this.currentStation).collect(Collectors.toList());
        }
        if (this.currentCategory != null) {
            allRecipes = allRecipes.stream().filter(r -> r.getCategory() == this.currentCategory).collect(Collectors.toList());
        }
        this.displayedRecipes = allRecipes;
    }

    private void updateInventory() {
        this.inventory.clear();
        ItemStack emptySlot = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
        ItemMeta emptyMeta = emptySlot.getItemMeta();
        emptyMeta.displayName((Component)Component.empty());
        emptySlot.setItemMeta(emptyMeta);
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, emptySlot);
        }
        this.addRecipeItems();
        this.addNavigationButtons();
        this.addFilterButtons();
        this.addInfoItem();
        this.addSearchButton();
        this.addBackButton();
    }

    private void addRecipeItems() {
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, this.displayedRecipes.size());
        for (int i = startIndex; i < endIndex; ++i) {
            VanillaRecipeInfo recipe = this.displayedRecipes.get(i);
            ItemStack item = this.createRecipeItem(recipe);
            this.inventory.setItem(i - startIndex, item);
        }
    }

    private ItemStack createRecipeItem(VanillaRecipeInfo recipe) {
        String statusText;
        NamedTextColor nameColor;
        String recipeKey = recipe.getKey().replace("minecraft:", "");
        ItemStack item = new ItemStack(recipe.getResultMaterial());
        ItemMeta meta = item.getItemMeta();
        boolean disabled = this.plugin.getVanillaRecipeManager().isRecipeDisabled(recipeKey);
        boolean changed = this.plugin.getVanillaRecipeManager().isRecipeChanged(recipeKey);
        if (disabled) {
            nameColor = NamedTextColor.RED;
            statusText = "\u2717 Disabled";
        } else if (changed) {
            nameColor = NamedTextColor.YELLOW;
            statusText = "\u26a1 Modified";
        } else {
            nameColor = NamedTextColor.GREEN;
            statusText = "\u2713 Enabled";
        }
        Component displayName = Component.text((String)recipe.getDisplayName(), (TextColor)nameColor).decoration(TextDecoration.ITALIC, false);
        meta.displayName(displayName);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)"Status: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)statusText, (TextColor)nameColor))).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)"Amount: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(recipe.getResultAmount() + "x"), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)"Category: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)recipe.getCategory().getDisplayName(), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Left Click to edit", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        lore.add(Component.text((String)("\u00bb Right Click to " + (disabled ? "enable" : "disable")), (TextColor)(disabled ? NamedTextColor.GREEN : NamedTextColor.RED)).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private void addNavigationButtons() {
        int maxPages = (int)Math.ceil((double)this.displayedRecipes.size() / 45.0);
        ItemStack prevButton = new ItemStack(Material.ARROW);
        ItemMeta prevMeta = prevButton.getItemMeta();
        prevMeta.displayName(Component.text((String)"\u25c0 Previous Page", (TextColor)(this.page > 0 ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false));
        if (this.page > 0) {
            prevMeta.lore(List.of((TextComponent)Component.text((String)("Page " + this.page + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            prevMeta.lore(List.of((TextComponent)Component.text((String)"Already on first page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        prevButton.setItemMeta(prevMeta);
        this.inventory.setItem(48, prevButton);
        ItemStack nextButton = new ItemStack(Material.ARROW);
        ItemMeta nextMeta = nextButton.getItemMeta();
        nextMeta.displayName(Component.text((String)"Next Page \u25b6", (TextColor)(this.page < maxPages - 1 ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY)).decoration(TextDecoration.ITALIC, false));
        if (this.page < maxPages - 1) {
            nextMeta.lore(List.of((TextComponent)Component.text((String)("Page " + (this.page + 2) + "/" + maxPages), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        } else {
            nextMeta.lore(List.of((TextComponent)Component.text((String)"Already on last page", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        }
        nextButton.setItemMeta(nextMeta);
        this.inventory.setItem(50, nextButton);
    }

    private void addFilterButtons() {
        ItemStack stationButton = new ItemStack(this.currentStation.getIcon());
        ItemMeta stationMeta = stationButton.getItemMeta();
        stationMeta.displayName(((TextComponent)Component.text((String)("Station: " + this.currentStation.getDisplayName()), (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> stationLore = new ArrayList<Object>();
        stationLore.add(Component.empty());
        stationLore.add(Component.text((String)"Click to change station", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        stationLore.add(Component.empty());
        for (VanillaRecipeInfo.RecipeStation station : VanillaRecipeInfo.RecipeStation.values()) {
            NamedTextColor color = station == this.currentStation ? NamedTextColor.GREEN : (station.isEnabled() ? NamedTextColor.YELLOW : NamedTextColor.DARK_GRAY);
            stationLore.add(Component.text((String)("  \u2022 " + station.getDisplayName()), (TextColor)color).decoration(TextDecoration.ITALIC, false));
        }
        stationMeta.lore(stationLore);
        stationButton.setItemMeta(stationMeta);
        this.inventory.setItem(46, stationButton);
        ItemStack categoryButton = new ItemStack(this.currentCategory != null ? this.currentCategory.getIcon() : Material.CHEST);
        ItemMeta categoryMeta = categoryButton.getItemMeta();
        categoryMeta.displayName(((TextComponent)Component.text((String)("Category: " + (this.currentCategory != null ? this.currentCategory.getDisplayName() : "All")), (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> categoryLore = new ArrayList<Object>();
        categoryLore.add(Component.empty());
        categoryLore.add(Component.text((String)"Click to change category", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        categoryLore.add(Component.empty());
        categoryLore.add(Component.text((String)"  \u2022 All Categories", (TextColor)(this.currentCategory == null ? NamedTextColor.GREEN : NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
        for (VanillaRecipeInfo.RecipeCategory category : VanillaRecipeInfo.RecipeCategory.values()) {
            NamedTextColor color = category == this.currentCategory ? NamedTextColor.GREEN : NamedTextColor.YELLOW;
            categoryLore.add(Component.text((String)("  \u2022 " + category.getDisplayName()), (TextColor)color).decoration(TextDecoration.ITALIC, false));
        }
        categoryMeta.lore(categoryLore);
        categoryButton.setItemMeta(categoryMeta);
        this.inventory.setItem(47, categoryButton);
    }

    private void addSearchButton() {
        ItemStack search = new ItemStack(Material.COMPASS);
        ItemMeta meta = search.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Search Recipe", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(Component.empty(), (TextComponent)Component.text((String)"Search recipes by name", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), Component.empty(), (TextComponent)Component.text((String)"\u00bb Click to search", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true)));
        search.setItemMeta(meta);
        this.inventory.setItem(45, search);
    }

    private void addInfoItem() {
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(Component.text((String)"Vanilla Recipes", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)("Total Recipes: " + this.displayedRecipes.size()), (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Left Click to edit recipe", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"Right Click to toggle enable/disable", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        info.setItemMeta(meta);
        this.inventory.setItem(49, info);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(Component.text((String)"\u00ab Back to Main Menu", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        back.setItemMeta(meta);
        this.inventory.setItem(53, back);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int recipeIndex;
        Player clicker;
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player) || !(clicker = (Player)humanEntity).equals((Object)this.player)) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        if (slot == 48 && this.page > 0) {
            --this.page;
            this.updateInventory();
            return;
        }
        int maxPages = (int)Math.ceil((double)this.displayedRecipes.size() / 45.0);
        if (slot == 50 && this.page < maxPages - 1) {
            ++this.page;
            this.updateInventory();
            return;
        }
        if (slot == 45) {
            waitingForSearch.put(this.player.getUniqueId(), this);
            this.player.closeInventory();
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type the recipe name to search (partial names allowed)");
            MessageUtil.sendAdminInfo((CommandSender)this.player, "Type <red>cancel</red> to cancel");
            return;
        }
        if (slot == 46) {
            this.cycleStation();
            return;
        }
        if (slot == 47) {
            this.cycleCategory();
            return;
        }
        if (slot == 53) {
            new RecipeListGUI(this.plugin, this.player).open();
            return;
        }
        if (slot < 0 || slot >= 54) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR || clicked.getType() == Material.LIME_STAINED_GLASS_PANE) {
            return;
        }
        if (slot >= 0 && slot < 45 && (recipeIndex = this.page * 45 + slot) >= 0 && recipeIndex < this.displayedRecipes.size()) {
            VanillaRecipeInfo recipe = this.displayedRecipes.get(recipeIndex);
            String recipeKey = recipe.getKey().replace("minecraft:", "");
            if (clickType.isRightClick()) {
                this.plugin.getVanillaRecipeManager().toggleRecipe(recipeKey);
                boolean nowDisabled = this.plugin.getVanillaRecipeManager().isRecipeDisabled(recipeKey);
                MessageUtil.send((CommandSender)this.player, (nowDisabled ? "Disabled" : "Enabled") + " vanilla recipe: " + recipe.getDisplayName(), (TextColor)(nowDisabled ? NamedTextColor.RED : NamedTextColor.GREEN));
                this.updateInventory();
            } else {
                new VanillaRecipeEditorGUI(this.plugin, this.player, recipe, this).open();
            }
        }
    }

    private void cycleStation() {
        int currentIndex;
        VanillaRecipeInfo.RecipeStation[] stations = VanillaRecipeInfo.RecipeStation.values();
        int nextIndex = currentIndex = Arrays.asList(stations).indexOf((Object)this.currentStation);
        do {
            if (!stations[nextIndex = (nextIndex + 1) % stations.length].isEnabled()) continue;
            this.currentStation = stations[nextIndex];
            this.page = 0;
            this.updateDisplayedRecipes();
            this.updateInventory();
            savedStations.put(this.player.getUniqueId(), this.currentStation);
            return;
        } while (nextIndex != currentIndex);
        MessageUtil.sendAdminWarning((CommandSender)this.player, "Other stations coming soon!");
    }

    private void cycleCategory() {
        int currentIndex;
        VanillaRecipeInfo.RecipeCategory[] categories = VanillaRecipeInfo.RecipeCategory.values();
        this.currentCategory = this.currentCategory == null ? categories[0] : ((currentIndex = Arrays.asList(categories).indexOf((Object)this.currentCategory)) == categories.length - 1 ? null : categories[currentIndex + 1]);
        this.page = 0;
        this.updateDisplayedRecipes();
        this.updateInventory();
        savedCategories.put(this.player.getUniqueId(), this.currentCategory);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player chatPlayer = event.getPlayer();
        VanillaRecipesGUI gui = waitingForSearch.get(chatPlayer.getUniqueId());
        if (gui == null || !chatPlayer.equals((Object)this.player)) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            waitingForSearch.remove(chatPlayer.getUniqueId());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                MessageUtil.sendAdminWarning((CommandSender)chatPlayer, "Search cancelled");
                gui.open();
            });
            return;
        }
        List<VanillaRecipeInfo> results = this.plugin.getVanillaRecipeManager().searchRecipes(message);
        waitingForSearch.remove(chatPlayer.getUniqueId());
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (results.isEmpty()) {
                MessageUtil.sendError((CommandSender)chatPlayer, "No recipes found matching: " + message);
                gui.open();
            } else {
                new VanillaRecipeSearchResultsGUI(this.plugin, chatPlayer, results, message, gui).open();
            }
        });
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player) && !waitingForSearch.containsKey(this.player.getUniqueId())) {
            savedCategories.remove(this.player.getUniqueId());
            savedStations.remove(this.player.getUniqueId());
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
            AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
        }
    }

    public void reopen() {
        this.updateDisplayedRecipes();
        this.updateInventory();
        this.open();
    }

    public VanillaRecipeInfo.RecipeCategory getCurrentCategory() {
        return this.currentCategory;
    }

    public VanillaRecipeInfo.RecipeStation getCurrentStation() {
        return this.currentStation;
    }
}

