/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.gui;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.gui.RecipeEditorGUI;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.util.MessageUtil;

public class WorldSettingsGUI
implements Listener {
    private final CustomRecipes plugin;
    private final Player player;
    private final CustomRecipe recipe;
    private final Inventory inventory;
    private final List<World> worlds;

    public WorldSettingsGUI(CustomRecipes plugin, Player player, CustomRecipe recipe) {
        this.plugin = plugin;
        this.player = player;
        this.recipe = recipe;
        this.worlds = new ArrayList<World>(Bukkit.getWorlds());
        this.inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.createMenuTitle("World Settings: " + recipe.getKey(), NamedTextColor.DARK_AQUA));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.updateInventory();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.clear();
        this.fillBorders();
        this.addInfoItem();
        this.addWorldButtons();
        this.addEnableAllButton();
        this.addDisableAllButton();
        this.addBackButton();
    }

    private void fillBorders() {
        int i;
        ItemStack borderPane = new ItemStack(Material.CYAN_STAINED_GLASS_PANE);
        ItemMeta meta = borderPane.getItemMeta();
        meta.displayName((Component)Component.empty());
        borderPane.setItemMeta(meta);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, borderPane);
            this.inventory.setItem(45 + i, borderPane);
        }
        for (i = 1; i < 5; ++i) {
            this.inventory.setItem(i * 9, borderPane);
            this.inventory.setItem(i * 9 + 8, borderPane);
        }
    }

    private void addInfoItem() {
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta meta = info.getItemMeta();
        meta.displayName(Component.text((String)"World Restrictions", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Configure which worlds", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"this recipe works in", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Green = Recipe Enabled", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"Red = Recipe Disabled", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Click a world to toggle", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        info.setItemMeta(meta);
        this.inventory.setItem(4, info);
    }

    private void addWorldButtons() {
        List<String> disabledWorlds = this.plugin.getRecipeWorldManager().getDisabledWorlds(this.recipe.getKey());
        int slot = 10;
        for (World world : this.worlds) {
            if (slot == 17 || slot == 26 || slot == 35) {
                slot += 2;
            }
            if (slot > 43) break;
            boolean isEnabled = !disabledWorlds.contains(world.getName());
            this.addWorldButton(slot, world, isEnabled);
            ++slot;
        }
    }

    private void addWorldButton(int slot, World world, boolean enabled) {
        Material icon = switch (world.getEnvironment()) {
            case World.Environment.NORMAL -> Material.GRASS_BLOCK;
            case World.Environment.NETHER -> Material.NETHERRACK;
            case World.Environment.THE_END -> Material.END_STONE;
            default -> Material.COMMAND_BLOCK;
        };
        ItemStack item = new ItemStack(icon);
        ItemMeta meta = item.getItemMeta();
        NamedTextColor nameColor = enabled ? NamedTextColor.GREEN : NamedTextColor.RED;
        meta.displayName(((TextComponent)Component.text((String)world.getName(), (TextColor)nameColor).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        String worldType = switch (world.getEnvironment()) {
            case World.Environment.NORMAL -> "Overworld";
            case World.Environment.NETHER -> "Nether";
            case World.Environment.THE_END -> "The End";
            default -> "Custom";
        };
        lore.add(((TextComponent)Component.text((String)"Type: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)worldType, (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        int playerCount = world.getPlayers().size();
        lore.add(((TextComponent)Component.text((String)"Players: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(playerCount + " online"), (TextColor)NamedTextColor.WHITE))).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"Recipe Status:", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)(enabled ? "\u2713 Enabled" : "\u2717 Disabled"), (TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED)).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)("\u00bb Click to " + (enabled ? "disable" : "enable")), (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        if (enabled) {
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.lore(lore);
        item.setItemMeta(meta);
        this.inventory.setItem(slot, item);
    }

    private void addEnableAllButton() {
        ItemStack button = new ItemStack(Material.LIME_WOOL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Enable in All Worlds", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Allow this recipe to", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"work in all worlds", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to enable all", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(47, button);
    }

    private void addDisableAllButton() {
        ItemStack button = new ItemStack(Material.RED_WOOL);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Disable in All Worlds", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(Component.empty());
        lore.add(Component.text((String)"Prevent this recipe from", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.text((String)"working in all worlds", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        lore.add(Component.text((String)"\u00bb Click to disable all", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, true));
        meta.lore(lore);
        button.setItemMeta(meta);
        this.inventory.setItem(51, button);
    }

    private void addBackButton() {
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta meta = back.getItemMeta();
        meta.displayName(Component.text((String)"\u00ab Back to Recipe Editor", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.ITALIC, false));
        back.setItemMeta(meta);
        this.inventory.setItem(49, back);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player clicker = (Player)humanEntity;
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 49) {
            new RecipeEditorGUI(this.plugin, this.player, this.recipe).open();
            return;
        }
        if (!this.player.hasPermission("customrecipes.manage")) {
            MessageUtil.sendError((CommandSender)this.player, "You don't have permission to manage world settings.");
            return;
        }
        if (slot == 47) {
            this.plugin.getRecipeWorldManager().setRecipeWorldRestrictions(this.recipe.getKey(), new ArrayList<String>());
            MessageUtil.sendAdminSuccess((CommandSender)this.player, "Enabled recipe in all worlds");
            this.updateInventory();
            return;
        }
        if (slot == 51) {
            List<String> allWorlds = this.worlds.stream().map(WorldInfo::getName).toList();
            this.plugin.getRecipeWorldManager().setRecipeWorldRestrictions(this.recipe.getKey(), allWorlds);
            MessageUtil.sendAdminWarning((CommandSender)this.player, "Disabled recipe in all worlds");
            this.updateInventory();
            return;
        }
        if (slot >= 10 && slot <= 43 && slot % 9 != 0 && slot % 9 != 8) {
            boolean nowEnabled;
            int index = this.calculateWorldIndex(slot);
            if (index < 0 || index >= this.worlds.size()) {
                return;
            }
            World world = this.worlds.get(index);
            this.plugin.getRecipeWorldManager().toggleWorldRestriction(this.recipe.getKey(), world.getName());
            List<String> disabledWorlds = this.plugin.getRecipeWorldManager().getDisabledWorlds(this.recipe.getKey());
            boolean bl = nowEnabled = !disabledWorlds.contains(world.getName());
            if (nowEnabled) {
                MessageUtil.sendAdminSuccess((CommandSender)this.player, "Enabled recipe in world: " + world.getName());
            } else {
                MessageUtil.sendAdminWarning((CommandSender)this.player, "Disabled recipe in world: " + world.getName());
            }
            this.updateInventory();
        }
    }

    private int calculateWorldIndex(int slot) {
        int row = slot / 9;
        int col = slot % 9;
        if (row < 1 || row > 4 || col < 1 || col > 7) {
            return -1;
        }
        int baseIndex = (row - 1) * 7;
        int index = baseIndex + (col - 1);
        return index;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory) && event.getPlayer().equals((Object)this.player)) {
            InventoryClickEvent.getHandlerList().unregister((Listener)this);
            InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        }
    }
}

