/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.listener;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.RecipeIngredient;

public class RecipeCraftListener
implements Listener {
    private final CustomRecipes plugin;

    public RecipeCraftListener(CustomRecipes plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraftItem(CraftItemEvent event) {
        ItemStack actual;
        RecipeIngredient required;
        int i;
        CraftingInventory inventory;
        ItemStack[] matrix;
        CustomRecipe exactMatchRecipe;
        if (event.isCancelled()) {
            return;
        }
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        NamespacedKey key = null;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            key = shapedRecipe.getKey();
        }
        if (key == null || !key.getNamespace().equals(this.plugin.getName().toLowerCase())) {
            return;
        }
        String recipeKey = key.getKey();
        CustomRecipe customRecipe = this.plugin.getRecipeManager().getRecipe(recipeKey);
        if (customRecipe == null || customRecipe.getType() != RecipeType.SHAPED) {
            return;
        }
        if (this.plugin.isDebugMode()) {
            this.plugin.getLogger().info("[CRAFT] Recipe selected by Bukkit: " + recipeKey);
        }
        if ((exactMatchRecipe = this.findExactMatchRecipe(matrix = (inventory = event.getInventory()).getMatrix())) != null && !exactMatchRecipe.getKey().equals(recipeKey)) {
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("[CRAFT] Found more specific recipe with exact-ingredients: " + exactMatchRecipe.getKey());
            }
            customRecipe = exactMatchRecipe;
            boolean useCraftedNames = this.plugin.isUseCraftedCustomNames();
            boolean keepSpawnEggNames = this.plugin.isKeepSpawnEggNames();
            ItemStack correctResult = exactMatchRecipe.createResult(useCraftedNames, keepSpawnEggNames);
            inventory.setResult(correctResult);
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("[CRAFT] Replaced result with: " + String.valueOf(correctResult.getType()));
            }
        }
        List<RecipeIngredient> ingredients = customRecipe.getRecipeData().ingredients();
        for (i = 0; i < Math.min(matrix.length, ingredients.size()); ++i) {
            required = ingredients.get(i);
            actual = matrix[i];
            if (required.material() == Material.AIR || actual == null || actual.getType() != required.material()) continue;
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("[CRAFT] Slot " + i + ": hasExactItem=" + required.hasExactItem());
            }
            if (!required.hasExactItem()) continue;
            ItemStack exactItem = required.getExactItem();
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("[CRAFT] Slot " + i + " exact: " + String.valueOf(exactItem.getType()) + " actual: " + String.valueOf(actual.getType()));
            }
            if (!actual.hasItemMeta() && exactItem.hasItemMeta()) {
                if (this.plugin.isDebugMode()) {
                    this.plugin.getLogger().info("[CRAFT] CANCELLED: actual has no meta but exact does");
                }
                event.setCancelled(true);
                return;
            }
            if (!actual.hasItemMeta() || !exactItem.hasItemMeta()) continue;
            ItemMeta actualMeta = actual.getItemMeta();
            ItemMeta exactMeta = exactItem.getItemMeta();
            if (exactMeta instanceof Damageable && actualMeta instanceof Damageable) {
                Damageable exactDamageable = (Damageable)exactMeta;
                Damageable actualDamageable = (Damageable)actualMeta;
                if (this.plugin.isDebugMode()) {
                    this.plugin.getLogger().info("[CRAFT] Durability check: exact=" + exactDamageable.getDamage() + " actual=" + actualDamageable.getDamage());
                }
                if (exactDamageable.hasDamage() && exactDamageable.getDamage() != actualDamageable.getDamage()) {
                    if (this.plugin.isDebugMode()) {
                        this.plugin.getLogger().info("[CRAFT] CANCELLED: durability mismatch");
                    }
                    event.setCancelled(true);
                    return;
                }
            }
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("[CRAFT] Enchants: exact=" + String.valueOf(exactMeta.getEnchants()) + " actual=" + String.valueOf(actualMeta.getEnchants()));
            }
            if (!actualMeta.getEnchants().equals(exactMeta.getEnchants())) {
                if (this.plugin.isDebugMode()) {
                    this.plugin.getLogger().info("[CRAFT] CANCELLED: enchantments mismatch");
                }
                event.setCancelled(true);
                return;
            }
            if (exactMeta instanceof EnchantmentStorageMeta && actualMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta exactBook = (EnchantmentStorageMeta)exactMeta;
                EnchantmentStorageMeta actualBook = (EnchantmentStorageMeta)actualMeta;
                if (this.plugin.isDebugMode()) {
                    this.plugin.getLogger().info("[CRAFT] Stored enchants: exact=" + String.valueOf(exactBook.getStoredEnchants()) + " actual=" + String.valueOf(actualBook.getStoredEnchants()));
                }
                if (!actualBook.getStoredEnchants().equals(exactBook.getStoredEnchants())) {
                    if (this.plugin.isDebugMode()) {
                        this.plugin.getLogger().info("[CRAFT] CANCELLED: stored enchantments mismatch");
                    }
                    event.setCancelled(true);
                    return;
                }
            }
            if (actualMeta.getPersistentDataContainer().getKeys().equals(exactMeta.getPersistentDataContainer().getKeys())) continue;
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("[CRAFT] CANCELLED: NBT mismatch");
            }
            event.setCancelled(true);
            return;
        }
        if (this.plugin.isDebugMode()) {
            this.plugin.getLogger().info("[CRAFT] All checks passed!");
        }
        for (i = 0; i < Math.min(matrix.length, ingredients.size()); ++i) {
            required = ingredients.get(i);
            actual = matrix[i];
            if (required.material() == Material.AIR || actual == null || actual.getType() != required.material() || required.amount() <= 1) continue;
            actual.setAmount(actual.getAmount() - (required.amount() - 1));
        }
    }

    private CustomRecipe findExactMatchRecipe(ItemStack[] matrix) {
        if (matrix == null || matrix.length != 9) {
            return null;
        }
        for (CustomRecipe recipe : this.plugin.getRecipeManager().getAllRecipes()) {
            List<RecipeIngredient> ingredients;
            if (recipe.getType() != RecipeType.SHAPED || (ingredients = recipe.getRecipeData().ingredients()).size() != 9) continue;
            boolean hasExactIngredient = false;
            for (RecipeIngredient ingredient : ingredients) {
                if (!ingredient.hasExactItem()) continue;
                hasExactIngredient = true;
                break;
            }
            if (!hasExactIngredient) continue;
            boolean allIngredientsMatch = true;
            for (int i = 0; i < 9; ++i) {
                RecipeIngredient required = ingredients.get(i);
                ItemStack actual = matrix[i];
                if (required.material() == Material.AIR) {
                    if (actual == null || actual.getType() == Material.AIR) continue;
                    allIngredientsMatch = false;
                    break;
                }
                if (actual == null || actual.getType() != required.material()) {
                    allIngredientsMatch = false;
                    break;
                }
                if (!required.hasExactItem()) continue;
                ItemStack exactItem = required.getExactItem();
                if (!actual.hasItemMeta() && exactItem.hasItemMeta()) {
                    allIngredientsMatch = false;
                    break;
                }
                if (!actual.hasItemMeta() || !exactItem.hasItemMeta()) continue;
                ItemMeta actualMeta = actual.getItemMeta();
                ItemMeta exactMeta = exactItem.getItemMeta();
                if (exactItem.getType() == Material.ENCHANTED_BOOK && exactMeta instanceof EnchantmentStorageMeta && actualMeta instanceof EnchantmentStorageMeta) {
                    EnchantmentStorageMeta exactBook = (EnchantmentStorageMeta)exactMeta;
                    EnchantmentStorageMeta actualBook = (EnchantmentStorageMeta)actualMeta;
                    if (!actualBook.getStoredEnchants().equals(exactBook.getStoredEnchants())) {
                        allIngredientsMatch = false;
                        break;
                    }
                }
                if (exactMeta instanceof Damageable && actualMeta instanceof Damageable) {
                    Damageable exactDamageable = (Damageable)exactMeta;
                    Damageable actualDamageable = (Damageable)actualMeta;
                    if (exactDamageable.hasDamage() && exactDamageable.getDamage() != actualDamageable.getDamage()) {
                        allIngredientsMatch = false;
                        break;
                    }
                }
                if (actualMeta.getEnchants().equals(exactMeta.getEnchants())) continue;
                allIngredientsMatch = false;
                break;
            }
            if (!allIngredientsMatch) continue;
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("[CRAFT] Found recipe with exact-ingredients: " + recipe.getKey());
            }
            return recipe;
        }
        return null;
    }
}

