/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.listener;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.recipe.CustomRecipe;

public class RecipeHidingListener
implements Listener {
    private final CustomRecipes plugin;

    public RecipeHidingListener(CustomRecipes plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        String recipeKey;
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        NamespacedKey key = null;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            key = shapedRecipe.getKey();
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            key = shapelessRecipe.getKey();
        } else {
            return;
        }
        if (key.getNamespace().equals("minecraft")) {
            recipeKey = key.getKey();
            if (this.plugin.getVanillaRecipeManager().isRecipeDisabled(recipeKey)) {
                CraftingInventory inventory = event.getInventory();
                inventory.setResult(null);
                this.plugin.debug("Blocked disabled vanilla recipe: " + recipeKey);
                return;
            }
        }
        if (!key.getNamespace().equals(this.plugin.getName().toLowerCase())) {
            return;
        }
        recipeKey = key.getKey();
        CustomRecipe customRecipe = this.plugin.getRecipeManager().getRecipe(recipeKey);
        if (customRecipe == null || !customRecipe.isHidden()) {
            return;
        }
        HumanEntity humanEntity = event.getView().getPlayer();
        if (humanEntity instanceof Player) {
            CraftingInventory inventory;
            Player player = (Player)humanEntity;
            if (!this.plugin.getRecipeWorldManager().isRecipeAllowedForPlayer(recipeKey, player)) {
                inventory = event.getInventory();
                inventory.setResult(null);
                this.plugin.debug("Recipe " + recipeKey + " is disabled in world " + player.getWorld().getName());
                return;
            }
            if (customRecipe.isHidden() && !this.plugin.getRecipeDataManager().hasDiscovered(player, recipeKey)) {
                inventory = event.getInventory();
                inventory.setResult(null);
                this.plugin.debug("Hiding recipe " + recipeKey + " from " + player.getName());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCraftItem(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Recipe recipe = event.getRecipe();
        NamespacedKey key = null;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            key = shapedRecipe.getKey();
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            key = shapelessRecipe.getKey();
        } else {
            return;
        }
        if (!key.getNamespace().equals(this.plugin.getName().toLowerCase())) {
            return;
        }
        String recipeKey = key.getKey();
        CustomRecipe customRecipe = this.plugin.getRecipeManager().getRecipe(recipeKey);
        if (customRecipe == null || !customRecipe.isHidden()) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.plugin.getRecipeDataManager().hasDiscovered(player, recipeKey)) {
                this.plugin.getRecipeDataManager().markDiscovered(player, recipeKey);
            }
        }
    }
}

