/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.listener;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.RecipeIngredient;

public class RecipePreviewListener
implements Listener {
    private final CustomRecipes plugin;

    public RecipePreviewListener(CustomRecipes plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        NamespacedKey key = null;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            key = shapedRecipe.getKey();
        }
        if (key == null || !key.getNamespace().equals(this.plugin.getName().toLowerCase())) {
            return;
        }
        String recipeKey = key.getKey();
        CustomRecipe customRecipe = this.plugin.getRecipeManager().getRecipe(recipeKey);
        if (customRecipe == null || customRecipe.getType() != RecipeType.SHAPED) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        ItemStack[] matrix = inventory.getMatrix();
        CustomRecipe exactMatchRecipe = this.findExactMatchRecipe(matrix);
        if (exactMatchRecipe != null && !exactMatchRecipe.getKey().equals(recipeKey)) {
            customRecipe = exactMatchRecipe;
            boolean useCraftedNames = this.plugin.isUseCraftedCustomNames();
            boolean keepSpawnEggNames = this.plugin.isKeepSpawnEggNames();
            ItemStack correctResult = exactMatchRecipe.createResult(useCraftedNames, keepSpawnEggNames);
            inventory.setResult(correctResult);
        }
        List<RecipeIngredient> ingredients = customRecipe.getRecipeData().ingredients();
        for (int i = 0; i < Math.min(matrix.length, ingredients.size()); ++i) {
            RecipeIngredient required = ingredients.get(i);
            ItemStack actual = matrix[i];
            if (required.material() == Material.AIR || actual == null || actual.getType() != required.material() || !required.hasExactItem()) continue;
            ItemStack exactItem = required.getExactItem();
            if (exactItem.getType() == Material.ENCHANTED_BOOK && exactItem.hasItemMeta() && actual.hasItemMeta() && exactItem.getItemMeta() instanceof EnchantmentStorageMeta && actual.getItemMeta() instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta exactBook = (EnchantmentStorageMeta)exactItem.getItemMeta();
                EnchantmentStorageMeta actualBook = (EnchantmentStorageMeta)actual.getItemMeta();
                if (!actualBook.getStoredEnchants().equals(exactBook.getStoredEnchants())) {
                    inventory.setResult(null);
                    return;
                }
            }
            if (!exactItem.hasItemMeta() || !actual.hasItemMeta()) continue;
            ItemMeta exactMeta = exactItem.getItemMeta();
            ItemMeta actualMeta = actual.getItemMeta();
            if (exactMeta instanceof Damageable && actualMeta instanceof Damageable) {
                Damageable exactDamageable = (Damageable)exactMeta;
                Damageable actualDamageable = (Damageable)actualMeta;
                if (exactDamageable.hasDamage() && exactDamageable.getDamage() != actualDamageable.getDamage()) {
                    inventory.setResult(null);
                    return;
                }
            }
            if (actualMeta.getEnchants().equals(exactMeta.getEnchants())) continue;
            inventory.setResult(null);
            return;
        }
    }

    private CustomRecipe findExactMatchRecipe(ItemStack[] matrix) {
        if (matrix == null || matrix.length != 9) {
            return null;
        }
        for (CustomRecipe recipe : this.plugin.getRecipeManager().getAllRecipes()) {
            List<RecipeIngredient> ingredients;
            if (recipe.getType() != RecipeType.SHAPED || (ingredients = recipe.getRecipeData().ingredients()).size() != 9) continue;
            boolean hasExactIngredient = false;
            for (RecipeIngredient ingredient : ingredients) {
                if (!ingredient.hasExactItem()) continue;
                hasExactIngredient = true;
                break;
            }
            if (!hasExactIngredient) continue;
            boolean allIngredientsMatch = true;
            for (int i = 0; i < 9; ++i) {
                RecipeIngredient required = ingredients.get(i);
                ItemStack actual = matrix[i];
                if (required.material() == Material.AIR) {
                    if (actual == null || actual.getType() == Material.AIR) continue;
                    allIngredientsMatch = false;
                    break;
                }
                if (actual == null || actual.getType() != required.material()) {
                    allIngredientsMatch = false;
                    break;
                }
                if (!required.hasExactItem()) continue;
                ItemStack exactItem = required.getExactItem();
                if (!actual.hasItemMeta() && exactItem.hasItemMeta()) {
                    allIngredientsMatch = false;
                    break;
                }
                if (!actual.hasItemMeta() || !exactItem.hasItemMeta()) continue;
                ItemMeta actualMeta = actual.getItemMeta();
                ItemMeta exactMeta = exactItem.getItemMeta();
                if (exactItem.getType() == Material.ENCHANTED_BOOK && exactMeta instanceof EnchantmentStorageMeta && actualMeta instanceof EnchantmentStorageMeta) {
                    EnchantmentStorageMeta exactBook = (EnchantmentStorageMeta)exactMeta;
                    EnchantmentStorageMeta actualBook = (EnchantmentStorageMeta)actualMeta;
                    if (!actualBook.getStoredEnchants().equals(exactBook.getStoredEnchants())) {
                        allIngredientsMatch = false;
                        break;
                    }
                }
                if (exactMeta instanceof Damageable && actualMeta instanceof Damageable) {
                    Damageable exactDamageable = (Damageable)exactMeta;
                    Damageable actualDamageable = (Damageable)actualMeta;
                    if (exactDamageable.hasDamage() && exactDamageable.getDamage() != actualDamageable.getDamage()) {
                        allIngredientsMatch = false;
                        break;
                    }
                }
                if (actualMeta.getEnchants().equals(exactMeta.getEnchants())) continue;
                allIngredientsMatch = false;
                break;
            }
            if (!allIngredientsMatch) continue;
            return recipe;
        }
        return null;
    }
}

