/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.ShapedRecipeData;
import org.hikarii.customrecipes.recipe.data.ShapelessRecipeData;
import org.hikarii.customrecipes.util.MessageUtil;

public class CustomRecipe {
    private final String key;
    private final String name;
    private final List<String> description;
    private final RecipeType type;
    private final ShapedRecipeData recipeData;
    private final ShapelessRecipeData shapelessData;
    private final ItemStack resultItem;
    private final boolean hidden;
    private final List<PotionEffect> potionEffects;

    public CustomRecipe(String key, String name, List<String> description, RecipeType type, ShapedRecipeData recipeData, ShapelessRecipeData shapelessData, ItemStack resultItem, boolean hidden, List<PotionEffect> potionEffects) {
        this.key = key.toLowerCase();
        this.name = name;
        this.description = description;
        this.type = type;
        this.recipeData = recipeData;
        this.shapelessData = shapelessData;
        this.resultItem = resultItem.clone();
        this.hidden = hidden;
        this.potionEffects = potionEffects != null ? potionEffects : new ArrayList();
    }

    public ItemStack createResult(boolean useCustomNames, boolean keepSpawnEggName) {
        ItemMeta finalMeta;
        ItemMeta meta;
        ItemStack item = this.resultItem.clone();
        if (useCustomNames && (meta = item.getItemMeta()) != null) {
            boolean shouldSetName;
            boolean isSpawnEgg = this.resultItem.getType().name().endsWith("_SPAWN_EGG");
            boolean bl = shouldSetName = !isSpawnEgg || keepSpawnEggName;
            if (shouldSetName && this.name != null && !this.name.isEmpty()) {
                Component nameComponent = MessageUtil.colorize(this.name).decoration(TextDecoration.ITALIC, false);
                meta.displayName(nameComponent);
            }
            if (this.description != null && !this.description.isEmpty()) {
                List<Component> loreComponents = this.description.stream().map(line -> MessageUtil.colorize(line).decoration(TextDecoration.ITALIC, false)).toList();
                meta.lore(loreComponents);
            }
            if (item.getType() == Material.SUSPICIOUS_STEW && !this.potionEffects.isEmpty() && meta instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta stewMeta = (SuspiciousStewMeta)meta;
                for (PotionEffect effect : this.potionEffects) {
                    stewMeta.addCustomEffect(effect, true);
                }
            }
            item.setItemMeta(meta);
        }
        if ((finalMeta = item.getItemMeta()) != null) {
            ItemMeta originalMeta = this.resultItem.getItemMeta();
            if (originalMeta != null) {
                for (ItemFlag flag : originalMeta.getItemFlags()) {
                    finalMeta.addItemFlags(new ItemFlag[]{flag});
                }
            }
            item.setItemMeta(finalMeta);
        }
        return item;
    }

    public ItemStack createResult(boolean keepSpawnEggName) {
        return this.createResult(true, keepSpawnEggName);
    }

    public ItemStack createResult() {
        return this.createResult(true, true);
    }

    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public RecipeType getType() {
        return this.type;
    }

    public ShapedRecipeData getRecipeData() {
        return this.recipeData;
    }

    public ShapelessRecipeData getShapelessData() {
        return this.shapelessData;
    }

    public Material getResultMaterial() {
        return this.resultItem.getType();
    }

    public int getResultAmount() {
        return this.resultItem.getAmount();
    }

    public ItemStack getResultItem() {
        return this.resultItem.clone();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        return "CustomRecipe{key='" + this.key + "', type=" + String.valueOf((Object)this.type) + ", result=" + String.valueOf(this.resultItem.getType()) + "x" + this.resultItem.getAmount() + "}";
    }
}

