/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.hikarii.customrecipes.CustomRecipes;

public class RecipeDataManager {
    private final CustomRecipes plugin;
    private final Map<UUID, Set<String>> discoveredRecipes;
    private final File dataFile;

    public RecipeDataManager(CustomRecipes plugin) {
        this.plugin = plugin;
        this.discoveredRecipes = new HashMap<UUID, Set<String>>();
        this.dataFile = new File(plugin.getDataFolder(), "discovered-recipes.dat");
        this.loadData();
    }

    public boolean hasDiscovered(Player player, String recipeKey) {
        return this.discoveredRecipes.getOrDefault(player.getUniqueId(), Collections.emptySet()).contains(recipeKey.toLowerCase());
    }

    public void markDiscovered(Player player, String recipeKey) {
        UUID uuid = player.getUniqueId();
        this.discoveredRecipes.computeIfAbsent(uuid, k -> new HashSet()).add(recipeKey.toLowerCase());
        this.saveData();
        this.plugin.debug("Player " + player.getName() + " discovered recipe: " + recipeKey);
    }

    private void loadData() {
        if (!this.dataFile.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.dataFile));){
            Map loaded = (Map)ois.readObject();
            this.discoveredRecipes.putAll(loaded);
            this.plugin.debug("Loaded discovered recipes data for " + this.discoveredRecipes.size() + " players");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load discovered recipes data: " + e.getMessage());
        }
    }

    private void saveData() {
        try {
            if (!this.dataFile.exists()) {
                this.dataFile.getParentFile().mkdirs();
                this.dataFile.createNewFile();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.dataFile));){
                oos.writeObject(this.discoveredRecipes);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to save discovered recipes data: " + e.getMessage());
        }
    }
}

