/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.config.DefaultRecipesManager;
import org.hikarii.customrecipes.config.JsonRecipeFileManager;
import org.hikarii.customrecipes.recipe.CustomRecipe;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.data.RecipeIngredient;
import org.hikarii.customrecipes.util.ItemStackSerializer;

public class RecipeManager {
    private final CustomRecipes plugin;
    private final Map<String, CustomRecipe> recipes;
    private final Set<NamespacedKey> registeredKeys;

    public RecipeManager(CustomRecipes plugin) {
        this.plugin = plugin;
        this.recipes = new LinkedHashMap<String, CustomRecipe>();
        this.registeredKeys = new HashSet<NamespacedKey>();
    }

    public void addRecipe(CustomRecipe recipe) {
        this.recipes.put(recipe.getKey(), recipe);
        this.plugin.debug("Added recipe: " + recipe.getKey());
    }

    public CustomRecipe removeRecipe(String key) {
        CustomRecipe removed = this.recipes.remove(key.toLowerCase());
        if (removed != null) {
            this.plugin.debug("Removed recipe: " + key);
        }
        return removed;
    }

    public CustomRecipe getRecipe(String key) {
        return this.recipes.get(key.toLowerCase());
    }

    public Collection<CustomRecipe> getAllRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    public int getRecipeCount() {
        return this.recipes.size();
    }

    public void clearRecipes() {
        this.recipes.clear();
        this.plugin.debug("Cleared all recipes from manager");
    }

    public void registerAllRecipes() {
        this.unregisterAll();
        int registered = 0;
        int skipped = 0;
        for (CustomRecipe recipe : this.recipes.values()) {
            boolean isDisabled = this.plugin.getRecipeStateTracker().isRecipeDisabled(recipe.getKey());
            if (isDisabled) {
                ++skipped;
                continue;
            }
            if (this.registerRecipe(recipe)) {
                ++registered;
                continue;
            }
            this.plugin.getLogger().warning("Failed to register recipe: " + recipe.getKey());
        }
        this.plugin.getLogger().info("Registered " + registered + " custom recipes" + (String)(skipped > 0 ? " (" + skipped + " disabled)" : ""));
    }

    public boolean registerSingleRecipe(CustomRecipe recipe) {
        this.recipes.put(recipe.getKey(), recipe);
        boolean success = this.registerRecipe(recipe);
        if (success) {
            this.plugin.getLogger().info("Registered new recipe: " + recipe.getKey());
        }
        return success;
    }

    private boolean registerRecipe(CustomRecipe recipe) {
        block14: {
            try {
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, recipe.getKey());
                if (recipe.getType() == RecipeType.SHAPED) {
                    boolean useCraftedNames = this.plugin.isUseCraftedCustomNames();
                    boolean keepSpawnEggNames = this.plugin.isKeepSpawnEggNames();
                    ShapedRecipe shapedRecipe = new ShapedRecipe(key, recipe.createResult(useCraftedNames, keepSpawnEggNames));
                    String[] shape = recipe.getRecipeData().toShapeArray();
                    if (shape.length == 1) {
                        shapedRecipe.shape(new String[]{shape[0]});
                    } else if (shape.length == 2) {
                        shapedRecipe.shape(new String[]{shape[0], shape[1]});
                    } else {
                        shapedRecipe.shape(new String[]{shape[0], shape[1], shape[2]});
                    }
                    Map<Character, Material> ingredients = recipe.getRecipeData().getIngredientMap();
                    List<RecipeIngredient> allIngredients = recipe.getRecipeData().ingredients();
                    for (Map.Entry<Character, Material> entry : ingredients.entrySet()) {
                        RecipeIngredient ingredientWithAmount = allIngredients.stream().filter(ing -> ing.material() == entry.getValue()).findFirst().orElse(new RecipeIngredient(entry.getValue(), 1));
                        if (ingredientWithAmount.hasExactItem()) {
                            ItemStack exactItem = ingredientWithAmount.getExactItem().clone();
                            if (exactItem.getType() == Material.ENCHANTED_BOOK) {
                                shapedRecipe.setIngredient(entry.getKey().charValue(), Material.ENCHANTED_BOOK);
                            } else {
                                shapedRecipe.setIngredient(entry.getKey().charValue(), (RecipeChoice)new RecipeChoice.ExactChoice(exactItem));
                            }
                            this.plugin.debug("Registered ingredient with exactItem: " + String.valueOf(exactItem.getType()) + " with enchants: " + exactItem.hasItemMeta());
                            continue;
                        }
                        if (ingredientWithAmount.amount() > 1) {
                            ItemStack itemWithAmount = new ItemStack(entry.getValue(), ingredientWithAmount.amount());
                            shapedRecipe.setIngredient(entry.getKey().charValue(), (RecipeChoice)new RecipeChoice.ExactChoice(itemWithAmount));
                            continue;
                        }
                        shapedRecipe.setIngredient(entry.getKey().charValue(), entry.getValue());
                    }
                    Bukkit.addRecipe((Recipe)shapedRecipe);
                    this.registeredKeys.add(key);
                    this.plugin.debug("Registered shaped recipe: " + recipe.getKey());
                    return true;
                }
                if (recipe.getType() == RecipeType.SHAPELESS) {
                    boolean useCraftedNames = this.plugin.isUseCraftedCustomNames();
                    boolean keepSpawnEggNames = this.plugin.isKeepSpawnEggNames();
                    ShapelessRecipe shapelessRecipe = new ShapelessRecipe(key, recipe.createResult(useCraftedNames, keepSpawnEggNames));
                    Map<Material, Integer> ingredients = recipe.getShapelessData().ingredients();
                    for (Map.Entry<Material, Integer> entry : ingredients.entrySet()) {
                        shapelessRecipe.addIngredient(entry.getValue().intValue(), entry.getKey());
                    }
                    Bukkit.addRecipe((Recipe)shapelessRecipe);
                    this.registeredKeys.add(key);
                    this.plugin.debug("Registered shapeless recipe: " + recipe.getKey());
                    return true;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to register recipe '" + recipe.getKey() + "': " + e.getMessage());
                if (!this.plugin.isDebugMode()) break block14;
                e.printStackTrace();
            }
        }
        return false;
    }

    public void unregisterAll() {
        int unregistered = 0;
        for (NamespacedKey key : this.registeredKeys) {
            if (!Bukkit.removeRecipe((NamespacedKey)key)) continue;
            ++unregistered;
            this.plugin.debug("Unregistered recipe: " + key.getKey());
        }
        this.registeredKeys.clear();
        if (unregistered > 0) {
            this.plugin.getLogger().info("Unregistered " + unregistered + " custom recipes");
        }
    }

    public boolean hasRecipe(String key) {
        return this.recipes.containsKey(key.toLowerCase());
    }

    public boolean enableRecipe(String key) {
        CustomRecipe recipe = this.getRecipe(key);
        if (recipe == null) {
            return false;
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, recipe.getKey());
        if (this.registeredKeys.contains(namespacedKey)) {
            return false;
        }
        return this.registerRecipe(recipe);
    }

    public boolean disableRecipe(String key) {
        CustomRecipe recipe = this.getRecipe(key);
        if (recipe == null) {
            return false;
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, recipe.getKey());
        if (!this.registeredKeys.contains(namespacedKey)) {
            return false;
        }
        if (Bukkit.removeRecipe((NamespacedKey)namespacedKey)) {
            this.registeredKeys.remove(namespacedKey);
            this.plugin.debug("Disabled recipe: " + key);
            return true;
        }
        return false;
    }

    public boolean deleteRecipe(String key) {
        CustomRecipe recipe = this.removeRecipe(key);
        if (recipe == null) {
            return false;
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, recipe.getKey());
        if (this.registeredKeys.contains(namespacedKey)) {
            Bukkit.removeRecipe((NamespacedKey)namespacedKey);
            this.registeredKeys.remove(namespacedKey);
        }
        this.plugin.debug("Deleted recipe: " + key);
        return true;
    }

    public boolean deleteRecipePermanently(String key) {
        CustomRecipe recipe = this.getRecipe(key);
        if (recipe == null) {
            return false;
        }
        this.removeRecipe(key);
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, recipe.getKey());
        if (this.registeredKeys.contains(namespacedKey)) {
            Bukkit.removeRecipe((NamespacedKey)namespacedKey);
            this.registeredKeys.remove(namespacedKey);
        }
        this.plugin.getConfigManager().removeEnabledRecipe(key);
        boolean isDefault = DefaultRecipesManager.isDefaultRecipe(key);
        if (isDefault) {
            this.plugin.getRecipeStateTracker().markDefaultRecipeDeleted(key);
        }
        this.plugin.getConfigManager().getRecipeFileManager().deleteRecipe(key);
        JsonRecipeFileManager jsonManager = new JsonRecipeFileManager(this.plugin);
        jsonManager.deleteRecipe(key);
        return true;
    }

    public boolean updateRecipeResult(String recipeKey, ItemStack newResult, String newName, List<String> newDescription) {
        ItemMeta meta;
        CustomRecipe recipe = this.getRecipe(recipeKey);
        if (recipe == null) {
            return false;
        }
        String finalName = newName;
        List<String> finalDescription = newDescription;
        if ((finalName == null || finalName.isEmpty()) && (meta = newResult.getItemMeta()) != null && meta.hasDisplayName()) {
            finalName = PlainTextComponentSerializer.plainText().serialize(meta.displayName());
        }
        if ((finalDescription == null || finalDescription.isEmpty()) && (meta = newResult.getItemMeta()) != null && meta.hasLore() && meta.lore() != null) {
            finalDescription = new ArrayList<String>();
            for (Component line : meta.lore()) {
                String loreText = PlainTextComponentSerializer.plainText().serialize(line);
                if (loreText == null || loreText.isEmpty()) continue;
                finalDescription.add(loreText);
            }
        }
        CustomRecipe updatedRecipe = new CustomRecipe(recipe.getKey(), finalName, finalDescription, recipe.getType(), recipe.getRecipeData(), recipe.getShapelessData(), newResult, recipe.isHidden(), recipe.getPotionEffects());
        this.recipes.put(recipeKey.toLowerCase(), updatedRecipe);
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, recipeKey);
        if (this.registeredKeys.contains(namespacedKey)) {
            Bukkit.removeRecipe((NamespacedKey)namespacedKey);
            this.registeredKeys.remove(namespacedKey);
            this.registerRecipe(updatedRecipe);
        }
        this.saveRecipeToFile(updatedRecipe);
        this.plugin.debug("Updated result item for recipe: " + recipeKey);
        return true;
    }

    private void saveRecipeToFile(CustomRecipe recipe) {
        try {
            HashMap<String, Object> recipeData = new HashMap<String, Object>();
            if (recipe.getName() != null && !recipe.getName().isEmpty()) {
                recipeData.put("name", recipe.getName());
            }
            if (recipe.getDescription() != null && !recipe.getDescription().isEmpty()) {
                recipeData.put("description", recipe.getDescription());
            }
            recipeData.put("type", recipe.getType().name());
            recipeData.put("hidden", recipe.isHidden());
            if (recipe.getType() == RecipeType.SHAPED) {
                String[] pattern = recipe.getRecipeData().toShapeArray();
                ArrayList<String> patternList = new ArrayList<String>();
                for (String row : pattern) {
                    StringBuilder rowBuilder = new StringBuilder();
                    Map<Character, Material> ingredients = recipe.getRecipeData().getIngredientMap();
                    for (char c : row.toCharArray()) {
                        if (c == ' ') {
                            rowBuilder.append("AIR ");
                            continue;
                        }
                        Material mat = ingredients.get(Character.valueOf(c));
                        rowBuilder.append(mat.name()).append(" ");
                    }
                    patternList.add(rowBuilder.toString().trim());
                }
                recipeData.put("recipe", patternList);
            } else {
                recipeData.put("ingredients", recipe.getShapelessData().toConfigList());
            }
            Map<String, Object> resultData = ItemStackSerializer.toMap(recipe.getResultItem());
            recipeData.put("result", resultData);
            recipeData.put("material", recipe.getResultMaterial().name());
            recipeData.put("amount", recipe.getResultAmount());
            this.plugin.getConfigManager().getRecipeFileManager().saveRecipe(recipe.getKey(), recipeData);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to save recipe: " + e.getMessage());
        }
    }

    public boolean isRecipeEnabled(String key) {
        CustomRecipe recipe = this.getRecipe(key);
        if (recipe == null) {
            return false;
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, recipe.getKey());
        return this.registeredKeys.contains(namespacedKey);
    }
}

