/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.hikarii.customrecipes.CustomRecipes;

public class RecipeWorldManager {
    private final CustomRecipes plugin;
    private final Map<String, Set<String>> recipeWorldRestrictions;
    private boolean globalWorldRestrictionEnabled;
    private Set<String> globalDisabledWorlds;

    public RecipeWorldManager(CustomRecipes plugin) {
        this.plugin = plugin;
        this.recipeWorldRestrictions = new HashMap<String, Set<String>>();
        this.globalDisabledWorlds = new HashSet<String>();
        this.loadWorldRestrictions();
    }

    public void loadWorldRestrictions() {
        ConfigurationSection recipesSection;
        this.recipeWorldRestrictions.clear();
        this.globalDisabledWorlds.clear();
        this.globalWorldRestrictionEnabled = this.plugin.getConfig().getBoolean("world-restrictions.enabled", false);
        if (this.globalWorldRestrictionEnabled) {
            List disabledWorldsList = this.plugin.getConfig().getStringList("world-restrictions.disabled-worlds");
            this.globalDisabledWorlds.addAll(disabledWorldsList);
            this.plugin.debug("Global world restrictions enabled. Disabled worlds: " + String.valueOf(this.globalDisabledWorlds));
        }
        if ((recipesSection = this.plugin.getConfig().getConfigurationSection("recipe-world-settings")) != null) {
            for (String recipeKey : recipesSection.getKeys(false)) {
                List disabledWorlds = recipesSection.getStringList(recipeKey + ".disabled-worlds");
                if (disabledWorlds.isEmpty()) continue;
                this.recipeWorldRestrictions.put(recipeKey.toLowerCase(), new HashSet(disabledWorlds));
                this.plugin.debug("Recipe '" + recipeKey + "' disabled in worlds: " + String.valueOf(disabledWorlds));
            }
        }
    }

    public boolean isRecipeAllowedInWorld(String recipeKey, World world) {
        if (world == null) {
            return true;
        }
        return this.isRecipeAllowedInWorld(recipeKey, world.getName());
    }

    public boolean isRecipeAllowedInWorld(String recipeKey, String worldName) {
        Set<String> disabledWorlds = this.recipeWorldRestrictions.get(recipeKey.toLowerCase());
        if (disabledWorlds != null && disabledWorlds.contains(worldName)) {
            return false;
        }
        if (this.globalWorldRestrictionEnabled && this.globalDisabledWorlds.contains(worldName)) {
            ConfigurationSection overrides = this.plugin.getConfig().getConfigurationSection("recipe-world-settings." + recipeKey);
            if (overrides != null && overrides.contains("override-global")) {
                return overrides.getBoolean("override-global");
            }
            return false;
        }
        return true;
    }

    public boolean isRecipeAllowedForPlayer(String recipeKey, Player player) {
        return this.isRecipeAllowedInWorld(recipeKey, player.getWorld());
    }

    public void setRecipeWorldRestrictions(String recipeKey, List<String> disabledWorlds) {
        if (disabledWorlds == null || disabledWorlds.isEmpty()) {
            this.recipeWorldRestrictions.remove(recipeKey.toLowerCase());
            this.plugin.getConfig().set("recipe-world-settings." + recipeKey, null);
        } else {
            this.recipeWorldRestrictions.put(recipeKey.toLowerCase(), new HashSet<String>(disabledWorlds));
            this.plugin.getConfig().set("recipe-world-settings." + recipeKey + ".disabled-worlds", disabledWorlds);
        }
        this.plugin.saveConfig();
    }

    public void toggleWorldRestriction(String recipeKey, String worldName) {
        Set disabledWorlds = this.recipeWorldRestrictions.computeIfAbsent(recipeKey.toLowerCase(), k -> new HashSet());
        if (disabledWorlds.contains(worldName)) {
            disabledWorlds.remove(worldName);
        } else {
            disabledWorlds.add(worldName);
        }
        this.setRecipeWorldRestrictions(recipeKey, new ArrayList<String>(disabledWorlds));
    }

    public List<String> getDisabledWorlds(String recipeKey) {
        Set<String> disabled = this.recipeWorldRestrictions.get(recipeKey.toLowerCase());
        if (disabled == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(disabled);
    }

    public void setGlobalWorldRestrictions(boolean enabled, List<String> disabledWorlds) {
        this.globalWorldRestrictionEnabled = enabled;
        this.globalDisabledWorlds.clear();
        if (disabledWorlds != null) {
            this.globalDisabledWorlds.addAll(disabledWorlds);
        }
        this.plugin.getConfig().set("world-restrictions.enabled", (Object)enabled);
        this.plugin.getConfig().set("world-restrictions.disabled-worlds", disabledWorlds);
        this.plugin.saveConfig();
    }

    public List<String> getGlobalDisabledWorlds() {
        return new ArrayList<String>(this.globalDisabledWorlds);
    }

    public boolean isGlobalWorldRestrictionEnabled() {
        return this.globalWorldRestrictionEnabled;
    }

    public static WorldType getWorldType(World.Environment environment) {
        return switch (environment) {
            case World.Environment.NORMAL -> WorldType.OVERWORLD;
            case World.Environment.NETHER -> WorldType.NETHER;
            case World.Environment.THE_END -> WorldType.END;
            default -> WorldType.CUSTOM;
        };
    }

    public static enum WorldType {
        OVERWORLD("Overworld", Material.GRASS_BLOCK),
        NETHER("Nether", Material.NETHERRACK),
        END("End", Material.END_STONE),
        CUSTOM("Custom", Material.COMMAND_BLOCK);

        private final String displayName;
        private final Material icon;

        private WorldType(String displayName, Material icon) {
            this.displayName = displayName;
            this.icon = icon;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Material getIcon() {
            return this.icon;
        }
    }
}

