/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe.data;

import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class IngredientMatcher {
    public static boolean matches(ItemStack required, ItemStack actual, boolean ignoreMetadata) {
        if (actual == null || actual.getType() == Material.AIR) {
            return required == null || required.getType() == Material.AIR;
        }
        if (required == null || required.getType() == Material.AIR) {
            return false;
        }
        if (required.getType() != actual.getType()) {
            return false;
        }
        if (ignoreMetadata) {
            return true;
        }
        ItemMeta requiredMeta = required.getItemMeta();
        ItemMeta actualMeta = actual.getItemMeta();
        if (requiredMeta == null) {
            return true;
        }
        if (actualMeta == null) {
            return !requiredMeta.hasEnchants();
        }
        if (requiredMeta.hasEnchants()) {
            Map requiredEnchants = requiredMeta.getEnchants();
            Map actualEnchants = actualMeta.getEnchants();
            for (Map.Entry entry : requiredEnchants.entrySet()) {
                if (actualEnchants.containsKey(entry.getKey()) && (Integer)actualEnchants.get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        if (requiredMeta.getPersistentDataContainer().getKeys().size() > 0) {
            for (NamespacedKey key : requiredMeta.getPersistentDataContainer().getKeys()) {
                String actualValue;
                String requiredValue = (String)requiredMeta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
                if (requiredValue.equals(actualValue = (String)actualMeta.getPersistentDataContainer().get(key, PersistentDataType.STRING))) continue;
                return false;
            }
        }
        return true;
    }
}

