/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.hikarii.customrecipes.config.ValidationException;

public record ShapelessRecipeData(Map<Material, Integer> ingredients) {
    public ShapelessRecipeData {
        if (ingredients == null || ingredients.isEmpty()) {
            throw new IllegalArgumentException("Ingredients cannot be null or empty");
        }
        int totalItems = ingredients.values().stream().mapToInt(Integer::intValue).sum();
        if (totalItems > 9) {
            throw new IllegalArgumentException("Too many ingredients (max 9 items)");
        }
        ingredients = Collections.unmodifiableMap(new HashMap<Material, Integer>(ingredients));
    }

    public static ShapelessRecipeData fromConfigList(List<String> ingredientList) throws ValidationException {
        HashMap<Material, Integer> ingredients = new HashMap<Material, Integer>();
        for (String entry : ingredientList) {
            int count;
            String[] parts = entry.split(":");
            if (parts.length != 2) {
                throw new ValidationException("Invalid ingredient format: " + entry + " (expected MATERIAL:COUNT)");
            }
            Material material = Material.getMaterial((String)parts[0].toUpperCase());
            if (material == null) {
                throw new ValidationException("Invalid material: " + parts[0]);
            }
            try {
                count = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid count: " + parts[1]);
            }
            if (count < 1 || count > 9) {
                throw new ValidationException("Count must be 1-9: " + count);
            }
            ingredients.put(material, count);
        }
        return new ShapelessRecipeData(ingredients);
    }

    public static ShapelessRecipeData fromGridItems(ItemStack[] gridItems) {
        HashMap<Material, Integer> counts = new HashMap<Material, Integer>();
        for (ItemStack item : gridItems) {
            if (item == null || item.getType() == Material.AIR) continue;
            Material mat = item.getType();
            counts.put(mat, counts.getOrDefault(mat, 0) + 1);
        }
        return new ShapelessRecipeData(counts);
    }

    public List<String> toConfigList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Material, Integer> entry : this.ingredients.entrySet()) {
            list.add(entry.getKey().name() + ":" + String.valueOf(entry.getValue()));
        }
        return list;
    }
}

