/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe.vanilla;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;

public class IngredientChoice {
    private final List<Material> options;
    private int selectedIndex;

    public IngredientChoice(List<Material> options) {
        this.options = new ArrayList<Material>(options);
        this.selectedIndex = 0;
    }

    public IngredientChoice(Material singleOption) {
        this.options = new ArrayList<Material>();
        this.options.add(singleOption);
        this.selectedIndex = 0;
    }

    public Material getSelected() {
        if (this.options.isEmpty()) {
            return Material.AIR;
        }
        return this.options.get(this.selectedIndex);
    }

    public List<Material> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.options.size()) {
            this.selectedIndex = index;
        }
    }

    public boolean hasMultipleOptions() {
        return this.options.size() > 1;
    }

    public void cycleNext() {
        this.selectedIndex = (this.selectedIndex + 1) % this.options.size();
    }

    public void cyclePrevious() {
        this.selectedIndex = (this.selectedIndex - 1 + this.options.size()) % this.options.size();
    }

    public static IngredientChoice fromString(String data) {
        if (data.contains("|")) {
            String[] parts = data.split("\\|");
            ArrayList<Material> materials = new ArrayList<Material>();
            for (String part : parts) {
                Material mat = Material.getMaterial((String)part.trim());
                if (mat == null) continue;
                materials.add(mat);
            }
            return new IngredientChoice(materials);
        }
        Material mat = Material.getMaterial((String)data);
        return new IngredientChoice(mat != null ? mat : Material.AIR);
    }

    public String toString() {
        if (this.options.size() == 1) {
            return this.options.get(0).name();
        }
        return String.join((CharSequence)"|", this.options.stream().map(Enum::name).toList());
    }
}

