/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe.vanilla;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.recipe.RecipeType;
import org.hikarii.customrecipes.recipe.vanilla.IngredientChoice;
import org.hikarii.customrecipes.recipe.vanilla.VanillaRecipeInfo;
import org.hikarii.customrecipes.recipe.vanilla.VanillaRecipesMigration;

public class VanillaRecipeManager {
    private final CustomRecipes plugin;
    private final File vanillaRecipesFolder;
    private final File vanillaRecipesDataFile;
    private final Map<String, VanillaRecipeInfo> allVanillaRecipes;
    private final Map<String, VanillaRecipeState> modifiedRecipes;

    public VanillaRecipeManager(CustomRecipes plugin) {
        VanillaRecipesMigration migration;
        this.plugin = plugin;
        this.vanillaRecipesFolder = new File(plugin.getDataFolder(), "vanillarecipes");
        this.vanillaRecipesDataFile = new File(plugin.getDataFolder(), "vanilla-recipes.yml");
        this.allVanillaRecipes = new LinkedHashMap<String, VanillaRecipeInfo>();
        this.modifiedRecipes = new HashMap<String, VanillaRecipeState>();
        if (!this.vanillaRecipesFolder.exists()) {
            this.vanillaRecipesFolder.mkdirs();
        }
        if (!(migration = new VanillaRecipesMigration(plugin)).checkAndMigrate()) {
            plugin.getLogger().warning("Vanilla recipes migration failed, but continuing...");
        }
        this.loadVanillaRecipesData();
        this.loadModifiedRecipes();
        this.applyModifications();
    }

    private void loadVanillaRecipesData() {
        YamlConfiguration config;
        ConfigurationSection recipesSection;
        if (!this.vanillaRecipesDataFile.exists()) {
            this.plugin.saveResource("vanilla-recipes.yml", false);
        }
        if ((recipesSection = (config = YamlConfiguration.loadConfiguration((File)this.vanillaRecipesDataFile)).getConfigurationSection("recipes")) == null) {
            this.plugin.getLogger().warning("No recipes found in vanilla-recipes.yml");
            return;
        }
        int loaded = 0;
        for (String recipeKey : recipesSection.getKeys(false)) {
            try {
                ConfigurationSection recipeSection = recipesSection.getConfigurationSection(recipeKey);
                if (recipeSection == null) continue;
                String displayName = recipeSection.getString("name", recipeKey);
                String materialStr = recipeSection.getString("material");
                int amount = recipeSection.getInt("amount", 1);
                String typeStr = recipeSection.getString("type", "SHAPED");
                List patternStrings = recipeSection.getStringList("pattern");
                ArrayList<List<IngredientChoice>> ingredientGrid = new ArrayList<List<IngredientChoice>>();
                for (String rowString : patternStrings) {
                    String[] items;
                    ArrayList<IngredientChoice> row = new ArrayList<IngredientChoice>();
                    for (String item : items = rowString.split(" ")) {
                        row.add(IngredientChoice.fromString(item));
                    }
                    ingredientGrid.add(row);
                }
                String categoryStr = recipeSection.getString("category", "MISC");
                String stationStr = recipeSection.getString("station", "CRAFTING_TABLE");
                Material material = Material.getMaterial((String)materialStr);
                if (material == null) {
                    this.plugin.getLogger().warning("Invalid material for recipe " + recipeKey + ": " + materialStr);
                    continue;
                }
                HashMap<Integer, ItemStack> variantResults = new HashMap<Integer, ItemStack>();
                ConfigurationSection resultsSection = recipeSection.getConfigurationSection("variant-results");
                if (resultsSection != null) {
                    for (String variantKey : resultsSection.getKeys(false)) {
                        try {
                            ItemMeta meta;
                            String variantMaterial;
                            Material mat;
                            int variantIndex = Integer.parseInt(variantKey);
                            ConfigurationSection variantResultSection = resultsSection.getConfigurationSection(variantKey);
                            if (variantResultSection == null || (mat = Material.getMaterial((String)(variantMaterial = variantResultSection.getString("material", materialStr)))) == null) continue;
                            int variantAmount = variantResultSection.getInt("amount", 1);
                            ItemStack variantItem = new ItemStack(mat, variantAmount);
                            if (variantResultSection.contains("potion-effects") && (meta = variantItem.getItemMeta()) instanceof SuspiciousStewMeta) {
                                SuspiciousStewMeta stewMeta = (SuspiciousStewMeta)meta;
                                List effectsList = variantResultSection.getMapList("potion-effects");
                                for (Map effectMap : effectsList) {
                                    try {
                                        int amplifier;
                                        String effectName = (String)effectMap.get("type");
                                        int duration = effectMap.containsKey("duration") ? ((Number)effectMap.get("duration")).intValue() : 160;
                                        int n = amplifier = effectMap.containsKey("amplifier") ? ((Number)effectMap.get("amplifier")).intValue() : 0;
                                        PotionEffectType effectType = PotionEffectType.getByName((String)effectName);
                                        if (effectType == null) continue;
                                        stewMeta.addCustomEffect(new PotionEffect(effectType, duration, amplifier), true);
                                    }
                                    catch (Exception e) {
                                        this.plugin.getLogger().warning("Failed to parse effect: " + e.getMessage());
                                    }
                                }
                                variantItem.setItemMeta((ItemMeta)stewMeta);
                            }
                            variantResults.put(variantIndex, variantItem);
                        }
                        catch (NumberFormatException e) {
                            this.plugin.getLogger().warning("Invalid variant index: " + variantKey);
                        }
                    }
                }
                RecipeType type = RecipeType.fromString(typeStr);
                VanillaRecipeInfo.RecipeCategory category = VanillaRecipeInfo.RecipeCategory.valueOf(categoryStr);
                VanillaRecipeInfo.RecipeStation station = VanillaRecipeInfo.RecipeStation.valueOf(stationStr);
                VanillaRecipeInfo info = new VanillaRecipeInfo("minecraft:" + recipeKey, displayName, material, amount, type, ingredientGrid, category, station, variantResults);
                this.allVanillaRecipes.put(recipeKey, info);
                ++loaded;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load vanilla recipe " + recipeKey + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Loaded " + loaded + " vanilla recipes from vanilla-recipes.yml");
    }

    private ItemStack createItemStackFromConfig(ConfigurationSection section) {
        ItemMeta meta;
        String materialStr = section.getString("material");
        Material material = Material.getMaterial((String)materialStr);
        if (material == null) {
            throw new IllegalArgumentException("Invalid material: " + materialStr);
        }
        int amount = section.getInt("amount", 1);
        ItemStack item = new ItemStack(material, amount);
        if (section.contains("nbt") && (meta = item.getItemMeta()) != null) {
            List effects;
            ConfigurationSection nbtSection = section.getConfigurationSection("nbt");
            if (nbtSection != null && nbtSection.contains("suspicious_stew_effects") && !(effects = nbtSection.getMapList("suspicious_stew_effects")).isEmpty()) {
                Map firstEffect = (Map)effects.get(0);
                String effectId = (String)firstEffect.get("id");
                int duration = firstEffect.containsKey("duration") ? ((Number)firstEffect.get("duration")).intValue() : 160;
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                pdc.set(new NamespacedKey((Plugin)this.plugin, "stew_effect"), PersistentDataType.STRING, (Object)effectId);
                pdc.set(new NamespacedKey((Plugin)this.plugin, "stew_duration"), PersistentDataType.INTEGER, (Object)duration);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void loadModifiedRecipes() {
        File[] files = this.vanillaRecipesFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            return;
        }
        int loaded = 0;
        for (File file : files) {
            try {
                ConfigurationSection variantsSection;
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                String recipeKey = file.getName().replace(".yml", "");
                boolean disabled = config.getBoolean("disabled", false);
                String originalKey = config.getString("original-recipe-key");
                int currentVariant = config.getInt("current-variant-index", 0);
                VanillaRecipeState state = new VanillaRecipeState(disabled, originalKey);
                state.setCurrentVariantIndex(currentVariant);
                if (config.contains("custom-result-amount")) {
                    state.setResultAmount(config.getInt("custom-result-amount"));
                }
                if ((variantsSection = config.getConfigurationSection("variants")) != null) {
                    for (String variantKey : variantsSection.getKeys(false)) {
                        try {
                            int variantIndex = Integer.parseInt(variantKey);
                            List pattern = variantsSection.getStringList(variantKey + ".pattern");
                            String typeStr = variantsSection.getString(variantKey + ".type", "SHAPED");
                            RecipeType type = RecipeType.fromString(typeStr);
                            state.setPatternForVariant(variantIndex, pattern);
                            state.setTypeForVariant(variantIndex, type);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                this.modifiedRecipes.put(recipeKey, state);
                ++loaded;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load modified recipe " + file.getName() + ": " + e.getMessage());
            }
        }
        if (loaded > 0) {
            this.plugin.getLogger().info("Loaded " + loaded + " modified vanilla recipes");
        }
    }

    private void applyModifications() {
        int disabled = 0;
        int changed = 0;
        for (Map.Entry<String, VanillaRecipeState> entry : this.modifiedRecipes.entrySet()) {
            NamespacedKey key;
            String recipeKey = entry.getKey();
            VanillaRecipeState state = entry.getValue();
            if (state.isDisabled()) {
                key = NamespacedKey.minecraft((String)recipeKey);
                if (!Bukkit.removeRecipe((NamespacedKey)key)) continue;
                ++disabled;
                this.plugin.debug("Disabled vanilla recipe: " + recipeKey);
                continue;
            }
            if (!state.hasChangedRecipe()) continue;
            key = NamespacedKey.minecraft((String)recipeKey);
            Bukkit.removeRecipe((NamespacedKey)key);
            this.registerAllVariants(recipeKey, state);
            ++changed;
            this.plugin.debug("Changed vanilla recipe with variants: " + recipeKey);
        }
        if (disabled > 0 || changed > 0) {
            this.plugin.getLogger().info("Applied vanilla recipe modifications: " + disabled + " disabled, " + changed + " changed");
        }
    }

    public void toggleRecipe(String recipeKey) {
        VanillaRecipeState state = this.modifiedRecipes.get(recipeKey);
        if (state == null) {
            state = new VanillaRecipeState(true, "minecraft:" + recipeKey);
            this.modifiedRecipes.put(recipeKey, state);
        } else {
            state.setDisabled(!state.isDisabled());
        }
        this.saveRecipeState(recipeKey, state);
        if (state.isDisabled()) {
            NamespacedKey originalKey = NamespacedKey.minecraft((String)recipeKey);
            Bukkit.removeRecipe((NamespacedKey)originalKey);
            VanillaRecipeInfo info = this.allVanillaRecipes.get(recipeKey);
            if (info != null) {
                int maxVariants = this.getMaxVariantsForRecipe(recipeKey);
                for (int i = 0; i < maxVariants; ++i) {
                    NamespacedKey variantKey = new NamespacedKey((Plugin)this.plugin, recipeKey + "_variant_" + i);
                    Bukkit.removeRecipe((NamespacedKey)variantKey);
                }
            }
            this.plugin.debug("Disabled vanilla recipe: " + recipeKey);
        } else {
            VanillaRecipeInfo info = this.allVanillaRecipes.get(recipeKey);
            if (info != null) {
                if (state.hasChangedRecipe()) {
                    this.registerAllVariants(recipeKey, state);
                    this.plugin.getLogger().info("Re-enabled modified recipe: " + recipeKey);
                } else {
                    NamespacedKey key = NamespacedKey.minecraft((String)recipeKey);
                    this.registerRecipe(key, info, info.getPattern(), 0);
                    this.plugin.getLogger().info("Re-enabled vanilla recipe: " + recipeKey);
                }
            }
        }
    }

    public void updateRecipeVariant(String recipeKey, int variantIndex, List<String> newPattern, RecipeType newType) {
        VanillaRecipeState state = this.modifiedRecipes.get(recipeKey);
        if (state == null) {
            state = new VanillaRecipeState(false, "minecraft:" + recipeKey);
            this.modifiedRecipes.put(recipeKey, state);
            this.initializeAllVariants(recipeKey, state);
        }
        state.setPatternForVariant(variantIndex, newPattern);
        state.setTypeForVariant(variantIndex, newType);
        state.setDisabled(false);
        this.saveRecipeState(recipeKey, state);
        NamespacedKey originalKey = NamespacedKey.minecraft((String)recipeKey);
        Bukkit.removeRecipe((NamespacedKey)originalKey);
        VanillaRecipeInfo info = this.allVanillaRecipes.get(recipeKey);
        if (info != null) {
            int maxVariants = this.getMaxVariantsForRecipe(recipeKey);
            for (int i = 0; i < maxVariants; ++i) {
                NamespacedKey variantKey = new NamespacedKey((Plugin)this.plugin, recipeKey + "_variant_" + i);
                Bukkit.removeRecipe((NamespacedKey)variantKey);
            }
        }
        this.registerAllVariants(recipeKey, state);
    }

    private void registerAllVariants(String recipeKey, VanillaRecipeState state) {
        VanillaRecipeInfo info = this.allVanillaRecipes.get(recipeKey);
        if (info == null) {
            return;
        }
        int maxVariants = this.getMaxVariantsForRecipe(recipeKey);
        NamespacedKey originalKey = NamespacedKey.minecraft((String)recipeKey);
        Bukkit.removeRecipe((NamespacedKey)originalKey);
        for (int i = 0; i < maxVariants; ++i) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, recipeKey + "_variant_" + i);
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        for (int variantIndex = 0; variantIndex < maxVariants; ++variantIndex) {
            List<String> pattern = state.getPatternForVariant(variantIndex);
            if (pattern == null || pattern.isEmpty()) {
                pattern = this.createPatternForVariant(info, variantIndex);
            }
            if (pattern == null || pattern.isEmpty()) continue;
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, recipeKey + "_variant_" + variantIndex);
            this.registerRecipe(key, info, pattern, variantIndex);
        }
    }

    public void setCurrentVariant(String recipeKey, int variantIndex) {
        VanillaRecipeInfo info = this.allVanillaRecipes.get(recipeKey);
        if (info == null) {
            return;
        }
        for (int row = 0; row < info.getIngredientGrid().size(); ++row) {
            List<IngredientChoice> rowList = info.getIngredientGrid().get(row);
            for (int col = 0; col < rowList.size(); ++col) {
                IngredientChoice choice = rowList.get(col);
                if (!choice.hasMultipleOptions() || variantIndex >= choice.getOptions().size()) continue;
                choice.setSelectedIndex(variantIndex);
            }
        }
        VanillaRecipeState state = this.modifiedRecipes.get(recipeKey);
        if (state != null) {
            state.setCurrentVariantIndex(variantIndex);
            this.saveRecipeState(recipeKey, state);
        }
    }

    public int getMaxVariantsForRecipe(String recipeKey) {
        VanillaRecipeInfo info = this.allVanillaRecipes.get(recipeKey);
        if (info == null) {
            return 1;
        }
        int maxVariants = 1;
        for (List<IngredientChoice> row : info.getIngredientGrid()) {
            for (IngredientChoice choice : row) {
                if (!choice.hasMultipleOptions()) continue;
                maxVariants = Math.max(maxVariants, choice.getOptions().size());
            }
        }
        return maxVariants;
    }

    private void initializeAllVariants(String recipeKey, VanillaRecipeState state) {
        VanillaRecipeInfo info = this.allVanillaRecipes.get(recipeKey);
        if (info == null) {
            return;
        }
        int maxVariants = this.getMaxVariantsForRecipe(recipeKey);
        for (int variantIndex = 0; variantIndex < maxVariants; ++variantIndex) {
            if (state.getPatternForVariant(variantIndex) != null) continue;
            List<String> variantPattern = this.createPatternForVariant(info, variantIndex);
            state.setPatternForVariant(variantIndex, variantPattern);
            state.setTypeForVariant(variantIndex, info.getType());
        }
    }

    private List<String> createAnyVariantPattern(VanillaRecipeInfo info) {
        ArrayList<String> pattern = new ArrayList<String>();
        for (List<IngredientChoice> row : info.getIngredientGrid()) {
            StringBuilder rowPattern = new StringBuilder();
            for (IngredientChoice choice : row) {
                if (rowPattern.length() > 0) {
                    rowPattern.append(" ");
                }
                if (choice.hasMultipleOptions()) {
                    StringBuilder options = new StringBuilder();
                    for (Material mat : choice.getOptions()) {
                        if (options.length() > 0) {
                            options.append("|");
                        }
                        options.append(mat.name());
                    }
                    rowPattern.append((CharSequence)options);
                    continue;
                }
                rowPattern.append(choice.getSelected().name());
            }
            pattern.add(rowPattern.toString());
        }
        return pattern;
    }

    private List<String> createPatternForVariant(VanillaRecipeInfo info, int variantIndex) {
        ArrayList<String> pattern = new ArrayList<String>();
        for (List<IngredientChoice> row : info.getIngredientGrid()) {
            StringBuilder rowPattern = new StringBuilder();
            for (IngredientChoice choice : row) {
                if (rowPattern.length() > 0) {
                    rowPattern.append(" ");
                }
                if (choice.hasMultipleOptions() && variantIndex < choice.getOptions().size()) {
                    rowPattern.append(choice.getOptions().get(variantIndex).name());
                    continue;
                }
                if (choice.hasMultipleOptions() && variantIndex >= choice.getOptions().size()) {
                    rowPattern.append(choice.getOptions().get(0).name());
                    continue;
                }
                rowPattern.append(choice.getSelected().name());
            }
            pattern.add(rowPattern.toString());
        }
        return pattern;
    }

    public void resetRecipe(String recipeKey) {
        VanillaRecipeInfo info;
        this.modifiedRecipes.remove(recipeKey);
        File file = new File(this.vanillaRecipesFolder, recipeKey + ".yml");
        if (file.exists()) {
            file.delete();
        }
        if ((info = this.allVanillaRecipes.get(recipeKey)) != null) {
            int maxVariants = this.getMaxVariantsForRecipe(recipeKey);
            for (int i = 0; i < maxVariants; ++i) {
                NamespacedKey variantKey = new NamespacedKey((Plugin)this.plugin, recipeKey + "_variant_" + i);
                Bukkit.removeRecipe((NamespacedKey)variantKey);
            }
        }
        NamespacedKey key = NamespacedKey.minecraft((String)recipeKey);
        Bukkit.removeRecipe((NamespacedKey)key);
        if (info != null) {
            this.registerOriginalRecipe(key, info);
            this.plugin.getLogger().info("Reset vanilla recipe: " + recipeKey);
        }
    }

    private boolean registerChangedRecipe(NamespacedKey key, VanillaRecipeInfo info, VanillaRecipeState state) {
        return this.registerRecipe(key, info, state.getChangedPattern(), state.getCurrentVariantIndex());
    }

    private boolean registerOriginalRecipe(NamespacedKey key, VanillaRecipeInfo info) {
        return this.registerRecipe(key, info, info.getPattern(), 0);
    }

    private boolean registerRecipe(NamespacedKey key, VanillaRecipeInfo info, List<String> pattern, int variantIndex) {
        try {
            ItemStack resultItem;
            ItemStack itemStack = resultItem = info.hasVariantResults() ? info.getResultForVariant(variantIndex) : new ItemStack(info.getResultMaterial(), info.getResultAmount());
            if (info.getType() == RecipeType.SHAPED) {
                ShapedRecipe recipe = new ShapedRecipe(key, resultItem);
                HashMap<Material, Character> materialToChar = new HashMap<Material, Character>();
                char currentChar = 'A';
                ArrayList<String> bukkitPattern = new ArrayList<String>();
                for (String string : pattern) {
                    String[] items;
                    StringBuilder bukkitRow = new StringBuilder();
                    for (String item : items = string.split(" ")) {
                        if (item.equals("AIR") || item.isEmpty()) {
                            bukkitRow.append(' ');
                            continue;
                        }
                        String firstMaterial = item.contains("|") ? item.split("\\|")[0] : item;
                        Material mat = Material.getMaterial((String)firstMaterial);
                        if (mat == null || mat == Material.AIR) {
                            bukkitRow.append(' ');
                            continue;
                        }
                        if (!materialToChar.containsKey(mat)) {
                            materialToChar.put(mat, Character.valueOf(currentChar));
                            currentChar = (char)(currentChar + '\u0001');
                        }
                        bukkitRow.append(materialToChar.get(mat));
                    }
                    bukkitPattern.add(bukkitRow.toString());
                }
                if (bukkitPattern.isEmpty()) {
                    return false;
                }
                if (bukkitPattern.size() == 1) {
                    recipe.shape(new String[]{(String)bukkitPattern.get(0)});
                } else if (bukkitPattern.size() == 2) {
                    recipe.shape(new String[]{(String)bukkitPattern.get(0), (String)bukkitPattern.get(1)});
                } else if (bukkitPattern.size() == 3) {
                    recipe.shape(new String[]{(String)bukkitPattern.get(0), (String)bukkitPattern.get(1), (String)bukkitPattern.get(2)});
                }
                for (Map.Entry entry : materialToChar.entrySet()) {
                    recipe.setIngredient(((Character)entry.getValue()).charValue(), (Material)entry.getKey());
                }
                Bukkit.addRecipe((Recipe)recipe);
                return true;
            }
            if (info.getType() == RecipeType.SHAPELESS) {
                ShapelessRecipe recipe = new ShapelessRecipe(key, resultItem);
                for (String row : pattern) {
                    String[] items;
                    for (String item : items = row.split(" ")) {
                        Material mat = Material.getMaterial((String)item);
                        if (mat == null || mat == Material.AIR) continue;
                        recipe.addIngredient(mat);
                    }
                }
                Bukkit.addRecipe((Recipe)recipe);
                return true;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to register recipe " + key.getKey() + ": " + e.getMessage());
        }
        return false;
    }

    private void saveRecipeState(String recipeKey, VanillaRecipeState state) {
        try {
            File file = new File(this.vanillaRecipesFolder, recipeKey + ".yml");
            YamlConfiguration config = new YamlConfiguration();
            config.set("disabled", (Object)state.isDisabled());
            config.set("original-recipe-key", (Object)state.getOriginalRecipeKey());
            config.set("current-variant-index", (Object)state.getCurrentVariantIndex());
            if (state.getCustomResultAmount() != null) {
                config.set("custom-result-amount", (Object)state.getCustomResultAmount());
            }
            for (Map.Entry<Integer, List<String>> entry : state.getAllVariantPatterns().entrySet()) {
                int variantIndex = entry.getKey();
                config.set("variants." + variantIndex + ".pattern", entry.getValue());
                config.set("variants." + variantIndex + ".type", (Object)state.getTypeForVariant(variantIndex).name());
            }
            config.save(file);
            this.plugin.debug("Saved vanilla recipe state: " + recipeKey);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save vanilla recipe state: " + e.getMessage());
        }
    }

    public Map<String, VanillaRecipeInfo> getAllVanillaRecipes() {
        return Collections.unmodifiableMap(this.allVanillaRecipes);
    }

    public VanillaRecipeInfo getRecipeInfo(String recipeKey) {
        return this.allVanillaRecipes.get(recipeKey);
    }

    public VanillaRecipeState getRecipeState(String recipeKey) {
        return this.modifiedRecipes.get(recipeKey);
    }

    public boolean isRecipeDisabled(String recipeKey) {
        VanillaRecipeState state = this.modifiedRecipes.get(recipeKey);
        return state != null && state.isDisabled();
    }

    public boolean isRecipeChanged(String recipeKey) {
        VanillaRecipeState state = this.modifiedRecipes.get(recipeKey);
        return state != null && state.hasChangedRecipe();
    }

    public List<VanillaRecipeInfo> searchRecipes(String query) {
        String lowerQuery = query.toLowerCase();
        return this.allVanillaRecipes.values().stream().filter(recipe -> recipe.getDisplayName().toLowerCase().contains(lowerQuery) || recipe.getResultMaterial().name().toLowerCase().contains(lowerQuery)).collect(Collectors.toList());
    }

    public List<VanillaRecipeInfo> getRecipesByCategory(VanillaRecipeInfo.RecipeCategory category) {
        return this.allVanillaRecipes.values().stream().filter(recipe -> recipe.getCategory() == category).collect(Collectors.toList());
    }

    public List<VanillaRecipeInfo> getRecipesByStation(VanillaRecipeInfo.RecipeStation station) {
        return this.allVanillaRecipes.values().stream().filter(recipe -> recipe.getStation() == station).collect(Collectors.toList());
    }

    public static class VanillaRecipeState {
        private boolean disabled;
        private final String originalRecipeKey;
        private int currentVariantIndex;
        private Map<Integer, List<String>> variantPatterns;
        private Map<Integer, RecipeType> variantTypes;
        private Integer customResultAmount;

        public VanillaRecipeState(boolean disabled, String originalRecipeKey) {
            this.disabled = disabled;
            this.originalRecipeKey = originalRecipeKey;
            this.currentVariantIndex = 0;
            this.variantPatterns = new HashMap<Integer, List<String>>();
            this.variantTypes = new HashMap<Integer, RecipeType>();
            this.customResultAmount = null;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public String getOriginalRecipeKey() {
            return this.originalRecipeKey;
        }

        public int getCurrentVariantIndex() {
            return this.currentVariantIndex;
        }

        public void setCurrentVariantIndex(int index) {
            this.currentVariantIndex = index;
        }

        public List<String> getChangedPattern() {
            return this.variantPatterns.get(this.currentVariantIndex);
        }

        public List<String> getPatternForVariant(int variantIndex) {
            return this.variantPatterns.get(variantIndex);
        }

        public void setPatternForVariant(int variantIndex, List<String> pattern) {
            this.variantPatterns.put(variantIndex, pattern);
        }

        public RecipeType getChangedType() {
            return this.variantTypes.getOrDefault(this.currentVariantIndex, RecipeType.SHAPED);
        }

        public RecipeType getTypeForVariant(int variantIndex) {
            return this.variantTypes.getOrDefault(variantIndex, RecipeType.SHAPED);
        }

        public void setTypeForVariant(int variantIndex, RecipeType type) {
            this.variantTypes.put(variantIndex, type);
        }

        public boolean hasChangedRecipe() {
            return !this.variantPatterns.isEmpty();
        }

        public Map<Integer, List<String>> getAllVariantPatterns() {
            return this.variantPatterns;
        }

        public Map<Integer, RecipeType> getAllVariantTypes() {
            return this.variantTypes;
        }

        public void setResultAmount(int amount) {
            this.customResultAmount = amount;
        }

        public Integer getCustomResultAmount() {
            return this.customResultAmount;
        }
    }
}

