/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.recipe.vanilla;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.configuration.file.YamlConfiguration;
import org.hikarii.customrecipes.CustomRecipes;

public class VanillaRecipesMigration {
    private final CustomRecipes plugin;

    public VanillaRecipesMigration(CustomRecipes plugin) {
        this.plugin = plugin;
    }

    public boolean checkAndMigrate() {
        File vanillaRecipesFile = new File(this.plugin.getDataFolder(), "vanilla-recipes.yml");
        if (!vanillaRecipesFile.exists()) {
            this.plugin.saveResource("vanilla-recipes.yml", false);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)vanillaRecipesFile);
            config.set("vanilla-recipes-version", (Object)2);
            try {
                config.save(vanillaRecipesFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to set version in vanilla-recipes.yml");
            }
            return true;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)vanillaRecipesFile);
        int version = config.getInt("vanilla-recipes-version", 0);
        if (version == 2) {
            this.plugin.debug("Vanilla recipes are up to date (v" + version + ")");
            return true;
        }
        if (version < 2) {
            this.plugin.getLogger().info("Migrating vanilla recipes from v" + version + " to v2");
            this.createBackup(vanillaRecipesFile);
            this.plugin.saveResource("vanilla-recipes.yml", true);
            config = YamlConfiguration.loadConfiguration((File)vanillaRecipesFile);
            config.set("vanilla-recipes-version", (Object)2);
            try {
                config.save(vanillaRecipesFile);
                this.plugin.getLogger().info("\u2713 Vanilla recipes updated to v2");
                return true;
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to update vanilla recipes: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void createBackup(File file) {
        try {
            File backupFolder = new File(this.plugin.getDataFolder(), "backups");
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            String timestamp = String.valueOf(System.currentTimeMillis());
            File backupFile = new File(backupFolder, "vanilla-recipes-backup-" + timestamp + ".yml");
            Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.plugin.getLogger().info("Created backup: " + backupFile.getName());
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to create backup: " + e.getMessage());
        }
    }
}

